/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter;

import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;

class BytesDictionaryMatcher
extends DictionaryMatcher {
    private final byte[] characters;
    private final int transform;

    public BytesDictionaryMatcher(byte[] byArray, int n2) {
        this.characters = byArray;
        Assert.assrt((n2 & 0x7F000000) == 0x1000000);
        this.transform = n2;
    }

    private int transform(int n2) {
        if (n2 == 8205) {
            return 255;
        }
        if (n2 == 8204) {
            return 254;
        }
        int n3 = n2 - (this.transform & 0x1FFFFF);
        if (n3 < 0 || 253 < n3) {
            return -1;
        }
        return n3;
    }

    @Override
    public int matches(CharacterIterator characterIterator, int n2, int[] nArray, int[] nArray2, int n3, int[] nArray3) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(characterIterator);
        BytesTrie bytesTrie = new BytesTrie(this.characters, 0);
        int n4 = uCharacterIterator.nextCodePoint();
        if (n4 == -1) {
            return 0;
        }
        BytesTrie.Result result = bytesTrie.first(this.transform(n4));
        int n5 = 1;
        int n6 = 0;
        while (true) {
            if (result.hasValue()) {
                if (n6 < n3) {
                    if (nArray3 != null) {
                        nArray3[n6] = bytesTrie.getValue();
                    }
                    nArray[n6] = n5;
                    ++n6;
                }
                if (result == BytesTrie.Result.FINAL_VALUE) {
                    break;
                }
            } else if (result == BytesTrie.Result.NO_MATCH) break;
            if (n5 >= n2 || (n4 = uCharacterIterator.nextCodePoint()) == -1) break;
            ++n5;
            result = bytesTrie.next(this.transform(n4));
        }
        nArray2[0] = n6;
        return n5;
    }

    @Override
    public int getType() {
        return 0;
    }
}

