/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter;

import java.io.IOException;
import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class BurmeseBreakEngine
extends DictionaryBreakEngine {
    private static final byte BURMESE_LOOKAHEAD = 3;
    private static final byte BURMESE_ROOT_COMBINE_THRESHOLD = 3;
    private static final byte BURMESE_PREFIX_COMBINE_THRESHOLD = 3;
    private static final byte BURMESE_MIN_WORD = 2;
    private DictionaryMatcher fDictionary;
    private UnicodeSet fEndWordSet;
    private UnicodeSet fBeginWordSet = new UnicodeSet(4096, 4138);
    private UnicodeSet fMarkSet;

    public BurmeseBreakEngine() throws IOException {
        this.fEndWordSet = new UnicodeSet("[[:Mymr:]&[:LineBreak=SA:]]");
        this.fMarkSet = new UnicodeSet("[[:Mymr:]&[:LineBreak=SA:]&[:M:]]");
        this.fMarkSet.add(32);
        this.fMarkSet.compact();
        this.fEndWordSet.compact();
        this.fBeginWordSet.compact();
        this.fMarkSet.freeze();
        this.fEndWordSet.freeze();
        this.fBeginWordSet.freeze();
        this.setCharacters(this.fEndWordSet);
        this.fDictionary = DictionaryData.loadDictionaryFor("Mymr");
    }

    public boolean equals(Object object) {
        return object instanceof BurmeseBreakEngine;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean handles(int n2) {
        int n3 = UCharacter.getIntPropertyValue(n2, 4106);
        return n3 == 28;
    }

    @Override
    public int divideUpDictionaryRange(CharacterIterator characterIterator, int n2, int n3, DictionaryBreakEngine.DequeI dequeI, boolean bl2) {
        int n4;
        int n5;
        if (n3 - n2 < 2) {
            return 0;
        }
        int n6 = 0;
        DictionaryBreakEngine.PossibleWord[] possibleWordArray = new DictionaryBreakEngine.PossibleWord[3];
        for (n5 = 0; n5 < 3; ++n5) {
            possibleWordArray[n5] = new DictionaryBreakEngine.PossibleWord();
        }
        characterIterator.setIndex(n2);
        while ((n4 = characterIterator.getIndex()) < n3) {
            int n7;
            int n8 = 0;
            int n9 = possibleWordArray[n6 % 3].candidates(characterIterator, this.fDictionary, n3);
            if (n9 == 1) {
                n8 = possibleWordArray[n6 % 3].acceptMarked(characterIterator);
                ++n6;
            } else if (n9 > 1) {
                n7 = 0;
                if (characterIterator.getIndex() < n3) {
                    block2: do {
                        if (possibleWordArray[(n6 + 1) % 3].candidates(characterIterator, this.fDictionary, n3) <= 0) continue;
                        possibleWordArray[n6 % 3].markCurrent();
                        if (characterIterator.getIndex() >= n3) break;
                        do {
                            if (possibleWordArray[(n6 + 2) % 3].candidates(characterIterator, this.fDictionary, n3) <= 0) continue;
                            possibleWordArray[n6 % 3].markCurrent();
                            n7 = 1;
                            continue block2;
                        } while (possibleWordArray[(n6 + 1) % 3].backUp(characterIterator));
                    } while (possibleWordArray[n6 % 3].backUp(characterIterator) && n7 == 0);
                }
                n8 = possibleWordArray[n6 % 3].acceptMarked(characterIterator);
                ++n6;
            }
            if (characterIterator.getIndex() < n3 && n8 < 3) {
                if (possibleWordArray[n6 % 3].candidates(characterIterator, this.fDictionary, n3) <= 0 && (n8 == 0 || possibleWordArray[n6 % 3].longestPrefix() < 3)) {
                    n7 = n3 - (n4 + n8);
                    int n10 = characterIterator.current();
                    int n11 = 0;
                    while (true) {
                        characterIterator.next();
                        n5 = characterIterator.current();
                        ++n11;
                        if (--n7 <= 0) break;
                        if (this.fEndWordSet.contains(n10) && this.fBeginWordSet.contains(n5)) {
                            int n12 = possibleWordArray[(n6 + 1) % 3].candidates(characterIterator, this.fDictionary, n3);
                            characterIterator.setIndex(n4 + n8 + n11);
                            if (n12 > 0) break;
                        }
                        n10 = n5;
                    }
                    if (n8 <= 0) {
                        ++n6;
                    }
                    n8 += n11;
                } else {
                    characterIterator.setIndex(n4 + n8);
                }
            }
            while ((n7 = characterIterator.getIndex()) < n3 && this.fMarkSet.contains(characterIterator.current())) {
                characterIterator.next();
                n8 += characterIterator.getIndex() - n7;
            }
            if (n8 <= 0) continue;
            dequeI.push(n4 + n8);
        }
        if (dequeI.peek() >= n3) {
            dequeI.pop();
            --n6;
        }
        return n6;
    }
}

