/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;

public final class UPropertyAliases {
    private static final int IX_VALUE_MAPS_OFFSET = 0;
    private static final int IX_BYTE_TRIES_OFFSET = 1;
    private static final int IX_NAME_GROUPS_OFFSET = 2;
    private static final int IX_RESERVED3_OFFSET = 3;
    private int[] valueMaps;
    private byte[] bytesTries;
    private String nameGroups;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private static final int DATA_FORMAT = 1886282093;
    public static final UPropertyAliases INSTANCE;

    private void load(ByteBuffer byteBuffer) throws IOException {
        int n2;
        ICUBinary.readHeader(byteBuffer, 1886282093, IS_ACCEPTABLE);
        int n3 = byteBuffer.getInt() / 4;
        if (n3 < 8) {
            throw new IOException("pnames.icu: not enough indexes");
        }
        int[] nArray = new int[n3];
        nArray[0] = n3 * 4;
        for (n2 = 1; n2 < n3; ++n2) {
            nArray[n2] = byteBuffer.getInt();
        }
        n2 = nArray[0];
        int n4 = nArray[1];
        int n5 = (n4 - n2) / 4;
        this.valueMaps = ICUBinary.getInts(byteBuffer, n5, 0);
        n2 = n4;
        n4 = nArray[2];
        int n6 = n4 - n2;
        this.bytesTries = new byte[n6];
        byteBuffer.get(this.bytesTries);
        n2 = n4;
        n4 = nArray[3];
        n6 = n4 - n2;
        StringBuilder stringBuilder = new StringBuilder(n6);
        for (int i2 = 0; i2 < n6; ++i2) {
            stringBuilder.append((char)byteBuffer.get());
        }
        this.nameGroups = stringBuilder.toString();
    }

    private UPropertyAliases() throws IOException {
        ByteBuffer byteBuffer = ICUBinary.getRequiredData("pnames.icu");
        this.load(byteBuffer);
    }

    private int findProperty(int n2) {
        int n3 = 1;
        for (int i2 = this.valueMaps[0]; i2 > 0; --i2) {
            int n4 = this.valueMaps[n3];
            int n5 = this.valueMaps[n3 + 1];
            n3 += 2;
            if (n2 < n4) break;
            if (n2 < n5) {
                return n3 + (n2 - n4) * 2;
            }
            n3 += (n5 - n4) * 2;
        }
        return 0;
    }

    private int findPropertyValueNameGroup(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        int n4 = ++n2;
        ++n2;
        int n5 = this.valueMaps[n4];
        if (n5 < 16) {
            while (n5 > 0) {
                int n6 = this.valueMaps[n2];
                int n7 = this.valueMaps[n2 + 1];
                n2 += 2;
                if (n3 >= n6) {
                    if (n3 < n7) {
                        return this.valueMaps[n2 + n3 - n6];
                    }
                    n2 += n7 - n6;
                    --n5;
                    continue;
                }
                break;
            }
        } else {
            int n8;
            int n9 = n2;
            int n10 = n2 + n5 - 16;
            while (n3 >= (n8 = this.valueMaps[n2])) {
                if (n3 == n8) {
                    return this.valueMaps[n10 + n2 - n9];
                }
                if (++n2 < n10) continue;
            }
        }
        return 0;
    }

    private String getName(int n2, int n3) {
        char c2 = this.nameGroups.charAt(n2++);
        if (n3 < 0 || c2 <= n3) {
            throw new IllegalIcuArgumentException("Invalid property (value) name choice");
        }
        while (n3 > 0) {
            while ('\u0000' != this.nameGroups.charAt(n2++)) {
            }
            --n3;
        }
        int n4 = n2;
        while ('\u0000' != this.nameGroups.charAt(n2)) {
            ++n2;
        }
        if (n4 == n2) {
            return null;
        }
        return this.nameGroups.substring(n4, n2);
    }

    private static int asciiToLowercase(int n2) {
        return 65 <= n2 && n2 <= 90 ? n2 + 32 : n2;
    }

    private boolean containsName(BytesTrie bytesTrie, CharSequence charSequence) {
        BytesTrie.Result result = BytesTrie.Result.NO_VALUE;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n2 = charSequence.charAt(i2);
            if (n2 == 45 || n2 == 95 || n2 == 32 || 9 <= n2 && n2 <= 13) continue;
            if (!result.hasNext()) {
                return false;
            }
            n2 = UPropertyAliases.asciiToLowercase(n2);
            result = bytesTrie.next(n2);
        }
        return result.hasValue();
    }

    public String getPropertyName(int n2, int n3) {
        int n4 = this.findProperty(n2);
        if (n4 == 0) {
            throw new IllegalArgumentException("Invalid property enum " + n2 + " (0x" + Integer.toHexString(n2) + ")");
        }
        return this.getName(this.valueMaps[n4], n3);
    }

    public String getPropertyValueName(int n2, int n3, int n4) {
        int n5 = this.findProperty(n2);
        if (n5 == 0) {
            throw new IllegalArgumentException("Invalid property enum " + n2 + " (0x" + Integer.toHexString(n2) + ")");
        }
        int n6 = this.findPropertyValueNameGroup(this.valueMaps[n5 + 1], n3);
        if (n6 == 0) {
            throw new IllegalArgumentException("Property " + n2 + " (0x" + Integer.toHexString(n2) + ") does not have named values");
        }
        return this.getName(n6, n4);
    }

    private int getPropertyOrValueEnum(int n2, CharSequence charSequence) {
        BytesTrie bytesTrie = new BytesTrie(this.bytesTries, n2);
        if (this.containsName(bytesTrie, charSequence)) {
            return bytesTrie.getValue();
        }
        return -1;
    }

    public int getPropertyEnum(CharSequence charSequence) {
        return this.getPropertyOrValueEnum(0, charSequence);
    }

    public int getPropertyValueEnum(int n2, CharSequence charSequence) {
        int n3 = this.findProperty(n2);
        if (n3 == 0) {
            throw new IllegalArgumentException("Invalid property enum " + n2 + " (0x" + Integer.toHexString(n2) + ")");
        }
        if ((n3 = this.valueMaps[n3 + 1]) == 0) {
            throw new IllegalArgumentException("Property " + n2 + " (0x" + Integer.toHexString(n2) + ") does not have named values");
        }
        return this.getPropertyOrValueEnum(this.valueMaps[n3], charSequence);
    }

    public int getPropertyValueEnumNoThrow(int n2, CharSequence charSequence) {
        int n3 = this.findProperty(n2);
        if (n3 == 0) {
            return -1;
        }
        if ((n3 = this.valueMaps[n3 + 1]) == 0) {
            return -1;
        }
        return this.getPropertyOrValueEnum(this.valueMaps[n3], charSequence);
    }

    public static int compare(String string, String string2) {
        int n2 = 0;
        int n3 = 0;
        char c2 = '\u0000';
        char c3 = '\u0000';
        block6: while (true) {
            boolean bl2;
            if (n2 < string.length()) {
                c2 = string.charAt(n2);
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '-': 
                    case '_': {
                        ++n2;
                        continue block6;
                    }
                }
            }
            block7: while (n3 < string2.length()) {
                c3 = string2.charAt(n3);
                switch (c3) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '-': 
                    case '_': {
                        ++n3;
                        continue block7;
                    }
                }
            }
            boolean bl3 = n2 == string.length();
            boolean bl4 = bl2 = n3 == string2.length();
            if (bl3) {
                if (bl2) {
                    return 0;
                }
                c2 = '\u0000';
            } else if (bl2) {
                c3 = '\u0000';
            }
            int n4 = UPropertyAliases.asciiToLowercase(c2) - UPropertyAliases.asciiToLowercase(c3);
            if (n4 != 0) {
                return n4;
            }
            ++n2;
            ++n3;
        }
    }

    static {
        try {
            INSTANCE = new UPropertyAliases();
        }
        catch (IOException iOException) {
            MissingResourceException missingResourceException = new MissingResourceException("Could not construct UPropertyAliases. Missing pnames.icu", "", "");
            missingResourceException.initCause(iOException);
            throw missingResourceException;
        }
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 2;
        }
    }
}

