/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharacterNameReader;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharacterUtility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public final class UCharacterName {
    public static final UCharacterName INSTANCE;
    public static final int LINES_PER_GROUP_ = 32;
    public int m_groupcount_ = 0;
    int m_groupsize_ = 0;
    private char[] m_tokentable_;
    private byte[] m_tokenstring_;
    private char[] m_groupinfo_;
    private byte[] m_groupstring_;
    private AlgorithmName[] m_algorithm_;
    private char[] m_groupoffsets_ = new char[33];
    private char[] m_grouplengths_ = new char[33];
    private static final String FILE_NAME_ = "unames.icu";
    private static final int GROUP_SHIFT_ = 5;
    private static final int GROUP_MASK_ = 31;
    private static final int OFFSET_HIGH_OFFSET_ = 1;
    private static final int OFFSET_LOW_OFFSET_ = 2;
    private static final int SINGLE_NIBBLE_MAX_ = 11;
    private int[] m_nameSet_ = new int[8];
    private int[] m_ISOCommentSet_ = new int[8];
    private StringBuffer m_utilStringBuffer_ = new StringBuffer();
    private int[] m_utilIntBuffer_ = new int[2];
    private int m_maxISOCommentLength_;
    private int m_maxNameLength_;
    private static final String[] TYPE_NAMES_;
    private static final String UNKNOWN_TYPE_NAME_ = "unknown";
    private static final int NON_CHARACTER_ = 30;
    private static final int LEAD_SURROGATE_ = 31;
    private static final int TRAIL_SURROGATE_ = 32;
    static final int EXTENDED_CATEGORY_ = 33;

    public String getName(int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF || n3 > 4) {
            return null;
        }
        String string = null;
        string = this.getAlgName(n2, n3);
        if (string == null || string.length() == 0) {
            string = n3 == 2 ? this.getExtendedName(n2) : this.getGroupName(n2, n3);
        }
        return string;
    }

    public int getCharFromName(int n2, String string) {
        if (n2 >= 4 || string == null || string.length() == 0) {
            return -1;
        }
        int n3 = UCharacterName.getExtendedChar(string.toLowerCase(Locale.ENGLISH), n2);
        if (n3 >= -1) {
            return n3;
        }
        String string2 = string.toUpperCase(Locale.ENGLISH);
        if (n2 == 0 || n2 == 2) {
            int n4 = 0;
            if (this.m_algorithm_ != null) {
                n4 = this.m_algorithm_.length;
            }
            --n4;
            while (n4 >= 0) {
                n3 = this.m_algorithm_[n4].getChar(string2);
                if (n3 >= 0) {
                    return n3;
                }
                --n4;
            }
        }
        if (n2 == 2) {
            n3 = this.getGroupChar(string2, 0);
            if (n3 == -1) {
                n3 = this.getGroupChar(string2, 3);
            }
        } else {
            n3 = this.getGroupChar(string2, n2);
        }
        return n3;
    }

    public int getGroupLengths(int n2, char[] cArray, char[] cArray2) {
        int n3 = 65535;
        byte by2 = 0;
        byte by3 = 0;
        int n4 = UCharacterUtility.toInt(this.m_groupinfo_[(n2 *= this.m_groupsize_) + 1], this.m_groupinfo_[n2 + 2]);
        cArray[0] = '\u0000';
        int n5 = 0;
        while (n5 < 32) {
            by2 = this.m_groupstring_[n4];
            for (int i2 = 4; i2 >= 0; i2 -= 4) {
                by3 = (byte)(by2 >> i2 & 0xF);
                if (n3 == 65535 && by3 > 11) {
                    n3 = (char)(by3 - 12 << 4);
                    continue;
                }
                cArray2[n5] = n3 != 65535 ? (char)((n3 | by3) + 12) : (char)by3;
                if (n5 < 32) {
                    cArray[n5 + 1] = (char)(cArray[n5] + cArray2[n5]);
                }
                n3 = 65535;
                ++n5;
            }
            ++n4;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupName(int n2, int n3, int n4) {
        int n5;
        if (n4 != 0 && n4 != 2) {
            if (59 >= this.m_tokentable_.length || this.m_tokentable_[59] == '\uffff') {
                int n6 = n4 == 4 ? 2 : n4;
                do {
                    n5 = n2;
                    n2 += UCharacterUtility.skipByteSubString(this.m_groupstring_, n2, n3, (byte)59);
                    n3 -= n2 - n5;
                } while (--n6 > 0);
            } else {
                n3 = 0;
            }
        }
        StringBuffer stringBuffer = this.m_utilStringBuffer_;
        synchronized (stringBuffer) {
            this.m_utilStringBuffer_.setLength(0);
            int n7 = 0;
            while (n7 < n3) {
                n5 = this.m_groupstring_[n2 + n7];
                ++n7;
                if (n5 >= this.m_tokentable_.length) {
                    if (n5 == 59) break;
                    this.m_utilStringBuffer_.append(n5);
                    continue;
                }
                char c2 = this.m_tokentable_[n5 & 0xFF];
                if (c2 == '\ufffe') {
                    c2 = this.m_tokentable_[n5 << 8 | this.m_groupstring_[n2 + n7] & 0xFF];
                    ++n7;
                }
                if (c2 == '\uffff') {
                    if (n5 == 59) {
                        if (this.m_utilStringBuffer_.length() != 0 || n4 != 2) break;
                        continue;
                    }
                    this.m_utilStringBuffer_.append((char)(n5 & 0xFF));
                    continue;
                }
                UCharacterUtility.getNullTermByteSubString(this.m_utilStringBuffer_, this.m_tokenstring_, c2);
            }
            if (this.m_utilStringBuffer_.length() > 0) {
                return this.m_utilStringBuffer_.toString();
            }
        }
        return null;
    }

    public String getExtendedName(int n2) {
        String string = this.getName(n2, 0);
        if (string == null) {
            string = this.getExtendedOr10Name(n2);
        }
        return string;
    }

    public int getGroup(int n2) {
        int n3 = this.m_groupcount_;
        int n4 = UCharacterName.getCodepointMSB(n2);
        int n5 = 0;
        while (n5 < n3 - 1) {
            int n6 = n5 + n3 >> 1;
            if (n4 < this.getGroupMSB(n6)) {
                n3 = n6;
                continue;
            }
            n5 = n6;
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExtendedOr10Name(int n2) {
        String string = null;
        if (string == null) {
            int n3 = UCharacterName.getType(n2);
            string = n3 >= TYPE_NAMES_.length ? UNKNOWN_TYPE_NAME_ : TYPE_NAMES_[n3];
            StringBuffer stringBuffer = this.m_utilStringBuffer_;
            synchronized (stringBuffer) {
                this.m_utilStringBuffer_.setLength(0);
                this.m_utilStringBuffer_.append('<');
                this.m_utilStringBuffer_.append(string);
                this.m_utilStringBuffer_.append('-');
                String string2 = Integer.toHexString(n2).toUpperCase(Locale.ENGLISH);
                for (int i2 = 4 - string2.length(); i2 > 0; --i2) {
                    this.m_utilStringBuffer_.append('0');
                }
                this.m_utilStringBuffer_.append(string2);
                this.m_utilStringBuffer_.append('>');
                string = this.m_utilStringBuffer_.toString();
            }
        }
        return string;
    }

    public int getGroupMSB(int n2) {
        if (n2 >= this.m_groupcount_) {
            return -1;
        }
        return this.m_groupinfo_[n2 * this.m_groupsize_];
    }

    public static int getCodepointMSB(int n2) {
        return n2 >> 5;
    }

    public static int getGroupLimit(int n2) {
        return (n2 << 5) + 32;
    }

    public static int getGroupMin(int n2) {
        return n2 << 5;
    }

    public static int getGroupOffset(int n2) {
        return n2 & 0x1F;
    }

    public static int getGroupMinFromCodepoint(int n2) {
        return n2 & 0xFFFFFFE0;
    }

    public int getAlgorithmLength() {
        return this.m_algorithm_.length;
    }

    public int getAlgorithmStart(int n2) {
        return this.m_algorithm_[n2].m_rangestart_;
    }

    public int getAlgorithmEnd(int n2) {
        return this.m_algorithm_[n2].m_rangeend_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlgorithmName(int n2, int n3) {
        String string = null;
        StringBuffer stringBuffer = this.m_utilStringBuffer_;
        synchronized (stringBuffer) {
            this.m_utilStringBuffer_.setLength(0);
            this.m_algorithm_[n2].appendName(n3, this.m_utilStringBuffer_);
            string = this.m_utilStringBuffer_.toString();
        }
        return string;
    }

    public synchronized String getGroupName(int n2, int n3) {
        int n4;
        int n5 = UCharacterName.getCodepointMSB(n2);
        if (n5 == this.m_groupinfo_[(n4 = this.getGroup(n2)) * this.m_groupsize_]) {
            int n6 = this.getGroupLengths(n4, this.m_groupoffsets_, this.m_grouplengths_);
            int n7 = n2 & 0x1F;
            return this.getGroupName(n6 + this.m_groupoffsets_[n7], this.m_grouplengths_[n7], n3);
        }
        return null;
    }

    public int getMaxCharNameLength() {
        if (this.initNameSetsLengths()) {
            return this.m_maxNameLength_;
        }
        return 0;
    }

    public int getMaxISOCommentLength() {
        if (this.initNameSetsLengths()) {
            return this.m_maxISOCommentLength_;
        }
        return 0;
    }

    public void getCharNameCharacters(UnicodeSet unicodeSet) {
        this.convert(this.m_nameSet_, unicodeSet);
    }

    public void getISOCommentCharacters(UnicodeSet unicodeSet) {
        this.convert(this.m_ISOCommentSet_, unicodeSet);
    }

    boolean setToken(char[] cArray, byte[] byArray) {
        if (cArray != null && byArray != null && cArray.length > 0 && byArray.length > 0) {
            this.m_tokentable_ = cArray;
            this.m_tokenstring_ = byArray;
            return true;
        }
        return false;
    }

    boolean setAlgorithm(AlgorithmName[] algorithmNameArray) {
        if (algorithmNameArray != null && algorithmNameArray.length != 0) {
            this.m_algorithm_ = algorithmNameArray;
            return true;
        }
        return false;
    }

    boolean setGroupCountSize(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            return false;
        }
        this.m_groupcount_ = n2;
        this.m_groupsize_ = n3;
        return true;
    }

    boolean setGroup(char[] cArray, byte[] byArray) {
        if (cArray != null && byArray != null && cArray.length > 0 && byArray.length > 0) {
            this.m_groupinfo_ = cArray;
            this.m_groupstring_ = byArray;
            return true;
        }
        return false;
    }

    private UCharacterName() throws IOException {
        ByteBuffer byteBuffer = ICUBinary.getRequiredData(FILE_NAME_);
        UCharacterNameReader uCharacterNameReader = new UCharacterNameReader(byteBuffer);
        uCharacterNameReader.read(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAlgName(int n2, int n3) {
        if (n3 == 0 || n3 == 2) {
            StringBuffer stringBuffer = this.m_utilStringBuffer_;
            synchronized (stringBuffer) {
                this.m_utilStringBuffer_.setLength(0);
                for (int i2 = this.m_algorithm_.length - 1; i2 >= 0; --i2) {
                    if (!this.m_algorithm_[i2].contains(n2)) continue;
                    this.m_algorithm_[i2].appendName(n2, this.m_utilStringBuffer_);
                    return this.m_utilStringBuffer_.toString();
                }
            }
        }
        return null;
    }

    private synchronized int getGroupChar(String string, int n2) {
        for (int i2 = 0; i2 < this.m_groupcount_; ++i2) {
            int n3 = this.getGroupLengths(i2, this.m_groupoffsets_, this.m_grouplengths_);
            int n4 = this.getGroupChar(n3, this.m_grouplengths_, string, n2);
            if (n4 == -1) continue;
            return this.m_groupinfo_[i2 * this.m_groupsize_] << 5 | n4;
        }
        return -1;
    }

    private int getGroupChar(int n2, char[] cArray, String string, int n3) {
        byte by2 = 0;
        int n4 = string.length();
        for (int i2 = 0; i2 <= 32; ++i2) {
            int n5 = 0;
            int n6 = cArray[i2];
            if (n3 != 0 && n3 != 2) {
                int n7 = n3 == 4 ? 2 : n3;
                do {
                    int n8 = n2;
                    n2 += UCharacterUtility.skipByteSubString(this.m_groupstring_, n2, n6, (byte)59);
                    n6 -= n2 - n8;
                } while (--n7 > 0);
            }
            int n9 = 0;
            while (n9 < n6 && n5 != -1 && n5 < n4) {
                by2 = this.m_groupstring_[n2 + n9];
                ++n9;
                if (by2 >= this.m_tokentable_.length) {
                    if (string.charAt(n5++) == (by2 & 0xFF)) continue;
                    n5 = -1;
                    continue;
                }
                char c2 = this.m_tokentable_[by2 & 0xFF];
                if (c2 == '\ufffe') {
                    c2 = this.m_tokentable_[by2 << 8 | this.m_groupstring_[n2 + n9] & 0xFF];
                    ++n9;
                }
                if (c2 == '\uffff') {
                    if (string.charAt(n5++) == (by2 & 0xFF)) continue;
                    n5 = -1;
                    continue;
                }
                n5 = UCharacterUtility.compareNullTermByteSubString(string, this.m_tokenstring_, n5, c2);
            }
            if (n4 == n5 && (n9 == n6 || this.m_groupstring_[n2 + n9] == 59)) {
                return i2;
            }
            n2 += n6;
        }
        return -1;
    }

    private static int getType(int n2) {
        if (UCharacterUtility.isNonCharacter(n2)) {
            return 30;
        }
        int n3 = UCharacter.getType(n2);
        if (n3 == 18) {
            n3 = n2 <= 56319 ? 31 : 32;
        }
        return n3;
    }

    private static int getExtendedChar(String string, int n2) {
        if (string.charAt(0) == '<') {
            int n3;
            int n4;
            if (n2 == 2 && string.charAt(n4 = string.length() - 1) == '>' && (n3 = string.lastIndexOf(45)) >= 0) {
                int n5;
                if ((n5 = n4 - ++n3) < 1 || 8 < n5) {
                    return -1;
                }
                int n6 = -1;
                try {
                    n6 = Integer.parseInt(string.substring(n3, n4), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return -1;
                }
                if (n6 < 0 || 0x10FFFF < n6) {
                    return -1;
                }
                int n7 = UCharacterName.getType(n6);
                String string2 = string.substring(1, n3 - 1);
                int n8 = TYPE_NAMES_.length;
                for (int i2 = 0; i2 < n8; ++i2) {
                    if (string2.compareTo(TYPE_NAMES_[i2]) != 0) continue;
                    if (n7 != i2) break;
                    return n6;
                }
            }
            return -1;
        }
        return -2;
    }

    private static void add(int[] nArray, char c2) {
        int n2 = c2 >>> 5;
        nArray[n2] = nArray[n2] | 1 << (c2 & 0x1F);
    }

    private static boolean contains(int[] nArray, char c2) {
        return (nArray[c2 >>> 5] & 1 << (c2 & 0x1F)) != 0;
    }

    private static int add(int[] nArray, String string) {
        int n2 = string.length();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            UCharacterName.add(nArray, string.charAt(i2));
        }
        return n2;
    }

    private static int add(int[] nArray, StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            UCharacterName.add(nArray, stringBuffer.charAt(i2));
        }
        return n2;
    }

    private int addAlgorithmName(int n2) {
        int n3 = 0;
        for (int i2 = this.m_algorithm_.length - 1; i2 >= 0; --i2) {
            n3 = this.m_algorithm_[i2].add(this.m_nameSet_, n2);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int addExtendedName(int n2) {
        for (int i2 = TYPE_NAMES_.length - 1; i2 >= 0; --i2) {
            int n3 = 9 + UCharacterName.add(this.m_nameSet_, TYPE_NAMES_[i2]);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] addGroupName(int n2, int n3, byte[] byArray, int[] nArray) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            char c2 = (char)(this.m_groupstring_[n2 + n5] & 0xFF);
            ++n5;
            if (c2 == ';') break;
            if (c2 >= this.m_tokentable_.length) {
                UCharacterName.add(nArray, c2);
                ++n4;
                continue;
            }
            char c3 = this.m_tokentable_[c2 & 0xFF];
            if (c3 == '\ufffe') {
                c2 = (char)(c2 << 8 | this.m_groupstring_[n2 + n5] & 0xFF);
                c3 = this.m_tokentable_[c2];
                ++n5;
            }
            if (c3 == '\uffff') {
                UCharacterName.add(nArray, c2);
                ++n4;
                continue;
            }
            byte by2 = byArray[c2];
            if (by2 == 0) {
                StringBuffer stringBuffer = this.m_utilStringBuffer_;
                synchronized (stringBuffer) {
                    this.m_utilStringBuffer_.setLength(0);
                    UCharacterUtility.getNullTermByteSubString(this.m_utilStringBuffer_, this.m_tokenstring_, c3);
                    by2 = (byte)UCharacterName.add(nArray, this.m_utilStringBuffer_);
                }
                byArray[c2] = by2;
            }
            n4 += by2;
        }
        this.m_utilIntBuffer_[0] = n4;
        this.m_utilIntBuffer_[1] = n5;
        return this.m_utilIntBuffer_;
    }

    private void addGroupName(int n2) {
        int n3 = 0;
        char[] cArray = new char[34];
        char[] cArray2 = new char[34];
        byte[] byArray = new byte[this.m_tokentable_.length];
        for (int i2 = 0; i2 < this.m_groupcount_; ++i2) {
            int n4 = this.getGroupLengths(i2, cArray, cArray2);
            for (int i3 = 0; i3 < 32; ++i3) {
                int n5 = n4 + cArray[i3];
                int n6 = cArray2[i3];
                if (n6 == 0) continue;
                int[] nArray = this.addGroupName(n5, n6, byArray, this.m_nameSet_);
                if (nArray[0] > n2) {
                    n2 = nArray[0];
                }
                n5 += nArray[1];
                if (nArray[1] >= n6) continue;
                if ((nArray = this.addGroupName(n5, n6 -= nArray[1], byArray, this.m_nameSet_))[0] > n2) {
                    n2 = nArray[0];
                }
                n5 += nArray[1];
                if (nArray[1] >= n6 || (nArray = this.addGroupName(n5, n6 -= nArray[1], byArray, this.m_ISOCommentSet_))[1] <= n3) continue;
                n3 = n6;
            }
        }
        this.m_maxISOCommentLength_ = n3;
        this.m_maxNameLength_ = n2;
    }

    private boolean initNameSetsLengths() {
        if (this.m_maxNameLength_ > 0) {
            return true;
        }
        String string = "0123456789ABCDEF<>-";
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            UCharacterName.add(this.m_nameSet_, string.charAt(i2));
        }
        this.m_maxNameLength_ = this.addAlgorithmName(0);
        this.m_maxNameLength_ = this.addExtendedName(this.m_maxNameLength_);
        this.addGroupName(this.m_maxNameLength_);
        return true;
    }

    private void convert(int[] nArray, UnicodeSet unicodeSet) {
        unicodeSet.clear();
        if (!this.initNameSetsLengths()) {
            return;
        }
        for (char c2 = '\u00ff'; c2 > '\u0000'; c2 = (char)(c2 - '\u0001')) {
            if (!UCharacterName.contains(nArray, c2)) continue;
            unicodeSet.add(c2);
        }
    }

    static {
        try {
            INSTANCE = new UCharacterName();
        }
        catch (IOException iOException) {
            throw new MissingResourceException("Could not construct UCharacterName. Missing unames.icu", "", "");
        }
        TYPE_NAMES_ = new String[]{"unassigned", "uppercase letter", "lowercase letter", "titlecase letter", "modifier letter", "other letter", "non spacing mark", "enclosing mark", "combining spacing mark", "decimal digit number", "letter number", "other number", "space separator", "line separator", "paragraph separator", "control", "format", "private use area", "surrogate", "dash punctuation", "start punctuation", "end punctuation", "connector punctuation", "other punctuation", "math symbol", "currency symbol", "modifier symbol", "other symbol", "initial punctuation", "final punctuation", "noncharacter", "lead surrogate", "trail surrogate"};
    }

    static final class AlgorithmName {
        static final int TYPE_0_ = 0;
        static final int TYPE_1_ = 1;
        private int m_rangestart_;
        private int m_rangeend_;
        private byte m_type_;
        private byte m_variant_;
        private char[] m_factor_;
        private String m_prefix_;
        private byte[] m_factorstring_;
        private StringBuffer m_utilStringBuffer_ = new StringBuffer();
        private int[] m_utilIntBuffer_ = new int[256];

        AlgorithmName() {
        }

        boolean setInfo(int n2, int n3, byte by2, byte by3) {
            if (n2 >= 0 && n2 <= n3 && n3 <= 0x10FFFF && (by2 == 0 || by2 == 1)) {
                this.m_rangestart_ = n2;
                this.m_rangeend_ = n3;
                this.m_type_ = by2;
                this.m_variant_ = by3;
                return true;
            }
            return false;
        }

        boolean setFactor(char[] cArray) {
            if (cArray.length == this.m_variant_) {
                this.m_factor_ = cArray;
                return true;
            }
            return false;
        }

        boolean setPrefix(String string) {
            if (string != null && string.length() > 0) {
                this.m_prefix_ = string;
                return true;
            }
            return false;
        }

        boolean setFactorString(byte[] byArray) {
            this.m_factorstring_ = byArray;
            return true;
        }

        boolean contains(int n2) {
            return this.m_rangestart_ <= n2 && n2 <= this.m_rangeend_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void appendName(int n2, StringBuffer stringBuffer) {
            stringBuffer.append(this.m_prefix_);
            switch (this.m_type_) {
                case 0: {
                    stringBuffer.append(Utility.hex(n2, this.m_variant_));
                    return;
                }
                case 1: {
                    int n3 = n2 - this.m_rangestart_;
                    int[] nArray = this.m_utilIntBuffer_;
                    int[] nArray2 = this.m_utilIntBuffer_;
                    synchronized (this.m_utilIntBuffer_) {
                        for (int i2 = this.m_variant_ - 1; i2 > 0; --i2) {
                            int n4 = this.m_factor_[i2] & 0xFF;
                            nArray[i2] = n3 % n4;
                            n3 /= n4;
                        }
                        nArray[0] = n3;
                        stringBuffer.append(this.getFactorString(nArray, this.m_variant_));
                        // ** MonitorExit[var6_5] (shouldn't be in output)
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        int getChar(String string) {
            int n2 = this.m_prefix_.length();
            if (string.length() < n2) return -1;
            if (!this.m_prefix_.equals(string.substring(0, n2))) {
                return -1;
            }
            switch (this.m_type_) {
                case 0: {
                    try {
                        int n3 = Integer.parseInt(string.substring(n2), 16);
                        if (this.m_rangestart_ > n3) return -1;
                        if (n3 > this.m_rangeend_) return -1;
                        return n3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return -1;
                    }
                }
                case 1: {
                    int n4 = this.m_rangestart_;
                    while (n4 <= this.m_rangeend_) {
                        int n5;
                        int n6 = n4 - this.m_rangestart_;
                        int[] nArray = this.m_utilIntBuffer_;
                        int[] nArray2 = this.m_utilIntBuffer_;
                        // MONITORENTER : this.m_utilIntBuffer_
                        for (int i2 = this.m_variant_ - 1; i2 > 0; n6 /= n5, --i2) {
                            n5 = this.m_factor_[i2] & 0xFF;
                            nArray[i2] = n6 % n5;
                        }
                        nArray[0] = n6;
                        if (this.compareFactorString(nArray, this.m_variant_, string, n2)) {
                            // MONITOREXIT : nArray2
                            return n4;
                        }
                        // MONITOREXIT : nArray2
                        ++n4;
                    }
                    return -1;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int add(int[] nArray, int n2) {
            int n3 = UCharacterName.add(nArray, this.m_prefix_);
            switch (this.m_type_) {
                case 0: {
                    n3 += this.m_variant_;
                    break;
                }
                case 1: {
                    for (int i2 = this.m_variant_ - 1; i2 > 0; --i2) {
                        int n4 = 0;
                        int n5 = 0;
                        for (int i3 = this.m_factor_[i2]; i3 > 0; --i3) {
                            StringBuffer stringBuffer = this.m_utilStringBuffer_;
                            synchronized (stringBuffer) {
                                this.m_utilStringBuffer_.setLength(0);
                                n5 = UCharacterUtility.getNullTermByteSubString(this.m_utilStringBuffer_, this.m_factorstring_, n5);
                                UCharacterName.add(nArray, this.m_utilStringBuffer_);
                                if (this.m_utilStringBuffer_.length() > n4) {
                                    n4 = this.m_utilStringBuffer_.length();
                                }
                                continue;
                            }
                        }
                        n3 += n4;
                    }
                    break;
                }
            }
            if (n3 > n2) {
                return n3;
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getFactorString(int[] nArray, int n2) {
            int n3 = this.m_factor_.length;
            if (nArray == null || n2 != n3) {
                return null;
            }
            StringBuffer stringBuffer = this.m_utilStringBuffer_;
            synchronized (stringBuffer) {
                this.m_utilStringBuffer_.setLength(0);
                int n4 = 0;
                --n3;
                for (int i2 = 0; i2 <= n3; ++i2) {
                    char c2 = this.m_factor_[i2];
                    n4 = UCharacterUtility.skipNullTermByteSubString(this.m_factorstring_, n4, nArray[i2]);
                    n4 = UCharacterUtility.getNullTermByteSubString(this.m_utilStringBuffer_, this.m_factorstring_, n4);
                    if (i2 == n3) continue;
                    n4 = UCharacterUtility.skipNullTermByteSubString(this.m_factorstring_, n4, c2 - nArray[i2] - 1);
                }
                return this.m_utilStringBuffer_.toString();
            }
        }

        private boolean compareFactorString(int[] nArray, int n2, String string, int n3) {
            int n4 = this.m_factor_.length;
            if (nArray == null || n2 != n4) {
                return false;
            }
            int n5 = 0;
            int n6 = n3;
            --n4;
            for (int i2 = 0; i2 <= n4; ++i2) {
                char c2 = this.m_factor_[i2];
                if ((n6 = UCharacterUtility.compareNullTermByteSubString(string, this.m_factorstring_, n6, n5 = UCharacterUtility.skipNullTermByteSubString(this.m_factorstring_, n5, nArray[i2]))) < 0) {
                    return false;
                }
                if (i2 == n4) continue;
                n5 = UCharacterUtility.skipNullTermByteSubString(this.m_factorstring_, n5, c2 - nArray[i2]);
            }
            return n6 == string.length();
        }
    }
}

