/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class UCaseProps {
    private static final byte[] flagsOffset = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    public static final int MAX_STRING_LENGTH = 31;
    public static final int LOC_ROOT = 1;
    static final int LOC_TURKISH = 2;
    static final int LOC_LITHUANIAN = 3;
    static final int LOC_GREEK = 4;
    public static final int LOC_DUTCH = 5;
    static final int LOC_ARMENIAN = 6;
    private static final String iDot = "i\u0307";
    private static final String jDot = "j\u0307";
    private static final String iOgonekDot = "\u012f\u0307";
    private static final String iDotGrave = "i\u0307\u0300";
    private static final String iDotAcute = "i\u0307\u0301";
    private static final String iDotTilde = "i\u0307\u0303";
    static final int FOLD_CASE_OPTIONS_MASK = 7;
    public static final StringBuilder dummyStringBuilder = new StringBuilder();
    private int[] indexes;
    private String exceptions;
    private char[] unfold;
    private Trie2_16 trie;
    private static final String DATA_NAME = "ucase";
    private static final String DATA_TYPE = "icu";
    private static final String DATA_FILE_NAME = "ucase.icu";
    private static final int FMT = 1665225541;
    private static final int IX_TRIE_SIZE = 2;
    private static final int IX_EXC_LENGTH = 3;
    private static final int IX_UNFOLD_LENGTH = 4;
    private static final int IX_TOP = 16;
    public static final int TYPE_MASK = 3;
    public static final int NONE = 0;
    public static final int LOWER = 1;
    public static final int UPPER = 2;
    public static final int TITLE = 3;
    static final int IGNORABLE = 4;
    private static final int EXCEPTION = 8;
    private static final int SENSITIVE = 16;
    private static final int DOT_MASK = 96;
    private static final int SOFT_DOTTED = 32;
    private static final int ABOVE = 64;
    private static final int OTHER_ACCENT = 96;
    private static final int DELTA_SHIFT = 7;
    private static final int EXC_SHIFT = 4;
    private static final int EXC_LOWER = 0;
    private static final int EXC_FOLD = 1;
    private static final int EXC_UPPER = 2;
    private static final int EXC_TITLE = 3;
    private static final int EXC_DELTA = 4;
    private static final int EXC_CLOSURE = 6;
    private static final int EXC_FULL_MAPPINGS = 7;
    private static final int EXC_DOUBLE_SLOTS = 256;
    private static final int EXC_NO_SIMPLE_CASE_FOLDING = 512;
    private static final int EXC_DELTA_IS_NEGATIVE = 1024;
    private static final int EXC_SENSITIVE = 2048;
    private static final int EXC_DOT_SHIFT = 7;
    private static final int EXC_CONDITIONAL_SPECIAL = 16384;
    private static final int EXC_CONDITIONAL_FOLD = 32768;
    private static final int FULL_LOWER = 15;
    private static final int CLOSURE_MAX_LENGTH = 15;
    private static final int UNFOLD_ROWS = 0;
    private static final int UNFOLD_ROW_WIDTH = 1;
    private static final int UNFOLD_STRING_WIDTH = 2;
    public static final UCaseProps INSTANCE;

    private UCaseProps() throws IOException {
        ByteBuffer byteBuffer = ICUBinary.getRequiredData(DATA_FILE_NAME);
        this.readData(byteBuffer);
    }

    private final void readData(ByteBuffer byteBuffer) throws IOException {
        int n2;
        ICUBinary.readHeader(byteBuffer, 1665225541, new IsAcceptable());
        int n3 = byteBuffer.getInt();
        if (n3 < 16) {
            throw new IOException("indexes[0] too small in ucase.icu");
        }
        this.indexes = new int[n3];
        this.indexes[0] = n3;
        for (n2 = 1; n2 < n3; ++n2) {
            this.indexes[n2] = byteBuffer.getInt();
        }
        this.trie = Trie2_16.createFromSerialized(byteBuffer);
        n2 = this.indexes[2];
        int n4 = this.trie.getSerializedLength();
        if (n4 > n2) {
            throw new IOException("ucase.icu: not enough bytes for the trie");
        }
        ICUBinary.skipBytes(byteBuffer, n2 - n4);
        n3 = this.indexes[3];
        if (n3 > 0) {
            this.exceptions = ICUBinary.getString(byteBuffer, n3, 0);
        }
        if ((n3 = this.indexes[4]) > 0) {
            this.unfold = ICUBinary.getChars(byteBuffer, n3, 0);
        }
    }

    public final void addPropertyStarts(UnicodeSet unicodeSet) {
        for (Trie2.Range range : this.trie) {
            if (range.leadSurrogate) break;
            unicodeSet.add(range.startCodePoint);
        }
    }

    private static final int getExceptionsOffset(int n2) {
        return n2 >> 4;
    }

    static final boolean propsHasException(int n2) {
        return (n2 & 8) != 0;
    }

    private static final boolean hasSlot(int n2, int n3) {
        return (n2 & 1 << n3) != 0;
    }

    private static final byte slotOffset(int n2, int n3) {
        return flagsOffset[n2 & (1 << n3) - 1];
    }

    private final long getSlotValueAndOffset(int n2, int n3, int n4) {
        long l2;
        if ((n2 & 0x100) == 0) {
            l2 = this.exceptions.charAt(n4 += UCaseProps.slotOffset(n2, n3));
        } else {
            n4 += 2 * UCaseProps.slotOffset(n2, n3);
            l2 = this.exceptions.charAt(n4++);
            l2 = l2 << 16 | (long)this.exceptions.charAt(n4);
        }
        return l2 | (long)n4 << 32;
    }

    private final int getSlotValue(int n2, int n3, int n4) {
        int n5;
        if ((n2 & 0x100) == 0) {
            n5 = this.exceptions.charAt(n4 += UCaseProps.slotOffset(n2, n3));
        } else {
            n4 += 2 * UCaseProps.slotOffset(n2, n3);
            n5 = this.exceptions.charAt(n4++);
            n5 = n5 << 16 | this.exceptions.charAt(n4);
        }
        return n5;
    }

    public final int tolower(int n2) {
        int n3 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n3)) {
            if (UCaseProps.isUpperOrTitleFromProps(n3)) {
                n2 += UCaseProps.getDelta(n3);
            }
        } else {
            char c2;
            int n4 = UCaseProps.getExceptionsOffset(n3);
            if (UCaseProps.hasSlot(c2 = this.exceptions.charAt(n4++), 4) && UCaseProps.isUpperOrTitleFromProps(n3)) {
                int n5 = this.getSlotValue(c2, 4, n4);
                return (c2 & 0x400) == 0 ? n2 + n5 : n2 - n5;
            }
            if (UCaseProps.hasSlot(c2, 0)) {
                n2 = this.getSlotValue(c2, 0, n4);
            }
        }
        return n2;
    }

    public final int toupper(int n2) {
        int n3 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n3)) {
            if (UCaseProps.getTypeFromProps(n3) == 1) {
                n2 += UCaseProps.getDelta(n3);
            }
        } else {
            char c2;
            int n4 = UCaseProps.getExceptionsOffset(n3);
            if (UCaseProps.hasSlot(c2 = this.exceptions.charAt(n4++), 4) && UCaseProps.getTypeFromProps(n3) == 1) {
                int n5 = this.getSlotValue(c2, 4, n4);
                return (c2 & 0x400) == 0 ? n2 + n5 : n2 - n5;
            }
            if (UCaseProps.hasSlot(c2, 2)) {
                n2 = this.getSlotValue(c2, 2, n4);
            }
        }
        return n2;
    }

    public final int totitle(int n2) {
        int n3 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n3)) {
            if (UCaseProps.getTypeFromProps(n3) == 1) {
                n2 += UCaseProps.getDelta(n3);
            }
        } else {
            int n4;
            char c2;
            int n5 = UCaseProps.getExceptionsOffset(n3);
            if (UCaseProps.hasSlot(c2 = this.exceptions.charAt(n5++), 4) && UCaseProps.getTypeFromProps(n3) == 1) {
                int n6 = this.getSlotValue(c2, 4, n5);
                return (c2 & 0x400) == 0 ? n2 + n6 : n2 - n6;
            }
            if (UCaseProps.hasSlot(c2, 3)) {
                n4 = 3;
            } else if (UCaseProps.hasSlot(c2, 2)) {
                n4 = 2;
            } else {
                return n2;
            }
            n2 = this.getSlotValue(c2, n4, n5);
        }
        return n2;
    }

    public final void addCaseClosure(int n2, UnicodeSet unicodeSet) {
        int n3 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n3)) {
            int n4;
            if (UCaseProps.getTypeFromProps(n3) != 0 && (n4 = UCaseProps.getDelta(n3)) != 0) {
                unicodeSet.add(n2 + n4);
            }
        } else {
            int n5;
            long l2;
            int n6;
            int n7;
            int n8 = UCaseProps.getExceptionsOffset(n3);
            char c2 = this.exceptions.charAt(n8++);
            int n9 = n8;
            if ((c2 & 0x8000) != 0) {
                if (n2 == 73) {
                    unicodeSet.add(105);
                    return;
                }
                if (n2 == 304) {
                    unicodeSet.add(iDot);
                    return;
                }
            } else {
                if (n2 == 105) {
                    unicodeSet.add(73);
                    return;
                }
                if (n2 == 305) {
                    return;
                }
            }
            for (n7 = 0; n7 <= 3; ++n7) {
                if (!UCaseProps.hasSlot(c2, n7)) continue;
                n8 = n9;
                n6 = this.getSlotValue(c2, n7, n8);
                unicodeSet.add(n6);
            }
            if (UCaseProps.hasSlot(c2, 4)) {
                n8 = n9;
                n7 = this.getSlotValue(c2, 4, n8);
                unicodeSet.add((c2 & 0x400) == 0 ? n2 + n7 : n2 - n7);
            }
            if (UCaseProps.hasSlot(c2, 6)) {
                n8 = n9;
                l2 = this.getSlotValueAndOffset(c2, 6, n8);
                n6 = (int)l2 & 0xF;
                n7 = (int)(l2 >> 32) + 1;
            } else {
                n6 = 0;
                n7 = 0;
            }
            if (UCaseProps.hasSlot(c2, 7)) {
                n8 = n9;
                l2 = this.getSlotValueAndOffset(c2, 7, n8);
                n5 = (int)l2;
                n8 = (int)(l2 >> 32) + 1;
                n8 += (n5 &= 0xFFFF) & 0xF;
                int n10 = (n5 >>= 4) & 0xF;
                if (n10 != 0) {
                    unicodeSet.add(this.exceptions.substring(n8, n8 + n10));
                    n8 += n10;
                }
                n8 += (n5 >>= 4) & 0xF;
                n7 = n8 += (n5 >>= 4);
            }
            int n11 = n7 + n6;
            for (int i2 = n7; i2 < n11; i2 += UTF16.getCharCount(n2)) {
                n5 = this.exceptions.codePointAt(i2);
                unicodeSet.add(n5);
            }
        }
    }

    public final void addSimpleCaseClosure(int n2, UnicodeSet unicodeSet) {
        int n3 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n3)) {
            int n4;
            if (UCaseProps.getTypeFromProps(n3) != 0 && (n4 = UCaseProps.getDelta(n3)) != 0) {
                unicodeSet.add(n2 + n4);
            }
        } else {
            int n5;
            long l2;
            int n6;
            int n7;
            int n8 = UCaseProps.getExceptionsOffset(n3);
            char c2 = this.exceptions.charAt(n8++);
            int n9 = n8;
            if ((c2 & 0x8000) != 0) {
                if (n2 == 73) {
                    unicodeSet.add(105);
                    return;
                }
                if (n2 == 304) {
                    return;
                }
            } else {
                if (n2 == 105) {
                    unicodeSet.add(73);
                    return;
                }
                if (n2 == 305) {
                    return;
                }
            }
            for (n7 = 0; n7 <= 3; ++n7) {
                if (!UCaseProps.hasSlot(c2, n7)) continue;
                n8 = n9;
                n6 = this.getSlotValue(c2, n7, n8);
                unicodeSet.add(n6);
            }
            if (UCaseProps.hasSlot(c2, 4)) {
                n8 = n9;
                n7 = this.getSlotValue(c2, 4, n8);
                n6 = (c2 & 0x400) == 0 ? n2 + n7 : n2 - n7;
                unicodeSet.add(n6);
            }
            if (UCaseProps.hasSlot(c2, 6)) {
                n8 = n9;
                l2 = this.getSlotValueAndOffset(c2, 6, n8);
                n6 = (int)l2 & 0xF;
                n7 = (int)(l2 >> 32) + 1;
            } else {
                n6 = 0;
                n7 = 0;
            }
            if (n6 > 0 && UCaseProps.hasSlot(c2, 7)) {
                n8 = n9;
                l2 = this.getSlotValueAndOffset(c2, 7, n8);
                n5 = (int)l2;
                n8 = (int)(l2 >> 32) + 1;
                n8 += (n5 &= 0xFFFF) & 0xF;
                n8 += (n5 >>= 4) & 0xF;
                n8 += (n5 >>= 4) & 0xF;
                n7 = n8 += (n5 >>= 4);
            }
            int n10 = n7 + n6;
            for (int i2 = n7; i2 < n10; i2 += UTF16.getCharCount(n2)) {
                n5 = this.exceptions.codePointAt(i2);
                unicodeSet.add(n5);
            }
        }
    }

    private final int strcmpMax(String string, int n2, int n3) {
        int n4 = string.length();
        n3 -= n4;
        int n5 = 0;
        do {
            char c2;
            int n6 = string.charAt(n5++);
            if ((c2 = this.unfold[n2++]) == '\u0000') {
                return 1;
            }
            if ((n6 -= c2) == 0) continue;
            return n6;
        } while (--n4 > 0);
        if (n3 == 0 || this.unfold[n2] == '\u0000') {
            return 0;
        }
        return -n3;
    }

    public final boolean addStringCaseClosure(String string, UnicodeSet unicodeSet) {
        if (this.unfold == null || string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 <= 1) {
            return false;
        }
        int n3 = this.unfold[0];
        char c2 = this.unfold[1];
        int n4 = this.unfold[2];
        if (n2 > n4) {
            return false;
        }
        int n5 = 0;
        int n6 = n3;
        while (n5 < n6) {
            int n7 = (n5 + n6) / 2;
            int n8 = (n7 + 1) * c2;
            int n9 = this.strcmpMax(string, n8, n4);
            if (n9 == 0) {
                int n10;
                for (n7 = n4; n7 < c2 && this.unfold[n8 + n7] != '\u0000'; n7 += UTF16.getCharCount(n10)) {
                    n10 = UTF16.charAt(this.unfold, n8, this.unfold.length, n7);
                    unicodeSet.add(n10);
                    this.addCaseClosure(n10, unicodeSet);
                }
                return true;
            }
            if (n9 < 0) {
                n6 = n7;
                continue;
            }
            n5 = n7 + 1;
        }
        return false;
    }

    public final int getType(int n2) {
        return UCaseProps.getTypeFromProps(this.trie.get(n2));
    }

    public final int getTypeOrIgnorable(int n2) {
        return UCaseProps.getTypeAndIgnorableFromProps(this.trie.get(n2));
    }

    public final int getDotType(int n2) {
        int n3 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n3)) {
            return n3 & 0x60;
        }
        return this.exceptions.charAt(UCaseProps.getExceptionsOffset(n3)) >> 7 & 0x60;
    }

    public final boolean isSoftDotted(int n2) {
        return this.getDotType(n2) == 32;
    }

    public final boolean isCaseSensitive(int n2) {
        int n3 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n3)) {
            return (n3 & 0x10) != 0;
        }
        return (this.exceptions.charAt(UCaseProps.getExceptionsOffset(n3)) & 0x800) != 0;
    }

    public static final int getCaseLocale(Locale locale) {
        return UCaseProps.getCaseLocale(locale.getLanguage());
    }

    public static final int getCaseLocale(ULocale uLocale) {
        return UCaseProps.getCaseLocale(uLocale.getLanguage());
    }

    private static final int getCaseLocale(String string) {
        if (string.length() == 2) {
            if (string.equals("en") || string.charAt(0) > 't') {
                return 1;
            }
            if (string.equals("tr") || string.equals("az")) {
                return 2;
            }
            if (string.equals("el")) {
                return 4;
            }
            if (string.equals("lt")) {
                return 3;
            }
            if (string.equals("nl")) {
                return 5;
            }
            if (string.equals("hy")) {
                return 6;
            }
        } else if (string.length() == 3) {
            if (string.equals("tur") || string.equals("aze")) {
                return 2;
            }
            if (string.equals("ell")) {
                return 4;
            }
            if (string.equals("lit")) {
                return 3;
            }
            if (string.equals("nld")) {
                return 5;
            }
            if (string.equals("hye")) {
                return 6;
            }
        }
        return 1;
    }

    private final boolean isFollowedByCasedLetter(ContextIterator contextIterator, int n2) {
        int n3;
        if (contextIterator == null) {
            return false;
        }
        contextIterator.reset(n2);
        while ((n3 = contextIterator.next()) >= 0) {
            int n4 = this.getTypeOrIgnorable(n3);
            if ((n4 & 4) != 0) continue;
            return n4 != 0;
        }
        return false;
    }

    private final boolean isPrecededBySoftDotted(ContextIterator contextIterator) {
        int n2;
        if (contextIterator == null) {
            return false;
        }
        contextIterator.reset(-1);
        while ((n2 = contextIterator.next()) >= 0) {
            int n3 = this.getDotType(n2);
            if (n3 == 32) {
                return true;
            }
            if (n3 == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean isPrecededBy_I(ContextIterator contextIterator) {
        int n2;
        if (contextIterator == null) {
            return false;
        }
        contextIterator.reset(-1);
        while ((n2 = contextIterator.next()) >= 0) {
            if (n2 == 73) {
                return true;
            }
            int n3 = this.getDotType(n2);
            if (n3 == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean isFollowedByMoreAbove(ContextIterator contextIterator) {
        int n2;
        if (contextIterator == null) {
            return false;
        }
        contextIterator.reset(1);
        while ((n2 = contextIterator.next()) >= 0) {
            int n3 = this.getDotType(n2);
            if (n3 == 64) {
                return true;
            }
            if (n3 == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean isFollowedByDotAbove(ContextIterator contextIterator) {
        int n2;
        if (contextIterator == null) {
            return false;
        }
        contextIterator.reset(1);
        while ((n2 = contextIterator.next()) >= 0) {
            if (n2 == 775) {
                return true;
            }
            int n3 = this.getDotType(n2);
            if (n3 == 96) continue;
            return false;
        }
        return false;
    }

    public final int toFullLower(int n2, ContextIterator contextIterator, Appendable appendable, int n3) {
        int n4 = n2;
        int n5 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n5)) {
            if (UCaseProps.isUpperOrTitleFromProps(n5)) {
                n4 = n2 + UCaseProps.getDelta(n5);
            }
        } else {
            long l2;
            int n6;
            int n7 = UCaseProps.getExceptionsOffset(n5);
            char c2 = this.exceptions.charAt(n7++);
            int n8 = n7;
            if ((c2 & 0x4000) != 0) {
                if (n3 == 3 && ((n2 == 73 || n2 == 74 || n2 == 302) && this.isFollowedByMoreAbove(contextIterator) || n2 == 204 || n2 == 205 || n2 == 296)) {
                    try {
                        switch (n2) {
                            case 73: {
                                appendable.append(iDot);
                                return 2;
                            }
                            case 74: {
                                appendable.append(jDot);
                                return 2;
                            }
                            case 302: {
                                appendable.append(iOgonekDot);
                                return 2;
                            }
                            case 204: {
                                appendable.append(iDotGrave);
                                return 3;
                            }
                            case 205: {
                                appendable.append(iDotAcute);
                                return 3;
                            }
                            case 296: {
                                appendable.append(iDotTilde);
                                return 3;
                            }
                        }
                        return 0;
                    }
                    catch (IOException iOException) {
                        throw new ICUUncheckedIOException(iOException);
                    }
                }
                if (n3 == 2 && n2 == 304) {
                    return 105;
                }
                if (n3 == 2 && n2 == 775 && this.isPrecededBy_I(contextIterator)) {
                    return 0;
                }
                if (n3 == 2 && n2 == 73 && !this.isFollowedByDotAbove(contextIterator)) {
                    return 305;
                }
                if (n2 == 304) {
                    try {
                        appendable.append(iDot);
                        return 2;
                    }
                    catch (IOException iOException) {
                        throw new ICUUncheckedIOException(iOException);
                    }
                }
                if (n2 == 931 && !this.isFollowedByCasedLetter(contextIterator, 1) && this.isFollowedByCasedLetter(contextIterator, -1)) {
                    return 962;
                }
            } else if (UCaseProps.hasSlot(c2, 7) && (n6 = (int)(l2 = this.getSlotValueAndOffset(c2, 7, n7)) & 0xF) != 0) {
                n7 = (int)(l2 >> 32) + 1;
                try {
                    appendable.append(this.exceptions, n7, n7 + n6);
                    return n6;
                }
                catch (IOException iOException) {
                    throw new ICUUncheckedIOException(iOException);
                }
            }
            if (UCaseProps.hasSlot(c2, 4) && UCaseProps.isUpperOrTitleFromProps(n5)) {
                int n9 = this.getSlotValue(c2, 4, n8);
                return (c2 & 0x400) == 0 ? n2 + n9 : n2 - n9;
            }
            if (UCaseProps.hasSlot(c2, 0)) {
                n4 = this.getSlotValue(c2, 0, n8);
            }
        }
        return n4 == n2 ? ~n4 : n4;
    }

    private final int toUpperOrTitle(int n2, ContextIterator contextIterator, Appendable appendable, int n3, boolean bl2) {
        int n4 = n2;
        int n5 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n5)) {
            if (UCaseProps.getTypeFromProps(n5) == 1) {
                n4 = n2 + UCaseProps.getDelta(n5);
            }
        } else {
            int n6;
            int n7 = UCaseProps.getExceptionsOffset(n5);
            char c2 = this.exceptions.charAt(n7++);
            int n8 = n7;
            if ((c2 & 0x4000) != 0) {
                if (n3 == 2 && n2 == 105) {
                    return 304;
                }
                if (n3 == 3 && n2 == 775 && this.isPrecededBySoftDotted(contextIterator)) {
                    return 0;
                }
                if (n2 == 1415) {
                    try {
                        if (n3 == 6) {
                            appendable.append(bl2 ? "\u0535\u054e" : "\u0535\u057e");
                        } else {
                            appendable.append(bl2 ? "\u0535\u0552" : "\u0535\u0582");
                        }
                        return 2;
                    }
                    catch (IOException iOException) {
                        throw new ICUUncheckedIOException(iOException);
                    }
                }
            } else if (UCaseProps.hasSlot(c2, 7)) {
                long l2 = this.getSlotValueAndOffset(c2, 7, n7);
                int n9 = (int)l2 & 0xFFFF;
                n7 = (int)(l2 >> 32) + 1;
                n7 += n9 & 0xF;
                n7 += (n9 >>= 4) & 0xF;
                n9 >>= 4;
                if (bl2) {
                    n9 &= 0xF;
                } else {
                    n7 += n9 & 0xF;
                    n9 = n9 >> 4 & 0xF;
                }
                if (n9 != 0) {
                    try {
                        appendable.append(this.exceptions, n7, n7 + n9);
                        return n9;
                    }
                    catch (IOException iOException) {
                        throw new ICUUncheckedIOException(iOException);
                    }
                }
            }
            if (UCaseProps.hasSlot(c2, 4) && UCaseProps.getTypeFromProps(n5) == 1) {
                int n10 = this.getSlotValue(c2, 4, n8);
                return (c2 & 0x400) == 0 ? n2 + n10 : n2 - n10;
            }
            if (!bl2 && UCaseProps.hasSlot(c2, 3)) {
                n6 = 3;
            } else if (UCaseProps.hasSlot(c2, 2)) {
                n6 = 2;
            } else {
                return ~n2;
            }
            n4 = this.getSlotValue(c2, n6, n8);
        }
        return n4 == n2 ? ~n4 : n4;
    }

    public final int toFullUpper(int n2, ContextIterator contextIterator, Appendable appendable, int n3) {
        return this.toUpperOrTitle(n2, contextIterator, appendable, n3, true);
    }

    public final int toFullTitle(int n2, ContextIterator contextIterator, Appendable appendable, int n3) {
        return this.toUpperOrTitle(n2, contextIterator, appendable, n3, false);
    }

    public final int fold(int n2, int n3) {
        int n4 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n4)) {
            if (UCaseProps.isUpperOrTitleFromProps(n4)) {
                n2 += UCaseProps.getDelta(n4);
            }
        } else {
            int n5;
            char c2;
            int n6 = UCaseProps.getExceptionsOffset(n4);
            if (((c2 = this.exceptions.charAt(n6++)) & 0x8000) != 0) {
                if ((n3 & 7) == 0) {
                    if (n2 == 73) {
                        return 105;
                    }
                    if (n2 == 304) {
                        return n2;
                    }
                } else {
                    if (n2 == 73) {
                        return 305;
                    }
                    if (n2 == 304) {
                        return 105;
                    }
                }
            }
            if ((c2 & 0x200) != 0) {
                return n2;
            }
            if (UCaseProps.hasSlot(c2, 4) && UCaseProps.isUpperOrTitleFromProps(n4)) {
                int n7 = this.getSlotValue(c2, 4, n6);
                return (c2 & 0x400) == 0 ? n2 + n7 : n2 - n7;
            }
            if (UCaseProps.hasSlot(c2, 1)) {
                n5 = 1;
            } else if (UCaseProps.hasSlot(c2, 0)) {
                n5 = 0;
            } else {
                return n2;
            }
            n2 = this.getSlotValue(c2, n5, n6);
        }
        return n2;
    }

    public final int toFullFolding(int n2, Appendable appendable, int n3) {
        int n4 = n2;
        int n5 = this.trie.get(n2);
        if (!UCaseProps.propsHasException(n5)) {
            if (UCaseProps.isUpperOrTitleFromProps(n5)) {
                n4 = n2 + UCaseProps.getDelta(n5);
            }
        } else {
            int n6;
            int n7 = UCaseProps.getExceptionsOffset(n5);
            char c2 = this.exceptions.charAt(n7++);
            int n8 = n7;
            if ((c2 & 0x8000) != 0) {
                if ((n3 & 7) == 0) {
                    if (n2 == 73) {
                        return 105;
                    }
                    if (n2 == 304) {
                        try {
                            appendable.append(iDot);
                            return 2;
                        }
                        catch (IOException iOException) {
                            throw new ICUUncheckedIOException(iOException);
                        }
                    }
                } else {
                    if (n2 == 73) {
                        return 305;
                    }
                    if (n2 == 304) {
                        return 105;
                    }
                }
            } else if (UCaseProps.hasSlot(c2, 7)) {
                long l2 = this.getSlotValueAndOffset(c2, 7, n7);
                int n9 = (int)l2 & 0xFFFF;
                n7 = (int)(l2 >> 32) + 1;
                n7 += n9 & 0xF;
                if ((n9 = n9 >> 4 & 0xF) != 0) {
                    try {
                        appendable.append(this.exceptions, n7, n7 + n9);
                        return n9;
                    }
                    catch (IOException iOException) {
                        throw new ICUUncheckedIOException(iOException);
                    }
                }
            }
            if ((c2 & 0x200) != 0) {
                return ~n2;
            }
            if (UCaseProps.hasSlot(c2, 4) && UCaseProps.isUpperOrTitleFromProps(n5)) {
                int n10 = this.getSlotValue(c2, 4, n8);
                return (c2 & 0x400) == 0 ? n2 + n10 : n2 - n10;
            }
            if (UCaseProps.hasSlot(c2, 1)) {
                n6 = 1;
            } else if (UCaseProps.hasSlot(c2, 0)) {
                n6 = 0;
            } else {
                return ~n2;
            }
            n4 = this.getSlotValue(c2, n6, n8);
        }
        return n4 == n2 ? ~n4 : n4;
    }

    public final boolean hasBinaryProperty(int n2, int n3) {
        switch (n3) {
            case 22: {
                return 1 == this.getType(n2);
            }
            case 30: {
                return 2 == this.getType(n2);
            }
            case 27: {
                return this.isSoftDotted(n2);
            }
            case 34: {
                return this.isCaseSensitive(n2);
            }
            case 49: {
                return 0 != this.getType(n2);
            }
            case 50: {
                return this.getTypeOrIgnorable(n2) >> 2 != 0;
            }
            case 51: {
                dummyStringBuilder.setLength(0);
                return this.toFullLower(n2, null, dummyStringBuilder, 1) >= 0;
            }
            case 52: {
                dummyStringBuilder.setLength(0);
                return this.toFullUpper(n2, null, dummyStringBuilder, 1) >= 0;
            }
            case 53: {
                dummyStringBuilder.setLength(0);
                return this.toFullTitle(n2, null, dummyStringBuilder, 1) >= 0;
            }
            case 55: {
                dummyStringBuilder.setLength(0);
                return this.toFullLower(n2, null, dummyStringBuilder, 1) >= 0 || this.toFullUpper(n2, null, dummyStringBuilder, 1) >= 0 || this.toFullTitle(n2, null, dummyStringBuilder, 1) >= 0;
            }
        }
        return false;
    }

    static Trie2_16 getTrie() {
        return UCaseProps.INSTANCE.trie;
    }

    static final int getTypeFromProps(int n2) {
        return n2 & 3;
    }

    private static final int getTypeAndIgnorableFromProps(int n2) {
        return n2 & 7;
    }

    static final boolean isUpperOrTitleFromProps(int n2) {
        return (n2 & 2) != 0;
    }

    static final int getDelta(int n2) {
        return (short)n2 >> 7;
    }

    static {
        try {
            INSTANCE = new UCaseProps();
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    static final class LatinCase {
        static final char LIMIT = '\u0180';
        static final char LONG_S = '\u017f';
        static final byte EXC = -128;
        static final byte[] TO_LOWER_NORMAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 32, 32, 32, 32, 32, 32, 32, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -121, 1, 0, 1, 0, 1, 0, -128};
        static final byte[] TO_LOWER_TR_LT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, -128, -128, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, -128, -128, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 32, 32, 32, 32, 32, 32, 32, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 0, 1, 0, 1, 0, -128, 0, -128, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -121, 1, 0, 1, 0, 1, 0, -128};
        static final byte[] TO_UPPER_NORMAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, -32, -32, -32, -32, -32, -32, -32, 121, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -128, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, -128, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, -128};
        static final byte[] TO_UPPER_TR = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -32, -32, -32, -32, -32, -32, -32, -32, -128, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, -32, -32, -32, -32, -32, -32, -32, 121, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -128, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, -128, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, -128};

        LatinCase() {
        }
    }

    public static interface ContextIterator {
        public void reset(int var1);

        public int next();
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 4;
        }
    }
}

