/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public abstract class Trie {
    protected static final int LEAD_INDEX_OFFSET_ = 320;
    protected static final int INDEX_STAGE_1_SHIFT_ = 5;
    protected static final int INDEX_STAGE_2_SHIFT_ = 2;
    protected static final int DATA_BLOCK_LENGTH = 32;
    protected static final int INDEX_STAGE_3_MASK_ = 31;
    protected static final int SURROGATE_BLOCK_BITS = 5;
    protected static final int SURROGATE_BLOCK_COUNT = 32;
    protected static final int BMP_INDEX_LENGTH = 2048;
    protected static final int SURROGATE_MASK_ = 1023;
    protected char[] m_index_;
    protected DataManipulate m_dataManipulate_;
    protected int m_dataOffset_;
    protected int m_dataLength_;
    protected static final int HEADER_LENGTH_ = 16;
    protected static final int HEADER_OPTIONS_LATIN1_IS_LINEAR_MASK_ = 512;
    protected static final int HEADER_SIGNATURE_ = 1416784229;
    private static final int HEADER_OPTIONS_SHIFT_MASK_ = 15;
    protected static final int HEADER_OPTIONS_INDEX_SHIFT_ = 4;
    protected static final int HEADER_OPTIONS_DATA_IS_32_BIT_ = 256;
    private boolean m_isLatin1Linear_;
    private int m_options_;

    public final boolean isLatin1Linear() {
        return this.m_isLatin1Linear_;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Trie)) {
            return false;
        }
        Trie trie = (Trie)object;
        return this.m_isLatin1Linear_ == trie.m_isLatin1Linear_ && this.m_options_ == trie.m_options_ && this.m_dataLength_ == trie.m_dataLength_ && Arrays.equals(this.m_index_, trie.m_index_);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public int getSerializedDataSize() {
        int n2 = 16;
        n2 += this.m_dataOffset_ << 1;
        if (this.isCharTrie()) {
            n2 += this.m_dataLength_ << 1;
        } else if (this.isIntTrie()) {
            n2 += this.m_dataLength_ << 2;
        }
        return n2;
    }

    protected Trie(ByteBuffer byteBuffer, DataManipulate dataManipulate) {
        int n2 = byteBuffer.getInt();
        this.m_options_ = byteBuffer.getInt();
        if (!this.checkHeader(n2)) {
            throw new IllegalArgumentException("ICU data file error: Trie header authentication failed, please check if you have the most updated ICU data file");
        }
        this.m_dataManipulate_ = dataManipulate != null ? dataManipulate : new DefaultGetFoldingOffset();
        this.m_isLatin1Linear_ = (this.m_options_ & 0x200) != 0;
        this.m_dataOffset_ = byteBuffer.getInt();
        this.m_dataLength_ = byteBuffer.getInt();
        this.unserialize(byteBuffer);
    }

    protected Trie(char[] cArray, int n2, DataManipulate dataManipulate) {
        this.m_options_ = n2;
        this.m_dataManipulate_ = dataManipulate != null ? dataManipulate : new DefaultGetFoldingOffset();
        this.m_isLatin1Linear_ = (this.m_options_ & 0x200) != 0;
        this.m_index_ = cArray;
        this.m_dataOffset_ = this.m_index_.length;
    }

    protected abstract int getSurrogateOffset(char var1, char var2);

    protected abstract int getValue(int var1);

    protected abstract int getInitialValue();

    protected final int getRawOffset(int n2, char c2) {
        return (this.m_index_[n2 + (c2 >> 5)] << 2) + (c2 & 0x1F);
    }

    protected final int getBMPOffset(char c2) {
        return c2 >= '\ud800' && c2 <= '\udbff' ? this.getRawOffset(320, c2) : this.getRawOffset(0, c2);
    }

    protected final int getLeadOffset(char c2) {
        return this.getRawOffset(0, c2);
    }

    protected final int getCodePointOffset(int n2) {
        if (n2 < 0) {
            return -1;
        }
        if (n2 < 55296) {
            return this.getRawOffset(0, (char)n2);
        }
        if (n2 < 65536) {
            return this.getBMPOffset((char)n2);
        }
        if (n2 <= 0x10FFFF) {
            return this.getSurrogateOffset(UTF16.getLeadSurrogate(n2), (char)(n2 & 0x3FF));
        }
        return -1;
    }

    protected void unserialize(ByteBuffer byteBuffer) {
        this.m_index_ = ICUBinary.getChars(byteBuffer, this.m_dataOffset_, 0);
    }

    protected final boolean isIntTrie() {
        return (this.m_options_ & 0x100) != 0;
    }

    protected final boolean isCharTrie() {
        return (this.m_options_ & 0x100) == 0;
    }

    private final boolean checkHeader(int n2) {
        if (n2 != 1416784229) {
            return false;
        }
        return (this.m_options_ & 0xF) == 5 && (this.m_options_ >> 4 & 0xF) == 2;
    }

    private static class DefaultGetFoldingOffset
    implements DataManipulate {
        private DefaultGetFoldingOffset() {
        }

        @Override
        public int getFoldingOffset(int n2) {
            return n2;
        }
    }

    public static interface DataManipulate {
        public int getFoldingOffset(int var1);
    }
}

