/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TextTrieMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ZoneMeta;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.LocaleDisplayNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneTransition;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class TimeZoneGenericNames
implements Freezable<TimeZoneGenericNames>,
Serializable {
    private static final long serialVersionUID = 2729910342063468417L;
    private final ULocale _locale;
    private TimeZoneNames _tznames;
    private volatile transient boolean _frozen;
    private transient String _region;
    private transient WeakReference<LocaleDisplayNames> _localeDisplayNamesRef;
    private transient MessageFormat[] _patternFormatters;
    private transient ConcurrentHashMap<String, String> _genericLocationNamesMap;
    private transient ConcurrentHashMap<String, String> _genericPartialLocationNamesMap;
    private transient TextTrieMap<NameInfo> _gnamesTrie;
    private transient boolean _gnamesTrieFullyLoaded;
    private static Cache GENERIC_NAMES_CACHE = new Cache();
    private static final long DST_CHECK_RANGE = 15897600000L;
    private static final TimeZoneNames.NameType[] GENERIC_NON_LOCATION_TYPES = new TimeZoneNames.NameType[]{TimeZoneNames.NameType.LONG_GENERIC, TimeZoneNames.NameType.SHORT_GENERIC};

    public TimeZoneGenericNames(ULocale uLocale, TimeZoneNames timeZoneNames) {
        this._locale = uLocale;
        this._tznames = timeZoneNames;
        this.init();
    }

    private void init() {
        if (this._tznames == null) {
            this._tznames = TimeZoneNames.getInstance(this._locale);
        }
        this._genericLocationNamesMap = new ConcurrentHashMap();
        this._genericPartialLocationNamesMap = new ConcurrentHashMap();
        this._gnamesTrie = new TextTrieMap(true);
        this._gnamesTrieFullyLoaded = false;
        TimeZone timeZone = TimeZone.getDefault();
        String string = ZoneMeta.getCanonicalCLDRID(timeZone);
        if (string != null) {
            this.loadStrings(string);
        }
    }

    private TimeZoneGenericNames(ULocale uLocale) {
        this(uLocale, (TimeZoneNames)null);
    }

    public static TimeZoneGenericNames getInstance(ULocale uLocale) {
        String string = uLocale.getBaseName();
        return (TimeZoneGenericNames)GENERIC_NAMES_CACHE.getInstance(string, uLocale);
    }

    public String getDisplayName(TimeZone timeZone, GenericNameType genericNameType, long l2) {
        String string = null;
        String string2 = null;
        switch (genericNameType) {
            case LOCATION: {
                string2 = ZoneMeta.getCanonicalCLDRID(timeZone);
                if (string2 == null) break;
                string = this.getGenericLocationName(string2);
                break;
            }
            case LONG: 
            case SHORT: {
                string = this.formatGenericNonLocationName(timeZone, genericNameType, l2);
                if (string != null || (string2 = ZoneMeta.getCanonicalCLDRID(timeZone)) == null) break;
                string = this.getGenericLocationName(string2);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGenericLocationName(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = this._genericLocationNamesMap.get(string);
        if (string2 != null) {
            if (string2.length() == 0) {
                return null;
            }
            return string2;
        }
        Output<Boolean> output = new Output<Boolean>();
        String string3 = ZoneMeta.getCanonicalCountry(string, output);
        if (string3 != null) {
            if (((Boolean)output.value).booleanValue()) {
                object = this.getLocaleDisplayNames().regionDisplayName(string3);
                string2 = this.formatPattern(Pattern.REGION_FORMAT, new String[]{object});
            } else {
                object = this._tznames.getExemplarLocationName(string);
                string2 = this.formatPattern(Pattern.REGION_FORMAT, new String[]{object});
            }
        }
        if (string2 == null) {
            this._genericLocationNamesMap.putIfAbsent(string.intern(), "");
        } else {
            object = this;
            synchronized (object) {
                string = string.intern();
                String string4 = this._genericLocationNamesMap.putIfAbsent(string, string2.intern());
                if (string4 == null) {
                    NameInfo nameInfo = new NameInfo(string, GenericNameType.LOCATION);
                    this._gnamesTrie.put(string2, nameInfo);
                } else {
                    string2 = string4;
                }
            }
        }
        return string2;
    }

    public TimeZoneGenericNames setFormatPattern(Pattern pattern, String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (!this._genericLocationNamesMap.isEmpty()) {
            this._genericLocationNamesMap = new ConcurrentHashMap();
        }
        if (!this._genericPartialLocationNamesMap.isEmpty()) {
            this._genericPartialLocationNamesMap = new ConcurrentHashMap();
        }
        this._gnamesTrie = null;
        this._gnamesTrieFullyLoaded = false;
        if (this._patternFormatters == null) {
            this._patternFormatters = new MessageFormat[Pattern.values().length];
        }
        this._patternFormatters[pattern.ordinal()] = new MessageFormat(string);
        return this;
    }

    private String formatGenericNonLocationName(TimeZone timeZone, GenericNameType genericNameType, long l2) {
        assert (genericNameType == GenericNameType.LONG || genericNameType == GenericNameType.SHORT);
        String string = ZoneMeta.getCanonicalCLDRID(timeZone);
        if (string == null) {
            return null;
        }
        TimeZoneNames.NameType nameType = genericNameType == GenericNameType.LONG ? TimeZoneNames.NameType.LONG_GENERIC : TimeZoneNames.NameType.SHORT_GENERIC;
        Object object = this._tznames.getTimeZoneDisplayName(string, nameType);
        if (object != null) {
            return object;
        }
        String string2 = this._tznames.getMetaZoneID(string, l2);
        if (string2 != null) {
            Object object2;
            Object object3;
            Object object4;
            boolean bl2 = false;
            int[] nArray = new int[]{0, 0};
            timeZone.getOffset(l2, false, nArray);
            if (nArray[1] == 0) {
                bl2 = true;
                if (timeZone instanceof BasicTimeZone) {
                    object4 = (BasicTimeZone)timeZone;
                    object3 = ((BasicTimeZone)object4).getPreviousTransition(l2, true);
                    if (object3 != null && l2 - ((TimeZoneTransition)object3).getTime() < 15897600000L && ((TimeZoneTransition)object3).getFrom().getDSTSavings() != 0) {
                        bl2 = false;
                    } else {
                        object2 = ((BasicTimeZone)object4).getNextTransition(l2, false);
                        if (object2 != null && ((TimeZoneTransition)object2).getTime() - l2 < 15897600000L && ((TimeZoneTransition)object2).getTo().getDSTSavings() != 0) {
                            bl2 = false;
                        }
                    }
                } else {
                    object4 = new int[2];
                    timeZone.getOffset(l2 - 15897600000L, false, (int[])object4);
                    if (object4[1] != false) {
                        bl2 = false;
                    } else {
                        timeZone.getOffset(l2 + 15897600000L, false, (int[])object4);
                        if (object4[1] != false) {
                            bl2 = false;
                        }
                    }
                }
            }
            if (bl2 && (object3 = this._tznames.getDisplayName(string, (TimeZoneNames.NameType)((Object)(object4 = nameType == TimeZoneNames.NameType.LONG_GENERIC ? TimeZoneNames.NameType.LONG_STANDARD : TimeZoneNames.NameType.SHORT_STANDARD)), l2)) != null) {
                object = object3;
                object2 = this._tznames.getMetaZoneDisplayName(string2, nameType);
                if (((String)object3).equalsIgnoreCase((String)object2)) {
                    object = null;
                }
            }
            if (object == null && (object4 = this._tznames.getMetaZoneDisplayName(string2, nameType)) != null) {
                object3 = this._tznames.getReferenceZoneID(string2, this.getTargetRegion());
                if (object3 != null && !((String)object3).equals(string)) {
                    object2 = TimeZone.getFrozenTimeZone((String)object3);
                    int[] nArray2 = new int[]{0, 0};
                    ((TimeZone)object2).getOffset(l2 + (long)nArray[0] + (long)nArray[1], true, nArray2);
                    object = nArray[0] != nArray2[0] || nArray[1] != nArray2[1] ? this.getPartialLocationName(string, string2, nameType == TimeZoneNames.NameType.LONG_GENERIC, (String)object4) : object4;
                } else {
                    object = object4;
                }
            }
        }
        return object;
    }

    private synchronized String formatPattern(Pattern pattern, String ... stringArray) {
        int n2;
        if (this._patternFormatters == null) {
            this._patternFormatters = new MessageFormat[Pattern.values().length];
        }
        if (this._patternFormatters[n2 = pattern.ordinal()] == null) {
            String string;
            try {
                ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/zone", this._locale);
                string = iCUResourceBundle.getStringWithFallback("zoneStrings/" + pattern.key());
            }
            catch (MissingResourceException missingResourceException) {
                string = pattern.defaultValue();
            }
            this._patternFormatters[n2] = new MessageFormat(string);
        }
        return this._patternFormatters[n2].format(stringArray);
    }

    private synchronized LocaleDisplayNames getLocaleDisplayNames() {
        LocaleDisplayNames localeDisplayNames = null;
        if (this._localeDisplayNamesRef != null) {
            localeDisplayNames = (LocaleDisplayNames)this._localeDisplayNamesRef.get();
        }
        if (localeDisplayNames == null) {
            localeDisplayNames = LocaleDisplayNames.getInstance(this._locale);
            this._localeDisplayNamesRef = new WeakReference<LocaleDisplayNames>(localeDisplayNames);
        }
        return localeDisplayNames;
    }

    private synchronized void loadStrings(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.getGenericLocationName(string);
        Set<String> set = this._tznames.getAvailableMetaZoneIDs(string);
        for (String string2 : set) {
            String string3 = this._tznames.getReferenceZoneID(string2, this.getTargetRegion());
            if (string.equals(string3)) continue;
            for (TimeZoneNames.NameType nameType : GENERIC_NON_LOCATION_TYPES) {
                String string4 = this._tznames.getMetaZoneDisplayName(string2, nameType);
                if (string4 == null) continue;
                this.getPartialLocationName(string, string2, nameType == TimeZoneNames.NameType.LONG_GENERIC, string4);
            }
        }
    }

    private synchronized String getTargetRegion() {
        if (this._region == null) {
            this._region = this._locale.getCountry();
            if (this._region.length() == 0) {
                ULocale uLocale = ULocale.addLikelySubtags(this._locale);
                this._region = uLocale.getCountry();
                if (this._region.length() == 0) {
                    this._region = "001";
                }
            }
        }
        return this._region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPartialLocationName(String string, String string2, boolean bl2, String string3) {
        Object object;
        String string4 = bl2 ? "L" : "S";
        String string5 = string + "&" + string2 + "#" + string4;
        String string6 = this._genericPartialLocationNamesMap.get(string5);
        if (string6 != null) {
            return string6;
        }
        String string7 = null;
        String string8 = ZoneMeta.getCanonicalCountry(string);
        if (string8 != null) {
            object = this._tznames.getReferenceZoneID(string2, string8);
            string7 = string.equals(object) ? this.getLocaleDisplayNames().regionDisplayName(string8) : this._tznames.getExemplarLocationName(string);
        } else {
            string7 = this._tznames.getExemplarLocationName(string);
            if (string7 == null) {
                string7 = string;
            }
        }
        string6 = this.formatPattern(Pattern.FALLBACK_FORMAT, string7, string3);
        object = this;
        synchronized (object) {
            String string9 = this._genericPartialLocationNamesMap.putIfAbsent(string5.intern(), string6.intern());
            if (string9 == null) {
                NameInfo nameInfo = new NameInfo(string.intern(), bl2 ? GenericNameType.LONG : GenericNameType.SHORT);
                this._gnamesTrie.put(string6, nameInfo);
            } else {
                string6 = string9;
            }
        }
        return string6;
    }

    public GenericMatchInfo findBestMatch(String string, int n2, EnumSet<GenericNameType> enumSet) {
        Object object;
        if (string == null || string.length() == 0 || n2 < 0 || n2 >= string.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        GenericMatchInfo object2 = null;
        Collection<TimeZoneNames.MatchInfo> collection = this.findTimeZoneNames(string, n2, enumSet);
        if (collection != null) {
            object = null;
            for (TimeZoneNames.MatchInfo object3 : collection) {
                if (object != null && object3.matchLength() <= ((TimeZoneNames.MatchInfo)object).matchLength()) continue;
                object = object3;
            }
            if (object != null && (object2 = this.createGenericMatchInfo((TimeZoneNames.MatchInfo)object)).matchLength() == string.length() - n2 && object2.timeType != TimeZoneFormat.TimeType.STANDARD) {
                return object2;
            }
        }
        if ((object = this.findLocal(string, n2, enumSet)) != null) {
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                GenericMatchInfo genericMatchInfo = (GenericMatchInfo)iterator.next();
                if (object2 != null && genericMatchInfo.matchLength() < object2.matchLength()) continue;
                object2 = genericMatchInfo;
            }
        }
        return object2;
    }

    public Collection<GenericMatchInfo> find(String string, int n2, EnumSet<GenericNameType> enumSet) {
        if (string == null || string.length() == 0 || n2 < 0 || n2 >= string.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        Collection<GenericMatchInfo> collection = this.findLocal(string, n2, enumSet);
        Collection<TimeZoneNames.MatchInfo> collection2 = this.findTimeZoneNames(string, n2, enumSet);
        if (collection2 != null) {
            for (TimeZoneNames.MatchInfo matchInfo : collection2) {
                if (collection == null) {
                    collection = new LinkedList<GenericMatchInfo>();
                }
                collection.add(this.createGenericMatchInfo(matchInfo));
            }
        }
        return collection;
    }

    private GenericMatchInfo createGenericMatchInfo(TimeZoneNames.MatchInfo matchInfo) {
        Object object;
        GenericNameType genericNameType = null;
        TimeZoneFormat.TimeType timeType = TimeZoneFormat.TimeType.UNKNOWN;
        switch (matchInfo.nameType()) {
            case LONG_STANDARD: {
                genericNameType = GenericNameType.LONG;
                timeType = TimeZoneFormat.TimeType.STANDARD;
                break;
            }
            case LONG_GENERIC: {
                genericNameType = GenericNameType.LONG;
                break;
            }
            case SHORT_STANDARD: {
                genericNameType = GenericNameType.SHORT;
                timeType = TimeZoneFormat.TimeType.STANDARD;
                break;
            }
            case SHORT_GENERIC: {
                genericNameType = GenericNameType.SHORT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected MatchInfo name type - " + (Object)((Object)matchInfo.nameType()));
            }
        }
        String string = matchInfo.tzID();
        if (string == null) {
            object = matchInfo.mzID();
            assert (object != null);
            string = this._tznames.getReferenceZoneID((String)object, this.getTargetRegion());
        }
        assert (string != null);
        object = new GenericMatchInfo(genericNameType, string, matchInfo.matchLength(), timeType);
        return object;
    }

    private Collection<TimeZoneNames.MatchInfo> findTimeZoneNames(String string, int n2, EnumSet<GenericNameType> enumSet) {
        Collection<TimeZoneNames.MatchInfo> collection = null;
        EnumSet<TimeZoneNames.NameType> enumSet2 = EnumSet.noneOf(TimeZoneNames.NameType.class);
        if (enumSet.contains((Object)GenericNameType.LONG)) {
            enumSet2.add(TimeZoneNames.NameType.LONG_GENERIC);
            enumSet2.add(TimeZoneNames.NameType.LONG_STANDARD);
        }
        if (enumSet.contains((Object)GenericNameType.SHORT)) {
            enumSet2.add(TimeZoneNames.NameType.SHORT_GENERIC);
            enumSet2.add(TimeZoneNames.NameType.SHORT_STANDARD);
        }
        if (!enumSet2.isEmpty()) {
            collection = this._tznames.find(string, n2, enumSet2);
        }
        return collection;
    }

    private synchronized Collection<GenericMatchInfo> findLocal(String string, int n2, EnumSet<GenericNameType> enumSet) {
        GenericNameSearchHandler genericNameSearchHandler = new GenericNameSearchHandler(enumSet);
        this._gnamesTrie.find(string, n2, genericNameSearchHandler);
        if (genericNameSearchHandler.getMaxMatchLen() == string.length() - n2 || this._gnamesTrieFullyLoaded) {
            return genericNameSearchHandler.getMatches();
        }
        Set<String> set = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
        for (String string2 : set) {
            this.loadStrings(string2);
        }
        this._gnamesTrieFullyLoaded = true;
        genericNameSearchHandler.resetResults();
        this._gnamesTrie.find(string, n2, genericNameSearchHandler);
        return genericNameSearchHandler.getMatches();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    @Override
    public boolean isFrozen() {
        return this._frozen;
    }

    @Override
    public TimeZoneGenericNames freeze() {
        this._frozen = true;
        return this;
    }

    @Override
    public TimeZoneGenericNames cloneAsThawed() {
        TimeZoneGenericNames timeZoneGenericNames = null;
        try {
            timeZoneGenericNames = (TimeZoneGenericNames)super.clone();
            timeZoneGenericNames._frozen = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return timeZoneGenericNames;
    }

    private static class Cache
    extends SoftCache<String, TimeZoneGenericNames, ULocale> {
        private Cache() {
        }

        @Override
        protected TimeZoneGenericNames createInstance(String string, ULocale uLocale) {
            return new TimeZoneGenericNames(uLocale).freeze();
        }
    }

    private static class GenericNameSearchHandler
    implements TextTrieMap.ResultHandler<NameInfo> {
        private EnumSet<GenericNameType> _types;
        private Collection<GenericMatchInfo> _matches;
        private int _maxMatchLen;

        GenericNameSearchHandler(EnumSet<GenericNameType> enumSet) {
            this._types = enumSet;
        }

        @Override
        public boolean handlePrefixMatch(int n2, Iterator<NameInfo> iterator) {
            while (iterator.hasNext()) {
                NameInfo nameInfo = iterator.next();
                if (this._types != null && !this._types.contains((Object)nameInfo.type)) continue;
                GenericMatchInfo genericMatchInfo = new GenericMatchInfo(nameInfo.type, nameInfo.tzID, n2);
                if (this._matches == null) {
                    this._matches = new LinkedList<GenericMatchInfo>();
                }
                this._matches.add(genericMatchInfo);
                if (n2 <= this._maxMatchLen) continue;
                this._maxMatchLen = n2;
            }
            return true;
        }

        public Collection<GenericMatchInfo> getMatches() {
            return this._matches;
        }

        public int getMaxMatchLen() {
            return this._maxMatchLen;
        }

        public void resetResults() {
            this._matches = null;
            this._maxMatchLen = 0;
        }
    }

    public static class GenericMatchInfo {
        final GenericNameType nameType;
        final String tzID;
        final int matchLength;
        final TimeZoneFormat.TimeType timeType;

        private GenericMatchInfo(GenericNameType genericNameType, String string, int n2) {
            this(genericNameType, string, n2, TimeZoneFormat.TimeType.UNKNOWN);
        }

        private GenericMatchInfo(GenericNameType genericNameType, String string, int n2, TimeZoneFormat.TimeType timeType) {
            this.nameType = genericNameType;
            this.tzID = string;
            this.matchLength = n2;
            this.timeType = timeType;
        }

        public GenericNameType nameType() {
            return this.nameType;
        }

        public String tzID() {
            return this.tzID;
        }

        public TimeZoneFormat.TimeType timeType() {
            return this.timeType;
        }

        public int matchLength() {
            return this.matchLength;
        }
    }

    private static class NameInfo {
        final String tzID;
        final GenericNameType type;

        NameInfo(String string, GenericNameType genericNameType) {
            this.tzID = string;
            this.type = genericNameType;
        }
    }

    public static enum Pattern {
        REGION_FORMAT("regionFormat", "({0})"),
        FALLBACK_FORMAT("fallbackFormat", "{1} ({0})");

        String _key;
        String _defaultVal;

        private Pattern(String string2, String string3) {
            this._key = string2;
            this._defaultVal = string3;
        }

        String key() {
            return this._key;
        }

        String defaultValue() {
            return this._defaultVal;
        }
    }

    public static enum GenericNameType {
        LOCATION("LONG", "SHORT"),
        LONG(new String[0]),
        SHORT(new String[0]);

        String[] _fallbackTypeOf;

        private GenericNameType(String ... stringArray) {
            this._fallbackTypeOf = stringArray;
        }

        public boolean isFallbackTypeOf(GenericNameType genericNameType) {
            String string = genericNameType.toString();
            for (String string2 : this._fallbackTypeOf) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

