/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;

public class Row<C0, C1, C2, C3, C4>
implements Freezable<Row<C0, C1, C2, C3, C4>>,
Cloneable,
Comparable {
    protected Object[] items;
    protected volatile boolean frozen;

    public static <C0, C1> R2<C0, C1> of(C0 C0, C1 C1) {
        return new R2<C0, C1>(C0, C1);
    }

    public static <C0, C1, C2> R3<C0, C1, C2> of(C0 C0, C1 C1, C2 C2) {
        return new R3<C0, C1, C2>(C0, C1, C2);
    }

    public static <C0, C1, C2, C3> R4<C0, C1, C2, C3> of(C0 C0, C1 C1, C2 C2, C3 C3) {
        return new R4<C0, C1, C2, C3>(C0, C1, C2, C3);
    }

    public static <C0, C1, C2, C3, C4> R5<C0, C1, C2, C3, C4> of(C0 C0, C1 C1, C2 C2, C3 C3, C4 C4) {
        return new R5<C0, C1, C2, C3, C4>(C0, C1, C2, C3, C4);
    }

    public Row<C0, C1, C2, C3, C4> set0(C0 C0) {
        return this.set(0, C0);
    }

    public C0 get0() {
        return (C0)this.items[0];
    }

    public Row<C0, C1, C2, C3, C4> set1(C1 C1) {
        return this.set(1, C1);
    }

    public C1 get1() {
        return (C1)this.items[1];
    }

    public Row<C0, C1, C2, C3, C4> set2(C2 C2) {
        return this.set(2, C2);
    }

    public C2 get2() {
        return (C2)this.items[2];
    }

    public Row<C0, C1, C2, C3, C4> set3(C3 C3) {
        return this.set(3, C3);
    }

    public C3 get3() {
        return (C3)this.items[3];
    }

    public Row<C0, C1, C2, C3, C4> set4(C4 C4) {
        return this.set(4, C4);
    }

    public C4 get4() {
        return (C4)this.items[4];
    }

    protected Row<C0, C1, C2, C3, C4> set(int n2, Object object) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this.items[n2] = object;
        return this;
    }

    public int hashCode() {
        int n2 = this.items.length;
        for (Object object : this.items) {
            n2 = n2 * 37 + Utility.checkHash(object);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            Row row = (Row)object;
            if (this.items.length != row.items.length) {
                return false;
            }
            int n2 = 0;
            for (Object object2 : this.items) {
                if (Objects.equals(object2, row.items[n2++])) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int compareTo(Object object) {
        Row row = (Row)object;
        int n2 = this.items.length - row.items.length;
        if (n2 != 0) {
            return n2;
        }
        int n3 = 0;
        for (Object object2 : this.items) {
            if ((n2 = Utility.checkCompare((Comparable)object2, (Comparable)row.items[n3++])) == 0) continue;
            return n2;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl2 = true;
        for (Object object : this.items) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object);
        }
        return stringBuilder.append("]").toString();
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public Row<C0, C1, C2, C3, C4> freeze() {
        this.frozen = true;
        return this;
    }

    public Object clone() {
        if (this.frozen) {
            return this;
        }
        try {
            Row row = (Row)super.clone();
            this.items = (Object[])this.items.clone();
            return row;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Row<C0, C1, C2, C3, C4> cloneAsThawed() {
        try {
            Row row = (Row)super.clone();
            this.items = (Object[])this.items.clone();
            row.frozen = false;
            return row;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static class R5<C0, C1, C2, C3, C4>
    extends Row<C0, C1, C2, C3, C4> {
        public R5(C0 C0, C1 C1, C2 C2, C3 C3, C4 C4) {
            this.items = new Object[]{C0, C1, C2, C3, C4};
        }
    }

    public static class R4<C0, C1, C2, C3>
    extends Row<C0, C1, C2, C3, C3> {
        public R4(C0 C0, C1 C1, C2 C2, C3 C3) {
            this.items = new Object[]{C0, C1, C2, C3};
        }
    }

    public static class R3<C0, C1, C2>
    extends Row<C0, C1, C2, C2, C2> {
        public R3(C0 C0, C1 C1, C2 C2) {
            this.items = new Object[]{C0, C1, C2};
        }
    }

    public static class R2<C0, C1>
    extends Row<C0, C1, C1, C1, C1> {
        public R2(C0 C0, C1 C1) {
            this.items = new Object[]{C0, C1};
        }
    }
}

