/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CacheBase;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ClassLoaderUtil;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUDebug;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public final class ResourceBundleWrapper
extends UResourceBundle {
    private ResourceBundle bundle = null;
    private String localeID = null;
    private String baseName = null;
    private List<String> keys = null;
    private static CacheBase<String, ResourceBundleWrapper, Loader> BUNDLE_CACHE = new SoftCache<String, ResourceBundleWrapper, Loader>(){

        @Override
        protected ResourceBundleWrapper createInstance(String string, Loader loader) {
            return loader.load();
        }
    };
    private static final boolean DEBUG = ICUDebug.enabled("resourceBundleWrapper");

    private ResourceBundleWrapper(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    @Override
    protected Object handleGetObject(String string) {
        Object object = null;
        for (ResourceBundleWrapper resourceBundleWrapper = this; resourceBundleWrapper != null; resourceBundleWrapper = (ResourceBundleWrapper)resourceBundleWrapper.getParent()) {
            try {
                object = resourceBundleWrapper.bundle.getObject(string);
                break;
            }
            catch (MissingResourceException missingResourceException) {
                continue;
            }
        }
        if (object == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.baseName + ", key " + string, this.getClass().getName(), string);
        }
        return object;
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keys);
    }

    private void initKeysVector() {
        this.keys = new ArrayList<String>();
        for (ResourceBundleWrapper resourceBundleWrapper = this; resourceBundleWrapper != null; resourceBundleWrapper = (ResourceBundleWrapper)resourceBundleWrapper.getParent()) {
            Enumeration<String> enumeration = resourceBundleWrapper.bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (this.keys.contains(string)) continue;
                this.keys.add(string);
            }
        }
    }

    @Override
    protected String getLocaleID() {
        return this.localeID;
    }

    @Override
    protected String getBaseName() {
        return this.bundle.getClass().getName().replace('.', '/');
    }

    @Override
    public ULocale getULocale() {
        return new ULocale(this.localeID);
    }

    @Override
    public UResourceBundle getParent() {
        return (UResourceBundle)this.parent;
    }

    public static ResourceBundleWrapper getBundleInstance(String string, String string2, ClassLoader classLoader, boolean bl2) {
        ResourceBundleWrapper resourceBundleWrapper;
        if (classLoader == null) {
            classLoader = ClassLoaderUtil.getClassLoader();
        }
        if ((resourceBundleWrapper = bl2 ? ResourceBundleWrapper.instantiateBundle(string, string2, null, classLoader, bl2) : ResourceBundleWrapper.instantiateBundle(string, string2, ULocale.getDefault().getBaseName(), classLoader, bl2)) == null) {
            String string3 = "_";
            if (string.indexOf(47) >= 0) {
                string3 = "/";
            }
            throw new MissingResourceException("Could not find the bundle " + string + string3 + string2, "", "");
        }
        return resourceBundleWrapper;
    }

    private static boolean localeIDStartsWithLangSubtag(String string, String string2) {
        return string.startsWith(string2) && (string.length() == string2.length() || string.charAt(string2.length()) == '_');
    }

    private static ResourceBundleWrapper instantiateBundle(final String string, final String string2, final String string3, final ClassLoader classLoader, final boolean bl2) {
        final String string4 = string2.isEmpty() ? string : string + '_' + string2;
        String string5 = bl2 ? string4 : string4 + '#' + string3;
        return BUNDLE_CACHE.getInstance(string5, new Loader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceBundleWrapper load() {
                Object object;
                block33: {
                    Object object2;
                    Object object3;
                    boolean bl22;
                    boolean bl3;
                    ResourceBundleWrapper resourceBundleWrapper;
                    block31: {
                        resourceBundleWrapper = null;
                        int n2 = string2.lastIndexOf(95);
                        bl3 = false;
                        bl22 = false;
                        if (n2 != -1) {
                            object = string2.substring(0, n2);
                            resourceBundleWrapper = ResourceBundleWrapper.instantiateBundle(string, (String)object, string3, classLoader, bl2);
                        } else if (!string2.isEmpty()) {
                            resourceBundleWrapper = ResourceBundleWrapper.instantiateBundle(string, "", string3, classLoader, bl2);
                            bl22 = true;
                        }
                        object = null;
                        try {
                            object3 = classLoader.loadClass(string4).asSubclass(ResourceBundle.class);
                            object2 = ((Class)object3).newInstance();
                            object = new ResourceBundleWrapper((ResourceBundle)object2);
                            if (resourceBundleWrapper != null) {
                                ((ResourceBundleWrapper)object).setParent(resourceBundleWrapper);
                            }
                            ((ResourceBundleWrapper)object).baseName = string;
                            ((ResourceBundleWrapper)object).localeID = string2;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            bl3 = true;
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            if (DEBUG) {
                                System.out.println("failure");
                            }
                            if (!DEBUG) break block31;
                            System.out.println(exception);
                        }
                    }
                    if (bl3) {
                        try {
                            object3 = string4.replace('.', '/') + ".properties";
                            object2 = AccessController.doPrivileged(new PrivilegedAction<InputStream>((String)object3){
                                final /* synthetic */ String val$resName;
                                {
                                    this.val$resName = string;
                                }

                                @Override
                                public InputStream run() {
                                    return classLoader.getResourceAsStream(this.val$resName);
                                }
                            });
                            if (object2 != null) {
                                object2 = new BufferedInputStream((InputStream)object2);
                                try {
                                    object = new ResourceBundleWrapper(new PropertyResourceBundle((InputStream)object2));
                                    if (resourceBundleWrapper != null) {
                                        ((ResourceBundleWrapper)object).setParent(resourceBundleWrapper);
                                    }
                                    ((ResourceBundleWrapper)object).baseName = string;
                                    ((ResourceBundleWrapper)object).localeID = string2;
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    try {
                                        ((InputStream)object2).close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            if (!(object != null || bl2 || string2.isEmpty() || string2.indexOf(95) >= 0 || ResourceBundleWrapper.localeIDStartsWithLangSubtag(string3, string2))) {
                                object = ResourceBundleWrapper.instantiateBundle(string, string3, string3, classLoader, bl2);
                            }
                            if (!(object != null || bl22 && bl2)) {
                                object = resourceBundleWrapper;
                            }
                        }
                        catch (Exception exception) {
                            if (DEBUG) {
                                System.out.println("failure");
                            }
                            if (!DEBUG) break block33;
                            System.out.println(exception);
                        }
                    }
                }
                if (object != null) {
                    ((ResourceBundleWrapper)object).initKeysVector();
                } else if (DEBUG) {
                    System.out.println("Returning null for " + string + "_" + string2);
                }
                return object;
            }
        });
    }

    private static abstract class Loader {
        private Loader() {
        }

        abstract ResourceBundleWrapper load();
    }
}

