/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedBreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;

public final class RBBIDataWrapper {
    public RBBIDataHeader fHeader;
    public RBBIStateTable fFTable;
    public RBBIStateTable fRTable;
    public CodePointTrie fTrie;
    public String fRuleSource;
    public int[] fStatusTable;
    public static final int DATA_FORMAT = 1114794784;
    public static final int FORMAT_VERSION = 0x6000000;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    public static final int DH_SIZE = 20;
    public static final int DH_MAGIC = 0;
    public static final int DH_FORMATVERSION = 1;
    public static final int DH_LENGTH = 2;
    public static final int DH_CATCOUNT = 3;
    public static final int DH_FTABLE = 4;
    public static final int DH_FTABLELEN = 5;
    public static final int DH_RTABLE = 6;
    public static final int DH_RTABLELEN = 7;
    public static final int DH_TRIE = 8;
    public static final int DH_TRIELEN = 9;
    public static final int DH_RULESOURCE = 10;
    public static final int DH_RULESOURCELEN = 11;
    public static final int DH_STATUSTABLE = 12;
    public static final int DH_STATUSTABLELEN = 13;
    public static final int ACCEPTING = 0;
    public static final int LOOKAHEAD = 1;
    public static final int TAGSIDX = 2;
    public static final int NEXTSTATES = 3;
    public static final int ACCEPTING_UNCONDITIONAL = 1;
    public static final int RBBI_LOOKAHEAD_HARD_BREAK = 1;
    public static final int RBBI_BOF_REQUIRED = 2;
    public static final int RBBI_8BITS_ROWS = 4;

    public static boolean equals(RBBIStateTable rBBIStateTable, RBBIStateTable rBBIStateTable2) {
        if (rBBIStateTable == rBBIStateTable2) {
            return true;
        }
        if (rBBIStateTable == null || rBBIStateTable2 == null) {
            return false;
        }
        return rBBIStateTable.equals(rBBIStateTable2);
    }

    public int getRowIndex(int n2) {
        return n2 * (this.fHeader.fCatCount + 3);
    }

    RBBIDataWrapper() {
    }

    public static RBBIDataWrapper get(ByteBuffer byteBuffer) throws IOException {
        RBBIDataWrapper rBBIDataWrapper = new RBBIDataWrapper();
        ICUBinary.readHeader(byteBuffer, 1114794784, IS_ACCEPTABLE);
        rBBIDataWrapper.fHeader = new RBBIDataHeader();
        rBBIDataWrapper.fHeader.fMagic = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fFormatVersion[0] = byteBuffer.get();
        rBBIDataWrapper.fHeader.fFormatVersion[1] = byteBuffer.get();
        rBBIDataWrapper.fHeader.fFormatVersion[2] = byteBuffer.get();
        rBBIDataWrapper.fHeader.fFormatVersion[3] = byteBuffer.get();
        rBBIDataWrapper.fHeader.fLength = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fCatCount = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fFTable = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fFTableLen = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fRTable = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fRTableLen = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fTrie = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fTrieLen = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fRuleSource = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fRuleSourceLen = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fStatusTable = byteBuffer.getInt();
        rBBIDataWrapper.fHeader.fStatusTableLen = byteBuffer.getInt();
        ICUBinary.skipBytes(byteBuffer, 24);
        if (rBBIDataWrapper.fHeader.fMagic != 45472 || !IS_ACCEPTABLE.isDataVersionAcceptable(rBBIDataWrapper.fHeader.fFormatVersion)) {
            throw new IOException("Break Iterator Rule Data Magic Number Incorrect, or unsupported data version.");
        }
        int n2 = 80;
        if (rBBIDataWrapper.fHeader.fFTable < n2 || rBBIDataWrapper.fHeader.fFTable > rBBIDataWrapper.fHeader.fLength) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(byteBuffer, rBBIDataWrapper.fHeader.fFTable - n2);
        n2 = rBBIDataWrapper.fHeader.fFTable;
        rBBIDataWrapper.fFTable = RBBIStateTable.get(byteBuffer, rBBIDataWrapper.fHeader.fFTableLen);
        ICUBinary.skipBytes(byteBuffer, rBBIDataWrapper.fHeader.fRTable - (n2 += rBBIDataWrapper.fHeader.fFTableLen));
        n2 = rBBIDataWrapper.fHeader.fRTable;
        rBBIDataWrapper.fRTable = RBBIStateTable.get(byteBuffer, rBBIDataWrapper.fHeader.fRTableLen);
        ICUBinary.skipBytes(byteBuffer, rBBIDataWrapper.fHeader.fTrie - (n2 += rBBIDataWrapper.fHeader.fRTableLen));
        n2 = rBBIDataWrapper.fHeader.fTrie;
        byteBuffer.mark();
        rBBIDataWrapper.fTrie = CodePointTrie.fromBinary(CodePointTrie.Type.FAST, null, byteBuffer);
        byteBuffer.reset();
        if (n2 > rBBIDataWrapper.fHeader.fStatusTable) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(byteBuffer, rBBIDataWrapper.fHeader.fStatusTable - n2);
        n2 = rBBIDataWrapper.fHeader.fStatusTable;
        rBBIDataWrapper.fStatusTable = ICUBinary.getInts(byteBuffer, rBBIDataWrapper.fHeader.fStatusTableLen / 4, rBBIDataWrapper.fHeader.fStatusTableLen & 3);
        if ((n2 += rBBIDataWrapper.fHeader.fStatusTableLen) > rBBIDataWrapper.fHeader.fRuleSource) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(byteBuffer, rBBIDataWrapper.fHeader.fRuleSource - n2);
        n2 = rBBIDataWrapper.fHeader.fRuleSource;
        rBBIDataWrapper.fRuleSource = new String(ICUBinary.getBytes(byteBuffer, rBBIDataWrapper.fHeader.fRuleSourceLen, 0), StandardCharsets.UTF_8);
        if (RuleBasedBreakIterator.fDebugEnv != null && RuleBasedBreakIterator.fDebugEnv.indexOf("data") >= 0) {
            rBBIDataWrapper.dump(System.out);
        }
        return rBBIDataWrapper;
    }

    public void dump(PrintStream printStream) {
        if (this.fFTable == null) {
            throw new NullPointerException();
        }
        printStream.println("RBBI Data Wrapper dump ...");
        printStream.println();
        printStream.println("Forward State Table");
        this.dumpTable(printStream, this.fFTable);
        printStream.println("Reverse State Table");
        this.dumpTable(printStream, this.fRTable);
        this.dumpCharCategories(printStream);
        printStream.println("Source Rules: " + this.fRuleSource);
    }

    public static String intToString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append(n2);
        while (stringBuilder.length() < n3) {
            stringBuilder.insert(0, ' ');
        }
        return stringBuilder.toString();
    }

    public static String charToString(char c2, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(c2);
        while (stringBuilder.length() < n2) {
            stringBuilder.insert(0, ' ');
        }
        return stringBuilder.toString();
    }

    public static String intToHexString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append(Integer.toHexString(n2));
        while (stringBuilder.length() < n3) {
            stringBuilder.insert(0, ' ');
        }
        return stringBuilder.toString();
    }

    private void dumpTable(PrintStream printStream, RBBIStateTable rBBIStateTable) {
        if (rBBIStateTable == null || rBBIStateTable.fTable.length == 0) {
            printStream.println("  -- null -- ");
        } else {
            int n2;
            StringBuilder stringBuilder = new StringBuilder(" Row  Acc Look  Tag");
            for (n2 = 0; n2 < this.fHeader.fCatCount; n2 = (int)((char)(n2 + 1))) {
                stringBuilder.append(RBBIDataWrapper.intToString(n2, 5));
            }
            printStream.println(stringBuilder.toString());
            for (n2 = 0; n2 < stringBuilder.length(); n2 = (int)((char)(n2 + 1))) {
                printStream.print("-");
            }
            printStream.println();
            for (char c2 = '\u0000'; c2 < rBBIStateTable.fNumStates; c2 = (char)(c2 + '\u0001')) {
                this.dumpRow(printStream, rBBIStateTable, c2);
            }
            printStream.println();
        }
    }

    private void dumpRow(PrintStream printStream, RBBIStateTable rBBIStateTable, char c2) {
        StringBuilder stringBuilder = new StringBuilder(this.fHeader.fCatCount * 5 + 20);
        stringBuilder.append(RBBIDataWrapper.intToString(c2, 4));
        int n2 = this.getRowIndex(c2);
        if (rBBIStateTable.fTable[n2 + 0] != '\u0000') {
            stringBuilder.append(RBBIDataWrapper.intToString(rBBIStateTable.fTable[n2 + 0], 5));
        } else {
            stringBuilder.append("     ");
        }
        if (rBBIStateTable.fTable[n2 + 1] != '\u0000') {
            stringBuilder.append(RBBIDataWrapper.intToString(rBBIStateTable.fTable[n2 + 1], 5));
        } else {
            stringBuilder.append("     ");
        }
        stringBuilder.append(RBBIDataWrapper.intToString(rBBIStateTable.fTable[n2 + 2], 5));
        for (int i2 = 0; i2 < this.fHeader.fCatCount; ++i2) {
            stringBuilder.append(RBBIDataWrapper.intToString(rBBIStateTable.fTable[n2 + 3 + i2], 5));
        }
        printStream.println(stringBuilder);
    }

    private void dumpCharCategories(PrintStream printStream) {
        int n2;
        int n3 = this.fHeader.fCatCount;
        String[] stringArray = new String[n3 + 1];
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int[] nArray = new int[n3 + 1];
        for (n2 = 0; n2 <= this.fHeader.fCatCount; ++n2) {
            stringArray[n2] = "";
        }
        printStream.println("\nCharacter Categories");
        printStream.println("--------------------");
        for (int i2 = 0; i2 <= 0x10FFFF; ++i2) {
            n2 = this.fTrie.get(i2);
            if (n2 < 0 || n2 > this.fHeader.fCatCount) {
                printStream.println("Error, bad category " + Integer.toHexString(n2) + " for char " + Integer.toHexString(i2));
                break;
            }
            if (n2 == n6) {
                n5 = i2;
                continue;
            }
            if (n6 >= 0) {
                if (stringArray[n6].length() > nArray[n6] + 70) {
                    nArray[n6] = stringArray[n6].length() + 10;
                    int n7 = n6;
                    stringArray[n7] = stringArray[n7] + "\n       ";
                }
                int n8 = n6;
                stringArray[n8] = stringArray[n8] + " " + Integer.toHexString(n4);
                if (n5 != n4) {
                    int n9 = n6;
                    stringArray[n9] = stringArray[n9] + "-" + Integer.toHexString(n5);
                }
            }
            n6 = n2;
            n4 = n5 = i2;
        }
        int n10 = n6;
        stringArray[n10] = stringArray[n10] + " " + Integer.toHexString(n4);
        if (n5 != n4) {
            int n11 = n6;
            stringArray[n11] = stringArray[n11] + "-" + Integer.toHexString(n5);
        }
        for (n2 = 0; n2 <= this.fHeader.fCatCount; ++n2) {
            printStream.println(RBBIDataWrapper.intToString(n2, 5) + "  " + stringArray[n2]);
        }
        printStream.println();
    }

    public static final class RBBIDataHeader {
        int fMagic = 0;
        byte[] fFormatVersion = new byte[4];
        int fLength;
        public int fCatCount;
        int fFTable;
        int fFTableLen;
        int fRTable;
        int fRTableLen;
        int fTrie;
        int fTrieLen;
        int fRuleSource;
        int fRuleSourceLen;
        int fStatusTable;
        int fStatusTableLen;
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            int n2 = (byArray[0] << 24) + (byArray[1] << 16) + (byArray[2] << 8) + byArray[3];
            return n2 == 0x6000000;
        }
    }

    public static class RBBIStateTable {
        public int fNumStates;
        public int fRowLen;
        public int fDictCategoriesStart;
        public int fLookAheadResultsSize;
        public int fFlags;
        public static int fHeaderSize = 20;
        public char[] fTable;

        static RBBIStateTable get(ByteBuffer byteBuffer, int n2) throws IOException {
            boolean bl2;
            if (n2 == 0) {
                return null;
            }
            if (n2 < fHeaderSize) {
                throw new IOException("Invalid RBBI state table length.");
            }
            RBBIStateTable rBBIStateTable = new RBBIStateTable();
            rBBIStateTable.fNumStates = byteBuffer.getInt();
            rBBIStateTable.fRowLen = byteBuffer.getInt();
            rBBIStateTable.fDictCategoriesStart = byteBuffer.getInt();
            rBBIStateTable.fLookAheadResultsSize = byteBuffer.getInt();
            rBBIStateTable.fFlags = byteBuffer.getInt();
            int n3 = n2 - fHeaderSize;
            boolean bl3 = bl2 = (rBBIStateTable.fFlags & 4) == 4;
            if (bl2) {
                rBBIStateTable.fTable = new char[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    byte by2 = byteBuffer.get();
                    rBBIStateTable.fTable[i2] = (char)(0xFF & by2);
                }
                ICUBinary.skipBytes(byteBuffer, n3 & 1);
            } else {
                rBBIStateTable.fTable = ICUBinary.getChars(byteBuffer, n3 / 2, n3 & 1);
            }
            return rBBIStateTable;
        }

        public int put(DataOutputStream dataOutputStream) throws IOException {
            int n2;
            int n3;
            dataOutputStream.writeInt(this.fNumStates);
            dataOutputStream.writeInt(this.fRowLen);
            dataOutputStream.writeInt(this.fDictCategoriesStart);
            dataOutputStream.writeInt(this.fLookAheadResultsSize);
            dataOutputStream.writeInt(this.fFlags);
            if ((this.fFlags & 4) == 4) {
                n3 = this.fRowLen * this.fNumStates;
                for (n2 = 0; n2 < n3; ++n2) {
                    byte by2 = (byte)(this.fTable[n2] & 0xFF);
                    dataOutputStream.writeByte(by2);
                }
            } else {
                n3 = this.fRowLen * this.fNumStates / 2;
                for (n2 = 0; n2 < n3; ++n2) {
                    dataOutputStream.writeChar(this.fTable[n2]);
                }
            }
            n3 = fHeaderSize + this.fRowLen * this.fNumStates;
            while (n3 % 8 != 0) {
                dataOutputStream.writeByte(0);
                ++n3;
            }
            return n3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RBBIStateTable)) {
                return false;
            }
            RBBIStateTable rBBIStateTable = (RBBIStateTable)object;
            if (this.fNumStates != rBBIStateTable.fNumStates) {
                return false;
            }
            if (this.fRowLen != rBBIStateTable.fRowLen) {
                return false;
            }
            if (this.fDictCategoriesStart != rBBIStateTable.fDictCategoriesStart) {
                return false;
            }
            if (this.fLookAheadResultsSize != rBBIStateTable.fLookAheadResultsSize) {
                return false;
            }
            if (this.fFlags != rBBIStateTable.fFlags) {
                return false;
            }
            return Arrays.equals(this.fTable, rBBIStateTable.fTable);
        }
    }
}

