/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Arrays;
import java.util.Comparator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IntTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IntTrieBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PVecToTrieCompactHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TrieBuilder;

public class PropsVectors {
    private int[] v;
    private int columns;
    private int maxRows;
    private int rows;
    private int prevRow;
    private boolean isCompacted;
    public static final int FIRST_SPECIAL_CP = 0x110000;
    public static final int INITIAL_VALUE_CP = 0x110000;
    public static final int ERROR_VALUE_CP = 0x110001;
    public static final int MAX_CP = 0x110001;
    public static final int INITIAL_ROWS = 4096;
    public static final int MEDIUM_ROWS = 65536;
    public static final int MAX_ROWS = 0x110002;

    private boolean areElementsSame(int n2, int[] nArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.v[n2 + i2] == nArray[n3 + i2]) continue;
            return false;
        }
        return true;
    }

    private int findRow(int n2) {
        int n3 = 0;
        n3 = this.prevRow * this.columns;
        if (n2 >= this.v[n3]) {
            if (n2 < this.v[n3 + 1]) {
                return n3;
            }
            if (n2 < this.v[(n3 += this.columns) + 1]) {
                ++this.prevRow;
                return n3;
            }
            if (n2 < this.v[(n3 += this.columns) + 1]) {
                this.prevRow += 2;
                return n3;
            }
            if (n2 - this.v[n3 + 1] < 10) {
                this.prevRow += 2;
                do {
                    ++this.prevRow;
                } while (n2 >= this.v[(n3 += this.columns) + 1]);
                return n3;
            }
        } else if (n2 < this.v[1]) {
            this.prevRow = 0;
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = this.rows;
        while (n4 < n6 - 1) {
            n5 = (n4 + n6) / 2;
            n3 = this.columns * n5;
            if (n2 < this.v[n3]) {
                n6 = n5;
                continue;
            }
            if (n2 < this.v[n3 + 1]) {
                this.prevRow = n5;
                return n3;
            }
            n4 = n5;
        }
        this.prevRow = n4;
        n3 = n4 * this.columns;
        return n3;
    }

    public PropsVectors(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("numOfColumns need to be no less than 1; but it is " + n2);
        }
        this.columns = n2 + 2;
        this.v = new int[4096 * this.columns];
        this.maxRows = 4096;
        this.rows = 3;
        this.prevRow = 0;
        this.isCompacted = false;
        this.v[0] = 0;
        this.v[1] = 0x110000;
        int n3 = this.columns;
        for (int i2 = 0x110000; i2 <= 0x110001; ++i2) {
            this.v[n3] = i2;
            this.v[n3 + 1] = i2 + 1;
            n3 += this.columns;
        }
    }

    public void setValue(int n2, int n3, int n4, int n5, int n6) {
        boolean bl2;
        if (n2 < 0 || n2 > n3 || n3 > 0x110001 || n4 < 0 || n4 >= this.columns - 2) {
            throw new IllegalArgumentException();
        }
        if (this.isCompacted) {
            throw new IllegalStateException("Shouldn't be called aftercompact()!");
        }
        int n7 = n3 + 1;
        int n8 = this.findRow(n2);
        int n9 = this.findRow(n3);
        boolean bl3 = n2 != this.v[n8] && (n5 &= n6) != (this.v[n8 + (n4 += 2)] & n6);
        boolean bl4 = bl2 = n7 != this.v[n9 + 1] && n5 != (this.v[n9 + n4] & n6);
        if (bl3 || bl2) {
            int n10;
            int n11 = 0;
            if (bl3) {
                ++n11;
            }
            if (bl2) {
                ++n11;
            }
            int n12 = 0;
            if (this.rows + n11 > this.maxRows) {
                if (this.maxRows < 65536) {
                    n12 = 65536;
                } else if (this.maxRows < 0x110002) {
                    n12 = 0x110002;
                } else {
                    throw new IndexOutOfBoundsException("MAX_ROWS exceeded! Increase it to a higher valuein the implementation");
                }
                int[] nArray = new int[n12 * this.columns];
                System.arraycopy(this.v, 0, nArray, 0, this.rows * this.columns);
                this.v = nArray;
                this.maxRows = n12;
            }
            if ((n10 = this.rows * this.columns - (n9 + this.columns)) > 0) {
                System.arraycopy(this.v, n9 + this.columns, this.v, n9 + (1 + n11) * this.columns, n10);
            }
            this.rows += n11;
            if (bl3) {
                n10 = n9 - n8 + this.columns;
                System.arraycopy(this.v, n8, this.v, n8 + this.columns, n10);
                n9 += this.columns;
                int n13 = n2;
                this.v[n8 + this.columns] = n13;
                this.v[n8 + 1] = n13;
                n8 += this.columns;
            }
            if (bl2) {
                System.arraycopy(this.v, n9, this.v, n9 + this.columns, this.columns);
                int n14 = n7;
                this.v[n9 + this.columns] = n14;
                this.v[n9 + 1] = n14;
            }
        }
        this.prevRow = n9 / this.columns;
        n8 += n4;
        n9 += n4;
        n6 ^= 0xFFFFFFFF;
        while (true) {
            this.v[n8] = this.v[n8] & n6 | n5;
            if (n8 == n9) break;
            n8 += this.columns;
        }
    }

    public int getValue(int n2, int n3) {
        if (this.isCompacted || n2 < 0 || n2 > 0x110001 || n3 < 0 || n3 >= this.columns - 2) {
            return 0;
        }
        int n4 = this.findRow(n2);
        return this.v[n4 + 2 + n3];
    }

    public int[] getRow(int n2) {
        if (this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method after compact()");
        }
        if (n2 < 0 || n2 > this.rows) {
            throw new IllegalArgumentException("rowIndex out of bound!");
        }
        int[] nArray = new int[this.columns - 2];
        System.arraycopy(this.v, n2 * this.columns + 2, nArray, 0, this.columns - 2);
        return nArray;
    }

    public int getRowStart(int n2) {
        if (this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method after compact()");
        }
        if (n2 < 0 || n2 > this.rows) {
            throw new IllegalArgumentException("rowIndex out of bound!");
        }
        return this.v[n2 * this.columns];
    }

    public int getRowEnd(int n2) {
        if (this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method after compact()");
        }
        if (n2 < 0 || n2 > this.rows) {
            throw new IllegalArgumentException("rowIndex out of bound!");
        }
        return this.v[n2 * this.columns + 1] - 1;
    }

    public void compact(CompactHandler compactHandler) {
        int n2;
        int n3;
        if (this.isCompacted) {
            return;
        }
        this.isCompacted = true;
        int n4 = this.columns - 2;
        Integer[] integerArray = new Integer[this.rows];
        for (n3 = 0; n3 < this.rows; ++n3) {
            integerArray[n3] = this.columns * n3;
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n2, Integer n3) {
                int n4 = n2;
                int n5 = n3;
                int n6 = PropsVectors.this.columns;
                int n7 = 2;
                do {
                    if (PropsVectors.this.v[n4 + n7] != PropsVectors.this.v[n5 + n7]) {
                        return PropsVectors.this.v[n4 + n7] < PropsVectors.this.v[n5 + n7] ? -1 : 1;
                    }
                    if (++n7 != PropsVectors.this.columns) continue;
                    n7 = 0;
                } while (--n6 > 0);
                return 0;
            }
        });
        n3 = -n4;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            n2 = this.v[integerArray[i2]];
            if (n3 < 0 || !this.areElementsSame(integerArray[i2] + 2, this.v, integerArray[i2 - 1] + 2, n4)) {
                n3 += n4;
            }
            if (n2 == 0x110000) {
                compactHandler.setRowIndexForInitialValue(n3);
                continue;
            }
            if (n2 != 0x110001) continue;
            compactHandler.setRowIndexForErrorValue(n3);
        }
        compactHandler.startRealValues(n3 += n4);
        int[] nArray = new int[n3];
        n3 = -n4;
        for (n2 = 0; n2 < this.rows; ++n2) {
            int n5 = this.v[integerArray[n2]];
            int n6 = this.v[integerArray[n2] + 1];
            if (n3 < 0 || !this.areElementsSame(integerArray[n2] + 2, nArray, n3, n4)) {
                System.arraycopy(this.v, integerArray[n2] + 2, nArray, n3 += n4, n4);
            }
            if (n5 >= 0x110000) continue;
            compactHandler.setRowIndexForRange(n5, n6 - 1, n3);
        }
        this.v = nArray;
        this.rows = n3 / n4 + 1;
    }

    public int[] getCompactedArray() {
        if (!this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method before compact()");
        }
        return this.v;
    }

    public int getCompactedRows() {
        if (!this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method before compact()");
        }
        return this.rows;
    }

    public int getCompactedColumns() {
        if (!this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method before compact()");
        }
        return this.columns - 2;
    }

    public IntTrie compactToTrieWithRowIndexes() {
        PVecToTrieCompactHandler pVecToTrieCompactHandler = new PVecToTrieCompactHandler();
        this.compact(pVecToTrieCompactHandler);
        return pVecToTrieCompactHandler.builder.serialize(new DefaultGetFoldedValue(pVecToTrieCompactHandler.builder), new DefaultGetFoldingOffset());
    }

    public static interface CompactHandler {
        public void setRowIndexForRange(int var1, int var2, int var3);

        public void setRowIndexForInitialValue(int var1);

        public void setRowIndexForErrorValue(int var1);

        public void startRealValues(int var1);
    }

    private static class DefaultGetFoldedValue
    implements TrieBuilder.DataManipulate {
        private IntTrieBuilder builder;

        public DefaultGetFoldedValue(IntTrieBuilder intTrieBuilder) {
            this.builder = intTrieBuilder;
        }

        @Override
        public int getFoldedValue(int n2, int n3) {
            int n4 = this.builder.m_initialValue_;
            int n5 = n2 + 1024;
            while (n2 < n5) {
                boolean[] blArray = new boolean[1];
                int n6 = this.builder.getValue(n2, blArray);
                if (blArray[0]) {
                    n2 += 32;
                    continue;
                }
                if (n6 != n4) {
                    return n3;
                }
                ++n2;
            }
            return 0;
        }
    }

    private static class DefaultGetFoldingOffset
    implements Trie.DataManipulate {
        private DefaultGetFoldingOffset() {
        }

        @Override
        public int getFoldingOffset(int n2) {
            return n2;
        }
    }
}

