/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Punycode;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringPrep;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringPrepParseException;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;

public final class IDNA2003 {
    private static char[] ACE_PREFIX = new char[]{'x', 'n', '-', '-'};
    private static final int MAX_LABEL_LENGTH = 63;
    private static final int HYPHEN = 45;
    private static final int CAPITAL_A = 65;
    private static final int CAPITAL_Z = 90;
    private static final int LOWER_CASE_DELTA = 32;
    private static final int FULL_STOP = 46;
    private static final int MAX_DOMAIN_NAME_LENGTH = 255;
    private static final StringPrep namePrep = StringPrep.getInstance(0);

    private static boolean startsWithPrefix(StringBuffer stringBuffer) {
        if (stringBuffer.length() < ACE_PREFIX.length) {
            return false;
        }
        for (int i2 = 0; i2 < ACE_PREFIX.length; ++i2) {
            if (IDNA2003.toASCIILower(stringBuffer.charAt(i2)) == ACE_PREFIX[i2]) continue;
            return false;
        }
        return true;
    }

    private static char toASCIILower(char c2) {
        if ('A' <= c2 && c2 <= 'Z') {
            return (char)(c2 + 32);
        }
        return c2;
    }

    private static StringBuffer toASCIILower(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            stringBuffer.append(IDNA2003.toASCIILower(charSequence.charAt(i2)));
        }
        return stringBuffer;
    }

    private static int compareCaseInsensitiveASCII(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n2 = 0;
        while (n2 != stringBuffer.length()) {
            int n3;
            char c2;
            char c3 = stringBuffer.charAt(n2);
            if (c3 != (c2 = stringBuffer2.charAt(n2)) && (n3 = IDNA2003.toASCIILower(c3) - IDNA2003.toASCIILower(c2)) != 0) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    private static int getSeparatorIndex(char[] cArray, int n2, int n3) {
        while (n2 < n3) {
            if (IDNA2003.isLabelSeparator(cArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    private static boolean isLDHChar(int n2) {
        if (n2 > 122) {
            return false;
        }
        return n2 == 45 || 48 <= n2 && n2 <= 57 || 65 <= n2 && n2 <= 90 || 97 <= n2 && n2 <= 122;
    }

    private static boolean isLabelSeparator(int n2) {
        switch (n2) {
            case 46: 
            case 12290: 
            case 65294: 
            case 65377: {
                return true;
            }
        }
        return false;
    }

    public static StringBuffer convertToASCII(UCharacterIterator uCharacterIterator, int n2) throws StringPrepParseException {
        int n3;
        boolean bl2;
        boolean[] blArray = null;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = bl2 = (n2 & 2) != 0;
        while ((n3 = uCharacterIterator.next()) != -1) {
            if (n3 <= 127) continue;
            bl3 = false;
            break;
        }
        int n4 = -1;
        uCharacterIterator.setToStart();
        StringBuffer stringBuffer = null;
        stringBuffer = !bl3 ? namePrep.prepare(uCharacterIterator, n2) : new StringBuffer(uCharacterIterator.getText());
        int n5 = stringBuffer.length();
        if (n5 == 0) {
            throw new StringPrepParseException("Found zero length label after NamePrep.", 10);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        bl3 = true;
        for (int i2 = 0; i2 < n5; ++i2) {
            n3 = stringBuffer.charAt(i2);
            if (n3 > 127) {
                bl3 = false;
                continue;
            }
            if (IDNA2003.isLDHChar(n3)) continue;
            bl4 = false;
            n4 = i2;
        }
        if (bl2 && (!bl4 || stringBuffer.charAt(0) == '-' || stringBuffer.charAt(stringBuffer.length() - 1) == '-')) {
            if (!bl4) {
                throw new StringPrepParseException("The input does not conform to the STD 3 ASCII rules", 5, stringBuffer.toString(), n4 > 0 ? n4 - 1 : n4);
            }
            if (stringBuffer.charAt(0) == '-') {
                throw new StringPrepParseException("The input does not conform to the STD 3 ASCII rules", 5, stringBuffer.toString(), 0);
            }
            throw new StringPrepParseException("The input does not conform to the STD 3 ASCII rules", 5, stringBuffer.toString(), n5 > 0 ? n5 - 1 : n5);
        }
        if (bl3) {
            stringBuffer2 = stringBuffer;
        } else if (!IDNA2003.startsWithPrefix(stringBuffer)) {
            blArray = new boolean[n5];
            StringBuilder stringBuilder = Punycode.encode(stringBuffer, blArray);
            StringBuffer stringBuffer3 = IDNA2003.toASCIILower(stringBuilder);
            stringBuffer2.append(ACE_PREFIX, 0, ACE_PREFIX.length);
            stringBuffer2.append(stringBuffer3);
        } else {
            throw new StringPrepParseException("The input does not start with the ACE Prefix.", 6, stringBuffer.toString(), 0);
        }
        if (stringBuffer2.length() > 63) {
            throw new StringPrepParseException("The labels in the input are too long. Length > 63.", 8, stringBuffer2.toString(), 0);
        }
        return stringBuffer2;
    }

    public static StringBuffer convertIDNToASCII(String string, int n2) throws StringPrepParseException {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (true) {
            String string2;
            if ((string2 = new String(cArray, n4, (n3 = IDNA2003.getSeparatorIndex(cArray, n3, cArray.length)) - n4)).length() != 0 || n3 != cArray.length) {
                UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(string2);
                stringBuffer.append(IDNA2003.convertToASCII(uCharacterIterator, n2));
            }
            if (n3 == cArray.length) break;
            n4 = ++n3;
            stringBuffer.append('.');
        }
        if (stringBuffer.length() > 255) {
            throw new StringPrepParseException("The output exceed the max allowed length.", 11);
        }
        return stringBuffer;
    }

    public static StringBuffer convertToUnicode(UCharacterIterator uCharacterIterator, int n2) throws StringPrepParseException {
        StringBuffer stringBuffer;
        int n3;
        boolean[] blArray = null;
        boolean bl2 = true;
        int n4 = uCharacterIterator.getIndex();
        while ((n3 = uCharacterIterator.next()) != -1) {
            if (n3 <= 127) continue;
            bl2 = false;
        }
        if (!bl2) {
            try {
                uCharacterIterator.setIndex(n4);
                stringBuffer = namePrep.prepare(uCharacterIterator, n2);
            }
            catch (StringPrepParseException stringPrepParseException) {
                return new StringBuffer(uCharacterIterator.getText());
            }
        } else {
            stringBuffer = new StringBuffer(uCharacterIterator.getText());
        }
        if (IDNA2003.startsWithPrefix(stringBuffer)) {
            StringBuffer stringBuffer2;
            StringBuffer stringBuffer3 = null;
            String string = stringBuffer.substring(ACE_PREFIX.length, stringBuffer.length());
            try {
                stringBuffer3 = new StringBuffer(Punycode.decode(string, blArray));
            }
            catch (StringPrepParseException stringPrepParseException) {
                stringBuffer3 = null;
            }
            if (stringBuffer3 != null && IDNA2003.compareCaseInsensitiveASCII(stringBuffer, stringBuffer2 = IDNA2003.convertToASCII(UCharacterIterator.getInstance(stringBuffer3), n2)) != 0) {
                stringBuffer3 = null;
            }
            if (stringBuffer3 != null) {
                return stringBuffer3;
            }
        }
        return new StringBuffer(uCharacterIterator.getText());
    }

    public static StringBuffer convertIDNToUnicode(String string, int n2) throws StringPrepParseException {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (true) {
            String string2;
            if ((string2 = new String(cArray, n4, (n3 = IDNA2003.getSeparatorIndex(cArray, n3, cArray.length)) - n4)).length() == 0 && n3 != cArray.length) {
                throw new StringPrepParseException("Found zero length label after NamePrep.", 10);
            }
            UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(string2);
            stringBuffer.append(IDNA2003.convertToUnicode(uCharacterIterator, n2));
            if (n3 == cArray.length) break;
            stringBuffer.append(cArray[n3]);
            n4 = ++n3;
        }
        if (stringBuffer.length() > 255) {
            throw new StringPrepParseException("The output exceed the max allowed length.", 11);
        }
        return stringBuffer;
    }

    public static int compare(String string, String string2, int n2) throws StringPrepParseException {
        StringBuffer stringBuffer = IDNA2003.convertIDNToASCII(string, n2);
        StringBuffer stringBuffer2 = IDNA2003.convertIDNToASCII(string2, n2);
        return IDNA2003.compareCaseInsensitiveASCII(stringBuffer, stringBuffer2);
    }
}

