/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CacheValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceTypeMismatchException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public final class ICUResourceBundleReader {
    private static final int DATA_FORMAT = 1382380354;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private static final int URES_INDEX_LENGTH = 0;
    private static final int URES_INDEX_KEYS_TOP = 1;
    private static final int URES_INDEX_BUNDLE_TOP = 3;
    private static final int URES_INDEX_MAX_TABLE_LENGTH = 4;
    private static final int URES_INDEX_ATTRIBUTES = 5;
    private static final int URES_INDEX_16BIT_TOP = 6;
    private static final int URES_INDEX_POOL_CHECKSUM = 7;
    private static final int URES_ATT_NO_FALLBACK = 1;
    private static final int URES_ATT_IS_POOL_BUNDLE = 2;
    private static final int URES_ATT_USES_POOL_BUNDLE = 4;
    private static final CharBuffer EMPTY_16_BIT_UNITS = CharBuffer.wrap("\u0000");
    static final int LARGE_SIZE = 24;
    private static final boolean DEBUG = false;
    private int dataVersion;
    private ByteBuffer bytes;
    private byte[] keyBytes;
    private CharBuffer b16BitUnits;
    private ICUResourceBundleReader poolBundleReader;
    private int rootRes;
    private int localKeyLimit;
    private int poolStringIndexLimit;
    private int poolStringIndex16Limit;
    private boolean noFallback;
    private boolean isPoolBundle;
    private boolean usesPoolBundle;
    private int poolCheckSum;
    private ResourceCache resourceCache;
    private static ReaderCache CACHE = new ReaderCache();
    private static final ICUResourceBundleReader NULL_READER = new ICUResourceBundleReader();
    private static final byte[] emptyBytes = new byte[0];
    private static final ByteBuffer emptyByteBuffer = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private static final char[] emptyChars = new char[0];
    private static final int[] emptyInts = new int[0];
    private static final String emptyString = "";
    private static final Array EMPTY_ARRAY = new Array();
    private static final Table EMPTY_TABLE = new Table();
    private static int[] PUBLIC_TYPES = new int[]{0, 1, 2, 3, 2, 2, 0, 7, 8, 8, -1, -1, -1, -1, 14, -1};
    private static final String ICU_RESOURCE_SUFFIX = ".res";

    private ICUResourceBundleReader() {
    }

    private ICUResourceBundleReader(ByteBuffer byteBuffer, String string, String string2, ClassLoader classLoader) throws IOException {
        this.init(byteBuffer);
        if (this.usesPoolBundle) {
            this.poolBundleReader = ICUResourceBundleReader.getReader(string, "pool", classLoader);
            if (this.poolBundleReader == null || !this.poolBundleReader.isPoolBundle) {
                throw new IllegalStateException("pool.res is not a pool bundle");
            }
            if (this.poolBundleReader.poolCheckSum != this.poolCheckSum) {
                throw new IllegalStateException("pool.res has a different checksum than this bundle");
            }
        }
    }

    static ICUResourceBundleReader getReader(String string, String string2, ClassLoader classLoader) {
        ReaderCacheKey readerCacheKey = new ReaderCacheKey(string, string2);
        ICUResourceBundleReader iCUResourceBundleReader = (ICUResourceBundleReader)CACHE.getInstance(readerCacheKey, classLoader);
        if (iCUResourceBundleReader == NULL_READER) {
            return null;
        }
        return iCUResourceBundleReader;
    }

    private void init(ByteBuffer byteBuffer) throws IOException {
        int n2;
        int n3;
        this.dataVersion = ICUBinary.readHeader(byteBuffer, 1382380354, IS_ACCEPTABLE);
        byte by2 = byteBuffer.get(16);
        this.bytes = ICUBinary.sliceWithOrder(byteBuffer);
        int n4 = this.bytes.remaining();
        this.rootRes = this.bytes.getInt(0);
        int n5 = this.getIndexesInt(0);
        int n6 = n5 & 0xFF;
        if (n6 <= 4) {
            throw new ICUException("not enough indexes");
        }
        if (n4 < 1 + n6 << 2 || n4 < (n3 = this.getIndexesInt(3)) << 2) {
            throw new ICUException("not enough bytes");
        }
        int n7 = n3 - 1;
        if (by2 >= 3) {
            this.poolStringIndexLimit = n5 >>> 8;
        }
        if (n6 > 5) {
            n2 = this.getIndexesInt(5);
            this.noFallback = (n2 & 1) != 0;
            this.isPoolBundle = (n2 & 2) != 0;
            this.usesPoolBundle = (n2 & 4) != 0;
            this.poolStringIndexLimit |= (n2 & 0xF000) << 12;
            this.poolStringIndex16Limit = n2 >>> 16;
        }
        n2 = 1 + n6;
        int n8 = this.getIndexesInt(1);
        if (n8 > n2) {
            if (this.isPoolBundle) {
                this.keyBytes = new byte[n8 - n2 << 2];
                this.bytes.position(n2 << 2);
            } else {
                this.localKeyLimit = n8 << 2;
                this.keyBytes = new byte[this.localKeyLimit];
            }
            this.bytes.get(this.keyBytes);
        }
        if (n6 > 6) {
            int n9 = this.getIndexesInt(6);
            if (n9 > n8) {
                int n10 = (n9 - n8) * 2;
                this.bytes.position(n8 << 2);
                this.b16BitUnits = this.bytes.asCharBuffer();
                this.b16BitUnits.limit(n10);
                n7 |= n10 - 1;
            } else {
                this.b16BitUnits = EMPTY_16_BIT_UNITS;
            }
        } else {
            this.b16BitUnits = EMPTY_16_BIT_UNITS;
        }
        if (n6 > 7) {
            this.poolCheckSum = this.getIndexesInt(7);
        }
        if (!this.isPoolBundle || this.b16BitUnits.length() > 1) {
            this.resourceCache = new ResourceCache(n7);
        }
        this.bytes.position(0);
    }

    private int getIndexesInt(int n2) {
        return this.bytes.getInt(1 + n2 << 2);
    }

    VersionInfo getVersion() {
        return ICUBinary.getVersionInfoFromCompactInt(this.dataVersion);
    }

    int getRootResource() {
        return this.rootRes;
    }

    boolean getNoFallback() {
        return this.noFallback;
    }

    boolean getUsesPoolBundle() {
        return this.usesPoolBundle;
    }

    static int RES_GET_TYPE(int n2) {
        return n2 >>> 28;
    }

    private static int RES_GET_OFFSET(int n2) {
        return n2 & 0xFFFFFFF;
    }

    private int getResourceByteOffset(int n2) {
        return n2 << 2;
    }

    static int RES_GET_INT(int n2) {
        return n2 << 4 >> 4;
    }

    static int RES_GET_UINT(int n2) {
        return n2 & 0xFFFFFFF;
    }

    static boolean URES_IS_ARRAY(int n2) {
        return n2 == 8 || n2 == 9;
    }

    static boolean URES_IS_TABLE(int n2) {
        return n2 == 2 || n2 == 5 || n2 == 4;
    }

    private char[] getChars(int n2, int n3) {
        char[] cArray = new char[n3];
        if (n3 <= 16) {
            for (int i2 = 0; i2 < n3; ++i2) {
                cArray[i2] = this.bytes.getChar(n2);
                n2 += 2;
            }
        } else {
            CharBuffer charBuffer = this.bytes.asCharBuffer();
            charBuffer.position(n2 / 2);
            charBuffer.get(cArray);
        }
        return cArray;
    }

    private int getInt(int n2) {
        return this.bytes.getInt(n2);
    }

    private int[] getInts(int n2, int n3) {
        int[] nArray = new int[n3];
        if (n3 <= 16) {
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = this.bytes.getInt(n2);
                n2 += 4;
            }
        } else {
            IntBuffer intBuffer = this.bytes.asIntBuffer();
            intBuffer.position(n2 / 4);
            intBuffer.get(nArray);
        }
        return nArray;
    }

    private char[] getTable16KeyOffsets(int n2) {
        int n3;
        if ((n3 = this.b16BitUnits.charAt(n2++)) > 0) {
            char[] cArray = new char[n3];
            if (n3 <= 16) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    cArray[i2] = this.b16BitUnits.charAt(n2++);
                }
            } else {
                CharBuffer charBuffer = this.b16BitUnits.duplicate();
                charBuffer.position(n2);
                charBuffer.get(cArray);
            }
            return cArray;
        }
        return emptyChars;
    }

    private char[] getTableKeyOffsets(int n2) {
        char c2 = this.bytes.getChar(n2);
        if (c2 > '\u0000') {
            return this.getChars(n2 + 2, c2);
        }
        return emptyChars;
    }

    private int[] getTable32KeyOffsets(int n2) {
        int n3 = this.getInt(n2);
        if (n3 > 0) {
            return this.getInts(n2 + 4, n3);
        }
        return emptyInts;
    }

    private static String makeKeyStringFromBytes(byte[] byArray, int n2) {
        int n3 = n2;
        while (byArray[n3] != 0) {
            ++n3;
        }
        int n4 = n3 - n2;
        return new String(byArray, n2, n4, StandardCharsets.ISO_8859_1);
    }

    private String getKey16String(int n2) {
        if (n2 < this.localKeyLimit) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(this.keyBytes, n2);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(this.poolBundleReader.keyBytes, n2 - this.localKeyLimit);
    }

    private String getKey32String(int n2) {
        if (n2 >= 0) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(this.keyBytes, n2);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(this.poolBundleReader.keyBytes, n2 & Integer.MAX_VALUE);
    }

    private void setKeyFromKey16(int n2, UResource.Key key) {
        if (n2 < this.localKeyLimit) {
            key.setBytes(this.keyBytes, n2);
        } else {
            key.setBytes(this.poolBundleReader.keyBytes, n2 - this.localKeyLimit);
        }
    }

    private void setKeyFromKey32(int n2, UResource.Key key) {
        if (n2 >= 0) {
            key.setBytes(this.keyBytes, n2);
        } else {
            key.setBytes(this.poolBundleReader.keyBytes, n2 & Integer.MAX_VALUE);
        }
    }

    private int compareKeys(CharSequence charSequence, char c2) {
        if (c2 < this.localKeyLimit) {
            return ICUBinary.compareKeys(charSequence, this.keyBytes, (int)c2);
        }
        return ICUBinary.compareKeys(charSequence, this.poolBundleReader.keyBytes, c2 - this.localKeyLimit);
    }

    private int compareKeys32(CharSequence charSequence, int n2) {
        if (n2 >= 0) {
            return ICUBinary.compareKeys(charSequence, this.keyBytes, n2);
        }
        return ICUBinary.compareKeys(charSequence, this.poolBundleReader.keyBytes, n2 & Integer.MAX_VALUE);
    }

    String getStringV2(int n2) {
        String string;
        assert (ICUResourceBundleReader.RES_GET_TYPE(n2) == 6);
        int n3 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        assert (n3 != 0);
        Object object = this.resourceCache.get(n2);
        if (object != null) {
            return (String)object;
        }
        char c2 = this.b16BitUnits.charAt(n3);
        if ((c2 & 0xFFFFFC00) != 56320) {
            char c3;
            if (c2 == '\u0000') {
                return emptyString;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(c2);
            while ((c3 = this.b16BitUnits.charAt(++n3)) != '\u0000') {
                stringBuilder.append(c3);
            }
            string = stringBuilder.toString();
        } else {
            int n4;
            if (c2 < '\udfef') {
                n4 = c2 & 0x3FF;
                ++n3;
            } else if (c2 < '\udfff') {
                n4 = c2 - 57327 << 16 | this.b16BitUnits.charAt(n3 + 1);
                n3 += 2;
            } else {
                n4 = this.b16BitUnits.charAt(n3 + 1) << 16 | this.b16BitUnits.charAt(n3 + 2);
                n3 += 3;
            }
            string = this.b16BitUnits.subSequence(n3, n3 + n4).toString();
        }
        return (String)this.resourceCache.putIfAbsent(n2, string, string.length() * 2);
    }

    private String makeStringFromBytes(int n2, int n3) {
        if (n3 <= 16) {
            StringBuilder stringBuilder = new StringBuilder(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuilder.append(this.bytes.getChar(n2));
                n2 += 2;
            }
            return stringBuilder.toString();
        }
        CharBuffer charBuffer = this.bytes.asCharBuffer();
        return charBuffer.subSequence(n2 /= 2, n2 + n3).toString();
    }

    String getString(int n2) {
        int n3 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (n2 != n3 && ICUResourceBundleReader.RES_GET_TYPE(n2) != 6) {
            return null;
        }
        if (n3 == 0) {
            return emptyString;
        }
        if (n2 != n3) {
            if (n3 < this.poolStringIndexLimit) {
                return this.poolBundleReader.getStringV2(n2);
            }
            return this.getStringV2(n2 - this.poolStringIndexLimit);
        }
        Object object = this.resourceCache.get(n2);
        if (object != null) {
            return (String)object;
        }
        n3 = this.getResourceByteOffset(n3);
        int n4 = this.getInt(n3);
        String string = this.makeStringFromBytes(n3 + 4, n4);
        return (String)this.resourceCache.putIfAbsent(n2, string, string.length() * 2);
    }

    private boolean isNoInheritanceMarker(int n2) {
        int n3 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (n3 != 0) {
            if (n2 == n3) {
                return this.getInt(n3 = this.getResourceByteOffset(n3)) == 3 && this.bytes.getChar(n3 + 4) == '\u2205' && this.bytes.getChar(n3 + 6) == '\u2205' && this.bytes.getChar(n3 + 8) == '\u2205';
            }
            if (ICUResourceBundleReader.RES_GET_TYPE(n2) == 6) {
                if (n3 < this.poolStringIndexLimit) {
                    return this.poolBundleReader.isStringV2NoInheritanceMarker(n3);
                }
                return this.isStringV2NoInheritanceMarker(n3 - this.poolStringIndexLimit);
            }
        }
        return false;
    }

    private boolean isStringV2NoInheritanceMarker(int n2) {
        char c2 = this.b16BitUnits.charAt(n2);
        if (c2 == '\u2205') {
            return this.b16BitUnits.charAt(n2 + 1) == '\u2205' && this.b16BitUnits.charAt(n2 + 2) == '\u2205' && this.b16BitUnits.charAt(n2 + 3) == '\u0000';
        }
        if (c2 == '\udc03') {
            return this.b16BitUnits.charAt(n2 + 1) == '\u2205' && this.b16BitUnits.charAt(n2 + 2) == '\u2205' && this.b16BitUnits.charAt(n2 + 3) == '\u2205';
        }
        return false;
    }

    String getAlias(int n2) {
        int n3 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (ICUResourceBundleReader.RES_GET_TYPE(n2) == 3) {
            if (n3 == 0) {
                return emptyString;
            }
            Object object = this.resourceCache.get(n2);
            if (object != null) {
                return (String)object;
            }
            n3 = this.getResourceByteOffset(n3);
            int n4 = this.getInt(n3);
            String string = this.makeStringFromBytes(n3 + 4, n4);
            return (String)this.resourceCache.putIfAbsent(n2, string, n4 * 2);
        }
        return null;
    }

    byte[] getBinary(int n2, byte[] byArray) {
        int n3 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (ICUResourceBundleReader.RES_GET_TYPE(n2) == 1) {
            if (n3 == 0) {
                return emptyBytes;
            }
            int n4 = this.getInt(n3 = this.getResourceByteOffset(n3));
            if (n4 == 0) {
                return emptyBytes;
            }
            if (byArray == null || byArray.length != n4) {
                byArray = new byte[n4];
            }
            n3 += 4;
            if (n4 <= 16) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    byArray[i2] = this.bytes.get(n3++);
                }
            } else {
                ByteBuffer byteBuffer = this.bytes.duplicate();
                byteBuffer.position(n3);
                byteBuffer.get(byArray);
            }
            return byArray;
        }
        return null;
    }

    ByteBuffer getBinary(int n2) {
        int n3 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (ICUResourceBundleReader.RES_GET_TYPE(n2) == 1) {
            if (n3 == 0) {
                return emptyByteBuffer.duplicate();
            }
            int n4 = this.getInt(n3 = this.getResourceByteOffset(n3));
            if (n4 == 0) {
                return emptyByteBuffer.duplicate();
            }
            ByteBuffer byteBuffer = this.bytes.duplicate();
            byteBuffer.position(n3 += 4).limit(n3 + n4);
            byteBuffer = ICUBinary.sliceWithOrder(byteBuffer);
            if (!byteBuffer.isReadOnly()) {
                byteBuffer = byteBuffer.asReadOnlyBuffer();
            }
            return byteBuffer;
        }
        return null;
    }

    int[] getIntVector(int n2) {
        int n3 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (ICUResourceBundleReader.RES_GET_TYPE(n2) == 14) {
            if (n3 == 0) {
                return emptyInts;
            }
            n3 = this.getResourceByteOffset(n3);
            int n4 = this.getInt(n3);
            return this.getInts(n3 + 4, n4);
        }
        return null;
    }

    Array getArray(int n2) {
        int n3 = ICUResourceBundleReader.RES_GET_TYPE(n2);
        if (!ICUResourceBundleReader.URES_IS_ARRAY(n3)) {
            return null;
        }
        int n4 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (n4 == 0) {
            return EMPTY_ARRAY;
        }
        Object object = this.resourceCache.get(n2);
        if (object != null) {
            return (Array)object;
        }
        Array array = n3 == 8 ? new Array32(this, n4) : new Array16(this, n4);
        return (Array)this.resourceCache.putIfAbsent(n2, array, 0);
    }

    Table getTable(int n2) {
        int n3;
        Table table;
        int n4 = ICUResourceBundleReader.RES_GET_TYPE(n2);
        if (!ICUResourceBundleReader.URES_IS_TABLE(n4)) {
            return null;
        }
        int n5 = ICUResourceBundleReader.RES_GET_OFFSET(n2);
        if (n5 == 0) {
            return EMPTY_TABLE;
        }
        Object object = this.resourceCache.get(n2);
        if (object != null) {
            return (Table)object;
        }
        if (n4 == 2) {
            table = new Table1632(this, n5);
            n3 = table.getSize() * 2;
        } else if (n4 == 5) {
            table = new Table16(this, n5);
            n3 = table.getSize() * 2;
        } else {
            table = new Table32(this, n5);
            n3 = table.getSize() * 4;
        }
        return (Table)this.resourceCache.putIfAbsent(n2, table, n3);
    }

    public static String getFullName(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (string2.length() == 0) {
                string2 = ULocale.getDefault().toString();
                return string2;
            }
            return string2 + ICU_RESOURCE_SUFFIX;
        }
        if (string.indexOf(46) == -1) {
            if (string.charAt(string.length() - 1) != '/') {
                return string + "/" + string2 + ICU_RESOURCE_SUFFIX;
            }
            return string + string2 + ICU_RESOURCE_SUFFIX;
        }
        string = string.replace('.', '/');
        if (string2.length() == 0) {
            return string + ICU_RESOURCE_SUFFIX;
        }
        return string + "_" + string2 + ICU_RESOURCE_SUFFIX;
    }

    private static final class ResourceCache {
        private static final int SIMPLE_LENGTH = 32;
        private static final int ROOT_BITS = 7;
        private static final int NEXT_BITS = 6;
        private int[] keys = new int[32];
        private Object[] values = new Object[32];
        private int length;
        private int maxOffsetBits;
        private int levelBitsList;
        private Level rootLevel;

        private static boolean storeDirectly(int n2) {
            return n2 < 24 || CacheValue.futureInstancesWillBeStrong();
        }

        private static final Object putIfCleared(Object[] objectArray, int n2, Object object, int n3) {
            Object object2 = objectArray[n2];
            if (!(object2 instanceof SoftReference)) {
                return object2;
            }
            assert (n3 >= 24);
            if ((object2 = ((SoftReference)object2).get()) != null) {
                return object2;
            }
            objectArray[n2] = CacheValue.futureInstancesWillBeStrong() ? object : new SoftReference<Object>(object);
            return object;
        }

        ResourceCache(int n2) {
            assert (n2 != 0);
            this.maxOffsetBits = 28;
            while (n2 <= 0x7FFFFFF) {
                n2 <<= 1;
                --this.maxOffsetBits;
            }
            int n3 = this.maxOffsetBits + 2;
            if (n3 <= 7) {
                this.levelBitsList = n3;
            } else if (n3 < 10) {
                this.levelBitsList = 0x30 | n3 - 3;
            } else {
                this.levelBitsList = 7;
                n3 -= 7;
                int n4 = 4;
                while (true) {
                    if (n3 <= 6) {
                        this.levelBitsList |= n3 << n4;
                        break;
                    }
                    if (n3 < 9) {
                        this.levelBitsList |= (0x30 | n3 - 3) << n4;
                        break;
                    }
                    this.levelBitsList |= 6 << n4;
                    n3 -= 6;
                    n4 += 4;
                }
            }
        }

        private int makeKey(int n2) {
            int n3 = ICUResourceBundleReader.RES_GET_TYPE(n2);
            int n4 = n3 == 6 ? 1 : (n3 == 5 ? 3 : (n3 == 9 ? 2 : 0));
            return ICUResourceBundleReader.RES_GET_OFFSET(n2) | n4 << this.maxOffsetBits;
        }

        private int findSimple(int n2) {
            return Arrays.binarySearch(this.keys, 0, this.length, n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        synchronized Object get(int n2) {
            Object object;
            assert (ICUResourceBundleReader.RES_GET_OFFSET(n2) != 0);
            if (this.length >= 0) {
                int n3 = this.findSimple(n2);
                if (n3 < 0) return null;
                object = this.values[n3];
            } else {
                object = this.rootLevel.get(this.makeKey(n2));
                if (object == null) {
                    return null;
                }
            }
            if (!(object instanceof SoftReference)) return object;
            return ((SoftReference)object).get();
        }

        synchronized Object putIfAbsent(int n2, Object object, int n3) {
            if (this.length >= 0) {
                int n4 = this.findSimple(n2);
                if (n4 >= 0) {
                    return ResourceCache.putIfCleared(this.values, n4, object, n3);
                }
                if (this.length < 32) {
                    if ((n4 ^= 0xFFFFFFFF) < this.length) {
                        System.arraycopy(this.keys, n4, this.keys, n4 + 1, this.length - n4);
                        System.arraycopy(this.values, n4, this.values, n4 + 1, this.length - n4);
                    }
                    ++this.length;
                    this.keys[n4] = n2;
                    this.values[n4] = ResourceCache.storeDirectly(n3) ? object : new SoftReference<Object>(object);
                    return object;
                }
                this.rootLevel = new Level(this.levelBitsList, 0);
                for (int i2 = 0; i2 < 32; ++i2) {
                    this.rootLevel.putIfAbsent(this.makeKey(this.keys[i2]), this.values[i2], 0);
                }
                this.keys = null;
                this.values = null;
                this.length = -1;
            }
            return this.rootLevel.putIfAbsent(this.makeKey(n2), object, n3);
        }

        private static final class Level {
            int levelBitsList;
            int shift;
            int mask;
            int[] keys;
            Object[] values;

            Level(int n2, int n3) {
                this.levelBitsList = n2;
                this.shift = n3;
                int n4 = n2 & 0xF;
                assert (n4 != 0);
                int n5 = 1 << n4;
                this.mask = n5 - 1;
                this.keys = new int[n5];
                this.values = new Object[n5];
            }

            Object get(int n2) {
                Level level;
                int n3 = n2 >> this.shift & this.mask;
                int n4 = this.keys[n3];
                if (n4 == n2) {
                    return this.values[n3];
                }
                if (n4 == 0 && (level = (Level)this.values[n3]) != null) {
                    return level.get(n2);
                }
                return null;
            }

            Object putIfAbsent(int n2, Object object, int n3) {
                int n4 = n2 >> this.shift & this.mask;
                int n5 = this.keys[n4];
                if (n5 == n2) {
                    return ResourceCache.putIfCleared(this.values, n4, object, n3);
                }
                if (n5 == 0) {
                    Level level = (Level)this.values[n4];
                    if (level != null) {
                        return level.putIfAbsent(n2, object, n3);
                    }
                    this.keys[n4] = n2;
                    this.values[n4] = ResourceCache.storeDirectly(n3) ? object : new SoftReference<Object>(object);
                    return object;
                }
                Level level = new Level(this.levelBitsList >> 4, this.shift + (this.levelBitsList & 0xF));
                int n6 = n5 >> level.shift & level.mask;
                level.keys[n6] = n5;
                level.values[n6] = this.values[n4];
                this.keys[n4] = 0;
                this.values[n4] = level;
                return level.putIfAbsent(n2, object, n3);
            }
        }
    }

    private static final class Table32
    extends Table {
        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            return this.getContainer32Resource(iCUResourceBundleReader, n2);
        }

        Table32(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            n2 = iCUResourceBundleReader.getResourceByteOffset(n2);
            this.key32Offsets = iCUResourceBundleReader.getTable32KeyOffsets(n2);
            this.size = this.key32Offsets.length;
            this.itemsOffset = n2 + 4 * (1 + this.size);
        }
    }

    private static final class Table16
    extends Table {
        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            return this.getContainer16Resource(iCUResourceBundleReader, n2);
        }

        Table16(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            this.keyOffsets = iCUResourceBundleReader.getTable16KeyOffsets(n2);
            this.size = this.keyOffsets.length;
            this.itemsOffset = n2 + 1 + this.size;
        }
    }

    private static final class Table1632
    extends Table {
        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            return this.getContainer32Resource(iCUResourceBundleReader, n2);
        }

        Table1632(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            n2 = iCUResourceBundleReader.getResourceByteOffset(n2);
            this.keyOffsets = iCUResourceBundleReader.getTableKeyOffsets(n2);
            this.size = this.keyOffsets.length;
            this.itemsOffset = n2 + 2 * (this.size + 2 & 0xFFFFFFFE);
        }
    }

    static class Table
    extends Container
    implements UResource.Table {
        protected char[] keyOffsets;
        protected int[] key32Offsets;
        private static final int URESDATA_ITEM_NOT_FOUND = -1;

        Table() {
        }

        String getKey(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            if (n2 < 0 || this.size <= n2) {
                return null;
            }
            return this.keyOffsets != null ? iCUResourceBundleReader.getKey16String(this.keyOffsets[n2]) : iCUResourceBundleReader.getKey32String(this.key32Offsets[n2]);
        }

        int findTableItem(ICUResourceBundleReader iCUResourceBundleReader, CharSequence charSequence) {
            int n2 = 0;
            int n3 = this.size;
            while (n2 < n3) {
                int n4 = n2 + n3 >>> 1;
                int n5 = this.keyOffsets != null ? iCUResourceBundleReader.compareKeys(charSequence, this.keyOffsets[n4]) : iCUResourceBundleReader.compareKeys32(charSequence, this.key32Offsets[n4]);
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                if (n5 > 0) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return -1;
        }

        @Override
        int getResource(ICUResourceBundleReader iCUResourceBundleReader, String string) {
            return this.getContainerResource(iCUResourceBundleReader, this.findTableItem(iCUResourceBundleReader, string));
        }

        @Override
        public boolean getKeyAndValue(int n2, UResource.Key key, UResource.Value value) {
            if (0 <= n2 && n2 < this.size) {
                ReaderValue readerValue = (ReaderValue)value;
                if (this.keyOffsets != null) {
                    readerValue.reader.setKeyFromKey16(this.keyOffsets[n2], key);
                } else {
                    readerValue.reader.setKeyFromKey32(this.key32Offsets[n2], key);
                }
                readerValue.res = this.getContainerResource(readerValue.reader, n2);
                return true;
            }
            return false;
        }

        @Override
        public boolean findValue(CharSequence charSequence, UResource.Value value) {
            ReaderValue readerValue = (ReaderValue)value;
            int n2 = this.findTableItem(readerValue.reader, charSequence);
            if (n2 >= 0) {
                readerValue.res = this.getContainerResource(readerValue.reader, n2);
                return true;
            }
            return false;
        }
    }

    private static final class Array16
    extends Array {
        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            return this.getContainer16Resource(iCUResourceBundleReader, n2);
        }

        Array16(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            this.size = iCUResourceBundleReader.b16BitUnits.charAt(n2);
            this.itemsOffset = n2 + 1;
        }
    }

    private static final class Array32
    extends Array {
        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            return this.getContainer32Resource(iCUResourceBundleReader, n2);
        }

        Array32(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            n2 = iCUResourceBundleReader.getResourceByteOffset(n2);
            this.size = iCUResourceBundleReader.getInt(n2);
            this.itemsOffset = n2 + 4;
        }
    }

    static class Array
    extends Container
    implements UResource.Array {
        Array() {
        }

        @Override
        public boolean getValue(int n2, UResource.Value value) {
            if (0 <= n2 && n2 < this.size) {
                ReaderValue readerValue = (ReaderValue)value;
                readerValue.res = this.getContainerResource(readerValue.reader, n2);
                return true;
            }
            return false;
        }
    }

    static class Container {
        protected int size;
        protected int itemsOffset;

        public final int getSize() {
            return this.size;
        }

        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            return -1;
        }

        protected int getContainer16Resource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            if (n2 < 0 || this.size <= n2) {
                return -1;
            }
            int n3 = iCUResourceBundleReader.b16BitUnits.charAt(this.itemsOffset + n2);
            if (n3 >= iCUResourceBundleReader.poolStringIndex16Limit) {
                n3 = n3 - iCUResourceBundleReader.poolStringIndex16Limit + iCUResourceBundleReader.poolStringIndexLimit;
            }
            return 0x60000000 | n3;
        }

        protected int getContainer32Resource(ICUResourceBundleReader iCUResourceBundleReader, int n2) {
            if (n2 < 0 || this.size <= n2) {
                return -1;
            }
            return iCUResourceBundleReader.getInt(this.itemsOffset + 4 * n2);
        }

        int getResource(ICUResourceBundleReader iCUResourceBundleReader, String string) {
            return this.getContainerResource(iCUResourceBundleReader, Integer.parseInt(string));
        }

        Container() {
        }
    }

    static class ReaderValue
    extends UResource.Value {
        ICUResourceBundleReader reader;
        int res;

        ReaderValue() {
        }

        @Override
        public int getType() {
            return PUBLIC_TYPES[ICUResourceBundleReader.RES_GET_TYPE(this.res)];
        }

        @Override
        public String getString() {
            String string = this.reader.getString(this.res);
            if (string == null) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return string;
        }

        @Override
        public String getAliasString() {
            String string = this.reader.getAlias(this.res);
            if (string == null) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return string;
        }

        @Override
        public int getInt() {
            if (ICUResourceBundleReader.RES_GET_TYPE(this.res) != 7) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return ICUResourceBundleReader.RES_GET_INT(this.res);
        }

        @Override
        public int getUInt() {
            if (ICUResourceBundleReader.RES_GET_TYPE(this.res) != 7) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return ICUResourceBundleReader.RES_GET_UINT(this.res);
        }

        @Override
        public int[] getIntVector() {
            int[] nArray = this.reader.getIntVector(this.res);
            if (nArray == null) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return nArray;
        }

        @Override
        public ByteBuffer getBinary() {
            ByteBuffer byteBuffer = this.reader.getBinary(this.res);
            if (byteBuffer == null) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return byteBuffer;
        }

        @Override
        public UResource.Array getArray() {
            Array array = this.reader.getArray(this.res);
            if (array == null) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return array;
        }

        @Override
        public UResource.Table getTable() {
            Table table = this.reader.getTable(this.res);
            if (table == null) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return table;
        }

        @Override
        public boolean isNoInheritanceMarker() {
            return this.reader.isNoInheritanceMarker(this.res);
        }

        @Override
        public String[] getStringArray() {
            Array array = this.reader.getArray(this.res);
            if (array == null) {
                throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
            }
            return this.getStringArray(array);
        }

        @Override
        public String[] getStringArrayOrStringAsArray() {
            Array array = this.reader.getArray(this.res);
            if (array != null) {
                return this.getStringArray(array);
            }
            String string = this.reader.getString(this.res);
            if (string != null) {
                return new String[]{string};
            }
            throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
        }

        @Override
        public String getStringOrFirstOfArray() {
            int n2;
            String string = this.reader.getString(this.res);
            if (string != null) {
                return string;
            }
            Array array = this.reader.getArray(this.res);
            if (array != null && array.size > 0 && (string = this.reader.getString(n2 = array.getContainerResource(this.reader, 0))) != null) {
                return string;
            }
            throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
        }

        private String[] getStringArray(Array array) {
            String[] stringArray = new String[array.size];
            for (int i2 = 0; i2 < array.size; ++i2) {
                int n2 = array.getContainerResource(this.reader, i2);
                String string = this.reader.getString(n2);
                if (string == null) {
                    throw new UResourceTypeMismatchException(ICUResourceBundleReader.emptyString);
                }
                stringArray[i2] = string;
            }
            return stringArray;
        }
    }

    private static class ReaderCache
    extends SoftCache<ReaderCacheKey, ICUResourceBundleReader, ClassLoader> {
        private ReaderCache() {
        }

        @Override
        protected ICUResourceBundleReader createInstance(ReaderCacheKey readerCacheKey, ClassLoader classLoader) {
            String string = ICUResourceBundleReader.getFullName(readerCacheKey.baseName, readerCacheKey.localeID);
            try {
                ByteBuffer byteBuffer;
                if (readerCacheKey.baseName != null && readerCacheKey.baseName.startsWith("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b")) {
                    String string2 = string.substring("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b".length() + 1);
                    byteBuffer = ICUBinary.getData(classLoader, string, string2);
                    if (byteBuffer == null) {
                        return NULL_READER;
                    }
                } else {
                    InputStream inputStream = ICUData.getStream(classLoader, string);
                    if (inputStream == null) {
                        return NULL_READER;
                    }
                    byteBuffer = ICUBinary.getByteBufferFromInputStreamAndCloseStream(inputStream);
                }
                return new ICUResourceBundleReader(byteBuffer, readerCacheKey.baseName, readerCacheKey.localeID, classLoader);
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException("Data file " + string + " is corrupt - " + iOException.getMessage(), iOException);
            }
        }
    }

    private static class ReaderCacheKey {
        final String baseName;
        final String localeID;

        ReaderCacheKey(String string, String string2) {
            this.baseName = string == null ? ICUResourceBundleReader.emptyString : string;
            this.localeID = string2 == null ? ICUResourceBundleReader.emptyString : string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ReaderCacheKey)) {
                return false;
            }
            ReaderCacheKey readerCacheKey = (ReaderCacheKey)object;
            return this.baseName.equals(readerCacheKey.baseName) && this.localeID.equals(readerCacheKey.localeID);
        }

        public int hashCode() {
            return this.baseName.hashCode() ^ this.localeID.hashCode();
        }
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 1 && (byArray[1] & 0xFF) >= 1 || 2 <= byArray[0] && byArray[0] <= 3;
        }
    }
}

