/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CacheValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundleReader;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceTypeMismatchException;

class ICUResourceBundleImpl
extends ICUResourceBundle {
    protected int resource;

    protected ICUResourceBundleImpl(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
        super(iCUResourceBundleImpl, string);
        this.resource = n2;
    }

    ICUResourceBundleImpl(ICUResourceBundle.WholeBundle wholeBundle) {
        super(wholeBundle);
        this.resource = wholeBundle.reader.getRootResource();
    }

    public int getResource() {
        return this.resource;
    }

    protected final ICUResourceBundle createBundleObject(String string, int n2, HashMap<String, String> hashMap, UResourceBundle uResourceBundle) {
        switch (ICUResourceBundleReader.RES_GET_TYPE(n2)) {
            case 0: 
            case 6: {
                return new ResourceString(this, string, n2);
            }
            case 1: {
                return new ResourceBinary(this, string, n2);
            }
            case 3: {
                return ICUResourceBundleImpl.getAliasedResource(this, null, 0, string, n2, hashMap, uResourceBundle);
            }
            case 7: {
                return new ResourceInt(this, string, n2);
            }
            case 14: {
                return new ResourceIntVector(this, string, n2);
            }
            case 8: 
            case 9: {
                return new ResourceArray(this, string, n2);
            }
            case 2: 
            case 4: 
            case 5: {
                return new ResourceTable(this, string, n2);
            }
        }
        throw new IllegalStateException("The resource type is unknown");
    }

    static class ResourceTable
    extends ResourceContainer {
        @Override
        public int getType() {
            return 2;
        }

        protected String getKey(int n2) {
            return ((ICUResourceBundleReader.Table)this.value).getKey(this.wholeBundle.reader, n2);
        }

        @Override
        protected Set<String> handleKeySet() {
            ICUResourceBundleReader iCUResourceBundleReader = this.wholeBundle.reader;
            TreeSet<String> treeSet = new TreeSet<String>();
            ICUResourceBundleReader.Table table = (ICUResourceBundleReader.Table)this.value;
            for (int i2 = 0; i2 < table.getSize(); ++i2) {
                treeSet.add(table.getKey(iCUResourceBundleReader, i2));
            }
            return treeSet;
        }

        @Override
        protected UResourceBundle handleGet(String string, HashMap<String, String> hashMap, UResourceBundle uResourceBundle) {
            int n2 = ((ICUResourceBundleReader.Table)this.value).findTableItem(this.wholeBundle.reader, string);
            if (n2 < 0) {
                return null;
            }
            return this.createBundleObject(string, this.getContainerResource(n2), hashMap, uResourceBundle);
        }

        @Override
        protected UResourceBundle handleGet(int n2, HashMap<String, String> hashMap, UResourceBundle uResourceBundle) {
            String string = ((ICUResourceBundleReader.Table)this.value).getKey(this.wholeBundle.reader, n2);
            if (string == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.createBundleObject(string, this.getContainerResource(n2), hashMap, uResourceBundle);
        }

        @Override
        protected Object handleGetObject(String string) {
            ICUResourceBundleReader iCUResourceBundleReader = this.wholeBundle.reader;
            int n2 = ((ICUResourceBundleReader.Table)this.value).findTableItem(iCUResourceBundleReader, string);
            if (n2 >= 0) {
                int n3 = this.value.getContainerResource(iCUResourceBundleReader, n2);
                String string2 = iCUResourceBundleReader.getString(n3);
                if (string2 != null) {
                    return string2;
                }
                ICUResourceBundleReader.Array array = iCUResourceBundleReader.getArray(n3);
                if (array != null) {
                    int n4 = array.getSize();
                    String[] stringArray = new String[n4];
                    int n5 = 0;
                    while (true) {
                        if (n5 == n4) {
                            return stringArray;
                        }
                        string2 = iCUResourceBundleReader.getString(array.getContainerResource(iCUResourceBundleReader, n5));
                        if (string2 == null) break;
                        stringArray[n5] = string2;
                        ++n5;
                    }
                }
            }
            return super.handleGetObject(string);
        }

        String findString(String string) {
            ICUResourceBundleReader iCUResourceBundleReader = this.wholeBundle.reader;
            int n2 = ((ICUResourceBundleReader.Table)this.value).findTableItem(iCUResourceBundleReader, string);
            if (n2 < 0) {
                return null;
            }
            return iCUResourceBundleReader.getString(this.value.getContainerResource(iCUResourceBundleReader, n2));
        }

        ResourceTable(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
            super(iCUResourceBundleImpl, string, n2);
            this.value = this.wholeBundle.reader.getTable(n2);
        }

        ResourceTable(ICUResourceBundle.WholeBundle wholeBundle, int n2) {
            super(wholeBundle);
            this.value = wholeBundle.reader.getTable(n2);
        }
    }

    static class ResourceArray
    extends ResourceContainer {
        @Override
        public int getType() {
            return 8;
        }

        @Override
        protected String[] handleGetStringArray() {
            ICUResourceBundleReader iCUResourceBundleReader = this.wholeBundle.reader;
            int n2 = this.value.getSize();
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = iCUResourceBundleReader.getString(this.value.getContainerResource(iCUResourceBundleReader, i2));
                if (string == null) {
                    throw new UResourceTypeMismatchException("");
                }
                stringArray[i2] = string;
            }
            return stringArray;
        }

        @Override
        public String[] getStringArray() {
            return this.handleGetStringArray();
        }

        @Override
        protected UResourceBundle handleGet(String string, HashMap<String, String> hashMap, UResourceBundle uResourceBundle) {
            int n2 = Integer.parseInt(string);
            return this.createBundleObject(n2, string, hashMap, uResourceBundle);
        }

        @Override
        protected UResourceBundle handleGet(int n2, HashMap<String, String> hashMap, UResourceBundle uResourceBundle) {
            return this.createBundleObject(n2, Integer.toString(n2), hashMap, uResourceBundle);
        }

        ResourceArray(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
            super(iCUResourceBundleImpl, string, n2);
            this.value = this.wholeBundle.reader.getArray(n2);
        }
    }

    static abstract class ResourceContainer
    extends ICUResourceBundleImpl {
        protected ICUResourceBundleReader.Container value;

        @Override
        public int getSize() {
            return this.value.getSize();
        }

        @Override
        public String getString(int n2) {
            int n3 = this.value.getContainerResource(this.wholeBundle.reader, n2);
            if (n3 == -1) {
                throw new IndexOutOfBoundsException();
            }
            String string = this.wholeBundle.reader.getString(n3);
            if (string != null) {
                return string;
            }
            return super.getString(n2);
        }

        protected int getContainerResource(int n2) {
            return this.value.getContainerResource(this.wholeBundle.reader, n2);
        }

        protected UResourceBundle createBundleObject(int n2, String string, HashMap<String, String> hashMap, UResourceBundle uResourceBundle) {
            int n3 = this.getContainerResource(n2);
            if (n3 == -1) {
                throw new IndexOutOfBoundsException();
            }
            return this.createBundleObject(string, n3, hashMap, uResourceBundle);
        }

        ResourceContainer(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
            super(iCUResourceBundleImpl, string, n2);
        }

        ResourceContainer(ICUResourceBundle.WholeBundle wholeBundle) {
            super(wholeBundle);
        }
    }

    private static final class ResourceIntVector
    extends ICUResourceBundleImpl {
        @Override
        public int getType() {
            return 14;
        }

        @Override
        public int[] getIntVector() {
            return this.wholeBundle.reader.getIntVector(this.resource);
        }

        ResourceIntVector(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
            super(iCUResourceBundleImpl, string, n2);
        }
    }

    private static final class ResourceString
    extends ICUResourceBundleImpl {
        private String value;

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public String getString() {
            if (this.value != null) {
                return this.value;
            }
            return this.wholeBundle.reader.getString(this.resource);
        }

        ResourceString(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
            super(iCUResourceBundleImpl, string, n2);
            String string2 = this.wholeBundle.reader.getString(n2);
            if (string2.length() < 12 || CacheValue.futureInstancesWillBeStrong()) {
                this.value = string2;
            }
        }
    }

    private static final class ResourceInt
    extends ICUResourceBundleImpl {
        @Override
        public int getType() {
            return 7;
        }

        @Override
        public int getInt() {
            return ICUResourceBundleReader.RES_GET_INT(this.resource);
        }

        @Override
        public int getUInt() {
            return ICUResourceBundleReader.RES_GET_UINT(this.resource);
        }

        ResourceInt(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
            super(iCUResourceBundleImpl, string, n2);
        }
    }

    private static final class ResourceBinary
    extends ICUResourceBundleImpl {
        @Override
        public int getType() {
            return 1;
        }

        @Override
        public ByteBuffer getBinary() {
            return this.wholeBundle.reader.getBinary(this.resource);
        }

        @Override
        public byte[] getBinary(byte[] byArray) {
            return this.wholeBundle.reader.getBinary(this.resource, byArray);
        }

        ResourceBinary(ICUResourceBundleImpl iCUResourceBundleImpl, String string, int n2) {
            super(iCUResourceBundleImpl, string, n2);
        }
    }
}

