/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ICURWLock {
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private Stats stats = null;

    public synchronized Stats resetStats() {
        Stats stats = this.stats;
        this.stats = new Stats();
        return stats;
    }

    public synchronized Stats clearStats() {
        Stats stats = this.stats;
        this.stats = null;
        return stats;
    }

    public synchronized Stats getStats() {
        return this.stats == null ? null : new Stats(this.stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRead() {
        if (this.stats != null) {
            ICURWLock iCURWLock = this;
            synchronized (iCURWLock) {
                ++this.stats._rc;
                if (this.rwl.getReadLockCount() > 0) {
                    ++this.stats._mrc;
                }
                if (this.rwl.isWriteLocked()) {
                    ++this.stats._wrc;
                }
            }
        }
        this.rwl.readLock().lock();
    }

    public void releaseRead() {
        this.rwl.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWrite() {
        if (this.stats != null) {
            ICURWLock iCURWLock = this;
            synchronized (iCURWLock) {
                ++this.stats._wc;
                if (this.rwl.getReadLockCount() > 0 || this.rwl.isWriteLocked()) {
                    ++this.stats._wwc;
                }
            }
        }
        this.rwl.writeLock().lock();
    }

    public void releaseWrite() {
        this.rwl.writeLock().unlock();
    }

    public static final class Stats {
        public int _rc;
        public int _mrc;
        public int _wrc;
        public int _wc;
        public int _wwc;

        private Stats() {
        }

        private Stats(int n2, int n3, int n4, int n5, int n6) {
            this._rc = n2;
            this._mrc = n3;
            this._wrc = n4;
            this._wc = n5;
            this._wwc = n6;
        }

        private Stats(Stats stats) {
            this(stats._rc, stats._mrc, stats._wrc, stats._wc, stats._wwc);
        }

        public String toString() {
            return " rc: " + this._rc + " mrc: " + this._mrc + " wrc: " + this._wrc + " wc: " + this._wc + " wwc: " + this._wwc;
        }
    }
}

