/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CurrencyData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class ICUCurrencyDisplayInfoProvider
implements CurrencyData.CurrencyDisplayInfoProvider {
    private volatile ICUCurrencyDisplayInfo currencyDisplayInfoCache = null;

    @Override
    public CurrencyData.CurrencyDisplayInfo getInstance(ULocale uLocale, boolean bl2) {
        ICUCurrencyDisplayInfo iCUCurrencyDisplayInfo;
        if (uLocale == null) {
            uLocale = ULocale.ROOT;
        }
        if ((iCUCurrencyDisplayInfo = this.currencyDisplayInfoCache) == null || !iCUCurrencyDisplayInfo.locale.equals(uLocale) || iCUCurrencyDisplayInfo.fallback != bl2) {
            ICUResourceBundle iCUResourceBundle;
            if (bl2) {
                iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/curr", uLocale, ICUResourceBundle.OpenType.LOCALE_DEFAULT_ROOT);
            } else {
                try {
                    iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/curr", uLocale, ICUResourceBundle.OpenType.LOCALE_ONLY);
                }
                catch (MissingResourceException missingResourceException) {
                    return null;
                }
            }
            this.currencyDisplayInfoCache = iCUCurrencyDisplayInfo = new ICUCurrencyDisplayInfo(uLocale, iCUResourceBundle, bl2);
        }
        return iCUCurrencyDisplayInfo;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    static class ICUCurrencyDisplayInfo
    extends CurrencyData.CurrencyDisplayInfo {
        final ULocale locale;
        final boolean fallback;
        private final ICUResourceBundle rb;
        private volatile FormattingData formattingDataCache = null;
        private volatile VariantSymbol variantSymbolCache = null;
        private volatile String[] pluralsDataCache = null;
        private volatile SoftReference<ParsingData> parsingDataCache = new SoftReference<Object>(null);
        private volatile Map<String, String> unitPatternsCache = null;
        private volatile CurrencyData.CurrencySpacingInfo spacingInfoCache = null;

        public ICUCurrencyDisplayInfo(ULocale uLocale, ICUResourceBundle iCUResourceBundle, boolean bl2) {
            this.locale = uLocale;
            this.fallback = bl2;
            this.rb = iCUResourceBundle;
        }

        @Override
        public ULocale getULocale() {
            return this.rb.getULocale();
        }

        @Override
        public String getName(String string) {
            FormattingData formattingData = this.fetchFormattingData(string);
            if (formattingData.displayName == null && this.fallback) {
                return string;
            }
            return formattingData.displayName;
        }

        @Override
        public String getSymbol(String string) {
            FormattingData formattingData = this.fetchFormattingData(string);
            if (formattingData.symbol == null && this.fallback) {
                return string;
            }
            return formattingData.symbol;
        }

        @Override
        public String getNarrowSymbol(String string) {
            VariantSymbol variantSymbol = this.fetchVariantSymbol(string, "narrow");
            if (variantSymbol.symbol == null && this.fallback) {
                return this.getSymbol(string);
            }
            return variantSymbol.symbol;
        }

        @Override
        public String getFormalSymbol(String string) {
            VariantSymbol variantSymbol = this.fetchVariantSymbol(string, "formal");
            if (variantSymbol.symbol == null && this.fallback) {
                return this.getSymbol(string);
            }
            return variantSymbol.symbol;
        }

        @Override
        public String getVariantSymbol(String string) {
            VariantSymbol variantSymbol = this.fetchVariantSymbol(string, "variant");
            if (variantSymbol.symbol == null && this.fallback) {
                return this.getSymbol(string);
            }
            return variantSymbol.symbol;
        }

        @Override
        public String getPluralName(String string, String string2) {
            StandardPlural standardPlural = StandardPlural.orNullFromString(string2);
            String[] stringArray = this.fetchPluralsData(string);
            Set<String> set = this.fetchUnitPatterns().keySet();
            String string3 = null;
            if (standardPlural != null) {
                string3 = stringArray[1 + standardPlural.ordinal()];
            }
            if (string3 == null && (this.fallback || set.contains(string2))) {
                string3 = stringArray[1 + StandardPlural.OTHER.ordinal()];
            }
            if (string3 == null && (this.fallback || set.contains(string2))) {
                FormattingData formattingData = this.fetchFormattingData(string);
                string3 = formattingData.displayName;
            }
            if (string3 == null && this.fallback) {
                string3 = string;
            }
            return string3;
        }

        @Override
        public Map<String, String> symbolMap() {
            ParsingData parsingData = this.fetchParsingData();
            return parsingData.symbolToIsoCode;
        }

        @Override
        public Map<String, String> nameMap() {
            ParsingData parsingData = this.fetchParsingData();
            return parsingData.nameToIsoCode;
        }

        @Override
        public Map<String, String> getUnitPatterns() {
            Map<String, String> map = this.fetchUnitPatterns();
            return map;
        }

        @Override
        public CurrencyData.CurrencyFormatInfo getFormatInfo(String string) {
            FormattingData formattingData = this.fetchFormattingData(string);
            return formattingData.formatInfo;
        }

        @Override
        public CurrencyData.CurrencySpacingInfo getSpacingInfo() {
            CurrencyData.CurrencySpacingInfo currencySpacingInfo = this.fetchSpacingInfo();
            if (!(currencySpacingInfo.hasBeforeCurrency && currencySpacingInfo.hasAfterCurrency || !this.fallback)) {
                return CurrencyData.CurrencySpacingInfo.DEFAULT;
            }
            return currencySpacingInfo;
        }

        FormattingData fetchFormattingData(String string) {
            FormattingData formattingData = this.formattingDataCache;
            if (formattingData == null || !formattingData.isoCode.equals(string)) {
                formattingData = new FormattingData(string);
                CurrencySink currencySink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCIES);
                currencySink.formattingData = formattingData;
                this.rb.getAllItemsWithFallbackNoFail("Currencies/" + string, currencySink);
                this.formattingDataCache = formattingData;
            }
            return formattingData;
        }

        VariantSymbol fetchVariantSymbol(String string, String string2) {
            VariantSymbol variantSymbol = this.variantSymbolCache;
            if (variantSymbol == null || !variantSymbol.isoCode.equals(string) || !variantSymbol.variant.equals(string2)) {
                variantSymbol = new VariantSymbol(string, string2);
                CurrencySink currencySink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_VARIANT);
                currencySink.variantSymbol = variantSymbol;
                this.rb.getAllItemsWithFallbackNoFail("Currencies%" + string2 + "/" + string, currencySink);
                this.variantSymbolCache = variantSymbol;
            }
            return variantSymbol;
        }

        String[] fetchPluralsData(String string) {
            String[] stringArray = this.pluralsDataCache;
            if (stringArray == null || !stringArray[0].equals(string)) {
                stringArray = new String[1 + StandardPlural.COUNT];
                stringArray[0] = string;
                CurrencySink currencySink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_PLURALS);
                currencySink.pluralsData = stringArray;
                this.rb.getAllItemsWithFallbackNoFail("CurrencyPlurals/" + string, currencySink);
                this.pluralsDataCache = stringArray;
            }
            return stringArray;
        }

        ParsingData fetchParsingData() {
            ParsingData parsingData = this.parsingDataCache.get();
            if (parsingData == null) {
                parsingData = new ParsingData();
                CurrencySink currencySink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.TOP);
                currencySink.parsingData = parsingData;
                this.rb.getAllItemsWithFallback("", currencySink);
                this.parsingDataCache = new SoftReference<ParsingData>(parsingData);
            }
            return parsingData;
        }

        Map<String, String> fetchUnitPatterns() {
            Map<String, String> map = this.unitPatternsCache;
            if (map == null) {
                map = new HashMap<String, String>();
                CurrencySink currencySink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_UNIT_PATTERNS);
                currencySink.unitPatterns = map;
                this.rb.getAllItemsWithFallback("CurrencyUnitPatterns", currencySink);
                this.unitPatternsCache = map;
            }
            return map;
        }

        CurrencyData.CurrencySpacingInfo fetchSpacingInfo() {
            CurrencyData.CurrencySpacingInfo currencySpacingInfo = this.spacingInfoCache;
            if (currencySpacingInfo == null) {
                currencySpacingInfo = new CurrencyData.CurrencySpacingInfo();
                CurrencySink currencySink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_SPACING);
                currencySink.spacingInfo = currencySpacingInfo;
                this.rb.getAllItemsWithFallback("currencySpacing", currencySink);
                this.spacingInfoCache = currencySpacingInfo;
            }
            return currencySpacingInfo;
        }

        private static final class CurrencySink
        extends UResource.Sink {
            final boolean noRoot;
            final EntrypointTable entrypointTable;
            FormattingData formattingData = null;
            String[] pluralsData = null;
            ParsingData parsingData = null;
            Map<String, String> unitPatterns = null;
            CurrencyData.CurrencySpacingInfo spacingInfo = null;
            VariantSymbol variantSymbol = null;

            CurrencySink(boolean bl2, EntrypointTable entrypointTable) {
                this.noRoot = bl2;
                this.entrypointTable = entrypointTable;
            }

            @Override
            public void put(UResource.Key key, UResource.Value value, boolean bl2) {
                if (this.noRoot && bl2) {
                    return;
                }
                switch (this.entrypointTable) {
                    case TOP: {
                        this.consumeTopTable(key, value);
                        break;
                    }
                    case CURRENCIES: {
                        this.consumeCurrenciesEntry(key, value);
                        break;
                    }
                    case CURRENCY_PLURALS: {
                        this.consumeCurrencyPluralsEntry(key, value);
                        break;
                    }
                    case CURRENCY_VARIANT: {
                        this.consumeCurrenciesVariantEntry(key, value);
                        break;
                    }
                    case CURRENCY_SPACING: {
                        this.consumeCurrencySpacingTable(key, value);
                        break;
                    }
                    case CURRENCY_UNIT_PATTERNS: {
                        this.consumeCurrencyUnitPatternsTable(key, value);
                    }
                }
            }

            private void consumeTopTable(UResource.Key key, UResource.Value value) {
                UResource.Table table = value.getTable();
                int n2 = 0;
                while (table.getKeyAndValue(n2, key, value)) {
                    if (key.contentEquals("Currencies")) {
                        this.consumeCurrenciesTable(key, value);
                    } else if (key.contentEquals("Currencies%variant")) {
                        this.consumeCurrenciesVariantTable(key, value);
                    } else if (key.contentEquals("CurrencyPlurals")) {
                        this.consumeCurrencyPluralsTable(key, value);
                    }
                    ++n2;
                }
            }

            void consumeCurrenciesTable(UResource.Key key, UResource.Value value) {
                assert (this.parsingData != null);
                UResource.Table table = value.getTable();
                int n2 = 0;
                while (table.getKeyAndValue(n2, key, value)) {
                    String string = key.toString();
                    if (value.getType() != 8) {
                        throw new ICUException("Unexpected data type in Currencies table for " + string);
                    }
                    UResource.Array array = value.getArray();
                    this.parsingData.symbolToIsoCode.put(string, string);
                    array.getValue(0, value);
                    this.parsingData.symbolToIsoCode.put(value.getString(), string);
                    array.getValue(1, value);
                    this.parsingData.nameToIsoCode.put(value.getString(), string);
                    ++n2;
                }
            }

            void consumeCurrenciesEntry(UResource.Key key, UResource.Value value) {
                assert (this.formattingData != null);
                String string = key.toString();
                if (value.getType() != 8) {
                    throw new ICUException("Unexpected data type in Currencies table for " + string);
                }
                UResource.Array array = value.getArray();
                if (this.formattingData.symbol == null) {
                    array.getValue(0, value);
                    this.formattingData.symbol = value.getString();
                }
                if (this.formattingData.displayName == null) {
                    array.getValue(1, value);
                    this.formattingData.displayName = value.getString();
                }
                if (array.getSize() > 2 && this.formattingData.formatInfo == null) {
                    array.getValue(2, value);
                    UResource.Array array2 = value.getArray();
                    array2.getValue(0, value);
                    String string2 = value.getString();
                    array2.getValue(1, value);
                    String string3 = value.getString();
                    array2.getValue(2, value);
                    String string4 = value.getString();
                    this.formattingData.formatInfo = new CurrencyData.CurrencyFormatInfo(string, string2, string3, string4);
                }
            }

            void consumeCurrenciesVariantEntry(UResource.Key key, UResource.Value value) {
                assert (this.variantSymbol != null);
                if (this.variantSymbol.symbol == null) {
                    this.variantSymbol.symbol = value.getString();
                }
            }

            void consumeCurrenciesVariantTable(UResource.Key key, UResource.Value value) {
                assert (this.parsingData != null);
                UResource.Table table = value.getTable();
                int n2 = 0;
                while (table.getKeyAndValue(n2, key, value)) {
                    String string = key.toString();
                    this.parsingData.symbolToIsoCode.put(value.getString(), string);
                    ++n2;
                }
            }

            void consumeCurrencyPluralsTable(UResource.Key key, UResource.Value value) {
                assert (this.parsingData != null);
                UResource.Table table = value.getTable();
                int n2 = 0;
                while (table.getKeyAndValue(n2, key, value)) {
                    String string = key.toString();
                    UResource.Table table2 = value.getTable();
                    int n3 = 0;
                    while (table2.getKeyAndValue(n3, key, value)) {
                        StandardPlural standardPlural = StandardPlural.orNullFromString(key.toString());
                        if (standardPlural == null) {
                            throw new ICUException("Could not make StandardPlural from keyword " + key);
                        }
                        this.parsingData.nameToIsoCode.put(value.getString(), string);
                        ++n3;
                    }
                    ++n2;
                }
            }

            void consumeCurrencyPluralsEntry(UResource.Key key, UResource.Value value) {
                assert (this.pluralsData != null);
                UResource.Table table = value.getTable();
                int n2 = 0;
                while (table.getKeyAndValue(n2, key, value)) {
                    StandardPlural standardPlural = StandardPlural.orNullFromString(key.toString());
                    if (standardPlural == null) {
                        throw new ICUException("Could not make StandardPlural from keyword " + key);
                    }
                    if (this.pluralsData[1 + standardPlural.ordinal()] == null) {
                        this.pluralsData[1 + standardPlural.ordinal()] = value.getString();
                    }
                    ++n2;
                }
            }

            void consumeCurrencySpacingTable(UResource.Key key, UResource.Value value) {
                assert (this.spacingInfo != null);
                UResource.Table table = value.getTable();
                int n2 = 0;
                while (table.getKeyAndValue(n2, key, value)) {
                    block8: {
                        CurrencyData.CurrencySpacingInfo.SpacingType spacingType;
                        block7: {
                            block6: {
                                if (!key.contentEquals("beforeCurrency")) break block6;
                                spacingType = CurrencyData.CurrencySpacingInfo.SpacingType.BEFORE;
                                this.spacingInfo.hasBeforeCurrency = true;
                                break block7;
                            }
                            if (!key.contentEquals("afterCurrency")) break block8;
                            spacingType = CurrencyData.CurrencySpacingInfo.SpacingType.AFTER;
                            this.spacingInfo.hasAfterCurrency = true;
                        }
                        UResource.Table table2 = value.getTable();
                        int n3 = 0;
                        while (table2.getKeyAndValue(n3, key, value)) {
                            block12: {
                                CurrencyData.CurrencySpacingInfo.SpacingPattern spacingPattern;
                                block10: {
                                    block11: {
                                        block9: {
                                            if (!key.contentEquals("currencyMatch")) break block9;
                                            spacingPattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.CURRENCY_MATCH;
                                            break block10;
                                        }
                                        if (!key.contentEquals("surroundingMatch")) break block11;
                                        spacingPattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.SURROUNDING_MATCH;
                                        break block10;
                                    }
                                    if (!key.contentEquals("insertBetween")) break block12;
                                    spacingPattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.INSERT_BETWEEN;
                                }
                                this.spacingInfo.setSymbolIfNull(spacingType, spacingPattern, value.getString());
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }

            void consumeCurrencyUnitPatternsTable(UResource.Key key, UResource.Value value) {
                assert (this.unitPatterns != null);
                UResource.Table table = value.getTable();
                int n2 = 0;
                while (table.getKeyAndValue(n2, key, value)) {
                    String string = key.toString();
                    if (this.unitPatterns.get(string) == null) {
                        this.unitPatterns.put(string, value.getString());
                    }
                    ++n2;
                }
            }

            static enum EntrypointTable {
                TOP,
                CURRENCIES,
                CURRENCY_PLURALS,
                CURRENCY_VARIANT,
                CURRENCY_SPACING,
                CURRENCY_UNIT_PATTERNS;

            }
        }

        static class ParsingData {
            Map<String, String> symbolToIsoCode = new HashMap<String, String>();
            Map<String, String> nameToIsoCode = new HashMap<String, String>();

            ParsingData() {
            }
        }

        static class VariantSymbol {
            final String isoCode;
            final String variant;
            String symbol = null;

            VariantSymbol(String string, String string2) {
                this.isoCode = string;
                this.variant = string2;
            }
        }

        static class FormattingData {
            final String isoCode;
            String displayName = null;
            String symbol = null;
            CurrencyData.CurrencyFormatInfo formatInfo = null;

            FormattingData(String string) {
                this.isoCode = string;
            }
        }
    }
}

