/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ClassLoaderUtil;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUConfig;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUData;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public final class ICUBinary {
    private static final List<DataFile> icuDataFiles = new ArrayList<DataFile>();
    private static final byte MAGIC1 = -38;
    private static final byte MAGIC2 = 39;
    private static final byte CHAR_SET_ = 0;
    private static final byte CHAR_SIZE_ = 2;
    private static final String MAGIC_NUMBER_AUTHENTICATION_FAILED_ = "ICU data file error: Not an ICU data file";
    private static final String HEADER_AUTHENTICATION_FAILED_ = "ICU data file error: Header authentication failed, please check if you have a valid ICU data file";

    private static void addDataFilesFromPath(String string, List<DataFile> list) {
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(File.pathSeparatorChar, n2);
            int n4 = n3 >= 0 ? n3 : string.length();
            String string2 = string.substring(n2, n4).trim();
            if (string2.endsWith(File.separator)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() != 0) {
                ICUBinary.addDataFilesFromFolder(new File(string2), new StringBuilder(), icuDataFiles);
            }
            if (n3 < 0) break;
            n2 = n3 + 1;
        }
    }

    private static void addDataFilesFromFolder(File file, StringBuilder stringBuilder, List<DataFile> list) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        int n2 = stringBuilder.length();
        if (n2 > 0) {
            stringBuilder.append('/');
            ++n2;
        }
        for (File file2 : fileArray) {
            String string = file2.getName();
            if (string.endsWith(".txt")) continue;
            stringBuilder.append(string);
            if (file2.isDirectory()) {
                ICUBinary.addDataFilesFromFolder(file2, stringBuilder, list);
            } else if (string.endsWith(".dat")) {
                ByteBuffer byteBuffer = ICUBinary.mapFile(file2);
                if (byteBuffer != null && DatPackageReader.validate(byteBuffer)) {
                    list.add(new PackageDataFile(stringBuilder.toString(), byteBuffer));
                }
            } else {
                list.add(new SingleDataFile(stringBuilder.toString(), file2));
            }
            stringBuilder.setLength(n2);
        }
    }

    static int compareKeys(CharSequence charSequence, ByteBuffer byteBuffer, int n2) {
        int n3 = 0;
        while (true) {
            byte by2;
            if ((by2 = byteBuffer.get(n2)) == 0) {
                if (n3 == charSequence.length()) {
                    return 0;
                }
                return 1;
            }
            if (n3 == charSequence.length()) {
                return -1;
            }
            int n4 = charSequence.charAt(n3) - by2;
            if (n4 != 0) {
                return n4;
            }
            ++n3;
            ++n2;
        }
    }

    static int compareKeys(CharSequence charSequence, byte[] byArray, int n2) {
        int n3 = 0;
        while (true) {
            byte by2;
            if ((by2 = byArray[n2]) == 0) {
                if (n3 == charSequence.length()) {
                    return 0;
                }
                return 1;
            }
            if (n3 == charSequence.length()) {
                return -1;
            }
            int n4 = charSequence.charAt(n3) - by2;
            if (n4 != 0) {
                return n4;
            }
            ++n3;
            ++n2;
        }
    }

    public static ByteBuffer getData(String string) {
        return ICUBinary.getData(null, null, string, false);
    }

    public static ByteBuffer getData(ClassLoader classLoader, String string, String string2) {
        return ICUBinary.getData(classLoader, string, string2, false);
    }

    public static ByteBuffer getRequiredData(String string) {
        return ICUBinary.getData(null, null, string, true);
    }

    private static ByteBuffer getData(ClassLoader classLoader, String string, String string2, boolean bl2) {
        ByteBuffer byteBuffer = ICUBinary.getDataFromFile(string2);
        if (byteBuffer != null) {
            return byteBuffer;
        }
        if (classLoader == null) {
            classLoader = ClassLoaderUtil.getClassLoader(ICUData.class);
        }
        if (string == null) {
            string = "macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/" + string2;
        }
        ByteBuffer byteBuffer2 = null;
        try {
            InputStream inputStream = ICUData.getStream(classLoader, string, bl2);
            if (inputStream == null) {
                return null;
            }
            byteBuffer2 = ICUBinary.getByteBufferFromInputStreamAndCloseStream(inputStream);
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
        return byteBuffer2;
    }

    private static ByteBuffer getDataFromFile(String string) {
        for (DataFile dataFile : icuDataFiles) {
            ByteBuffer byteBuffer = dataFile.getData(string);
            if (byteBuffer == null) continue;
            return byteBuffer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer mapFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            MappedByteBuffer mappedByteBuffer = null;
            try {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            }
            finally {
                fileInputStream.close();
            }
            return mappedByteBuffer;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return null;
    }

    public static void addBaseNamesInFileFolder(String string, String string2, Set<String> set) {
        for (DataFile dataFile : icuDataFiles) {
            dataFile.addBaseNamesInFolder(string, string2, set);
        }
    }

    public static VersionInfo readHeaderAndDataVersion(ByteBuffer byteBuffer, int n2, Authenticate authenticate) throws IOException {
        return ICUBinary.getVersionInfoFromCompactInt(ICUBinary.readHeader(byteBuffer, n2, authenticate));
    }

    public static int readHeader(ByteBuffer byteBuffer, int n2, Authenticate authenticate) throws IOException {
        assert (byteBuffer != null && byteBuffer.position() == 0);
        byte by2 = byteBuffer.get(2);
        byte by3 = byteBuffer.get(3);
        if (by2 != -38 || by3 != 39) {
            throw new IOException(MAGIC_NUMBER_AUTHENTICATION_FAILED_);
        }
        byte by4 = byteBuffer.get(8);
        byte by5 = byteBuffer.get(9);
        byte by6 = byteBuffer.get(10);
        if (by4 < 0 || 1 < by4 || by5 != 0 || by6 != 2) {
            throw new IOException(HEADER_AUTHENTICATION_FAILED_);
        }
        byteBuffer.order(by4 != 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        char c2 = byteBuffer.getChar(0);
        char c3 = byteBuffer.getChar(4);
        if (c3 < '\u0014' || c2 < c3 + 4) {
            throw new IOException("Internal Error: Header size error");
        }
        byte[] byArray = new byte[]{byteBuffer.get(16), byteBuffer.get(17), byteBuffer.get(18), byteBuffer.get(19)};
        if (byteBuffer.get(12) != (byte)(n2 >> 24) || byteBuffer.get(13) != (byte)(n2 >> 16) || byteBuffer.get(14) != (byte)(n2 >> 8) || byteBuffer.get(15) != (byte)n2 || authenticate != null && !authenticate.isDataVersionAcceptable(byArray)) {
            throw new IOException(HEADER_AUTHENTICATION_FAILED_ + String.format("; data format %02x%02x%02x%02x, format version %d.%d.%d.%d", byteBuffer.get(12), byteBuffer.get(13), byteBuffer.get(14), byteBuffer.get(15), byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF, byArray[3] & 0xFF));
        }
        byteBuffer.position(c2);
        return byteBuffer.get(20) << 24 | (byteBuffer.get(21) & 0xFF) << 16 | (byteBuffer.get(22) & 0xFF) << 8 | byteBuffer.get(23) & 0xFF;
    }

    public static int writeHeader(int n2, int n3, int n4, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeChar(32);
        dataOutputStream.writeByte(-38);
        dataOutputStream.writeByte(39);
        dataOutputStream.writeChar(20);
        dataOutputStream.writeChar(0);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(2);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeLong(0L);
        assert (dataOutputStream.size() == 32);
        return 32;
    }

    public static void skipBytes(ByteBuffer byteBuffer, int n2) {
        if (n2 > 0) {
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }

    public static byte[] getBytes(ByteBuffer byteBuffer, int n2, int n3) {
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        if (n3 > 0) {
            ICUBinary.skipBytes(byteBuffer, n3);
        }
        return byArray;
    }

    public static String getString(ByteBuffer byteBuffer, int n2, int n3) {
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        String string = charBuffer.subSequence(0, n2).toString();
        ICUBinary.skipBytes(byteBuffer, n2 * 2 + n3);
        return string;
    }

    public static char[] getChars(ByteBuffer byteBuffer, int n2, int n3) {
        char[] cArray = new char[n2];
        byteBuffer.asCharBuffer().get(cArray);
        ICUBinary.skipBytes(byteBuffer, n2 * 2 + n3);
        return cArray;
    }

    public static short[] getShorts(ByteBuffer byteBuffer, int n2, int n3) {
        short[] sArray = new short[n2];
        byteBuffer.asShortBuffer().get(sArray);
        ICUBinary.skipBytes(byteBuffer, n2 * 2 + n3);
        return sArray;
    }

    public static int[] getInts(ByteBuffer byteBuffer, int n2, int n3) {
        int[] nArray = new int[n2];
        byteBuffer.asIntBuffer().get(nArray);
        ICUBinary.skipBytes(byteBuffer, n2 * 4 + n3);
        return nArray;
    }

    public static long[] getLongs(ByteBuffer byteBuffer, int n2, int n3) {
        long[] lArray = new long[n2];
        byteBuffer.asLongBuffer().get(lArray);
        ICUBinary.skipBytes(byteBuffer, n2 * 8 + n3);
        return lArray;
    }

    public static ByteBuffer sliceWithOrder(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        return byteBuffer2.order(byteBuffer.order());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getByteBufferFromInputStreamAndCloseStream(InputStream inputStream) throws IOException {
        try {
            int n2 = inputStream.available();
            byte[] byArray = n2 > 32 ? new byte[n2] : new byte[128];
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < byArray.length) {
                    n4 = inputStream.read(byArray, n3, byArray.length - n3);
                    if (n4 < 0) break;
                    n3 += n4;
                    continue;
                }
                n4 = inputStream.read();
                if (n4 < 0) break;
                int n5 = 2 * byArray.length;
                if (n5 < 128) {
                    n5 = 128;
                } else if (n5 < 16384) {
                    n5 *= 2;
                }
                byArray = Arrays.copyOf(byArray, n5);
                byArray[n3++] = (byte)n4;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n3);
            return byteBuffer;
        }
        finally {
            inputStream.close();
        }
    }

    public static VersionInfo getVersionInfoFromCompactInt(int n2) {
        return VersionInfo.getInstance(n2 >>> 24, n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public static byte[] getVersionByteArrayFromCompactInt(int n2) {
        return new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
    }

    static {
        String string = ICUConfig.get(ICUBinary.class.getName() + ".dataPath");
        if (string != null) {
            ICUBinary.addDataFilesFromPath(string, icuDataFiles);
        }
    }

    public static interface Authenticate {
        public boolean isDataVersionAcceptable(byte[] var1);
    }

    private static final class PackageDataFile
    extends DataFile {
        private final ByteBuffer pkgBytes;

        PackageDataFile(String string, ByteBuffer byteBuffer) {
            super(string);
            this.pkgBytes = byteBuffer;
        }

        @Override
        ByteBuffer getData(String string) {
            return DatPackageReader.getData(this.pkgBytes, string);
        }

        @Override
        void addBaseNamesInFolder(String string, String string2, Set<String> set) {
            DatPackageReader.addBaseNamesInFolder(this.pkgBytes, string, string2, set);
        }
    }

    private static final class SingleDataFile
    extends DataFile {
        private final File path;

        SingleDataFile(String string, File file) {
            super(string);
            this.path = file;
        }

        @Override
        public String toString() {
            return this.path.toString();
        }

        @Override
        ByteBuffer getData(String string) {
            if (string.equals(this.itemPath)) {
                return ICUBinary.mapFile(this.path);
            }
            return null;
        }

        @Override
        void addBaseNamesInFolder(String string, String string2, Set<String> set) {
            if (this.itemPath.length() > string.length() + string2.length() && this.itemPath.startsWith(string) && this.itemPath.endsWith(string2) && this.itemPath.charAt(string.length()) == '/' && this.itemPath.indexOf(47, string.length() + 1) < 0) {
                set.add(this.itemPath.substring(string.length() + 1, this.itemPath.length() - string2.length()));
            }
        }
    }

    private static abstract class DataFile {
        protected final String itemPath;

        DataFile(String string) {
            this.itemPath = string;
        }

        public String toString() {
            return this.itemPath;
        }

        abstract ByteBuffer getData(String var1);

        abstract void addBaseNamesInFolder(String var1, String var2, Set<String> var3);
    }

    private static final class DatPackageReader {
        private static final int DATA_FORMAT = 1131245124;
        private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();

        private DatPackageReader() {
        }

        static boolean validate(ByteBuffer byteBuffer) {
            try {
                ICUBinary.readHeader(byteBuffer, 1131245124, IS_ACCEPTABLE);
            }
            catch (IOException iOException) {
                return false;
            }
            int n2 = byteBuffer.getInt(byteBuffer.position());
            if (n2 <= 0) {
                return false;
            }
            if (byteBuffer.position() + 4 + n2 * 24 > byteBuffer.capacity()) {
                return false;
            }
            return DatPackageReader.startsWithPackageName(byteBuffer, DatPackageReader.getNameOffset(byteBuffer, 0)) && DatPackageReader.startsWithPackageName(byteBuffer, DatPackageReader.getNameOffset(byteBuffer, n2 - 1));
        }

        private static boolean startsWithPackageName(ByteBuffer byteBuffer, int n2) {
            int n3;
            int n4 = "icudt75b".length() - 1;
            for (n3 = 0; n3 < n4; ++n3) {
                if (byteBuffer.get(n2 + n3) == "icudt75b".charAt(n3)) continue;
                return false;
            }
            return ((n3 = (int)byteBuffer.get(n2 + n4++)) == 98 || n3 == 108) && byteBuffer.get(n2 + n4) == 47;
        }

        static ByteBuffer getData(ByteBuffer byteBuffer, CharSequence charSequence) {
            int n2 = DatPackageReader.binarySearch(byteBuffer, charSequence);
            if (n2 >= 0) {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.position(DatPackageReader.getDataOffset(byteBuffer, n2));
                byteBuffer2.limit(DatPackageReader.getDataOffset(byteBuffer, n2 + 1));
                return ICUBinary.sliceWithOrder(byteBuffer2);
            }
            return null;
        }

        static void addBaseNamesInFolder(ByteBuffer byteBuffer, String string, String string2, Set<String> set) {
            int n2 = DatPackageReader.binarySearch(byteBuffer, string);
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            }
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.getInt(n3);
            StringBuilder stringBuilder = new StringBuilder();
            while (n2 < n4 && DatPackageReader.addBaseName(byteBuffer, n2, string, string2, stringBuilder, set)) {
                ++n2;
            }
        }

        private static int binarySearch(ByteBuffer byteBuffer, CharSequence charSequence) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.getInt(n2);
            int n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                int n6 = n4 + n5 >>> 1;
                int n7 = DatPackageReader.getNameOffset(byteBuffer, n6);
                int n8 = ICUBinary.compareKeys(charSequence, byteBuffer, n7 += "icudt75b".length() + 1);
                if (n8 < 0) {
                    n5 = n6;
                    continue;
                }
                if (n8 > 0) {
                    n4 = n6 + 1;
                    continue;
                }
                return n6;
            }
            return ~n4;
        }

        private static int getNameOffset(ByteBuffer byteBuffer, int n2) {
            int n3 = byteBuffer.position();
            assert (0 <= n2 && n2 < byteBuffer.getInt(n3));
            return n3 + byteBuffer.getInt(n3 + 4 + n2 * 8);
        }

        private static int getDataOffset(ByteBuffer byteBuffer, int n2) {
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.getInt(n3);
            if (n2 == n4) {
                return byteBuffer.capacity();
            }
            assert (0 <= n2 && n2 < n4);
            return n3 + byteBuffer.getInt(n3 + 4 + 4 + n2 * 8);
        }

        static boolean addBaseName(ByteBuffer byteBuffer, int n2, String string, String string2, StringBuilder stringBuilder, Set<String> set) {
            char c2;
            int n3;
            int n4 = DatPackageReader.getNameOffset(byteBuffer, n2);
            n4 += "icudt75b".length() + 1;
            if (string.length() != 0) {
                n3 = 0;
                while (n3 < string.length()) {
                    if (byteBuffer.get(n4) != string.charAt(n3)) {
                        return false;
                    }
                    ++n3;
                    ++n4;
                }
                if (byteBuffer.get(n4++) != 47) {
                    return false;
                }
            }
            stringBuilder.setLength(0);
            while (true) {
                byte by2 = byteBuffer.get(n4++);
                n3 = by2;
                if (by2 == 0) break;
                c2 = (char)n3;
                if (c2 == '/') {
                    return true;
                }
                stringBuilder.append(c2);
            }
            c2 = stringBuilder.length() - string2.length();
            if (stringBuilder.lastIndexOf(string2, c2) >= 0) {
                set.add(stringBuilder.substring(0, c2));
            }
            return true;
        }

        private static final class IsAcceptable
        implements Authenticate {
            private IsAcceptable() {
            }

            @Override
            public boolean isDataVersionAcceptable(byte[] byArray) {
                return byArray[0] == 1;
            }
        }
    }
}

