/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.text.Format;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;

public class FormattedStringBuilder
implements Appendable,
CharSequence {
    public static final FormattedStringBuilder EMPTY = new FormattedStringBuilder();
    char[] chars;
    Object[] fields;
    int zero;
    int length;
    int appendOffset = 0;
    Object appendableField = null;
    private static final Map<Object, Character> fieldToDebugChar = new HashMap<Object, Character>();

    public static Format.Field unwrapField(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FieldWrapper) {
            return ((FieldWrapper)object).unwrap();
        }
        if (object instanceof Format.Field) {
            return (Format.Field)object;
        }
        throw new AssertionError((Object)("Not a field: " + object));
    }

    public FormattedStringBuilder() {
        this(40);
    }

    public FormattedStringBuilder(int n2) {
        this.chars = new char[n2];
        this.fields = new Object[n2];
        this.zero = n2 / 2;
        this.length = 0;
    }

    public FormattedStringBuilder(FormattedStringBuilder formattedStringBuilder) {
        this.copyFrom(formattedStringBuilder);
    }

    public void copyFrom(FormattedStringBuilder formattedStringBuilder) {
        this.chars = Arrays.copyOf(formattedStringBuilder.chars, formattedStringBuilder.chars.length);
        this.fields = Arrays.copyOf(formattedStringBuilder.fields, formattedStringBuilder.fields.length);
        this.zero = formattedStringBuilder.zero;
        this.length = formattedStringBuilder.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int codePointCount() {
        return Character.codePointCount(this, 0, this.length());
    }

    @Override
    public char charAt(int n2) {
        assert (n2 >= 0);
        assert (n2 < this.length);
        return this.chars[this.zero + n2];
    }

    public Object fieldAt(int n2) {
        assert (n2 >= 0);
        assert (n2 < this.length);
        return this.fields[this.zero + n2];
    }

    public int getFirstCodePoint() {
        if (this.length == 0) {
            return -1;
        }
        return Character.codePointAt(this.chars, this.zero, this.zero + this.length);
    }

    public int getLastCodePoint() {
        if (this.length == 0) {
            return -1;
        }
        return Character.codePointBefore(this.chars, this.zero + this.length, this.zero);
    }

    public int codePointAt(int n2) {
        return Character.codePointAt(this.chars, this.zero + n2, this.zero + this.length);
    }

    public int codePointBefore(int n2) {
        return Character.codePointBefore(this.chars, this.zero + n2, this.zero);
    }

    public FormattedStringBuilder clear() {
        this.zero = this.getCapacity() / 2;
        this.length = 0;
        return this;
    }

    public void setAppendIndex(int n2) {
        this.appendOffset = this.length - n2;
    }

    public int appendChar16(char c2, Object object) {
        return this.insertChar16(this.length - this.appendOffset, c2, object);
    }

    public int insertChar16(int n2, char c2, Object object) {
        int n3 = 1;
        int n4 = this.prepareForInsert(n2, n3);
        this.chars[n4] = c2;
        this.fields[n4] = object;
        return n3;
    }

    public int appendCodePoint(int n2, Object object) {
        return this.insertCodePoint(this.length - this.appendOffset, n2, object);
    }

    public int insertCodePoint(int n2, int n3, Object object) {
        int n4 = Character.charCount(n3);
        int n5 = this.prepareForInsert(n2, n4);
        Character.toChars(n3, this.chars, n5);
        this.fields[n5] = object;
        if (n4 == 2) {
            this.fields[n5 + 1] = object;
        }
        return n4;
    }

    public int append(CharSequence charSequence, Object object) {
        return this.insert(this.length - this.appendOffset, charSequence, object);
    }

    public int insert(int n2, CharSequence charSequence, Object object) {
        if (charSequence.length() == 0) {
            return 0;
        }
        if (charSequence.length() == 1) {
            return this.insertCodePoint(n2, charSequence.charAt(0), object);
        }
        return this.insert(n2, charSequence, 0, charSequence.length(), object);
    }

    public int insert(int n2, CharSequence charSequence, int n3, int n4, Object object) {
        int n5 = n4 - n3;
        int n6 = this.prepareForInsert(n2, n5);
        for (int i2 = 0; i2 < n5; ++i2) {
            this.chars[n6 + i2] = charSequence.charAt(n3 + i2);
            this.fields[n6 + i2] = object;
        }
        return n5;
    }

    public int splice(int n2, int n3, CharSequence charSequence, int n4, int n5, Object object) {
        int n6 = n5 - n4;
        int n7 = n3 - n2;
        int n8 = n6 - n7;
        int n9 = n8 > 0 ? this.prepareForInsert(n2, n8) : this.remove(n2, -n8);
        for (int i2 = 0; i2 < n6; ++i2) {
            this.chars[n9 + i2] = charSequence.charAt(n4 + i2);
            this.fields[n9 + i2] = object;
        }
        return n8;
    }

    public int append(char[] cArray, Object[] objectArray) {
        return this.insert(this.length - this.appendOffset, cArray, objectArray);
    }

    public int insert(int n2, char[] cArray, Object[] objectArray) {
        assert (objectArray == null || cArray.length == objectArray.length);
        int n3 = cArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.prepareForInsert(n2, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.chars[n4 + i2] = cArray[i2];
            this.fields[n4 + i2] = objectArray == null ? null : objectArray[i2];
        }
        return n3;
    }

    public int append(FormattedStringBuilder formattedStringBuilder) {
        return this.insert(this.length - this.appendOffset, formattedStringBuilder);
    }

    public int insert(int n2, FormattedStringBuilder formattedStringBuilder) {
        if (this == formattedStringBuilder) {
            throw new IllegalArgumentException("Cannot call insert/append on myself");
        }
        int n3 = formattedStringBuilder.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.prepareForInsert(n2, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.chars[n4 + i2] = formattedStringBuilder.charAt(i2);
            this.fields[n4 + i2] = formattedStringBuilder.fieldAt(i2);
        }
        return n3;
    }

    private int prepareForInsert(int n2, int n3) {
        if (n2 == -1) {
            n2 = this.length;
        }
        if (n2 == 0 && this.zero - n3 >= 0) {
            this.zero -= n3;
            this.length += n3;
            return this.zero;
        }
        if (n2 == this.length && this.zero + this.length + n3 < this.getCapacity()) {
            this.length += n3;
            return this.zero + this.length - n3;
        }
        return this.prepareForInsertHelper(n2, n3);
    }

    private int prepareForInsertHelper(int n2, int n3) {
        int n4 = this.getCapacity();
        int n5 = this.zero;
        char[] cArray = this.chars;
        Object[] objectArray = this.fields;
        if (this.length + n3 > n4) {
            int n6 = (this.length + n3) * 2;
            int n7 = n6 / 2 - (this.length + n3) / 2;
            char[] cArray2 = new char[n6];
            Object[] objectArray2 = new Object[n6];
            System.arraycopy(cArray, n5, cArray2, n7, n2);
            System.arraycopy(cArray, n5 + n2, cArray2, n7 + n2 + n3, this.length - n2);
            System.arraycopy(objectArray, n5, objectArray2, n7, n2);
            System.arraycopy(objectArray, n5 + n2, objectArray2, n7 + n2 + n3, this.length - n2);
            this.chars = cArray2;
            this.fields = objectArray2;
            this.zero = n7;
            this.length += n3;
        } else {
            int n8 = n4 / 2 - (this.length + n3) / 2;
            System.arraycopy(cArray, n5, cArray, n8, this.length);
            System.arraycopy(cArray, n8 + n2, cArray, n8 + n2 + n3, this.length - n2);
            System.arraycopy(objectArray, n5, objectArray, n8, this.length);
            System.arraycopy(objectArray, n8 + n2, objectArray, n8 + n2 + n3, this.length - n2);
            this.zero = n8;
            this.length += n3;
        }
        return this.zero + n2;
    }

    private int remove(int n2, int n3) {
        int n4 = n2 + this.zero;
        System.arraycopy(this.chars, n4 + n3, this.chars, n4, this.length - n2 - n3);
        System.arraycopy(this.fields, n4 + n3, this.fields, n4, this.length - n2 - n3);
        this.length -= n3;
        return n4;
    }

    private int getCapacity() {
        return this.chars.length;
    }

    @Override
    @Deprecated
    public CharSequence subSequence(int n2, int n3) {
        assert (n2 >= 0);
        assert (n3 <= this.length);
        assert (n3 >= n2);
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder(this);
        formattedStringBuilder.zero = this.zero + n2;
        formattedStringBuilder.length = n3 - n2;
        return formattedStringBuilder;
    }

    public String subString(int n2, int n3) {
        if (n2 < 0 || n3 > this.length || n3 < n2) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.chars, n2 + this.zero, n3 - n2);
    }

    @Override
    public String toString() {
        return new String(this.chars, this.zero, this.length);
    }

    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<FormattedStringBuilder [");
        stringBuilder.append(this.toString());
        stringBuilder.append("] [");
        for (int i2 = this.zero; i2 < this.zero + this.length; ++i2) {
            if (this.fields[i2] == null) {
                stringBuilder.append('n');
                continue;
            }
            if (fieldToDebugChar.containsKey(this.fields[i2])) {
                stringBuilder.append(fieldToDebugChar.get(this.fields[i2]));
                continue;
            }
            stringBuilder.append('?');
        }
        stringBuilder.append("]>");
        return stringBuilder.toString();
    }

    public char[] toCharArray() {
        return Arrays.copyOfRange(this.chars, this.zero, this.zero + this.length);
    }

    public Object[] toFieldArray() {
        return Arrays.copyOfRange(this.fields, this.zero, this.zero + this.length);
    }

    public void setAppendableField(Object object) {
        this.appendableField = object;
    }

    @Override
    public Appendable append(CharSequence charSequence) {
        assert (this.appendableField != null);
        this.insert(this.length - this.appendOffset, charSequence, this.appendableField);
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n2, int n3) {
        assert (this.appendableField != null);
        this.insert(this.length - this.appendOffset, charSequence, n2, n3, this.appendableField);
        return this;
    }

    @Override
    public Appendable append(char c2) {
        assert (this.appendableField != null);
        this.insertChar16(this.length - this.appendOffset, c2, this.appendableField);
        return this;
    }

    public boolean contentEquals(char[] cArray, Object[] objectArray) {
        if (cArray.length != this.length) {
            return false;
        }
        if (objectArray.length != this.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (this.chars[this.zero + i2] != cArray[i2]) {
                return false;
            }
            if (FormattedStringBuilder.unwrapField(this.fields[this.zero + i2]) == FormattedStringBuilder.unwrapField(objectArray[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean contentEquals(FormattedStringBuilder formattedStringBuilder) {
        if (this.length != formattedStringBuilder.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (this.charAt(i2) != formattedStringBuilder.charAt(i2)) {
                return false;
            }
            if (FormattedStringBuilder.unwrapField(this.fieldAt(i2)) == FormattedStringBuilder.unwrapField(formattedStringBuilder.fieldAt(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Don't call #hashCode() or #equals() on a mutable.");
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException("Don't call #hashCode() or #equals() on a mutable.");
    }

    static {
        fieldToDebugChar.put(NumberFormat.Field.SIGN, Character.valueOf('-'));
        fieldToDebugChar.put(NumberFormat.Field.INTEGER, Character.valueOf('i'));
        fieldToDebugChar.put(NumberFormat.Field.FRACTION, Character.valueOf('f'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT, Character.valueOf('e'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT_SIGN, Character.valueOf('+'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT_SYMBOL, Character.valueOf('E'));
        fieldToDebugChar.put(NumberFormat.Field.DECIMAL_SEPARATOR, Character.valueOf('.'));
        fieldToDebugChar.put(NumberFormat.Field.GROUPING_SEPARATOR, Character.valueOf(','));
        fieldToDebugChar.put(NumberFormat.Field.PERCENT, Character.valueOf('%'));
        fieldToDebugChar.put(NumberFormat.Field.PERMILLE, Character.valueOf('\u2030'));
        fieldToDebugChar.put(NumberFormat.Field.CURRENCY, Character.valueOf('$'));
        fieldToDebugChar.put(NumberFormat.Field.MEASURE_UNIT, Character.valueOf('u'));
        fieldToDebugChar.put(NumberFormat.Field.COMPACT, Character.valueOf('C'));
    }

    public static interface FieldWrapper {
        public Format.Field unwrap();
    }
}

