/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CalType;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Grego;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundleIterator;

public class EraRules {
    private static final int MAX_ENCODED_START_YEAR = Short.MAX_VALUE;
    private static final int MIN_ENCODED_START_YEAR = Short.MIN_VALUE;
    public static final int MIN_ENCODED_START = EraRules.encodeDate(Short.MIN_VALUE, 1, 1);
    private static final int YEAR_MASK = -65536;
    private static final int MONTH_MASK = 65280;
    private static final int DAY_MASK = 255;
    private int[] startDates;
    private int numEras;
    private int currentEra;

    private EraRules(int[] nArray, int n2) {
        this.startDates = nArray;
        this.numEras = n2;
        this.initCurrentEra();
    }

    public static EraRules getInstance(CalType calType, boolean bl2) {
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle uResourceBundle2 = uResourceBundle.get("calendarData");
        UResourceBundle uResourceBundle3 = uResourceBundle2.get(calType.getId());
        UResourceBundle uResourceBundle4 = uResourceBundle3.get("eras");
        int n2 = uResourceBundle4.getSize();
        int n3 = Integer.MAX_VALUE;
        int[] nArray = new int[n2];
        UResourceBundleIterator uResourceBundleIterator = uResourceBundle4.getIterator();
        while (uResourceBundleIterator.hasNext()) {
            UResourceBundle uResourceBundle5 = uResourceBundleIterator.next();
            String string = uResourceBundle5.getKey();
            int n4 = -1;
            try {
                n4 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ICUException("Invalid era rule key:" + string + " in era rule data for " + calType.getId());
            }
            if (n4 < 0 || n4 >= n2) {
                throw new ICUException("Era rule key:" + string + " in era rule data for " + calType.getId() + " must be in range [0, " + (n2 - 1) + "]");
            }
            if (EraRules.isSet(nArray[n4])) {
                throw new ICUException("Duplicated era rule for rule key:" + string + " in era rule data for " + calType.getId());
            }
            boolean bl3 = true;
            boolean bl4 = false;
            UResourceBundleIterator uResourceBundleIterator2 = uResourceBundle5.getIterator();
            while (uResourceBundleIterator2.hasNext()) {
                Object object;
                UResourceBundle uResourceBundle6 = uResourceBundleIterator2.next();
                String string2 = uResourceBundle6.getKey();
                if (string2.equals("start")) {
                    object = uResourceBundle6.getIntVector();
                    if (((int[])object).length != 3 || !EraRules.isValidRuleStartDate(object[0], (int)object[1], (int)object[2])) {
                        throw new ICUException("Invalid era rule date data:" + Arrays.toString(object) + " in era rule data for " + calType.getId());
                    }
                    nArray[n4] = EraRules.encodeDate((int)object[0], (int)object[1], (int)object[2]);
                    continue;
                }
                if (string2.equals("named")) {
                    object = uResourceBundle6.getString();
                    if (!object.equals("false")) continue;
                    bl3 = false;
                    continue;
                }
                if (!string2.equals("end")) continue;
                bl4 = true;
            }
            if (EraRules.isSet(nArray[n4])) {
                if (bl4) {
                    // empty if block
                }
            } else if (bl4) {
                if (n4 != 0) {
                    throw new ICUException("Era data for " + string + " in era rule data for " + calType.getId() + " has only end rule.");
                }
                nArray[n4] = MIN_ENCODED_START;
            } else {
                throw new ICUException("Missing era start/end rule date for key:" + string + " in era rule data for " + calType.getId());
            }
            if (bl3) {
                if (n4 < n3) continue;
                throw new ICUException("Non-tentative era(" + n4 + ") must be placed before the first tentative era");
            }
            if (n4 >= n3) continue;
            n3 = n4;
        }
        if (n3 < Integer.MAX_VALUE && !bl2) {
            return new EraRules(nArray, n3);
        }
        return new EraRules(nArray, n2);
    }

    public int getNumberOfEras() {
        return this.numEras;
    }

    public int[] getStartDate(int n2, int[] nArray) {
        if (n2 < 0 || n2 >= this.numEras) {
            throw new IllegalArgumentException("eraIdx is out of range");
        }
        return EraRules.decodeDate(this.startDates[n2], nArray);
    }

    public int getStartYear(int n2) {
        if (n2 < 0 || n2 >= this.numEras) {
            throw new IllegalArgumentException("eraIdx is out of range");
        }
        int[] nArray = EraRules.decodeDate(this.startDates[n2], null);
        return nArray[0];
    }

    public int getEraIndex(int n2, int n3, int n4) {
        if (n3 < 1 || n3 > 12 || n4 < 1 || n4 > 31) {
            throw new IllegalArgumentException("Illegal date - year:" + n2 + "month:" + n3 + "day:" + n4);
        }
        int n5 = this.numEras;
        int n6 = EraRules.compareEncodedDateWithYMD(this.startDates[this.getCurrentEraIndex()], n2, n3, n4) <= 0 ? this.getCurrentEraIndex() : 0;
        while (n6 < n5 - 1) {
            int n7 = (n6 + n5) / 2;
            if (EraRules.compareEncodedDateWithYMD(this.startDates[n7], n2, n3, n4) <= 0) {
                n6 = n7;
                continue;
            }
            n5 = n7;
        }
        return n6;
    }

    public int getCurrentEraIndex() {
        return this.currentEra;
    }

    private void initCurrentEra() {
        int n2;
        long l2 = System.currentTimeMillis();
        TimeZone timeZone = TimeZone.getDefault();
        l2 += (long)timeZone.getOffset(l2);
        int[] nArray = Grego.timeToFields(l2, null);
        int n3 = EraRules.encodeDate(nArray[0], nArray[1] + 1, nArray[2]);
        for (n2 = this.numEras - 1; n2 > 0 && n3 < this.startDates[n2]; --n2) {
        }
        this.currentEra = n2;
    }

    private static boolean isSet(int n2) {
        return n2 != 0;
    }

    private static boolean isValidRuleStartDate(int n2, int n3, int n4) {
        return n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE && n3 >= 1 && n3 <= 12 && n4 >= 1 && n4 <= 31;
    }

    private static int encodeDate(int n2, int n3, int n4) {
        return n2 << 16 | n3 << 8 | n4;
    }

    private static int[] decodeDate(int n2, int[] nArray) {
        int n3;
        int n4;
        int n5;
        if (n2 == MIN_ENCODED_START) {
            n5 = Integer.MIN_VALUE;
            n4 = 1;
            n3 = 1;
        } else {
            n5 = (n2 & 0xFFFF0000) >> 16;
            n4 = (n2 & 0xFF00) >> 8;
            n3 = n2 & 0xFF;
        }
        if (nArray != null && nArray.length >= 3) {
            nArray[0] = n5;
            nArray[1] = n4;
            nArray[2] = n3;
            return nArray;
        }
        int[] nArray2 = new int[]{n5, n4, n3};
        return nArray2;
    }

    private static int compareEncodedDateWithYMD(int n2, int n3, int n4, int n5) {
        if (n3 < Short.MIN_VALUE) {
            if (n2 == MIN_ENCODED_START) {
                if (n3 > Integer.MIN_VALUE || n4 > 1 || n5 > 1) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }
        if (n3 > Short.MAX_VALUE) {
            return -1;
        }
        int n6 = EraRules.encodeDate(n3, n4, n5);
        if (n2 < n6) {
            return -1;
        }
        if (n2 == n6) {
            return 0;
        }
        return 1;
    }
}

