/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class DayPeriodRules {
    private static final DayPeriodRulesData DATA = DayPeriodRules.loadData();
    private boolean hasMidnight = false;
    private boolean hasNoon = false;
    private DayPeriod[] dayPeriodForHour = new DayPeriod[24];

    private DayPeriodRules() {
    }

    public static DayPeriodRules getInstance(ULocale uLocale) {
        String string = uLocale.getBaseName();
        if (string.isEmpty()) {
            string = "root";
        }
        Integer n2 = null;
        while (n2 == null && (n2 = DayPeriodRules.DATA.localesToRuleSetNumMap.get(string)) == null && !(string = ULocale.getFallback(string)).isEmpty()) {
        }
        if (n2 == null || DayPeriodRules.DATA.rules[n2] == null) {
            return null;
        }
        return DayPeriodRules.DATA.rules[n2];
    }

    public double getMidPointForDayPeriod(DayPeriod dayPeriod) {
        int n2 = this.getStartHourForDayPeriod(dayPeriod);
        int n3 = this.getEndHourForDayPeriod(dayPeriod);
        double d2 = (double)(n2 + n3) / 2.0;
        if (n2 > n3 && (d2 += 12.0) >= 24.0) {
            d2 -= 24.0;
        }
        return d2;
    }

    private static DayPeriodRulesData loadData() {
        DayPeriodRulesData dayPeriodRulesData = new DayPeriodRulesData();
        ICUResourceBundle iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "dayPeriods", ICUResourceBundle.ICU_DATA_CLASS_LOADER, true);
        DayPeriodRulesCountSink dayPeriodRulesCountSink = new DayPeriodRulesCountSink(dayPeriodRulesData);
        iCUResourceBundle.getAllItemsWithFallback("rules", dayPeriodRulesCountSink);
        dayPeriodRulesData.rules = new DayPeriodRules[dayPeriodRulesData.maxRuleSetNum + 1];
        DayPeriodRulesDataSink dayPeriodRulesDataSink = new DayPeriodRulesDataSink(dayPeriodRulesData);
        iCUResourceBundle.getAllItemsWithFallback("", dayPeriodRulesDataSink);
        return dayPeriodRulesData;
    }

    private int getStartHourForDayPeriod(DayPeriod dayPeriod) throws IllegalArgumentException {
        if (dayPeriod == DayPeriod.MIDNIGHT) {
            return 0;
        }
        if (dayPeriod == DayPeriod.NOON) {
            return 12;
        }
        if (this.dayPeriodForHour[0] == dayPeriod && this.dayPeriodForHour[23] == dayPeriod) {
            for (int i2 = 22; i2 >= 1; --i2) {
                if (this.dayPeriodForHour[i2] == dayPeriod) continue;
                return i2 + 1;
            }
        } else {
            for (int i3 = 0; i3 <= 23; ++i3) {
                if (this.dayPeriodForHour[i3] != dayPeriod) continue;
                return i3;
            }
        }
        throw new IllegalArgumentException();
    }

    private int getEndHourForDayPeriod(DayPeriod dayPeriod) {
        if (dayPeriod == DayPeriod.MIDNIGHT) {
            return 0;
        }
        if (dayPeriod == DayPeriod.NOON) {
            return 12;
        }
        if (this.dayPeriodForHour[0] == dayPeriod && this.dayPeriodForHour[23] == dayPeriod) {
            for (int i2 = 1; i2 <= 22; ++i2) {
                if (this.dayPeriodForHour[i2] == dayPeriod) continue;
                return i2;
            }
        } else {
            for (int i3 = 23; i3 >= 0; --i3) {
                if (this.dayPeriodForHour[i3] != dayPeriod) continue;
                return i3 + 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean hasMidnight() {
        return this.hasMidnight;
    }

    public boolean hasNoon() {
        return this.hasNoon;
    }

    public DayPeriod getDayPeriodForHour(int n2) {
        return this.dayPeriodForHour[n2];
    }

    private void add(int n2, int n3, DayPeriod dayPeriod) {
        for (int i2 = n2; i2 != n3; ++i2) {
            if (i2 == 24) {
                i2 = 0;
            }
            this.dayPeriodForHour[i2] = dayPeriod;
        }
    }

    private static int parseSetNum(String string) {
        if (!string.startsWith("set")) {
            throw new ICUException("Set number should start with \"set\".");
        }
        String string2 = string.substring(3);
        return Integer.parseInt(string2);
    }

    private static class DayPeriodRulesCountSink
    extends UResource.Sink {
        private DayPeriodRulesData data;

        private DayPeriodRulesCountSink(DayPeriodRulesData dayPeriodRulesData) {
            this.data = dayPeriodRulesData;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                int n3 = DayPeriodRules.parseSetNum(key.toString());
                if (n3 > this.data.maxRuleSetNum) {
                    this.data.maxRuleSetNum = n3;
                }
                ++n2;
            }
        }
    }

    private static final class DayPeriodRulesDataSink
    extends UResource.Sink {
        private DayPeriodRulesData data;
        private int[] cutoffs = new int[25];
        private int ruleSetNum;
        private DayPeriod period;
        private CutoffType cutoffType;

        private DayPeriodRulesDataSink(DayPeriodRulesData dayPeriodRulesData) {
            this.data = dayPeriodRulesData;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                UResource.Table table2;
                if (key.contentEquals("locales")) {
                    table2 = value.getTable();
                    int n3 = 0;
                    while (table2.getKeyAndValue(n3, key, value)) {
                        int n4 = DayPeriodRules.parseSetNum(value.getString());
                        this.data.localesToRuleSetNumMap.put(key.toString(), n4);
                        ++n3;
                    }
                } else if (key.contentEquals("rules")) {
                    table2 = value.getTable();
                    this.processRules(table2, key, value);
                }
                ++n2;
            }
        }

        private void processRules(UResource.Table table, UResource.Key key, UResource.Value value) {
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                this.ruleSetNum = DayPeriodRules.parseSetNum(key.toString());
                this.data.rules[this.ruleSetNum] = new DayPeriodRules();
                UResource.Table table2 = value.getTable();
                int n3 = 0;
                while (table2.getKeyAndValue(n3, key, value)) {
                    this.period = DayPeriod.fromStringOrNull(key);
                    if (this.period == null) {
                        throw new ICUException("Unknown day period in data.");
                    }
                    UResource.Table table3 = value.getTable();
                    int n4 = 0;
                    while (table3.getKeyAndValue(n4, key, value)) {
                        if (value.getType() == 0) {
                            CutoffType cutoffType = CutoffType.fromStringOrNull(key);
                            this.addCutoff(cutoffType, value.getString());
                        } else {
                            this.cutoffType = CutoffType.fromStringOrNull(key);
                            UResource.Array array = value.getArray();
                            int n5 = array.getSize();
                            for (int i2 = 0; i2 < n5; ++i2) {
                                array.getValue(i2, value);
                                this.addCutoff(this.cutoffType, value.getString());
                            }
                        }
                        ++n4;
                    }
                    this.setDayPeriodForHoursFromCutoffs();
                    for (n4 = 0; n4 < this.cutoffs.length; ++n4) {
                        this.cutoffs[n4] = 0;
                    }
                    ++n3;
                }
                for (DayPeriod dayPeriod : this.data.rules[this.ruleSetNum].dayPeriodForHour) {
                    if (dayPeriod != null) continue;
                    throw new ICUException("Rules in data don't cover all 24 hours (they should).");
                }
                ++n2;
            }
        }

        private void addCutoff(CutoffType cutoffType, String string) {
            int n2;
            if (cutoffType == null) {
                throw new ICUException("Cutoff type not recognized.");
            }
            int n3 = n2 = DayPeriodRulesDataSink.parseHour(string);
            this.cutoffs[n3] = this.cutoffs[n3] | 1 << cutoffType.ordinal();
        }

        private void setDayPeriodForHoursFromCutoffs() {
            DayPeriodRules dayPeriodRules = this.data.rules[this.ruleSetNum];
            block0: for (int i2 = 0; i2 <= 24; ++i2) {
                if ((this.cutoffs[i2] & 1 << CutoffType.AT.ordinal()) > 0) {
                    if (i2 == 0 && this.period == DayPeriod.MIDNIGHT) {
                        dayPeriodRules.hasMidnight = true;
                    } else if (i2 == 12 && this.period == DayPeriod.NOON) {
                        dayPeriodRules.hasNoon = true;
                    } else {
                        throw new ICUException("AT cutoff must only be set for 0:00 or 12:00.");
                    }
                }
                if ((this.cutoffs[i2] & 1 << CutoffType.FROM.ordinal()) <= 0 && (this.cutoffs[i2] & 1 << CutoffType.AFTER.ordinal()) <= 0) continue;
                int n2 = i2 + 1;
                while (true) {
                    if (n2 == i2) {
                        throw new ICUException("FROM/AFTER cutoffs must have a matching BEFORE cutoff.");
                    }
                    if (n2 == 25) {
                        n2 = 0;
                    }
                    if ((this.cutoffs[n2] & 1 << CutoffType.BEFORE.ordinal()) > 0) {
                        dayPeriodRules.add(i2, n2, this.period);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }

        private static int parseHour(String string) {
            int n2 = string.indexOf(58);
            if (n2 < 0 || !string.substring(n2).equals(":00")) {
                throw new ICUException("Cutoff time must end in \":00\".");
            }
            String string2 = string.substring(0, n2);
            if (n2 != 1 && n2 != 2) {
                throw new ICUException("Cutoff time must begin with h: or hh:");
            }
            int n3 = Integer.parseInt(string2);
            if (n3 < 0 || n3 > 24) {
                throw new ICUException("Cutoff hour must be between 0 and 24, inclusive.");
            }
            return n3;
        }
    }

    private static final class DayPeriodRulesData {
        Map<String, Integer> localesToRuleSetNumMap = new HashMap<String, Integer>();
        DayPeriodRules[] rules;
        int maxRuleSetNum = -1;

        private DayPeriodRulesData() {
        }
    }

    private static enum CutoffType {
        BEFORE,
        AFTER,
        FROM,
        AT;


        private static CutoffType fromStringOrNull(CharSequence charSequence) {
            if ("from".contentEquals(charSequence)) {
                return FROM;
            }
            if ("before".contentEquals(charSequence)) {
                return BEFORE;
            }
            if ("after".contentEquals(charSequence)) {
                return AFTER;
            }
            if ("at".contentEquals(charSequence)) {
                return AT;
            }
            return null;
        }
    }

    public static enum DayPeriod {
        MIDNIGHT,
        NOON,
        MORNING1,
        AFTERNOON1,
        EVENING1,
        NIGHT1,
        MORNING2,
        AFTERNOON2,
        EVENING2,
        NIGHT2,
        AM,
        PM;

        public static DayPeriod[] VALUES;

        private static DayPeriod fromStringOrNull(CharSequence charSequence) {
            if ("midnight".contentEquals(charSequence)) {
                return MIDNIGHT;
            }
            if ("noon".contentEquals(charSequence)) {
                return NOON;
            }
            if ("morning1".contentEquals(charSequence)) {
                return MORNING1;
            }
            if ("afternoon1".contentEquals(charSequence)) {
                return AFTERNOON1;
            }
            if ("evening1".contentEquals(charSequence)) {
                return EVENING1;
            }
            if ("night1".contentEquals(charSequence)) {
                return NIGHT1;
            }
            if ("morning2".contentEquals(charSequence)) {
                return MORNING2;
            }
            if ("afternoon2".contentEquals(charSequence)) {
                return AFTERNOON2;
            }
            if ("evening2".contentEquals(charSequence)) {
                return EVENING2;
            }
            if ("night2".contentEquals(charSequence)) {
                return NIGHT2;
            }
            if ("am".contentEquals(charSequence)) {
                return AM;
            }
            if ("pm".contentEquals(charSequence)) {
                return PM;
            }
            return null;
        }

        static {
            VALUES = DayPeriod.values();
        }
    }
}

