/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.math.BigDecimal;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public final class DateNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = -6315692826916346953L;
    private char[] digits;
    private char zeroDigit;
    private char minusSign;
    private boolean positiveOnly = false;
    private static final int DECIMAL_BUF_SIZE = 20;
    private transient char[] decimalBuf = new char[20];
    private static SimpleCache<ULocale, char[]> CACHE = new SimpleCache();
    private int maxIntDigits;
    private int minIntDigits;
    private static final long PARSE_THRESHOLD = 0xCCCCCCCCCCCCCCBL;

    public DateNumberFormat(ULocale uLocale, String string, String string2) {
        if (string.length() > 10) {
            throw new UnsupportedOperationException("DateNumberFormat does not support digits out of BMP.");
        }
        this.initialize(uLocale, string, string2);
    }

    public DateNumberFormat(ULocale uLocale, char c2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < 10; ++i2) {
            stringBuffer.append((char)(c2 + i2));
        }
        this.initialize(uLocale, stringBuffer.toString(), string);
    }

    private void initialize(ULocale uLocale, String string, String string2) {
        char[] cArray = CACHE.get(uLocale);
        if (cArray == null) {
            String string3;
            ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
            try {
                string3 = iCUResourceBundle.getStringWithFallback("NumberElements/" + string2 + "/symbols/minusSign");
            }
            catch (MissingResourceException missingResourceException) {
                if (!string2.equals("latn")) {
                    try {
                        string3 = iCUResourceBundle.getStringWithFallback("NumberElements/latn/symbols/minusSign");
                    }
                    catch (MissingResourceException missingResourceException2) {
                        string3 = "-";
                    }
                }
                string3 = "-";
            }
            cArray = new char[11];
            for (int i2 = 0; i2 < 10; ++i2) {
                cArray[i2] = string.charAt(i2);
            }
            cArray[10] = string3.charAt(0);
            CACHE.put(uLocale, cArray);
        }
        this.digits = new char[10];
        System.arraycopy(cArray, 0, this.digits, 0, 10);
        this.zeroDigit = this.digits[0];
        this.minusSign = cArray[10];
    }

    @Override
    public void setMaximumIntegerDigits(int n2) {
        this.maxIntDigits = n2;
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.maxIntDigits;
    }

    @Override
    public void setMinimumIntegerDigits(int n2) {
        this.minIntDigits = n2;
    }

    @Override
    public int getMinimumIntegerDigits() {
        return this.minIntDigits;
    }

    public void setParsePositiveOnly(boolean bl2) {
        this.positiveOnly = bl2;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public void setZeroDigit(char c2) {
        this.zeroDigit = c2;
        if (this.digits == null) {
            this.digits = new char[10];
        }
        this.digits[0] = c2;
        for (int i2 = 1; i2 < 10; ++i2) {
            this.digits[i2] = (char)(c2 + i2);
        }
    }

    public char[] getDigits() {
        return (char[])this.digits.clone();
    }

    @Override
    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        throw new UnsupportedOperationException("StringBuffer format(double, StringBuffer, FieldPosition) is not implemented");
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (l2 < 0L) {
            stringBuffer.append(this.minusSign);
            l2 = -l2;
        }
        int n2 = (int)l2;
        int n3 = this.decimalBuf.length < this.maxIntDigits ? this.decimalBuf.length : this.maxIntDigits;
        int n4 = n3 - 1;
        while (true) {
            this.decimalBuf[n4] = this.digits[n2 % 10];
            if (n4 == 0 || (n2 /= 10) == 0) break;
            --n4;
        }
        for (int i2 = this.minIntDigits - (n3 - n4); i2 > 0; --i2) {
            this.decimalBuf[--n4] = this.digits[0];
        }
        int n5 = n3 - n4;
        stringBuffer.append(this.decimalBuf, n4, n5);
        fieldPosition.setBeginIndex(0);
        if (fieldPosition.getField() == 0) {
            fieldPosition.setEndIndex(n5);
        } else {
            fieldPosition.setEndIndex(0);
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        throw new UnsupportedOperationException("StringBuffer format(BigInteger, StringBuffer, FieldPosition) is not implemented");
    }

    @Override
    public StringBuffer format(java.math.BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        throw new UnsupportedOperationException("StringBuffer format(BigDecimal, StringBuffer, FieldPosition) is not implemented");
    }

    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        throw new UnsupportedOperationException("StringBuffer format(BigDecimal, StringBuffer, FieldPosition) is not implemented");
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        long l2 = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = parsePosition.getIndex();
        int n3 = 0;
        while (n2 + n3 < string.length()) {
            char c2 = string.charAt(n2 + n3);
            if (n3 == 0 && c2 == this.minusSign) {
                if (this.positiveOnly) break;
                bl3 = true;
            } else {
                int n4 = c2 - this.digits[0];
                if (n4 < 0 || 9 < n4) {
                    n4 = UCharacter.digit(c2);
                }
                if (n4 < 0 || 9 < n4) {
                    for (n4 = 0; n4 < 10 && c2 != this.digits[n4]; ++n4) {
                    }
                }
                if (0 > n4 || n4 > 9 || l2 >= 0xCCCCCCCCCCCCCCBL) break;
                bl2 = true;
                l2 = l2 * 10L + (long)n4;
            }
            ++n3;
        }
        Long l3 = null;
        if (bl2) {
            l2 = bl3 ? l2 * -1L : l2;
            l3 = l2;
            parsePosition.setIndex(n2 + n3);
        }
        return l3;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !super.equals(object) || !(object instanceof DateNumberFormat)) {
            return false;
        }
        DateNumberFormat dateNumberFormat = (DateNumberFormat)object;
        return this.maxIntDigits == dateNumberFormat.maxIntDigits && this.minIntDigits == dateNumberFormat.minIntDigits && this.minusSign == dateNumberFormat.minusSign && this.positiveOnly == dateNumberFormat.positiveOnly && Arrays.equals(this.digits, dateNumberFormat.digits);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.digits == null) {
            this.setZeroDigit(this.zeroDigit);
        }
        this.decimalBuf = new char[20];
    }

    @Override
    public Object clone() {
        DateNumberFormat dateNumberFormat = (DateNumberFormat)super.clone();
        dateNumberFormat.digits = (char[])this.digits.clone();
        dateNumberFormat.decimalBuf = new char[20];
        return dateNumberFormat;
    }
}

