/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;

public class CharacterIteratorWrapper
extends UCharacterIterator {
    private CharacterIterator iterator;

    public CharacterIteratorWrapper(CharacterIterator characterIterator) {
        if (characterIterator == null) {
            throw new IllegalArgumentException();
        }
        this.iterator = characterIterator;
    }

    @Override
    public int current() {
        char c2 = this.iterator.current();
        if (c2 == '\uffff') {
            return -1;
        }
        return c2;
    }

    @Override
    public int getLength() {
        return this.iterator.getEndIndex() - this.iterator.getBeginIndex();
    }

    @Override
    public int getIndex() {
        return this.iterator.getIndex();
    }

    @Override
    public int next() {
        char c2 = this.iterator.current();
        this.iterator.next();
        if (c2 == '\uffff') {
            return -1;
        }
        return c2;
    }

    @Override
    public int previous() {
        char c2 = this.iterator.previous();
        if (c2 == '\uffff') {
            return -1;
        }
        return c2;
    }

    @Override
    public void setIndex(int n2) {
        try {
            this.iterator.setIndex(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void setToLimit() {
        this.iterator.setIndex(this.iterator.getEndIndex());
    }

    @Override
    public int getText(char[] cArray, int n2) {
        int n3 = this.iterator.getEndIndex() - this.iterator.getBeginIndex();
        int n4 = this.iterator.getIndex();
        if (n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n3));
        }
        char c2 = this.iterator.first();
        while (c2 != '\uffff') {
            cArray[n2++] = c2;
            c2 = this.iterator.next();
        }
        this.iterator.setIndex(n4);
        return n3;
    }

    @Override
    public Object clone() {
        try {
            CharacterIteratorWrapper characterIteratorWrapper = (CharacterIteratorWrapper)super.clone();
            characterIteratorWrapper.iterator = (CharacterIterator)this.iterator.clone();
            return characterIteratorWrapper;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int moveIndex(int n2) {
        int n3 = this.iterator.getEndIndex() - this.iterator.getBeginIndex();
        int n4 = this.iterator.getIndex() + n2;
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n3) {
            n4 = n3;
        }
        return this.iterator.setIndex(n4);
    }

    @Override
    public CharacterIterator getCharacterIterator() {
        return (CharacterIterator)this.iterator.clone();
    }
}

