/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public final class CharacterIteration {
    public static final int DONE32 = Integer.MAX_VALUE;

    private CharacterIteration() {
    }

    public static int next32(CharacterIterator characterIterator) {
        int n2 = characterIterator.current();
        if (n2 >= 55296 && n2 <= 56319 && ((n2 = characterIterator.next()) < 56320 || n2 > 57343)) {
            characterIterator.previous();
        }
        if ((n2 = characterIterator.next()) >= 55296) {
            n2 = CharacterIteration.nextTrail32(characterIterator, n2);
        }
        if (n2 >= 65536 && n2 != Integer.MAX_VALUE) {
            characterIterator.previous();
        }
        return n2;
    }

    public static int nextTrail32(CharacterIterator characterIterator, int n2) {
        if (n2 == 65535 && characterIterator.getIndex() >= characterIterator.getEndIndex()) {
            return Integer.MAX_VALUE;
        }
        int n3 = n2;
        if (n2 <= 56319) {
            char c2 = characterIterator.next();
            if (UTF16.isTrailSurrogate(c2)) {
                n3 = (n2 - 55296 << 10) + (c2 - 56320) + 65536;
            } else {
                characterIterator.previous();
            }
        }
        return n3;
    }

    public static int previous32(CharacterIterator characterIterator) {
        int n2;
        if (characterIterator.getIndex() <= characterIterator.getBeginIndex()) {
            return Integer.MAX_VALUE;
        }
        int n3 = n2 = characterIterator.previous();
        if (UTF16.isTrailSurrogate(n2) && characterIterator.getIndex() > characterIterator.getBeginIndex()) {
            char c2 = characterIterator.previous();
            if (UTF16.isLeadSurrogate(c2)) {
                n3 = (c2 - 55296 << 10) + (n2 - 56320) + 65536;
            } else {
                characterIterator.next();
            }
        }
        return n3;
    }

    public static int current32(CharacterIterator characterIterator) {
        int n2 = characterIterator.current();
        int n3 = n2;
        if (n3 < 55296) {
            return n3;
        }
        if (UTF16.isLeadSurrogate(n2)) {
            char c2 = characterIterator.next();
            characterIterator.previous();
            if (UTF16.isTrailSurrogate(c2)) {
                n3 = (n2 - 55296 << 10) + (c2 - 56320) + 65536;
            }
        } else if (n2 == 65535 && characterIterator.getIndex() >= characterIterator.getEndIndex()) {
            n3 = Integer.MAX_VALUE;
        }
        return n3;
    }
}

