/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.text.CharacterIterator;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_16;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCaseProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCharacterProperty;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Edits;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class CaseMapImpl {
    public static final int TITLECASE_WHOLE_STRING = 32;
    public static final int TITLECASE_SENTENCES = 64;
    private static final int TITLECASE_ITERATOR_MASK = 224;
    public static final int TITLECASE_ADJUST_TO_CASED = 1024;
    private static final int TITLECASE_ADJUSTMENT_MASK = 1536;
    private static final char ACUTE = '\u0301';
    private static final int U_GC_M_MASK = 448;
    private static final int LNS = 251792942;
    public static final int OMIT_UNCHANGED_TEXT = 16384;
    private static final Trie2_16 CASE_TRIE = UCaseProps.getTrie();

    public static int addTitleAdjustmentOption(int n2, int n3) {
        int n4 = n2 & 0x600;
        if (n4 != 0 && n4 != n3) {
            throw new IllegalArgumentException("multiple titlecasing index adjustment options");
        }
        return n2 | n3;
    }

    private static boolean isLNS(int n2) {
        int n3 = UCharacterProperty.INSTANCE.getType(n2);
        return (1 << n3 & 0xF020E2E) != 0 || n3 == 4 && UCaseProps.INSTANCE.getType(n2) != 0;
    }

    public static int addTitleIteratorOption(int n2, int n3) {
        int n4 = n2 & 0xE0;
        if (n4 != 0 && n4 != n3) {
            throw new IllegalArgumentException("multiple titlecasing iterator options");
        }
        return n2 | n3;
    }

    public static BreakIterator getTitleBreakIterator(Locale locale, int n2, BreakIterator breakIterator) {
        if ((n2 &= 0xE0) != 0 && breakIterator != null) {
            throw new IllegalArgumentException("titlecasing iterator option together with an explicit iterator");
        }
        if (breakIterator == null) {
            switch (n2) {
                case 0: {
                    breakIterator = BreakIterator.getWordInstance(locale);
                    break;
                }
                case 32: {
                    breakIterator = new WholeStringBreakIterator();
                    break;
                }
                case 64: {
                    breakIterator = BreakIterator.getSentenceInstance(locale);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown titlecasing iterator option");
                }
            }
        }
        return breakIterator;
    }

    public static BreakIterator getTitleBreakIterator(ULocale uLocale, int n2, BreakIterator breakIterator) {
        if ((n2 &= 0xE0) != 0 && breakIterator != null) {
            throw new IllegalArgumentException("titlecasing iterator option together with an explicit iterator");
        }
        if (breakIterator == null) {
            switch (n2) {
                case 0: {
                    breakIterator = BreakIterator.getWordInstance(uLocale);
                    break;
                }
                case 32: {
                    breakIterator = new WholeStringBreakIterator();
                    break;
                }
                case 64: {
                    breakIterator = BreakIterator.getSentenceInstance(uLocale);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown titlecasing iterator option");
                }
            }
        }
        return breakIterator;
    }

    private static int appendCodePoint(Appendable appendable, int n2) throws IOException {
        if (n2 <= 65535) {
            appendable.append((char)n2);
            return 1;
        }
        appendable.append((char)(55232 + (n2 >> 10)));
        appendable.append((char)(56320 + (n2 & 0x3FF)));
        return 2;
    }

    private static void appendResult(int n2, Appendable appendable, int n3, int n4, Edits edits) throws IOException {
        if (n2 < 0) {
            if (edits != null) {
                edits.addUnchanged(n3);
            }
            if ((n4 & 0x4000) != 0) {
                return;
            }
            CaseMapImpl.appendCodePoint(appendable, ~n2);
        } else if (n2 <= 31) {
            if (edits != null) {
                edits.addReplace(n3, n2);
            }
        } else {
            int n5 = CaseMapImpl.appendCodePoint(appendable, n2);
            if (edits != null) {
                edits.addReplace(n3, n5);
            }
        }
    }

    private static final void appendUnchanged(CharSequence charSequence, int n2, int n3, Appendable appendable, int n4, Edits edits) throws IOException {
        if (n3 > 0) {
            if (edits != null) {
                edits.addUnchanged(n3);
            }
            if ((n4 & 0x4000) != 0) {
                return;
            }
            appendable.append(charSequence, n2, n2 + n3);
        }
    }

    private static String applyEdits(CharSequence charSequence, StringBuilder stringBuilder, Edits edits) {
        if (!edits.hasChanges()) {
            return charSequence.toString();
        }
        StringBuilder stringBuilder2 = new StringBuilder(charSequence.length() + edits.lengthDelta());
        Edits.Iterator iterator = edits.getCoarseIterator();
        while (iterator.next()) {
            int n2;
            if (iterator.hasChange()) {
                n2 = iterator.replacementIndex();
                stringBuilder2.append(stringBuilder, n2, n2 + iterator.newLength());
                continue;
            }
            n2 = iterator.sourceIndex();
            stringBuilder2.append(charSequence, n2, n2 + iterator.oldLength());
        }
        return stringBuilder2.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static void internalToLower(int var0, int var1_1, CharSequence var2_2, int var3_3, int var4_4, StringContextIterator var5_5, Appendable var6_6, Edits var7_7) throws IOException {
        var8_8 = var0 == 1 || (var0 >= 0 ? var0 != 2 && var0 != 3 : (var1_1 & 7) == 0) ? UCaseProps.LatinCase.TO_LOWER_NORMAL : UCaseProps.LatinCase.TO_LOWER_TR_LT;
        var9_9 = var3_3;
        var10_10 = var3_3;
        while (var10_10 < var4_4) {
            block10: {
                block11: {
                    block9: {
                        var11_11 = var2_2.charAt(var10_10);
                        if (var11_11 >= 383) break block9;
                        var13_13 = var8_8[var11_11];
                        if (var13_13 == '\uffffff80') break block10;
                        ++var10_10;
                        if (var13_13 == '\u0000') continue;
                        var12_12 = var13_13;
                        break block11;
                    }
                    if (var11_11 < 55296 && !UCaseProps.propsHasException(var13_13 = CaseMapImpl.CASE_TRIE.getFromU16SingleLead((char)var11_11))) {
                        ++var10_10;
                        if (!UCaseProps.isUpperOrTitleFromProps(var13_13) || (var12_12 = UCaseProps.getDelta(var13_13)) == 0) continue;
                    }
                    break block10;
                }
                var11_11 = (char)(var11_11 + var12_12);
                CaseMapImpl.appendUnchanged(var2_2, var9_9, var10_10 - 1 - var9_9, var6_6, var1_1, var7_7);
                var6_6.append((char)var11_11);
                if (var7_7 != null) {
                    var7_7.addReplace(1, 1);
                }
                var9_9 = var10_10;
                continue;
            }
            var12_12 = var10_10++;
            if (!Character.isHighSurrogate((char)var11_11) || var10_10 >= var4_4) ** GOTO lbl-1000
            v0 = var2_2.charAt(var10_10);
            var13_13 = v0;
            if (Character.isLowSurrogate(v0)) {
                var14_14 = Character.toCodePoint((char)var11_11, var13_13);
                ++var10_10;
            } else lbl-1000:
            // 2 sources

            {
                var14_14 = var11_11;
            }
            CaseMapImpl.appendUnchanged(var2_2, var9_9, var12_12 - var9_9, var6_6, var1_1, var7_7);
            var9_9 = var12_12;
            if (var0 >= 0) {
                if (var5_5 == null) {
                    var5_5 = new StringContextIterator(var2_2, var12_12, var10_10);
                } else {
                    var5_5.setCPStartAndLimit(var12_12, var10_10);
                }
                var14_14 = UCaseProps.INSTANCE.toFullLower(var14_14, var5_5, var6_6, var0);
            } else {
                var14_14 = UCaseProps.INSTANCE.toFullFolding(var14_14, var6_6, var1_1);
            }
            if (var14_14 < 0) continue;
            CaseMapImpl.appendResult(var14_14, var6_6, var10_10 - var12_12, var1_1, var7_7);
            var9_9 = var10_10;
        }
        CaseMapImpl.appendUnchanged(var2_2, var9_9, var10_10 - var9_9, var6_6, var1_1, var7_7);
    }

    /*
     * Unable to fully structure code
     */
    private static void internalToUpper(int var0, int var1_1, CharSequence var2_2, Appendable var3_3, Edits var4_4) throws IOException {
        var5_5 = null;
        var6_6 = var0 == 2 ? UCaseProps.LatinCase.TO_UPPER_TR : UCaseProps.LatinCase.TO_UPPER_NORMAL;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = var2_2.length();
        while (var8_8 < var9_9) {
            block8: {
                block9: {
                    block7: {
                        var10_10 = var2_2.charAt(var8_8);
                        if (var10_10 >= 383) break block7;
                        var12_12 = var6_6[var10_10];
                        if (var12_12 == '\uffffff80') break block8;
                        ++var8_8;
                        if (var12_12 == '\u0000') continue;
                        var11_11 = var12_12;
                        break block9;
                    }
                    if (var10_10 < 55296 && !UCaseProps.propsHasException(var12_12 = CaseMapImpl.CASE_TRIE.getFromU16SingleLead((char)var10_10))) {
                        ++var8_8;
                        if (UCaseProps.getTypeFromProps(var12_12) != 1 || (var11_11 = UCaseProps.getDelta(var12_12)) == 0) continue;
                    }
                    break block8;
                }
                var10_10 = (char)(var10_10 + var11_11);
                CaseMapImpl.appendUnchanged(var2_2, var7_7, var8_8 - 1 - var7_7, var3_3, var1_1, var4_4);
                var3_3.append((char)var10_10);
                if (var4_4 != null) {
                    var4_4.addReplace(1, 1);
                }
                var7_7 = var8_8;
                continue;
            }
            var11_11 = var8_8++;
            if (!Character.isHighSurrogate((char)var10_10) || var8_8 >= var9_9) ** GOTO lbl-1000
            v0 = var2_2.charAt(var8_8);
            var12_12 = v0;
            if (Character.isLowSurrogate(v0)) {
                var13_13 = Character.toCodePoint((char)var10_10, var12_12);
                ++var8_8;
            } else lbl-1000:
            // 2 sources

            {
                var13_13 = var10_10;
            }
            if (var5_5 == null) {
                var5_5 = new StringContextIterator(var2_2, var11_11, var8_8);
            } else {
                var5_5.setCPStartAndLimit(var11_11, var8_8);
            }
            CaseMapImpl.appendUnchanged(var2_2, var7_7, var11_11 - var7_7, var3_3, var1_1, var4_4);
            var7_7 = var11_11;
            if ((var13_13 = UCaseProps.INSTANCE.toFullUpper(var13_13, var5_5, var3_3, var0)) < 0) continue;
            CaseMapImpl.appendResult(var13_13, var3_3, var8_8 - var11_11, var1_1, var4_4);
            var7_7 = var8_8;
        }
        CaseMapImpl.appendUnchanged(var2_2, var7_7, var8_8 - var7_7, var3_3, var1_1, var4_4);
    }

    public static String toLower(int n2, int n3, CharSequence charSequence) {
        if (charSequence.length() <= 100 && (n3 & 0x4000) == 0) {
            if (charSequence.length() == 0) {
                return charSequence.toString();
            }
            Edits edits = new Edits();
            StringBuilder stringBuilder = CaseMapImpl.toLower(n2, n3 | 0x4000, charSequence, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(charSequence, stringBuilder, edits);
        }
        return CaseMapImpl.toLower(n2, n3, charSequence, new StringBuilder(charSequence.length()), null).toString();
    }

    public static <A extends Appendable> A toLower(int n2, int n3, CharSequence charSequence, A a2, Edits edits) {
        try {
            if (edits != null) {
                edits.reset();
            }
            CaseMapImpl.internalToLower(n2, n3, charSequence, 0, charSequence.length(), null, a2, edits);
            return a2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public static String toUpper(int n2, int n3, CharSequence charSequence) {
        if (charSequence.length() <= 100 && (n3 & 0x4000) == 0) {
            if (charSequence.length() == 0) {
                return charSequence.toString();
            }
            Edits edits = new Edits();
            StringBuilder stringBuilder = CaseMapImpl.toUpper(n2, n3 | 0x4000, charSequence, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(charSequence, stringBuilder, edits);
        }
        return CaseMapImpl.toUpper(n2, n3, charSequence, new StringBuilder(charSequence.length()), null).toString();
    }

    public static <A extends Appendable> A toUpper(int n2, int n3, CharSequence charSequence, A a2, Edits edits) {
        try {
            if (edits != null) {
                edits.reset();
            }
            if (n2 == 4) {
                return (A)GreekUpper.toUpper(n3, charSequence, a2, edits);
            }
            CaseMapImpl.internalToUpper(n2, n3, charSequence, a2, edits);
            return a2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public static String toTitle(int n2, int n3, BreakIterator breakIterator, CharSequence charSequence) {
        if (charSequence.length() <= 100 && (n3 & 0x4000) == 0) {
            if (charSequence.length() == 0) {
                return charSequence.toString();
            }
            Edits edits = new Edits();
            StringBuilder stringBuilder = CaseMapImpl.toTitle(n2, n3 | 0x4000, breakIterator, charSequence, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(charSequence, stringBuilder, edits);
        }
        return CaseMapImpl.toTitle(n2, n3, breakIterator, charSequence, new StringBuilder(charSequence.length()), null).toString();
    }

    public static <A extends Appendable> A toTitle(int n2, int n3, BreakIterator breakIterator, CharSequence charSequence, A a2, Edits edits) {
        try {
            if (edits != null) {
                edits.reset();
            }
            StringContextIterator stringContextIterator = new StringContextIterator(charSequence);
            int n4 = charSequence.length();
            int n5 = 0;
            boolean bl2 = true;
            while (n5 < n4) {
                int n6;
                if (bl2) {
                    bl2 = false;
                    n6 = breakIterator.first();
                } else {
                    n6 = breakIterator.next();
                }
                if (n6 == -1 || n6 > n4) {
                    n6 = n4;
                }
                if (n5 < n6) {
                    int n7;
                    int n8 = n5;
                    stringContextIterator.setLimit(n6);
                    int n9 = stringContextIterator.nextCaseMapCP();
                    if ((n3 & 0x200) == 0) {
                        int n10 = n7 = (n3 & 0x400) != 0 ? 1 : 0;
                        while ((n7 != 0 ? 0 == UCaseProps.INSTANCE.getType(n9) : !CaseMapImpl.isLNS(n9)) && (n9 = stringContextIterator.nextCaseMapCP()) >= 0) {
                        }
                        n8 = stringContextIterator.getCPStart();
                        if (n5 < n8) {
                            CaseMapImpl.appendUnchanged(charSequence, n5, n8 - n5, a2, n3, edits);
                        }
                    }
                    if (n8 < n6) {
                        n9 = UCaseProps.INSTANCE.toFullTitle(n9, stringContextIterator, a2, n2);
                        CaseMapImpl.appendResult(n9, a2, stringContextIterator.getCPLength(), n3, edits);
                        if (n8 + 1 < n6 && n2 == 5) {
                            if (n9 < 0) {
                                n9 ^= 0xFFFFFFFF;
                            }
                            if (n9 == 73 || n9 == 205) {
                                n7 = CaseMapImpl.maybeTitleDutchIJ(charSequence, n9, n8 + 1, n6, a2, n3, edits);
                                stringContextIterator.moveTo(n7);
                            } else {
                                n7 = stringContextIterator.getCPLimit();
                            }
                        } else {
                            n7 = stringContextIterator.getCPLimit();
                        }
                        if (n7 < n6) {
                            if ((n3 & 0x100) == 0) {
                                CaseMapImpl.internalToLower(n2, n3, charSequence, n7, n6, stringContextIterator, a2, edits);
                            } else {
                                CaseMapImpl.appendUnchanged(charSequence, n7, n6 - n7, a2, n3, edits);
                            }
                            stringContextIterator.moveToLimit();
                        }
                    }
                }
                n5 = n6;
            }
            return a2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    private static <A extends Appendable> int maybeTitleDutchIJ(CharSequence charSequence, int n2, int n3, int n4, A a2, int n5, Edits edits) throws IOException {
        int n6;
        int n7;
        assert (n3 < n4);
        int n8 = n3;
        boolean bl2 = false;
        int n9 = 0;
        boolean bl3 = false;
        int n10 = 0;
        char c2 = charSequence.charAt(n8++);
        if (n2 == 73) {
            if (c2 == '\u0301') {
                bl2 = true;
                n9 = 1;
                if (n8 == n4) {
                    return n3;
                }
                c2 = charSequence.charAt(n8++);
            }
        } else {
            bl2 = true;
        }
        if (c2 == 'j') {
            bl3 = true;
        } else if (c2 == 'J') {
            ++n9;
        } else {
            return n3;
        }
        if (bl2) {
            if (n8 == n4 || charSequence.charAt(n8++) != '\u0301') {
                return n3;
            }
            if (bl3) {
                n10 = 1;
            } else {
                ++n9;
            }
        }
        if (n8 < n4 && ((n7 = 1 << UCharacter.getType(n6 = Character.codePointAt(charSequence, n8))) & 0x1C0) != 0) {
            return n3;
        }
        CaseMapImpl.appendUnchanged(charSequence, n3, n9, a2, n5, edits);
        n3 += n9;
        if (bl3) {
            a2.append('J');
            if (edits != null) {
                edits.addReplace(1, 1);
            }
            ++n3;
        }
        CaseMapImpl.appendUnchanged(charSequence, n3, n10, a2, n5, edits);
        assert (n3 + n10 == n8);
        return n8;
    }

    public static String fold(int n2, CharSequence charSequence) {
        if (charSequence.length() <= 100 && (n2 & 0x4000) == 0) {
            if (charSequence.length() == 0) {
                return charSequence.toString();
            }
            Edits edits = new Edits();
            StringBuilder stringBuilder = CaseMapImpl.fold(n2 | 0x4000, charSequence, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(charSequence, stringBuilder, edits);
        }
        return CaseMapImpl.fold(n2, charSequence, new StringBuilder(charSequence.length()), null).toString();
    }

    public static <A extends Appendable> A fold(int n2, CharSequence charSequence, A a2, Edits edits) {
        try {
            if (edits != null) {
                edits.reset();
            }
            CaseMapImpl.internalToLower(-1, n2, charSequence, 0, charSequence.length(), null, a2, edits);
            return a2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    private static final class GreekUpper {
        private static final int UPPER_MASK = 1023;
        private static final int HAS_VOWEL = 4096;
        private static final int HAS_YPOGEGRAMMENI = 8192;
        private static final int HAS_ACCENT = 16384;
        private static final int HAS_DIALYTIKA = 32768;
        private static final int HAS_COMBINING_DIALYTIKA = 65536;
        private static final int HAS_OTHER_GREEK_DIACRITIC = 131072;
        private static final int HAS_VOWEL_AND_ACCENT = 20480;
        private static final int HAS_VOWEL_AND_ACCENT_AND_DIALYTIKA = 53248;
        private static final int HAS_EITHER_DIALYTIKA = 98304;
        private static final int AFTER_CASED = 1;
        private static final int AFTER_VOWEL_WITH_COMBINING_ACCENT = 2;
        private static final int AFTER_VOWEL_WITH_PRECOMPOSED_ACCENT = 4;
        private static final char[] data0370 = new char[]{'\u0370', '\u0370', '\u0372', '\u0372', '\u0000', '\u0000', '\u0376', '\u0376', '\u0000', '\u0000', '\u037a', '\u03fd', '\u03fe', '\u03ff', '\u0000', '\u037f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u5391', '\u0000', '\u5395', '\u5397', '\u5399', '\u0000', '\u539f', '\u0000', '\u53a5', '\u53a9', '\ud399', '\u1391', '\u0392', '\u0393', '\u0394', '\u1395', '\u0396', '\u1397', '\u0398', '\u1399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u139f', '\u03a0', '\u03a1', '\u0000', '\u03a3', '\u03a4', '\u13a5', '\u03a6', '\u03a7', '\u03a8', '\u13a9', '\u9399', '\u93a5', '\u5391', '\u5395', '\u5397', '\u5399', '\ud3a5', '\u1391', '\u0392', '\u0393', '\u0394', '\u1395', '\u0396', '\u1397', '\u0398', '\u1399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u139f', '\u03a0', '\u03a1', '\u03a3', '\u03a3', '\u03a4', '\u13a5', '\u03a6', '\u03a7', '\u03a8', '\u13a9', '\u9399', '\u93a5', '\u539f', '\u53a5', '\u53a9', '\u03cf', '\u0392', '\u0398', '\u03d2', '\u43d2', '\u83d2', '\u03a6', '\u03a0', '\u03cf', '\u03d8', '\u03d8', '\u03da', '\u03da', '\u03dc', '\u03dc', '\u03de', '\u03de', '\u03e0', '\u03e0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u039a', '\u03a1', '\u03f9', '\u037f', '\u03f4', '\u1395', '\u0000', '\u03f7', '\u03f7', '\u03f9', '\u03fa', '\u03fa', '\u03fc', '\u03fd', '\u03fe', '\u03ff'};
        private static final char[] data1F00 = new char[]{'\u1391', '\u1391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u1391', '\u1391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u1395', '\u1395', '\u5395', '\u5395', '\u5395', '\u5395', '\u0000', '\u0000', '\u1395', '\u1395', '\u5395', '\u5395', '\u5395', '\u5395', '\u0000', '\u0000', '\u1397', '\u1397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u1397', '\u1397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u1399', '\u1399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u1399', '\u1399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u139f', '\u139f', '\u539f', '\u539f', '\u539f', '\u539f', '\u0000', '\u0000', '\u139f', '\u139f', '\u539f', '\u539f', '\u539f', '\u539f', '\u0000', '\u0000', '\u13a5', '\u13a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u0000', '\u13a5', '\u0000', '\u53a5', '\u0000', '\u53a5', '\u0000', '\u53a5', '\u13a9', '\u13a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u13a9', '\u13a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u5391', '\u5391', '\u5395', '\u5395', '\u5397', '\u5397', '\u5399', '\u5399', '\u539f', '\u539f', '\u53a5', '\u53a5', '\u53a9', '\u53a9', '\u0000', '\u0000', '\u3391', '\u3391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u3391', '\u3391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u3397', '\u3397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u3397', '\u3397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u33a9', '\u33a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u33a9', '\u33a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u1391', '\u1391', '\u7391', '\u3391', '\u7391', '\u0000', '\u5391', '\u7391', '\u1391', '\u1391', '\u5391', '\u5391', '\u3391', '\u0000', '\u1399', '\u0000', '\u0000', '\u0000', '\u7397', '\u3397', '\u7397', '\u0000', '\u5397', '\u7397', '\u5395', '\u5395', '\u5397', '\u5397', '\u3397', '\u0000', '\u0000', '\u0000', '\u1399', '\u1399', '\ud399', '\ud399', '\u0000', '\u0000', '\u5399', '\ud399', '\u1399', '\u1399', '\u5399', '\u5399', '\u0000', '\u0000', '\u0000', '\u0000', '\u13a5', '\u13a5', '\ud3a5', '\ud3a5', '\u03a1', '\u03a1', '\u53a5', '\ud3a5', '\u13a5', '\u13a5', '\u53a5', '\u53a5', '\u03a1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u73a9', '\u33a9', '\u73a9', '\u0000', '\u53a9', '\u73a9', '\u539f', '\u539f', '\u53a9', '\u53a9', '\u33a9', '\u0000', '\u0000', '\u0000'};
        private static final char data2126 = '\u13a9';

        private GreekUpper() {
        }

        private static final int getLetterData(int n2) {
            if (n2 < 880 || 8486 < n2 || 1023 < n2 && n2 < 7936) {
                return 0;
            }
            if (n2 <= 1023) {
                return data0370[n2 - 880];
            }
            if (n2 <= 8191) {
                return data1F00[n2 - 7936];
            }
            if (n2 == 8486) {
                return 5033;
            }
            return 0;
        }

        private static final int getDiacriticData(int n2) {
            switch (n2) {
                case 768: 
                case 769: 
                case 770: 
                case 771: 
                case 785: 
                case 834: {
                    return 16384;
                }
                case 776: {
                    return 65536;
                }
                case 836: {
                    return 81920;
                }
                case 837: {
                    return 8192;
                }
                case 772: 
                case 774: 
                case 787: 
                case 788: 
                case 835: {
                    return 131072;
                }
            }
            return 0;
        }

        private static boolean isFollowedByCasedLetter(CharSequence charSequence, int n2) {
            while (n2 < charSequence.length()) {
                int n3 = Character.codePointAt(charSequence, n2);
                int n4 = UCaseProps.INSTANCE.getTypeOrIgnorable(n3);
                if ((n4 & 4) != 0) {
                    n2 += Character.charCount(n3);
                    continue;
                }
                return n4 != 0;
            }
            return false;
        }

        private static <A extends Appendable> A toUpper(int n2, CharSequence charSequence, A a2, Edits edits) throws IOException {
            int n3 = 0;
            int n4 = 0;
            while (n4 < charSequence.length()) {
                int n5 = Character.codePointAt(charSequence, n4);
                int n6 = n4 + Character.charCount(n5);
                int n7 = 0;
                int n8 = UCaseProps.INSTANCE.getTypeOrIgnorable(n5);
                if ((n8 & 4) != 0) {
                    n7 |= n3 & true;
                } else if (n8 != 0) {
                    n7 |= 1;
                }
                int n9 = GreekUpper.getLetterData(n5);
                if (n9 > 0) {
                    boolean bl2;
                    int n10;
                    boolean bl3;
                    int n11 = n9 & 0x3FF;
                    if ((n9 & 0x1000) != 0 && (n3 & 6) != 0 && (n11 == 921 || n11 == 933)) {
                        n9 |= (n3 & 4) != 0 ? 32768 : 65536;
                    }
                    int n12 = 0;
                    if ((n9 & 0x2000) != 0) {
                        n12 = 1;
                    }
                    boolean bl4 = bl3 = (n9 & 0x4000) != 0;
                    while (n6 < charSequence.length() && (n10 = GreekUpper.getDiacriticData(charSequence.charAt(n6))) != 0) {
                        n9 |= n10;
                        if ((n10 & 0x2000) != 0) {
                            ++n12;
                        }
                        ++n6;
                    }
                    if ((n9 & 0xD000) == 20480) {
                        n7 |= bl3 ? 4 : 2;
                    }
                    n10 = 0;
                    if (n11 == 919 && (n9 & 0x4000) != 0 && n12 == 0 && (n3 & 1) == 0 && !GreekUpper.isFollowedByCasedLetter(charSequence, n6)) {
                        if (bl3) {
                            n11 = 905;
                        } else {
                            n10 = 1;
                        }
                    } else if ((n9 & 0x8000) != 0) {
                        if (n11 == 921) {
                            n11 = 938;
                            n9 &= 0xFFFE7FFF;
                        } else if (n11 == 933) {
                            n11 = 939;
                            n9 &= 0xFFFE7FFF;
                        }
                    }
                    if (edits == null && (n2 & 0x4000) == 0) {
                        bl2 = true;
                    } else {
                        int n13;
                        int n14;
                        bl2 = charSequence.charAt(n4) != n11 || n12 > 0;
                        int n15 = n4 + 1;
                        if ((n9 & 0x18000) != 0) {
                            bl2 |= n15 >= n6 || charSequence.charAt(n15) != '\u0308';
                            ++n15;
                        }
                        if (n10 != 0) {
                            bl2 |= n15 >= n6 || charSequence.charAt(n15) != '\u0301';
                            ++n15;
                        }
                        if (bl2 |= (n14 = n6 - n4) != (n13 = n15 - n4 + n12)) {
                            if (edits != null) {
                                edits.addReplace(n14, n13);
                            }
                        } else {
                            if (edits != null) {
                                edits.addUnchanged(n14);
                            }
                            boolean bl5 = bl2 = (n2 & 0x4000) == 0;
                        }
                    }
                    if (bl2) {
                        a2.append((char)n11);
                        if ((n9 & 0x18000) != 0) {
                            a2.append('\u0308');
                        }
                        if (n10 != 0) {
                            a2.append('\u0301');
                        }
                        while (n12 > 0) {
                            a2.append('\u0399');
                            --n12;
                        }
                    }
                } else {
                    n5 = UCaseProps.INSTANCE.toFullUpper(n5, null, a2, 4);
                    CaseMapImpl.appendResult(n5, a2, n6 - n4, n2, edits);
                }
                n4 = n6;
                n3 = n7;
            }
            return a2;
        }
    }

    private static final class WholeStringBreakIterator
    extends BreakIterator {
        private int length;

        private WholeStringBreakIterator() {
        }

        private static void notImplemented() {
            throw new UnsupportedOperationException("should not occur");
        }

        @Override
        public int first() {
            return 0;
        }

        @Override
        public int last() {
            WholeStringBreakIterator.notImplemented();
            return 0;
        }

        @Override
        public int next(int n2) {
            WholeStringBreakIterator.notImplemented();
            return 0;
        }

        @Override
        public int next() {
            return this.length;
        }

        @Override
        public int previous() {
            WholeStringBreakIterator.notImplemented();
            return 0;
        }

        @Override
        public int following(int n2) {
            WholeStringBreakIterator.notImplemented();
            return 0;
        }

        @Override
        public int current() {
            WholeStringBreakIterator.notImplemented();
            return 0;
        }

        @Override
        public CharacterIterator getText() {
            WholeStringBreakIterator.notImplemented();
            return null;
        }

        @Override
        public void setText(CharacterIterator characterIterator) {
            this.length = characterIterator.getEndIndex();
        }

        @Override
        public void setText(CharSequence charSequence) {
            this.length = charSequence.length();
        }

        @Override
        public void setText(String string) {
            this.length = string.length();
        }
    }

    public static final class StringContextIterator
    implements UCaseProps.ContextIterator {
        protected CharSequence s;
        protected int index;
        protected int limit;
        protected int cpStart;
        protected int cpLimit;
        protected int dir;

        public StringContextIterator(CharSequence charSequence) {
            this.s = charSequence;
            this.limit = charSequence.length();
            this.index = 0;
            this.cpLimit = 0;
            this.cpStart = 0;
            this.dir = 0;
        }

        public StringContextIterator(CharSequence charSequence, int n2, int n3) {
            this.s = charSequence;
            this.index = 0;
            this.limit = charSequence.length();
            this.cpStart = n2;
            this.cpLimit = n3;
            this.dir = 0;
        }

        public void setLimit(int n2) {
            this.limit = 0 <= n2 && n2 <= this.s.length() ? n2 : this.s.length();
        }

        public void moveToLimit() {
            this.cpStart = this.cpLimit = this.limit;
        }

        public void moveTo(int n2) {
            this.cpStart = this.cpLimit = n2;
        }

        public int nextCaseMapCP() {
            this.cpStart = this.cpLimit;
            if (this.cpLimit < this.limit) {
                int n2 = Character.codePointAt(this.s, this.cpLimit);
                this.cpLimit += Character.charCount(n2);
                return n2;
            }
            return -1;
        }

        public void setCPStartAndLimit(int n2, int n3) {
            this.cpStart = n2;
            this.cpLimit = n3;
            this.dir = 0;
        }

        public int getCPStart() {
            return this.cpStart;
        }

        public int getCPLimit() {
            return this.cpLimit;
        }

        public int getCPLength() {
            return this.cpLimit - this.cpStart;
        }

        @Override
        public void reset(int n2) {
            if (n2 > 0) {
                this.dir = 1;
                this.index = this.cpLimit;
            } else if (n2 < 0) {
                this.dir = -1;
                this.index = this.cpStart;
            } else {
                this.dir = 0;
                this.index = 0;
            }
        }

        @Override
        public int next() {
            if (this.dir > 0 && this.index < this.s.length()) {
                int n2 = Character.codePointAt(this.s, this.index);
                this.index += Character.charCount(n2);
                return n2;
            }
            if (this.dir < 0 && this.index > 0) {
                int n3 = Character.codePointBefore(this.s, this.index);
                this.index -= Character.charCount(n3);
                return n3;
            }
            return -1;
        }
    }
}

