/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;

public abstract class CacheValue<V> {
    private static volatile Strength strength = Strength.SOFT;
    private static final CacheValue NULL_VALUE = new NullValue();

    public static void setStrength(Strength strength) {
        CacheValue.strength = strength;
    }

    public static boolean futureInstancesWillBeStrong() {
        return strength == Strength.STRONG;
    }

    public static <V> CacheValue<V> getInstance(V v2) {
        if (v2 == null) {
            return NULL_VALUE;
        }
        return strength == Strength.STRONG ? new StrongValue<V>(v2) : new SoftValue<V>(v2);
    }

    public boolean isNull() {
        return false;
    }

    public abstract V get();

    public abstract V resetIfCleared(V var1);

    private static final class SoftValue<V>
    extends CacheValue<V> {
        private volatile Reference<V> ref;

        SoftValue(V v2) {
            this.ref = new SoftReference<V>(v2);
        }

        @Override
        public V get() {
            return this.ref.get();
        }

        @Override
        public synchronized V resetIfCleared(V v2) {
            V v3 = this.ref.get();
            if (v3 == null) {
                this.ref = new SoftReference<V>(v2);
                return v2;
            }
            return v3;
        }
    }

    private static final class StrongValue<V>
    extends CacheValue<V> {
        private V value;

        StrongValue(V v2) {
            this.value = v2;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V resetIfCleared(V v2) {
            return this.value;
        }
    }

    private static final class NullValue<V>
    extends CacheValue<V> {
        private NullValue() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public V resetIfCleared(V v2) {
            if (v2 != null) {
                throw new ICUException("resetting a null value to a non-null value");
            }
            return null;
        }
    }

    public static enum Strength {
        STRONG,
        SOFT;

    }
}

