/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterStaticData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.InvalidFormatException;

final class UConverterDataReader {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private int posAfterStaticData;
    private ByteBuffer byteBuffer;
    private static final int DATA_FORMAT_ID = 1668183668;

    protected UConverterDataReader(ByteBuffer byteBuffer) throws IOException {
        this.byteBuffer = byteBuffer;
        ICUBinary.readHeader(this.byteBuffer, 1668183668, IS_ACCEPTABLE);
    }

    protected void readStaticData(UConverterStaticData uConverterStaticData) throws IOException {
        uConverterStaticData.structSize = this.byteBuffer.getInt();
        byte[] byArray = new byte[60];
        this.byteBuffer.get(byArray);
        uConverterStaticData.name = new String(byArray, "US-ASCII");
        uConverterStaticData.codepage = this.byteBuffer.getInt();
        uConverterStaticData.platform = this.byteBuffer.get();
        uConverterStaticData.conversionType = this.byteBuffer.get();
        uConverterStaticData.minBytesPerChar = this.byteBuffer.get();
        uConverterStaticData.maxBytesPerChar = this.byteBuffer.get();
        this.byteBuffer.get(uConverterStaticData.subChar);
        uConverterStaticData.subCharLen = this.byteBuffer.get();
        uConverterStaticData.hasToUnicodeFallback = this.byteBuffer.get();
        uConverterStaticData.hasFromUnicodeFallback = this.byteBuffer.get();
        uConverterStaticData.unicodeMask = (short)(this.byteBuffer.get() & 0xFF);
        uConverterStaticData.subChar1 = this.byteBuffer.get();
        this.byteBuffer.get(uConverterStaticData.reserved);
        this.posAfterStaticData = this.byteBuffer.position();
    }

    int bytesReadAfterStaticData() {
        return this.byteBuffer.position() - this.posAfterStaticData;
    }

    protected void readMBCSHeader(CharsetMBCS.MBCSHeader mBCSHeader) throws IOException {
        this.byteBuffer.get(mBCSHeader.version);
        mBCSHeader.countStates = this.byteBuffer.getInt();
        mBCSHeader.countToUFallbacks = this.byteBuffer.getInt();
        mBCSHeader.offsetToUCodeUnits = this.byteBuffer.getInt();
        mBCSHeader.offsetFromUTable = this.byteBuffer.getInt();
        mBCSHeader.offsetFromUBytes = this.byteBuffer.getInt();
        mBCSHeader.flags = this.byteBuffer.getInt();
        mBCSHeader.fromUBytesLength = this.byteBuffer.getInt();
        if (mBCSHeader.version[0] == 5 && mBCSHeader.version[1] >= 3) {
            mBCSHeader.options = this.byteBuffer.getInt();
            if ((mBCSHeader.options & 0x40) != 0) {
                mBCSHeader.fullStage2Length = this.byteBuffer.getInt();
            }
        }
    }

    protected void readMBCSTable(CharsetMBCS.MBCSHeader mBCSHeader, CharsetMBCS.UConverterMBCSTable uConverterMBCSTable) throws IOException {
        block13: {
            block12: {
                boolean bl2;
                int n2;
                int n3;
                IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
                uConverterMBCSTable.countStates = (byte)mBCSHeader.countStates;
                uConverterMBCSTable.stateTable = new int[mBCSHeader.countStates][256];
                for (n3 = 0; n3 < mBCSHeader.countStates; ++n3) {
                    intBuffer.get(uConverterMBCSTable.stateTable[n3]);
                }
                uConverterMBCSTable.countToUFallbacks = mBCSHeader.countToUFallbacks;
                uConverterMBCSTable.toUFallbacks = new CharsetMBCS.MBCSToUFallback[mBCSHeader.countToUFallbacks];
                for (n3 = 0; n3 < mBCSHeader.countToUFallbacks; ++n3) {
                    n2 = intBuffer.get();
                    int n4 = intBuffer.get();
                    uConverterMBCSTable.toUFallbacks[n3] = new CharsetMBCS.MBCSToUFallback(n2, n4);
                }
                n2 = intBuffer.position() * 4;
                ICUBinary.skipBytes(this.byteBuffer, n2);
                CharBuffer charBuffer = this.byteBuffer.asCharBuffer();
                n2 = mBCSHeader.offsetFromUTable - mBCSHeader.offsetToUCodeUnits;
                assert ((n2 & 1) == 0);
                uConverterMBCSTable.unicodeCodeUnits = new char[n2 / 2];
                charBuffer.get(uConverterMBCSTable.unicodeCodeUnits);
                ICUBinary.skipBytes(this.byteBuffer, n2);
                n2 = mBCSHeader.offsetFromUBytes - mBCSHeader.offsetFromUTable;
                assert ((n2 & 1) == 0);
                int n5 = uConverterMBCSTable.outputType == 0 ? n2 / 2 : (uConverterMBCSTable.hasSupplementary() ? 1088 : 64);
                uConverterMBCSTable.fromUnicodeTable = new char[n5];
                charBuffer.get(uConverterMBCSTable.fromUnicodeTable);
                if (uConverterMBCSTable.outputType != 0) {
                    assert ((n2 & 3) == 0);
                    uConverterMBCSTable.fromUnicodeTableInts = new int[n2 / 4];
                    this.byteBuffer.asIntBuffer().get(uConverterMBCSTable.fromUnicodeTableInts);
                }
                ICUBinary.skipBytes(this.byteBuffer, n2);
                uConverterMBCSTable.fromUBytesLength = mBCSHeader.fromUBytesLength;
                boolean bl3 = bl2 = (mBCSHeader.options & 0x40) != 0;
                if (bl2) break block12;
                switch (uConverterMBCSTable.outputType) {
                    case 0: 
                    case 1: 
                    case 8: 
                    case 12: {
                        uConverterMBCSTable.fromUnicodeChars = ICUBinary.getChars(this.byteBuffer, mBCSHeader.fromUBytesLength / 2, 0);
                        break block13;
                    }
                    case 2: 
                    case 9: {
                        uConverterMBCSTable.fromUnicodeBytes = new byte[mBCSHeader.fromUBytesLength];
                        this.byteBuffer.get(uConverterMBCSTable.fromUnicodeBytes);
                        break block13;
                    }
                    case 3: {
                        uConverterMBCSTable.fromUnicodeInts = ICUBinary.getInts(this.byteBuffer, mBCSHeader.fromUBytesLength / 4, 0);
                        break block13;
                    }
                    default: {
                        assert (false);
                        break block13;
                    }
                }
            }
            uConverterMBCSTable.mbcsIndex = this.byteBuffer.asCharBuffer();
        }
    }

    protected String readBaseTableName() throws IOException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((c2 = (char)this.byteBuffer.get()) != '\u0000') {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    protected ByteBuffer readExtIndexes(int n2) throws IOException, InvalidFormatException {
        ICUBinary.skipBytes(this.byteBuffer, n2);
        ByteBuffer byteBuffer = ICUBinary.sliceWithOrder(this.byteBuffer);
        int n3 = byteBuffer.getInt(0);
        if (n3 < 32) {
            throw new InvalidFormatException();
        }
        int n4 = byteBuffer.getInt(124);
        byteBuffer.limit(n4);
        ICUBinary.skipBytes(this.byteBuffer, n4);
        return byteBuffer;
    }

    boolean dataFormatHasUnicodeMask() {
        int n2 = this.byteBuffer.get(16) & 0xFF;
        return n2 > 6 || n2 == 6 && this.byteBuffer.get(17) != 0;
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 6;
        }
    }
}

