/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32BE;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32LE;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetUTF32
extends CharsetICU {
    private static final int SIGNATURE_LENGTH = 4;
    private static final byte[] fromUSubstitution_BE = new byte[]{0, 0, -1, -3};
    private static final byte[] fromUSubstitution_LE = new byte[]{-3, -1, 0, 0};
    private static final byte[] BOM_BE = new byte[]{0, 0, -2, -1};
    private static final byte[] BOM_LE = new byte[]{-1, -2, 0, 0};
    private static final int ENDIAN_XOR_BE = 0;
    private static final int ENDIAN_XOR_LE = 3;
    private static final int NEED_TO_WRITE_BOM = 1;
    private boolean isEndianSpecified = this instanceof CharsetUTF32BE || this instanceof CharsetUTF32LE;
    private boolean isBigEndian;
    private int endianXOR;
    private byte[] bom;
    private byte[] fromUSubstitution;

    public CharsetUTF32(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        boolean bl2 = this.isBigEndian = !(this instanceof CharsetUTF32LE);
        if (this.isBigEndian) {
            this.bom = BOM_BE;
            this.fromUSubstitution = fromUSubstitution_BE;
            this.endianXOR = 0;
        } else {
            this.bom = BOM_LE;
            this.fromUSubstitution = fromUSubstitution_LE;
            this.endianXOR = 3;
        }
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 4;
        this.maxCharsPerByte = 1.0f;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF32(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF32(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        CharsetUTF32.getNonSurrogateUnicodeSet(unicodeSet);
    }

    class CharsetEncoderUTF32
    extends CharsetEncoderICU {
        private final byte[] temp;

        public CharsetEncoderUTF32(CharsetICU charsetICU) {
            super(charsetICU, CharsetUTF32.this.fromUSubstitution);
            this.temp = new byte[4];
            this.fromUnicodeStatus = CharsetUTF32.this.isEndianSpecified ? 0 : 1;
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = CharsetUTF32.this.isEndianSpecified ? 0 : 1;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult;
            if (this.fromUnicodeStatus == 1) {
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                this.fromUnicodeStatus = 0;
                coderResult = CharsetEncoderUTF32.fromUWriteBytes(this, CharsetUTF32.this.bom, 0, CharsetUTF32.this.bom.length, byteBuffer, intBuffer, -1);
                if (coderResult.isOverflow()) {
                    return coderResult;
                }
            }
            if (this.fromUChar32 != 0) {
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                coderResult = this.encodeChar(charBuffer, byteBuffer, intBuffer, (char)this.fromUChar32);
                if (coderResult != null) {
                    return coderResult;
                }
            }
            do {
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (byteBuffer.hasRemaining()) continue;
                return CoderResult.OVERFLOW;
            } while ((coderResult = this.encodeChar(charBuffer, byteBuffer, intBuffer, charBuffer.get())) == null);
            return coderResult;
        }

        private final CoderResult encodeChar(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, char n2) {
            int n3;
            CoderResult coderResult;
            int n4 = charBuffer.position() - 1;
            if (UTF16.isSurrogate(n2)) {
                coderResult = this.handleSurrogates(charBuffer, (char)n2);
                if (coderResult != null) {
                    return coderResult;
                }
                n3 = this.fromUChar32;
                this.fromUChar32 = 0;
            } else {
                n3 = n2;
            }
            this.temp[1 ^ ((CharsetUTF32)CharsetUTF32.this).endianXOR] = (byte)(n3 >>> 16);
            this.temp[2 ^ ((CharsetUTF32)CharsetUTF32.this).endianXOR] = (byte)(n3 >>> 8);
            this.temp[3 ^ ((CharsetUTF32)CharsetUTF32.this).endianXOR] = (byte)n3;
            coderResult = CharsetEncoderUTF32.fromUWriteBytes(this, this.temp, 0, 4, byteBuffer, intBuffer, n4);
            return coderResult.isUnderflow() ? null : coderResult;
        }
    }

    class CharsetDecoderUTF32
    extends CharsetDecoderICU {
        private boolean isBOMReadYet;
        private int actualEndianXOR;
        private byte[] actualBOM;

        public CharsetDecoderUTF32(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.isBOMReadYet = false;
            this.actualBOM = null;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            block14: {
                int n2;
                if (!this.isBOMReadYet) {
                    block13: {
                        while (true) {
                            if (!byteBuffer.hasRemaining()) {
                                return CoderResult.UNDERFLOW;
                            }
                            this.toUBytesArray[this.toULength++] = byteBuffer.get();
                            if (this.toULength == 1) {
                                if ((!CharsetUTF32.this.isEndianSpecified || CharsetUTF32.this.isBigEndian) && this.toUBytesArray[this.toULength - 1] == BOM_BE[this.toULength - 1]) {
                                    this.actualBOM = BOM_BE;
                                    this.actualEndianXOR = 0;
                                    continue;
                                }
                                if (!(CharsetUTF32.this.isEndianSpecified && CharsetUTF32.this.isBigEndian || this.toUBytesArray[this.toULength - 1] != BOM_LE[this.toULength - 1])) {
                                    this.actualBOM = BOM_LE;
                                    this.actualEndianXOR = 3;
                                    continue;
                                }
                                this.actualBOM = null;
                                this.actualEndianXOR = CharsetUTF32.this.endianXOR;
                                break block13;
                            }
                            if (this.toUBytesArray[this.toULength - 1] != this.actualBOM[this.toULength - 1]) {
                                this.actualBOM = null;
                                this.actualEndianXOR = CharsetUTF32.this.endianXOR;
                                break block13;
                            }
                            if (this.toULength == 4) break;
                        }
                        this.toULength = 0;
                    }
                    this.isBOMReadYet = true;
                }
                while (true) {
                    if (this.toULength < 4) {
                        if (!byteBuffer.hasRemaining()) {
                            return CoderResult.UNDERFLOW;
                        }
                        this.toUBytesArray[this.toULength++] = byteBuffer.get();
                        continue;
                    }
                    if (!charBuffer.hasRemaining()) {
                        return CoderResult.OVERFLOW;
                    }
                    n2 = 0;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        n2 = n2 << 8 | this.toUBytesArray[i2 ^ this.actualEndianXOR] & 0xFF;
                    }
                    if (0 > n2 || n2 > 0x10FFFF || CharsetICU.isSurrogate(n2)) break block14;
                    this.toULength = 0;
                    if (n2 <= 65535) {
                        charBuffer.put((char)n2);
                        continue;
                    }
                    charBuffer.put(UTF16.getLeadSurrogate(n2));
                    n2 = UTF16.getTrailSurrogate(n2);
                    if (!charBuffer.hasRemaining()) break;
                    charBuffer.put((char)n2);
                }
                this.charErrorBufferArray[0] = (char)n2;
                this.charErrorBufferLength = 1;
                return CoderResult.OVERFLOW;
            }
            return CoderResult.malformedForLength(this.toULength);
        }
    }
}

