/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetSCSU
extends CharsetICU {
    private static final short SQ0 = 1;
    private static final short SQ7 = 8;
    private static final short SDX = 11;
    private static final short SQU = 14;
    private static final short SCU = 15;
    private static final short SC0 = 16;
    private static final short SC7 = 23;
    private static final short SD0 = 24;
    private static final short UC0 = 224;
    private static final short UC7 = 231;
    private static final short UD0 = 232;
    private static final short UD7 = 239;
    private static final short UQU = 240;
    private static final short UDX = 241;
    private static final short Urs = 242;
    private static final int gapThreshold = 104;
    private static final int gapOffset = 44032;
    private static final int reservedStart = 168;
    private static final int fixedThreshold = 249;
    protected byte[] fromUSubstitution = new byte[]{14, -1, -3};
    private static final int[] staticOffsets = new int[]{0, 128, 256, 768, 8192, 8320, 8448, 12288};
    private static final int[] initialDynamicOffsets = new int[]{128, 192, 1024, 1536, 2304, 12352, 12448, 65280};
    private static final int[] fixedOffsets = new int[]{192, 592, 880, 1328, 12352, 12448, 65376};
    private static final int readCommand = 0;
    private static final int quotePairOne = 1;
    private static final int quotePairTwo = 2;
    private static final int quoteOne = 3;
    private static final int definePairOne = 4;
    private static final int definePairTwo = 5;
    private static final int defineOne = 6;
    static final byte[] initialWindowUse = new byte[]{7, 0, 3, 2, 4, 5, 6, 1};
    private SCSUData extraInfo = null;

    public CharsetSCSU(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.extraInfo = new SCSUData();
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderSCSU(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderSCSU(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        CharsetICU.getCompleteUnicodeSet(unicodeSet);
    }

    class CharsetEncoderSCSU
    extends CharsetEncoderICU {
        private static final int Loop = 0;
        private static final int GetTrailUnicode = 1;
        private static final int OutputBytes = 2;
        private static final int EndLoop = 3;
        private int delta;
        private int length;
        private int offset;
        private char lead;
        private char trail;
        private int code;
        private byte window;
        private boolean isSingleByteMode;
        private byte dynamicWindow;
        private int currentOffset;
        int c;
        SCSUData data;
        private int sourceIndex;
        private int nextSourceIndex;
        private int targetCapacity;
        private boolean LabelLoop;
        private boolean AfterGetTrail;
        private boolean AfterGetTrailUnicode;
        CoderResult cr;

        public CharsetEncoderSCSU(CharsetICU charsetICU) {
            super(charsetICU, CharsetSCSU.this.fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetSCSU.this.extraInfo.initialize();
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            this.data = CharsetSCSU.this.extraInfo;
            this.cr = CoderResult.UNDERFLOW;
            this.isSingleByteMode = this.data.fromUIsSingleByteMode;
            this.dynamicWindow = this.data.fromUDynamicWindow;
            this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
            this.c = this.fromUChar32;
            this.sourceIndex = this.c == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            this.targetCapacity = byteBuffer.limit() - byteBuffer.position();
            this.sourceIndex = this.c == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            int n2 = 0;
            this.LabelLoop = true;
            this.AfterGetTrail = false;
            this.AfterGetTrailUnicode = false;
            while (this.LabelLoop) {
                switch (n2) {
                    case 0: {
                        n2 = this.loop(charBuffer, byteBuffer, intBuffer);
                        break;
                    }
                    case 1: {
                        n2 = this.getTrailUnicode(charBuffer, byteBuffer, intBuffer);
                        break;
                    }
                    case 2: {
                        n2 = this.outputBytes(charBuffer, byteBuffer, intBuffer);
                        break;
                    }
                    case 3: {
                        this.endLoop(charBuffer, byteBuffer, intBuffer);
                    }
                }
            }
            return this.cr;
        }

        private byte getWindow(int[] nArray) {
            for (int i2 = 0; i2 < 8; ++i2) {
                if (((long)(this.c - nArray[i2]) & 0xFFFFFFFFL) > 127L) continue;
                return (byte)i2;
            }
            return -1;
        }

        private boolean isInOffsetWindowOrDirect(int n2, int n3) {
            return ((long)n3 & 0xFFFFFFFFL) <= ((long)n2 & 0xFFFFFFFFL) + 127L & (((long)n3 & 0xFFFFFFFFL) >= ((long)n2 & 0xFFFFFFFFL) || ((long)n3 & 0xFFFFFFFFL) <= 127L && (((long)n3 & 0xFFFFFFFFL) >= 32L || (1L << (int)((long)n3 & 0xFFFFFFFFL) & 0x2601L) != 0L));
        }

        private byte getNextDynamicWindow() {
            byte by2 = this.data.windowUse[this.data.nextWindowUseIndex];
            this.data.nextWindowUseIndex = (byte)(this.data.nextWindowUseIndex + 1);
            if (this.data.nextWindowUseIndex == 8) {
                this.data.nextWindowUseIndex = 0;
            }
            return by2;
        }

        private void useDynamicWindow(byte by2) {
            int n2 = this.data.nextWindowUseIndex;
            do {
                if (--n2 >= 0) continue;
                n2 = 7;
            } while (this.data.windowUse[n2] != by2);
            int n3 = n2 + 1;
            if (n3 == 8) {
                n3 = 0;
            }
            while (n3 != this.data.nextWindowUseIndex) {
                this.data.windowUse[n2] = this.data.windowUse[n3];
                n2 = n3++;
                if (n3 != 8) continue;
                n3 = 0;
            }
            this.data.windowUse[n2] = by2;
        }

        private int getDynamicOffset() {
            for (int i2 = 0; i2 < 7; ++i2) {
                if (((long)(this.c - fixedOffsets[i2]) & 0xFFFFFFFFL) > 127L) continue;
                this.offset = fixedOffsets[i2];
                return 249 + i2;
            }
            if (((long)this.c & 0xFFFFFFFFL) < 128L) {
                return -1;
            }
            if (((long)this.c & 0xFFFFFFFFL) < 13312L || ((long)(this.c - 65536) & 0xFFFFFFFFL) < 16384L || ((long)(this.c - 118784) & 0xFFFFFFFFL) <= 12287L) {
                this.offset = this.c & 0x7FFFFF80;
                return this.c >> 7;
            }
            if (57344L <= ((long)this.c & 0xFFFFFFFFL) && ((long)this.c & 0xFFFFFFFFL) != 65279L && ((long)this.c & 0xFFFFFFFFL) < 65520L) {
                this.offset = this.c & 0x7FFFFF80;
                return this.c - 44032 >> 7;
            }
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int loop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            int n2 = 0;
            if (!this.isSingleByteMode) {
                if (this.c != 0 && this.targetCapacity > 0 && !this.AfterGetTrailUnicode) {
                    return 1;
                }
            } else {
                if (this.c != 0 && this.targetCapacity > 0 && !this.AfterGetTrail) {
                    return this.getTrail(charBuffer, byteBuffer, intBuffer);
                }
                while (true) {
                    block51: {
                        if (!this.AfterGetTrail) {
                            if (!charBuffer.hasRemaining()) return 3;
                        }
                        if (this.targetCapacity <= 0 && !this.AfterGetTrail) {
                            this.cr = CoderResult.OVERFLOW;
                            return 3;
                        }
                        if (!this.AfterGetTrail) {
                            this.c = charBuffer.get();
                            ++this.nextSourceIndex;
                        }
                        if (((long)(this.c - 32) & 0xFFFFFFFFL) <= 95L && !this.AfterGetTrail) {
                            byteBuffer.put((byte)this.c);
                            if (intBuffer != null) {
                                intBuffer.put(this.sourceIndex);
                            }
                            --this.targetCapacity;
                        } else if (((long)this.c & 0xFFFFFFFFL) < 32L && !this.AfterGetTrail) {
                            if ((1L << (int)((long)this.c & 0xFFFFFFFFL) & 0x2601L) == 0L) {
                                this.c |= 0x100;
                                this.length = 2;
                                return 2;
                            }
                            byteBuffer.put((byte)this.c);
                            if (intBuffer != null) {
                                intBuffer.put(this.sourceIndex);
                            }
                            --this.targetCapacity;
                        } else {
                            this.delta = this.c - this.currentOffset;
                            if (((long)this.delta & 0xFFFFFFFFL) <= 127L && !this.AfterGetTrail) {
                                byteBuffer.put((byte)(this.delta | 0x80));
                                if (intBuffer != null) {
                                    intBuffer.put(this.sourceIndex);
                                }
                                --this.targetCapacity;
                            } else {
                                if (this.AfterGetTrail || UTF16.isSurrogate(this.c)) {
                                    if (!this.AfterGetTrail) {
                                        if (!UTF16.isLeadSurrogate(this.c)) {
                                            this.cr = CoderResult.malformedForLength(1);
                                            return 3;
                                        }
                                        n2 = this.getTrail(charBuffer, byteBuffer, intBuffer);
                                        if (n2 == 3) {
                                            return n2;
                                        }
                                    }
                                    if (this.AfterGetTrail) {
                                        this.AfterGetTrail = false;
                                    }
                                    if (((long)(this.delta = this.c - this.currentOffset) & 0xFFFFFFFFL) <= 127L) {
                                        byteBuffer.put((byte)(this.delta | 0x80));
                                        if (intBuffer != null) {
                                            intBuffer.put(this.sourceIndex);
                                        }
                                        --this.targetCapacity;
                                        break block51;
                                    } else {
                                        this.window = this.getWindow(this.data.fromUDynamicOffsets);
                                        if (this.window >= 0) {
                                            this.dynamicWindow = this.window;
                                            this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                                            this.useDynamicWindow(this.dynamicWindow);
                                            this.c = 16 + this.dynamicWindow << 8 | this.c - this.currentOffset | 0x80;
                                            this.length = 2;
                                            return 2;
                                        }
                                        this.code = this.getDynamicOffset();
                                        if (this.code >= 0) {
                                            this.code -= 512;
                                            this.dynamicWindow = this.getNextDynamicWindow();
                                            this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                                            this.useDynamicWindow(this.dynamicWindow);
                                            this.c = 0xB000000 | this.dynamicWindow << 21 | this.code << 8 | this.c - this.currentOffset | 0x80;
                                            this.length = 4;
                                            return 2;
                                        }
                                        this.isSingleByteMode = false;
                                        byteBuffer.put((byte)15);
                                        if (intBuffer != null) {
                                            intBuffer.put(this.sourceIndex);
                                        }
                                        --this.targetCapacity;
                                        this.c = this.lead << 16 | this.trail;
                                        this.length = 4;
                                        return 2;
                                    }
                                }
                                if (((long)this.c & 0xFFFFFFFFL) < 160L) {
                                    this.c = this.c & 0x7F | 0x200;
                                    this.length = 2;
                                    return 2;
                                }
                                if (((long)this.c & 0xFFFFFFFFL) == 65279L || ((long)this.c & 0xFFFFFFFFL) >= 65520L) {
                                    this.c |= 0xE0000;
                                    this.length = 3;
                                    return 2;
                                }
                                this.window = this.getWindow(this.data.fromUDynamicOffsets);
                                if (this.window >= 0) {
                                    if (charBuffer.position() < charBuffer.limit() && !this.isInOffsetWindowOrDirect(this.data.fromUDynamicOffsets[this.window], charBuffer.get(charBuffer.position()))) {
                                        this.c = 1 + this.window << 8 | this.c - this.data.fromUDynamicOffsets[this.window] | 0x80;
                                        this.length = 2;
                                        return 2;
                                    }
                                    this.dynamicWindow = this.window;
                                    this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                                    this.useDynamicWindow(this.dynamicWindow);
                                    this.c = 16 + this.window << 8 | this.c - this.currentOffset | 0x80;
                                    this.length = 2;
                                    return 2;
                                }
                                this.window = this.getWindow(staticOffsets);
                                if (this.window >= 0) {
                                    this.c = 1 + this.window << 8 | this.c - staticOffsets[this.window];
                                    this.length = 2;
                                    return 2;
                                }
                                this.code = this.getDynamicOffset();
                                if (this.code >= 0) {
                                    this.dynamicWindow = this.getNextDynamicWindow();
                                    this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                                    this.useDynamicWindow(this.dynamicWindow);
                                    this.c = 24 + this.dynamicWindow << 16 | this.code << 8 | this.c - this.currentOffset | 0x80;
                                    this.length = 3;
                                    return 2;
                                }
                                if ((int)((long)(this.c - 13312) & 0xFFFFFFFFL) < 41984 && (charBuffer.position() >= charBuffer.limit() || (int)((long)(charBuffer.get(charBuffer.position()) - 13312) & 0xFFFFFFFFL) < 41984)) {
                                    this.isSingleByteMode = false;
                                    this.c |= 0xF0000;
                                    this.length = 3;
                                    return 2;
                                }
                                this.c |= 0xE0000;
                                this.length = 3;
                                return 2;
                            }
                        }
                    }
                    this.c = 0;
                    this.sourceIndex = this.nextSourceIndex;
                }
            }
            while (true) {
                if (!this.AfterGetTrailUnicode) {
                    if (!charBuffer.hasRemaining()) return 3;
                }
                if (this.targetCapacity <= 0 && !this.AfterGetTrailUnicode) break;
                if (!this.AfterGetTrailUnicode) {
                    this.c = charBuffer.get();
                    ++this.nextSourceIndex;
                }
                if (((long)(this.c - 13312) & 0xFFFFFFFFL) < 41984L && !this.AfterGetTrailUnicode) {
                    if (this.targetCapacity < 2) {
                        this.length = 2;
                        return 2;
                    }
                    byteBuffer.put((byte)(this.c >> 8));
                    byteBuffer.put((byte)this.c);
                    if (intBuffer != null) {
                        intBuffer.put(this.sourceIndex);
                        intBuffer.put(this.sourceIndex);
                    }
                    this.targetCapacity -= 2;
                } else {
                    if (((long)(this.c - 13312) & 0xFFFFFFFFL) >= 48896L && !this.AfterGetTrailUnicode) {
                        if (!charBuffer.hasRemaining() || ((long)(charBuffer.get(charBuffer.position()) - 13312) & 0xFFFFFFFFL) >= 41984L) {
                            if (((long)(this.c - 48) & 0xFFFFFFFFL) < 10L || ((long)(this.c - 97) & 0xFFFFFFFFL) < 26L || ((long)(this.c - 65) & 0xFFFFFFFFL) < 26L) {
                                this.isSingleByteMode = true;
                                this.c |= 224 + this.dynamicWindow << 8 | this.c;
                                this.length = 2;
                                return 2;
                            }
                            this.window = this.getWindow(this.data.fromUDynamicOffsets);
                            if (this.window >= 0) {
                                this.isSingleByteMode = true;
                                this.dynamicWindow = this.window;
                                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                                this.useDynamicWindow(this.dynamicWindow);
                                this.c = 224 + this.dynamicWindow << 8 | this.c - this.currentOffset | 0x80;
                                this.length = 2;
                                return 2;
                            }
                            this.code = this.getDynamicOffset();
                            if (this.code >= 0) {
                                this.isSingleByteMode = true;
                                this.dynamicWindow = this.getNextDynamicWindow();
                                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                                this.useDynamicWindow(this.dynamicWindow);
                                this.c = 232 + this.dynamicWindow << 16 | this.code << 8 | this.c - this.currentOffset | 0x80;
                                this.length = 3;
                                return 2;
                            }
                        }
                        this.length = 2;
                        return 2;
                    }
                    if (this.c < 57344 && !this.AfterGetTrailUnicode) {
                        return 1;
                    }
                    if (!this.AfterGetTrailUnicode) {
                        this.c |= 0xF00000;
                        this.length = 3;
                        return 2;
                    }
                }
                if (this.AfterGetTrailUnicode) {
                    this.AfterGetTrailUnicode = false;
                }
                this.c = 0;
                this.sourceIndex = this.nextSourceIndex;
            }
            this.cr = CoderResult.OVERFLOW;
            this.LabelLoop = false;
            return 3;
        }

        private int getTrail(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            this.lead = (char)this.c;
            int n2 = 0;
            if (charBuffer.hasRemaining()) {
                this.trail = charBuffer.get(charBuffer.position());
                if (UTF16.isTrailSurrogate(this.trail)) {
                    charBuffer.position(charBuffer.position() + 1);
                    ++this.nextSourceIndex;
                    this.c = UCharacter.getCodePoint(this.c, this.trail);
                    n2 = 0;
                } else {
                    this.cr = CoderResult.malformedForLength(1);
                    n2 = 3;
                }
            } else {
                n2 = 3;
            }
            this.AfterGetTrail = true;
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int getTrailUnicode(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            int n2 = 3;
            this.AfterGetTrailUnicode = true;
            if (!UTF16.isLeadSurrogate(this.c)) {
                this.cr = CoderResult.malformedForLength(1);
                return 3;
            }
            this.lead = (char)this.c;
            if (!charBuffer.hasRemaining()) {
                return 3;
            }
            this.trail = charBuffer.get(charBuffer.position());
            if (!UTF16.isTrailSurrogate(this.trail)) {
                this.cr = CoderResult.malformedForLength(1);
                return 3;
            }
            charBuffer.get();
            ++this.nextSourceIndex;
            this.c = UCharacter.getCodePoint(this.c, this.trail);
            this.window = this.getWindow(this.data.fromUDynamicOffsets);
            if (!(this.window < 0 || charBuffer.hasRemaining() && ((long)(charBuffer.get(charBuffer.position()) - 13312) & 0xFFFFFFFFL) < 41984L)) {
                this.isSingleByteMode = true;
                this.dynamicWindow = this.window;
                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                this.useDynamicWindow(this.dynamicWindow);
                this.c = 224 + this.dynamicWindow << 8 | this.c - this.currentOffset | 0x80;
                this.length = 2;
                return 2;
            }
            if (charBuffer.hasRemaining() && this.lead == charBuffer.get(charBuffer.position()) && (this.code = this.getDynamicOffset()) >= 0) {
                this.isSingleByteMode = true;
                this.dynamicWindow = this.getNextDynamicWindow();
                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                this.useDynamicWindow(this.dynamicWindow);
                this.c = 0xF1000000 | this.dynamicWindow << 21 | this.code << 8 | this.c - this.currentOffset | 0x80;
                this.length = 4;
                return 2;
            }
            this.c = this.lead << 16 | this.trail;
            this.length = 4;
            return 2;
        }

        private void endLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            this.data.fromUIsSingleByteMode = this.isSingleByteMode;
            this.data.fromUDynamicWindow = this.dynamicWindow;
            this.fromUChar32 = this.c;
            this.LabelLoop = false;
        }

        private int outputBytes(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            if (this.length <= this.targetCapacity) {
                switch (this.length) {
                    case 4: {
                        byteBuffer.put((byte)(this.c >> 24));
                        if (intBuffer != null) {
                            intBuffer.put(this.sourceIndex);
                        }
                    }
                    case 3: {
                        byteBuffer.put((byte)(this.c >> 16));
                        if (intBuffer != null) {
                            intBuffer.put(this.sourceIndex);
                        }
                    }
                    case 2: {
                        byteBuffer.put((byte)(this.c >> 8));
                        if (intBuffer != null) {
                            intBuffer.put(this.sourceIndex);
                        }
                    }
                    case 1: {
                        byteBuffer.put((byte)this.c);
                        if (intBuffer == null) break;
                        intBuffer.put(this.sourceIndex);
                    }
                }
                this.targetCapacity -= this.length;
                this.c = 0;
                this.sourceIndex = this.nextSourceIndex;
                int n2 = 0;
                return n2;
            }
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.errorBuffer);
            this.length -= this.targetCapacity;
            switch (this.length) {
                case 4: {
                    byteBuffer2.put((byte)(this.c >> 24));
                }
                case 3: {
                    byteBuffer2.put((byte)(this.c >> 16));
                }
                case 2: {
                    byteBuffer2.put((byte)(this.c >> 8));
                }
                case 1: {
                    byteBuffer2.put((byte)this.c);
                }
            }
            this.errorBufferLength = this.length;
            this.c >>= 8 * this.length;
            switch (this.targetCapacity) {
                case 3: {
                    byteBuffer.put((byte)(this.c >> 16));
                    if (intBuffer != null) {
                        intBuffer.put(this.sourceIndex);
                    }
                }
                case 2: {
                    byteBuffer.put((byte)(this.c >> 8));
                    if (intBuffer != null) {
                        intBuffer.put(this.sourceIndex);
                    }
                }
                case 1: {
                    byteBuffer.put((byte)this.c);
                    if (intBuffer == null) break;
                    intBuffer.put(this.sourceIndex);
                }
            }
            this.targetCapacity = 0;
            this.cr = CoderResult.OVERFLOW;
            this.c = 0;
            int n3 = 3;
            return n3;
        }
    }

    class CharsetDecoderSCSU
    extends CharsetDecoderICU {
        private static final int FastSingle = 0;
        private static final int SingleByteMode = 1;
        private static final int EndLoop = 2;
        private static final int ByteMode = 0;
        private static final int UnicodeMode = 1;
        short b;
        private boolean isSingleByteMode;
        private short state;
        private byte quoteWindow;
        private byte dynamicWindow;
        private short byteOne;
        private int sourceIndex;
        private int nextSourceIndex;
        CoderResult cr;
        SCSUData data;
        private boolean LabelLoop;

        public CharsetDecoderSCSU(CharsetICU charsetICU) {
            super(charsetICU);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.toULength = 0;
            CharsetSCSU.this.extraInfo.initialize();
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            this.data = CharsetSCSU.this.extraInfo;
            this.isSingleByteMode = this.data.toUIsSingleByteMode;
            this.state = this.data.toUState;
            this.quoteWindow = this.data.toUQuoteWindow;
            this.dynamicWindow = this.data.toUDynamicWindow;
            this.byteOne = this.data.toUByteOne;
            this.LabelLoop = true;
            this.sourceIndex = this.data.toUState == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            this.cr = CoderResult.UNDERFLOW;
            int n2 = 0;
            while (this.LabelLoop) {
                if (this.isSingleByteMode) {
                    switch (n2) {
                        case 0: {
                            n2 = this.fastSingle(byteBuffer, charBuffer, intBuffer, 0);
                            break;
                        }
                        case 1: {
                            n2 = this.singleByteMode(byteBuffer, charBuffer, intBuffer, 0);
                            break;
                        }
                        case 2: {
                            this.endLoop(byteBuffer, charBuffer, intBuffer);
                        }
                    }
                    continue;
                }
                switch (n2) {
                    case 0: {
                        n2 = this.fastSingle(byteBuffer, charBuffer, intBuffer, 1);
                        break;
                    }
                    case 1: {
                        n2 = this.singleByteMode(byteBuffer, charBuffer, intBuffer, 1);
                        break;
                    }
                    case 2: {
                        this.endLoop(byteBuffer, charBuffer, intBuffer);
                    }
                }
            }
            return this.cr;
        }

        private int fastSingle(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, int n2) {
            int n3 = 0;
            if (n2 == 0) {
                if (this.state == 0) {
                    while (byteBuffer.hasRemaining() && charBuffer.hasRemaining() && (this.b = (short)(byteBuffer.get(byteBuffer.position()) & 0xFF)) >= 32) {
                        byteBuffer.position(byteBuffer.position() + 1);
                        ++this.nextSourceIndex;
                        if (this.b <= 127) {
                            charBuffer.put((char)this.b);
                            if (intBuffer != null) {
                                intBuffer.put(this.sourceIndex);
                            }
                        } else {
                            int n4 = this.data.toUDynamicOffsets[this.dynamicWindow] + (this.b & 0x7F);
                            if (n4 <= 65535) {
                                charBuffer.put((char)n4);
                                if (intBuffer != null) {
                                    intBuffer.put(this.sourceIndex);
                                }
                            } else {
                                charBuffer.put((char)(55232 + (n4 >> 10)));
                                if (charBuffer.hasRemaining()) {
                                    charBuffer.put((char)(0xDC00 | n4 & 0x3FF));
                                    if (intBuffer != null) {
                                        intBuffer.put(this.sourceIndex);
                                        intBuffer.put(this.sourceIndex);
                                    }
                                } else {
                                    if (intBuffer != null) {
                                        intBuffer.put(this.sourceIndex);
                                    }
                                    this.charErrorBufferArray[0] = (char)(0xDC00 | n4 & 0x3FF);
                                    this.charErrorBufferLength = 1;
                                    n3 = 2;
                                    this.cr = CoderResult.OVERFLOW;
                                    return n3;
                                }
                            }
                        }
                        this.sourceIndex = this.nextSourceIndex;
                    }
                }
            } else if (n2 == 1 && this.state == 0) {
                while (byteBuffer.position() + 1 < byteBuffer.limit() && charBuffer.hasRemaining() && ((this.b = (short)byteBuffer.get(byteBuffer.position())) - 224 & 0xFF) > 18) {
                    charBuffer.put((char)(this.b << 8 | byteBuffer.get(byteBuffer.position() + 1) & 0xFF));
                    if (intBuffer != null) {
                        intBuffer.put(this.sourceIndex);
                    }
                    this.sourceIndex = this.nextSourceIndex;
                    this.nextSourceIndex += 2;
                    byteBuffer.position(byteBuffer.position() + 2);
                }
            }
            n3 = 1;
            return n3;
        }

        private int singleByteMode(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, int n2) {
            int n3 = 1;
            if (n2 == 0) {
                while (byteBuffer.hasRemaining()) {
                    if (!charBuffer.hasRemaining()) {
                        this.cr = CoderResult.OVERFLOW;
                        n3 = 2;
                        return n3;
                    }
                    this.b = (short)(byteBuffer.get() & 0xFF);
                    ++this.nextSourceIndex;
                    switch (this.state) {
                        case 0: {
                            if ((1L << this.b & 0x2601L) != 0L) {
                                charBuffer.put((char)this.b);
                                if (intBuffer != null) {
                                    intBuffer.put(this.sourceIndex);
                                }
                                this.sourceIndex = this.nextSourceIndex;
                                n3 = 0;
                                return n3;
                            }
                            if (16 <= this.b) {
                                if (this.b <= 23) {
                                    this.dynamicWindow = (byte)(this.b - 16);
                                    this.sourceIndex = this.nextSourceIndex;
                                    n3 = 0;
                                    return n3;
                                }
                                this.dynamicWindow = (byte)(this.b - 24);
                                this.state = (short)6;
                            } else if (this.b <= 8) {
                                this.quoteWindow = (byte)(this.b - 1);
                                this.state = (short)3;
                            } else if (this.b == 11) {
                                this.state = (short)4;
                            } else if (this.b == 14) {
                                this.state = 1;
                            } else {
                                if (this.b == 15) {
                                    this.sourceIndex = this.nextSourceIndex;
                                    this.isSingleByteMode = false;
                                    n3 = 0;
                                    return n3;
                                }
                                this.cr = CoderResult.malformedForLength(1);
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                n3 = 2;
                                return n3;
                            }
                            this.toUBytesArray[0] = (byte)this.b;
                            this.toULength = 1;
                            break;
                        }
                        case 1: {
                            this.byteOne = this.b;
                            this.toUBytesArray[1] = (byte)this.b;
                            this.toULength = 2;
                            this.state = (short)2;
                            break;
                        }
                        case 2: {
                            charBuffer.put((char)(this.byteOne << 8 | this.b));
                            if (intBuffer != null) {
                                intBuffer.put(this.sourceIndex);
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            n3 = 0;
                            return n3;
                        }
                        case 3: {
                            if (this.b < 128) {
                                charBuffer.put((char)(staticOffsets[this.quoteWindow] + this.b));
                                if (intBuffer != null) {
                                    intBuffer.put(this.sourceIndex);
                                }
                            } else {
                                int n4 = this.data.toUDynamicOffsets[this.quoteWindow] + (this.b & 0x7F);
                                if (n4 <= 65535) {
                                    charBuffer.put((char)n4);
                                    if (intBuffer != null) {
                                        intBuffer.put(this.sourceIndex);
                                    }
                                } else {
                                    charBuffer.put((char)(55232 + (n4 >> 10)));
                                    if (charBuffer.hasRemaining()) {
                                        charBuffer.put((char)(0xDC00 | n4 & 0x3FF));
                                        if (intBuffer != null) {
                                            intBuffer.put(this.sourceIndex);
                                            intBuffer.put(this.sourceIndex);
                                        }
                                    } else {
                                        if (intBuffer != null) {
                                            intBuffer.put(this.sourceIndex);
                                        }
                                        this.charErrorBufferArray[0] = (char)(0xDC00 | n4 & 0x3FF);
                                        this.charErrorBufferLength = 1;
                                        n3 = 2;
                                        this.cr = CoderResult.OVERFLOW;
                                        this.LabelLoop = false;
                                        return n3;
                                    }
                                }
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            n3 = 0;
                            return n3;
                        }
                        case 4: {
                            this.dynamicWindow = (byte)(this.b >> 5 & 7);
                            this.byteOne = (byte)(this.b & 0x1F);
                            this.toUBytesArray[1] = (byte)this.b;
                            this.toULength = 2;
                            this.state = (short)5;
                            break;
                        }
                        case 5: {
                            this.data.toUDynamicOffsets[this.dynamicWindow] = 65536 + (this.byteOne << 15 | this.b << 7);
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            n3 = 0;
                            return n3;
                        }
                        case 6: {
                            if (this.b == 0) {
                                this.toUBytesArray[1] = (byte)this.b;
                                this.toULength = 2;
                                n3 = 2;
                                return n3;
                            }
                            if (this.b < 104) {
                                this.data.toUDynamicOffsets[this.dynamicWindow] = this.b << 7;
                            } else if ((this.b - 104 & 0xFF) < 64) {
                                this.data.toUDynamicOffsets[this.dynamicWindow] = (this.b << 7) + 44032;
                            } else if (this.b >= 249) {
                                this.data.toUDynamicOffsets[this.dynamicWindow] = fixedOffsets[this.b - 249];
                            } else {
                                this.toUBytesArray[1] = (byte)this.b;
                                this.toULength = 2;
                                n3 = 2;
                                return n3;
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            n3 = 0;
                            return n3;
                        }
                    }
                }
            } else if (n2 == 1) {
                while (byteBuffer.hasRemaining()) {
                    if (!charBuffer.hasRemaining()) {
                        this.cr = CoderResult.OVERFLOW;
                        n3 = 2;
                        return n3;
                    }
                    this.b = (short)(byteBuffer.get() & 0xFF);
                    ++this.nextSourceIndex;
                    switch (this.state) {
                        case 0: {
                            if ((short)(this.b - 224 & 0xFF) > 18) {
                                this.byteOne = this.b;
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = (short)2;
                                break;
                            }
                            if ((this.b & 0xFF) <= 231) {
                                this.dynamicWindow = (byte)(this.b - 224);
                                this.sourceIndex = this.nextSourceIndex;
                                this.isSingleByteMode = true;
                                n3 = 0;
                                return n3;
                            }
                            if ((this.b & 0xFF) <= 239) {
                                this.dynamicWindow = (byte)(this.b - 232);
                                this.isSingleByteMode = true;
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = (short)6;
                                n3 = 1;
                                return n3;
                            }
                            if ((this.b & 0xFF) == 241) {
                                this.isSingleByteMode = true;
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = (short)4;
                                n3 = 1;
                                return n3;
                            }
                            if ((this.b & 0xFF) == 240) {
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = 1;
                                break;
                            }
                            this.cr = CoderResult.malformedForLength(1);
                            this.toUBytesArray[0] = (byte)this.b;
                            this.toULength = 1;
                            n3 = 2;
                            return n3;
                        }
                        case 1: {
                            this.byteOne = this.b;
                            this.toUBytesArray[1] = (byte)this.b;
                            this.toULength = 2;
                            this.state = (short)2;
                            break;
                        }
                        case 2: {
                            charBuffer.put((char)(this.byteOne << 8 | this.b));
                            if (intBuffer != null) {
                                intBuffer.put(this.sourceIndex);
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            n3 = 0;
                            return n3;
                        }
                    }
                }
            }
            n3 = 2;
            return n3;
        }

        private void endLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer) {
            if (this.cr == CoderResult.OVERFLOW) {
                this.state = 0;
            } else if (this.state == 0) {
                this.toULength = 0;
            }
            this.data.toUIsSingleByteMode = this.isSingleByteMode;
            this.data.toUState = this.state;
            this.data.toUQuoteWindow = this.quoteWindow;
            this.data.toUDynamicWindow = this.dynamicWindow;
            this.data.toUByteOne = this.byteOne;
            this.LabelLoop = false;
        }
    }

    private static final class SCSUData {
        int[] toUDynamicOffsets = new int[8];
        int[] fromUDynamicOffsets = new int[8];
        boolean toUIsSingleByteMode;
        short toUState;
        byte toUQuoteWindow;
        byte toUDynamicWindow;
        short toUByteOne;
        boolean fromUIsSingleByteMode;
        byte fromUDynamicWindow;
        byte locale;
        byte nextWindowUseIndex;
        byte[] windowUse = new byte[8];

        SCSUData() {
            this.initialize();
        }

        void initialize() {
            int n2;
            for (n2 = 0; n2 < 8; ++n2) {
                this.toUDynamicOffsets[n2] = initialDynamicOffsets[n2];
            }
            this.toUIsSingleByteMode = true;
            this.toUState = 0;
            this.toUQuoteWindow = 0;
            this.toUDynamicWindow = 0;
            this.toUByteOne = 0;
            this.fromUIsSingleByteMode = true;
            this.fromUDynamicWindow = 0;
            for (n2 = 0; n2 < 8; ++n2) {
                this.fromUDynamicOffsets[n2] = initialDynamicOffsets[n2];
            }
            this.nextWindowUseIndex = 0;
            switch (this.locale) {
                default: 
            }
            for (n2 = 0; n2 < 8; ++n2) {
                this.windowUse[n2] = initialWindowUse[n2];
            }
        }
    }
}

