/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterDataReader;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterSharedData;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterStaticData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.InvalidFormatException;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetMBCS
extends CharsetICU {
    private byte[] fromUSubstitution = null;
    UConverterSharedData sharedData = null;
    private static final int MAX_VERSION_LENGTH = 4;
    static final int UCNV_SET_FILTER_NONE = 1;
    static final int UCNV_SET_FILTER_DBCS_ONLY = 2;
    static final int UCNV_SET_FILTER_2022_CN = 3;
    static final int UCNV_SET_FILTER_SJIS = 4;
    static final int UCNV_SET_FILTER_GR94DBCS = 5;
    static final int UCNV_SET_FILTER_HZ = 6;
    static final int UCNV_SET_FILTER_COUNT = 7;
    static final int MBCS_OPT_LENGTH_MASK = 63;
    static final int MBCS_OPT_NO_FROM_U = 64;
    static final int MBCS_OPT_INCOMPATIBLE_MASK = 65472;
    static final int MBCS_OPT_UNKNOWN_INCOMPATIBLE_MASK = 65408;
    static final int SBCS_FAST_MAX = 4095;
    static final int SBCS_FAST_LIMIT = 4096;
    static final int MBCS_FAST_MAX = 55295;
    static final int MBCS_FAST_LIMIT = 55296;
    private static final short EBCDIC_LF = 37;
    private static final short EBCDIC_NL = 21;
    private static final short EBCDIC_RT_LF = 3877;
    private static final short EBCDIC_RT_NL = 3861;
    private static final short U_LF = 10;
    private static final short U_NL = 133;
    static final int MBCS_OUTPUT_1 = 0;
    static final int MBCS_OUTPUT_2 = 1;
    static final int MBCS_OUTPUT_3 = 2;
    static final int MBCS_OUTPUT_4 = 3;
    static final int MBCS_OUTPUT_3_EUC = 8;
    static final int MBCS_OUTPUT_4_EUC = 9;
    static final int MBCS_OUTPUT_2_SISO = 12;
    static final int MBCS_OUTPUT_2_HZ = 13;
    static final int MBCS_OUTPUT_EXT_ONLY = 14;
    static final int MBCS_OUTPUT_DBCS_ONLY = 219;
    private static int LINEAR_18030_BASE = CharsetMBCS.LINEAR_18030(129, 48, 129, 48);
    private static final int[][] gb18030Ranges = new int[][]{{65536, 0x10FFFF, CharsetMBCS.LINEAR(-1875869392), CharsetMBCS.LINEAR(-483222987)}, {40870, 55295, CharsetMBCS.LINEAR(-2110419149), CharsetMBCS.LINEAR(-2093562056)}, {1106, 7742, CharsetMBCS.LINEAR(-2127506640), CharsetMBCS.LINEAR(-2127170506)}, {7744, 8207, CharsetMBCS.LINEAR(-2127170504), CharsetMBCS.LINEAR(-2127125199)}, {59493, 63787, CharsetMBCS.LINEAR(-2093559760), CharsetMBCS.LINEAR(-2077194956)}, {9795, 11904, CharsetMBCS.LINEAR(-2127058887), CharsetMBCS.LINEAR(-2126971592)}, {64042, 65071, CharsetMBCS.LINEAR(-2077189064), CharsetMBCS.LINEAR(-2077129417)}, {15585, 16469, CharsetMBCS.LINEAR(-2110663624), CharsetMBCS.LINEAR(-2110607566)}, {13851, 14615, CharsetMBCS.LINEAR(-2110740941), CharsetMBCS.LINEAR(-2110721481)}, {18872, 19574, CharsetMBCS.LINEAR(-2110480079), CharsetMBCS.LINEAR(-2110462157)}, {16736, 17206, CharsetMBCS.LINEAR(-2110600905), CharsetMBCS.LINEAR(-2110588873)}, {18318, 18758, CharsetMBCS.LINEAR(-2110527432), CharsetMBCS.LINEAR(-2110482888)}, {17623, 17995, CharsetMBCS.LINEAR(-2110545095), CharsetMBCS.LINEAR(-2110535375)}, {65510, 65535, CharsetMBCS.LINEAR(-2077121996), CharsetMBCS.LINEAR(-2077121479)}};
    private static final int MBCS_OPTION_GB18030 = 32768;
    private static final int MBCS_OPTION_KEIS = 4096;
    private static final int MBCS_OPTION_JEF = 8192;
    private static final int MBCS_OPTION_JIPS = 16384;
    private static final byte[] KEIS_SO_CHAR = new byte[]{10, 66};
    private static final byte[] KEIS_SI_CHAR = new byte[]{10, 65};
    private static final byte JEF_SO_CHAR = 40;
    private static final byte JEF_SI_CHAR = 41;
    private static final byte[] JIPS_SO_CHAR = new byte[]{26, 112};
    private static final byte[] JIPS_SI_CHAR = new byte[]{26, 113};
    static final int MBCS_MAX_STATE_COUNT = 128;
    static final int MBCS_STATE_VALID_DIRECT_16 = 0;
    static final int MBCS_STATE_VALID_DIRECT_20 = 1;
    static final int MBCS_STATE_FALLBACK_DIRECT_16 = 2;
    static final int MBCS_STATE_FALLBACK_DIRECT_20 = 3;
    static final int MBCS_STATE_VALID_16 = 4;
    static final int MBCS_STATE_VALID_16_PAIR = 5;
    static final int MBCS_STATE_UNASSIGNED = 6;
    static final int MBCS_STATE_ILLEGAL = 7;
    static final int MBCS_STATE_CHANGE_ONLY = 8;
    static final int EXT_INDEXES_LENGTH = 0;
    static final int EXT_TO_U_INDEX = 1;
    static final int EXT_TO_U_LENGTH = 2;
    static final int EXT_TO_U_UCHARS_INDEX = 3;
    static final int EXT_TO_U_UCHARS_LENGTH = 4;
    static final int EXT_FROM_U_UCHARS_INDEX = 5;
    static final int EXT_FROM_U_VALUES_INDEX = 6;
    static final int EXT_FROM_U_LENGTH = 7;
    static final int EXT_FROM_U_BYTES_INDEX = 8;
    static final int EXT_FROM_U_BYTES_LENGTH = 9;
    static final int EXT_FROM_U_STAGE_12_INDEX = 10;
    static final int EXT_FROM_U_STAGE_1_LENGTH = 11;
    static final int EXT_FROM_U_STAGE_12_LENGTH = 12;
    static final int EXT_FROM_U_STAGE_3_INDEX = 13;
    static final int EXT_FROM_U_STAGE_3_LENGTH = 14;
    static final int EXT_FROM_U_STAGE_3B_INDEX = 15;
    static final int EXT_FROM_U_STAGE_3B_LENGTH = 16;
    private static final int EXT_COUNT_BYTES = 17;
    static final int EXT_FROM_U_MAX_DIRECT_LENGTH = 3;
    private static final int TO_U_BYTE_SHIFT = 24;
    private static final int TO_U_VALUE_MASK = 0xFFFFFF;
    private static final int TO_U_MIN_CODE_POINT = 0x1F0000;
    private static final int TO_U_MAX_CODE_POINT = 0x2FFFFF;
    private static final int TO_U_ROUNDTRIP_FLAG = 0x800000;
    private static final int TO_U_INDEX_MASK = 262143;
    private static final int TO_U_LENGTH_SHIFT = 18;
    private static final int TO_U_LENGTH_OFFSET = 12;
    static final int MAX_UCHARS = 19;
    private static final int STAGE_2_LEFT_SHIFT = 2;
    private static final int FROM_U_LENGTH_SHIFT = 24;
    private static final int FROM_U_ROUNDTRIP_FLAG = Integer.MIN_VALUE;
    static final int FROM_U_RESERVED_MASK = 0x60000000;
    private static final int FROM_U_DATA_MASK = 0xFFFFFF;
    static final int FROM_U_SUBCHAR1 = -2147483647;
    private static final int FROM_U_MAX_DIRECT_LENGTH = 3;
    static final int MAX_BYTES = 31;

    public CharsetMBCS(String string, String string2, String[] stringArray, String string3, ClassLoader classLoader) throws InvalidFormatException {
        super(string, string2, stringArray);
        if (string.indexOf(",swaplfnl") > -1) {
            this.options = 16;
            this.icuCanonicalName = string = string.substring(0, string.indexOf(",swaplfnl"));
        }
        this.sharedData = this.loadConverter(1, string, string3, classLoader);
        this.maxBytesPerChar = this.sharedData.staticData.maxBytesPerChar;
        this.minBytesPerChar = this.sharedData.staticData.minBytesPerChar;
        this.maxCharsPerByte = 1.0f;
        this.fromUSubstitution = this.sharedData.staticData.subChar;
        this.subChar = this.sharedData.staticData.subChar;
        this.subCharLen = this.sharedData.staticData.subCharLen;
        this.subChar1 = this.sharedData.staticData.subChar1;
        this.fromUSubstitution = new byte[this.sharedData.staticData.subCharLen];
        System.arraycopy(this.sharedData.staticData.subChar, 0, this.fromUSubstitution, 0, this.sharedData.staticData.subCharLen);
        this.initializeConverter(this.options);
    }

    public CharsetMBCS(String string, String string2, String[] stringArray) throws InvalidFormatException {
        this(string, string2, stringArray, "data/icudt75b", null);
    }

    private UConverterSharedData loadConverter(int n2, String string, String string2, ClassLoader classLoader) throws InvalidFormatException {
        Object object;
        Object object2;
        Object object3;
        boolean bl2 = false;
        UConverterStaticData uConverterStaticData = new UConverterStaticData();
        UConverterDataReader uConverterDataReader = null;
        try {
            String string3 = string + '.' + "cnv";
            object3 = string2 + '/' + string3;
            if (classLoader != null) {
                object2 = ICUData.getRequiredStream(classLoader, (String)object3);
                object = ICUBinary.getByteBufferFromInputStreamAndCloseStream((InputStream)object2);
            } else if (!string2.equals("data/icudt75b")) {
                object2 = ICUData.getRequiredStream((String)object3);
                object = ICUBinary.getByteBufferFromInputStreamAndCloseStream((InputStream)object2);
            } else {
                object = ICUBinary.getRequiredData(string3);
            }
            uConverterDataReader = new UConverterDataReader((ByteBuffer)object);
            uConverterDataReader.readStaticData(uConverterStaticData);
        }
        catch (IOException iOException) {
            throw new InvalidFormatException(iOException);
        }
        catch (Exception exception) {
            throw new InvalidFormatException(exception);
        }
        byte by2 = uConverterStaticData.conversionType;
        if (by2 != 2 || uConverterStaticData.structSize != 100) {
            throw new InvalidFormatException();
        }
        object3 = new UConverterSharedData(uConverterStaticData);
        object = ((UConverterSharedData)object3).mbcs;
        object2 = new MBCSHeader();
        try {
            uConverterDataReader.readMBCSHeader((MBCSHeader)object2);
        }
        catch (IOException iOException) {
            throw new InvalidFormatException();
        }
        String string4 = null;
        if (((MBCSHeader)object2).version[0] == 5 && ((MBCSHeader)object2).version[1] >= 3 && (((MBCSHeader)object2).options & 0xFF80) == 0) {
            bl2 = (((MBCSHeader)object2).options & 0x40) != 0;
        } else if (((MBCSHeader)object2).version[0] != 4) {
            throw new InvalidFormatException();
        }
        ((UConverterMBCSTable)object).outputType = (byte)((MBCSHeader)object2).flags;
        int n3 = ((MBCSHeader)object2).flags >>> 8;
        if (((UConverterMBCSTable)object).outputType == 14) {
            try {
                string4 = uConverterDataReader.readBaseTableName();
                if (n3 != 0) {
                    ((UConverterMBCSTable)object).extIndexes = uConverterDataReader.readExtIndexes(n3 - uConverterDataReader.bytesReadAfterStaticData());
                }
            }
            catch (IOException iOException) {
                throw new InvalidFormatException();
            }
        }
        if (((UConverterMBCSTable)object).outputType == 14) {
            UConverterSharedData uConverterSharedData = null;
            ByteBuffer byteBuffer = ((UConverterMBCSTable)object).extIndexes;
            if (byteBuffer == null) {
                throw new InvalidFormatException();
            }
            if (n2 != 1) {
                throw new InvalidFormatException();
            }
            String string5 = string4;
            if (string5.equals(uConverterStaticData.name)) {
                throw new InvalidFormatException();
            }
            uConverterSharedData = this.loadConverter(2, string5, string2, classLoader);
            if (uConverterSharedData.staticData.conversionType != 2 || uConverterSharedData.mbcs.baseSharedData != null) {
                throw new InvalidFormatException();
            }
            ((UConverterSharedData)object3).mbcs = uConverterSharedData.mbcs;
            object = ((UConverterSharedData)object3).mbcs;
            ((UConverterMBCSTable)object).baseSharedData = uConverterSharedData;
            ((UConverterMBCSTable)object).extIndexes = byteBuffer;
            ((UConverterMBCSTable)object).swapLFNLStateTable = null;
            ((UConverterMBCSTable)object).swapLFNLFromUnicodeChars = null;
            ((UConverterMBCSTable)object).swapLFNLName = null;
            if (uConverterStaticData.conversionType == 1 || uConverterStaticData.conversionType == 2 && uConverterStaticData.minBytesPerChar >= 2) {
                if (uConverterSharedData.mbcs.outputType == 12) {
                    int n4 = ((UConverterMBCSTable)object).stateTable[0][14];
                    if (CharsetMBCS.MBCS_ENTRY_IS_FINAL(n4) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n4) == 8 && CharsetMBCS.MBCS_ENTRY_FINAL_STATE(n4) != 0) {
                        ((UConverterMBCSTable)object).dbcsOnlyState = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(n4);
                        ((UConverterMBCSTable)object).outputType = (short)219;
                    }
                } else if (uConverterSharedData.staticData.conversionType == 2 && uConverterSharedData.staticData.minBytesPerChar == 1 && uConverterSharedData.staticData.maxBytesPerChar == 2 && ((UConverterMBCSTable)object).countStates <= 127) {
                    int n5;
                    short s2 = ((UConverterMBCSTable)object).countStates;
                    int[][] nArray = new int[(s2 + 1) * 1024][256];
                    for (n5 = 0; n5 < ((UConverterMBCSTable)object).stateTable.length; ++n5) {
                        System.arraycopy(((UConverterMBCSTable)object).stateTable[n5], 0, nArray[n5], 0, ((UConverterMBCSTable)object).stateTable[n5].length);
                    }
                    int[] nArray2 = nArray[0];
                    for (n5 = 0; n5 < 256; ++n5) {
                        if (!CharsetMBCS.MBCS_ENTRY_IS_FINAL(nArray2[n5])) continue;
                        nArray2[n5] = CharsetMBCS.MBCS_ENTRY_TRANSITION(s2, 0);
                    }
                    nArray2 = nArray[s2];
                    for (n5 = 0; n5 < 256; ++n5) {
                        nArray2[n5] = CharsetMBCS.MBCS_ENTRY_FINAL(0, 7, 0);
                    }
                    ((UConverterMBCSTable)object).stateTable = nArray;
                    ((UConverterMBCSTable)object).countStates = (byte)(s2 + 1);
                    ((UConverterMBCSTable)object).stateTableOwned = true;
                    ((UConverterMBCSTable)object).outputType = (short)219;
                }
            }
        } else {
            int n6;
            switch (((UConverterMBCSTable)object).outputType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 12: {
                    break;
                }
                default: {
                    throw new InvalidFormatException();
                }
            }
            ((UConverterMBCSTable)object).unicodeMask = uConverterDataReader.dataFormatHasUnicodeMask() ? (short)(uConverterStaticData.unicodeMask & 3) : (short)3;
            try {
                uConverterDataReader.readMBCSTable((MBCSHeader)object2, (UConverterMBCSTable)object);
            }
            catch (IOException iOException) {
                throw new InvalidFormatException();
            }
            if (n3 != 0) {
                try {
                    ((UConverterMBCSTable)object).extIndexes = uConverterDataReader.readExtIndexes(n3 - uConverterDataReader.bytesReadAfterStaticData());
                }
                catch (IOException iOException) {
                    throw new InvalidFormatException();
                }
            }
            if (((MBCSHeader)object2).version[1] >= 3 && (((UConverterMBCSTable)object).unicodeMask & 2) == 0 && (((UConverterMBCSTable)object).countStates == 1 ? (char)((MBCSHeader)object2).version[2] >= '\u000f' : (char)((MBCSHeader)object2).version[2] >= '\u00d7')) {
                ((UConverterMBCSTable)object).utf8Friendly = true;
                ((UConverterMBCSTable)object).maxFastUChar = ((UConverterMBCSTable)object).countStates == 1 ? (char)4095 : (char)(((MBCSHeader)object2).version[2] << 8 | 0xFF);
            }
            int n7 = -1;
            for (n6 = 0; n6 < 128; ++n6) {
                if (((UConverterMBCSTable)object).stateTable[0][n6] == CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, n6)) continue;
                n7 &= ~(1 << (n6 >> 2));
            }
            ((UConverterMBCSTable)object).asciiRoundtrips = n7;
            if (bl2) {
                n7 = (((UConverterMBCSTable)object).unicodeMask & 1) != 0 ? 1088 : 64;
                n6 = (((MBCSHeader)object2).offsetFromUBytes - ((MBCSHeader)object2).offsetFromUTable) / 4 - n7 / 2;
                CharsetMBCS.reconstituteData((UConverterMBCSTable)object, n7, n6, ((MBCSHeader)object2).fullStage2Length);
            }
            if (((UConverterMBCSTable)object).outputType == 219 || ((UConverterMBCSTable)object).outputType == 12) {
                ((UConverterMBCSTable)object).asciiRoundtrips = 0;
            }
        }
        ((UConverterMBCSTable)object).mbcsIndex = null;
        return object3;
    }

    private static boolean writeStage3Roundtrip(UConverterMBCSTable uConverterMBCSTable, long l2, int[] nArray) {
        char[] cArray = uConverterMBCSTable.fromUnicodeTable;
        int[] nArray2 = uConverterMBCSTable.fromUnicodeTableInts;
        byte[] byArray = uConverterMBCSTable.fromUnicodeBytes;
        char[] cArray2 = uConverterMBCSTable.fromUnicodeChars;
        int[] nArray3 = uConverterMBCSTable.fromUnicodeInts;
        switch (uConverterMBCSTable.outputType) {
            case 8: {
                if (l2 <= 65535L) break;
                if (l2 <= 0x8EFFFFL) {
                    l2 &= 0x7FFFL;
                    break;
                }
                l2 &= 0xFF7FL;
                break;
            }
            case 9: {
                if (l2 <= 0xFFFFFFL) break;
                if (l2 <= 0x8EFFFFFFL) {
                    l2 &= 0x7FFFFFL;
                    break;
                }
                l2 &= 0xFF7FFFL;
                break;
            }
        }
        for (int i2 = 0; i2 <= 31; ++i2) {
            int n2 = nArray[i2];
            if (n2 >= 0) {
                int n3 = cArray[n2 >> 10] + (n2 >> 4 & 0x3F);
                int n4 = nArray2[n3];
                n4 = (char)(n4 * 16 + (n2 & 0xF));
                switch (uConverterMBCSTable.outputType) {
                    case 2: 
                    case 9: {
                        int n5 = n4 * 3;
                        byArray[n5] = (byte)(l2 >> 16);
                        byArray[n5 + 1] = (byte)(l2 >> 8);
                        byArray[n5 + 2] = (byte)l2;
                        break;
                    }
                    case 3: {
                        nArray3[n4] = (int)l2;
                        break;
                    }
                    default: {
                        cArray2[n4] = (char)l2;
                    }
                }
                int n6 = 16 + (n2 & 0xF);
                int n7 = n3;
                nArray2[n7] = (int)((long)nArray2[n7] | 1L << n6);
            }
            ++l2;
        }
        return true;
    }

    private static void reconstituteData(UConverterMBCSTable uConverterMBCSTable, int n2, int n3, int n4) {
        char[] cArray = uConverterMBCSTable.fromUnicodeTable;
        int n5 = n2 / 2;
        int[] nArray = new int[n5 + n4];
        System.arraycopy(uConverterMBCSTable.fromUnicodeTableInts, n5, nArray, n4 - n3 + n5, n3);
        uConverterMBCSTable.fromUnicodeTableInts = nArray;
        int n6 = uConverterMBCSTable.maxFastUChar + '\u0001' >> 6;
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            int n9 = cArray[n8];
            if (n9 != n2 / 2) {
                for (int i2 = 0; i2 < 16; ++i2) {
                    int n10;
                    if ((n10 = uConverterMBCSTable.mbcsIndex.get(n7++)) != 0) {
                        n10 >>= 4;
                        nArray[n9++] = n10++;
                        nArray[n9++] = n10++;
                        nArray[n9++] = n10++;
                        nArray[n9++] = n10;
                        continue;
                    }
                    n9 += 4;
                }
            } else {
                n7 += 16;
            }
            ++n8;
        }
        switch (uConverterMBCSTable.outputType) {
            case 1: 
            case 8: 
            case 12: {
                uConverterMBCSTable.fromUnicodeChars = new char[uConverterMBCSTable.fromUBytesLength / 2];
                break;
            }
            case 2: 
            case 9: {
                uConverterMBCSTable.fromUnicodeBytes = new byte[uConverterMBCSTable.fromUBytesLength];
                break;
            }
            case 3: {
                uConverterMBCSTable.fromUnicodeInts = new int[uConverterMBCSTable.fromUBytesLength / 4];
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        CharsetMBCS.MBCSEnumToUnicode(uConverterMBCSTable);
    }

    private static void MBCSEnumToUnicode(UConverterMBCSTable uConverterMBCSTable) {
        byte[] byArray = new byte[128];
        CharsetMBCS.getStateProp(uConverterMBCSTable.stateTable, byArray, 0);
        for (int i2 = 0; i2 < uConverterMBCSTable.countStates; ++i2) {
            if (byArray[i2] < 64) continue;
            CharsetMBCS.enumToU(uConverterMBCSTable, byArray, i2, 0, 0);
        }
    }

    private static boolean enumToU(UConverterMBCSTable uConverterMBCSTable, byte[] byArray, int n2, int n3, int n4) {
        int[] nArray = new int[32];
        int[] nArray2 = uConverterMBCSTable.stateTable[n2];
        char[] cArray = uConverterMBCSTable.unicodeCodeUnits;
        n4 <<= 8;
        int n5 = -1;
        int n6 = (byArray[n2] & 0x38) << 2;
        if (n6 == 0 && byArray[n2] >= 64) {
            nArray[0] = -1;
            n6 = 1;
        }
        int n7 = (byArray[n2] & 7) + 1 << 5;
        while (n6 < n7) {
            int n8;
            int n9 = nArray2[n6];
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n9)) {
                n8 = CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(n9);
                if (byArray[n8] >= 0 && !CharsetMBCS.enumToU(uConverterMBCSTable, byArray, n8, n3 + CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(n9), n4 | n6)) {
                    return false;
                }
                nArray[n6 & 0x1F] = -1;
            } else {
                int n10;
                int n11 = CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n9);
                if (n11 == 0) {
                    n8 = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n9);
                } else if (n11 == 4) {
                    n10 = n3 + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n9);
                    n8 = cArray[n10];
                    if (n8 >= 65534) {
                        n8 = -1;
                    }
                } else if (n11 == 5) {
                    n10 = n3 + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n9);
                    if ((n8 = cArray[n10++]) >= 55296) {
                        n8 = n8 <= 56319 ? ((n8 & 0x3FF) << 10) + cArray[n10] + 9216 : (n8 == 57344 ? cArray[n10] : -1);
                    }
                } else {
                    n8 = n11 == 1 ? CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(n9) + 65536 : -1;
                }
                nArray[n6 & 0x1F] = n8;
                n5 &= n8;
            }
            if ((++n6 & 0x1F) != 0 || n5 < 0) continue;
            if (!CharsetMBCS.writeStage3Roundtrip(uConverterMBCSTable, n4 | n6 - 32, nArray)) {
                return false;
            }
            n5 = -1;
        }
        return true;
    }

    private static byte getStateProp(int[][] nArray, byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray2 = nArray[n2];
        byArray[n2] = 0;
        int n6 = 0;
        while (true) {
            if (byArray[n5 = CharsetMBCS.MBCS_ENTRY_STATE(n4 = nArray2[n6])] == -1) {
                CharsetMBCS.getStateProp(nArray, byArray, n5);
            }
            if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n4) ? CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n4) < 6 : byArray[n5] > 0) break;
            if (n6 == 255) {
                byArray[n2] = -64;
                return byArray[n2];
            }
            ++n6;
        }
        int n7 = n2;
        byArray[n7] = (byte)(byArray[n7] | (byte)(n6 >> 5 << 3));
        for (n3 = 255; n6 < n3; --n3) {
            n4 = nArray2[n3];
            n5 = CharsetMBCS.MBCS_ENTRY_STATE(n4);
            if (byArray[n5] == -1) {
                CharsetMBCS.getStateProp(nArray, byArray, n5);
            }
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n4) ? byArray[n5] > 0 : CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n4) < 6) break;
        }
        int n8 = n2;
        byArray[n8] = (byte)(byArray[n8] | (byte)(n3 >> 5));
        while (n6 <= n3) {
            n4 = nArray2[n6];
            n5 = CharsetMBCS.MBCS_ENTRY_STATE(n4);
            if (byArray[n5] == -1) {
                CharsetMBCS.getStateProp(nArray, byArray, n5);
            }
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n4)) {
                int n9 = n5;
                byArray[n9] = (byte)(byArray[n9] | 0x40);
                if (CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n4) <= 3) {
                    int n10 = n2;
                    byArray[n10] = (byte)(byArray[n10] | 0x40);
                }
            }
            ++n6;
        }
        return byArray[n2];
    }

    protected void initializeConverter(int n2) {
        ByteBuffer byteBuffer;
        String string;
        UConverterMBCSTable uConverterMBCSTable = this.sharedData.mbcs;
        short s2 = uConverterMBCSTable.outputType;
        if (s2 == 219) {
            this.options = n2 &= 0xFFFFFFEF;
        }
        if ((n2 & 0x10) != 0) {
            boolean bl2;
            boolean bl3 = bl2 = uConverterMBCSTable.swapLFNLStateTable != null;
            if (!bl2) {
                try {
                    if (!this.EBCDICSwapLFNL()) {
                        this.options = n2 & 0xFFFFFFEF;
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
        if ((string = this.icuCanonicalName.toLowerCase(Locale.ENGLISH)).indexOf("gb18030") >= 0) {
            this.options |= 0x8000;
        } else if (string.indexOf("keis") >= 0) {
            this.options |= 0x1000;
        } else if (string.indexOf("jef") >= 0) {
            this.options |= 0x2000;
        } else if (string.indexOf("jips") >= 0) {
            this.options |= 0x4000;
        }
        if (s2 == 12) {
            this.maxBytesPerChar = 4;
        }
        if ((byteBuffer = uConverterMBCSTable.extIndexes) != null) {
            byte by2 = (byte)CharsetMBCS.GET_MAX_BYTES_PER_UCHAR(byteBuffer);
            if (s2 == 12) {
                by2 = (byte)(by2 + 1);
            }
            if (by2 > this.maxBytesPerChar) {
                this.maxBytesPerChar = by2;
            }
        }
    }

    private boolean EBCDICSwapLFNL() throws Exception {
        int n2;
        char[] cArray;
        UConverterMBCSTable uConverterMBCSTable = this.sharedData.mbcs;
        char[] cArray2 = uConverterMBCSTable.fromUnicodeTable;
        int[] nArray = this.sharedData.mbcs.fromUnicodeTableInts;
        char[] cArray3 = cArray = uConverterMBCSTable.fromUnicodeChars;
        if (uConverterMBCSTable.outputType != 0 && uConverterMBCSTable.outputType != 12 || uConverterMBCSTable.stateTable[0][37] != CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 10) || uConverterMBCSTable.stateTable[0][21] != CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 133)) {
            return false;
        }
        if (uConverterMBCSTable.outputType == 0) {
            if ('\u0f25' != CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(cArray2, cArray3, 10) || '\u0f15' != CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(cArray2, cArray3, 133)) {
                return false;
            }
        } else {
            n2 = CharsetMBCS.MBCS_STAGE_2_FROM_U(cArray2, nArray, 10);
            if (!CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(n2, 10) || '%' != CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(cArray, n2, 10)) {
                return false;
            }
            n2 = CharsetMBCS.MBCS_STAGE_2_FROM_U(cArray2, nArray, 133);
            if (!CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(n2, 133) || '\u0015' != CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(cArray, n2, 133)) {
                return false;
            }
        }
        if (uConverterMBCSTable.fromUBytesLength <= 0) {
            throw new Exception("U_INVALID_FORMAT_ERROR");
        }
        int[][] nArray2 = new int[uConverterMBCSTable.stateTable.length][uConverterMBCSTable.stateTable[0].length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            System.arraycopy(uConverterMBCSTable.stateTable[i2], 0, nArray2[i2], 0, nArray2[i2].length);
        }
        nArray2[0][37] = CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 133);
        nArray2[0][21] = CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 10);
        char[] cArray4 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray4, 0, cArray.length);
        if (uConverterMBCSTable.outputType == 0) {
            CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U_SET(cArray2, cArray4, 10, 3861);
            CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U_SET(cArray2, cArray4, 133, 3877);
        } else {
            n2 = CharsetMBCS.MBCS_STAGE_2_FROM_U(cArray2, nArray, 10);
            CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2_SET(cArray4, n2, 10, 21);
            n2 = CharsetMBCS.MBCS_STAGE_2_FROM_U(cArray2, nArray, 133);
            CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2_SET(cArray4, n2, 133, 37);
        }
        String string = this.icuCanonicalName.concat(",swaplfnl");
        if (uConverterMBCSTable.swapLFNLStateTable == null) {
            uConverterMBCSTable.swapLFNLStateTable = nArray2;
            uConverterMBCSTable.swapLFNLFromUnicodeChars = cArray4;
            uConverterMBCSTable.swapLFNLName = string;
        }
        return true;
    }

    private static int LINEAR_18030(int n2, int n3, int n4, int n5) {
        return (((n2 & 0xFF) * 10 + (n3 & 0xFF)) * 126 + (n4 & 0xFF)) * 10 + (n5 & 0xFF);
    }

    private static int LINEAR(int n2) {
        return CharsetMBCS.LINEAR_18030(n2 >>> 24, n2 >>> 16 & 0xFF, n2 >>> 8 & 0xFF, n2 & 0xFF);
    }

    private static int getSISOBytes(SISO_Option sISO_Option, int n2, byte[] byArray) {
        int n3 = 0;
        switch (sISO_Option) {
            case SI: {
                if ((n2 & 0x1000) != 0) {
                    byArray[0] = KEIS_SI_CHAR[0];
                    byArray[1] = KEIS_SI_CHAR[1];
                    n3 = 2;
                    break;
                }
                if ((n2 & 0x2000) != 0) {
                    byArray[0] = 41;
                    n3 = 1;
                    break;
                }
                if ((n2 & 0x4000) != 0) {
                    byArray[0] = JIPS_SI_CHAR[0];
                    byArray[1] = JIPS_SI_CHAR[1];
                    n3 = 2;
                    break;
                }
                byArray[0] = 15;
                n3 = 1;
                break;
            }
            case SO: {
                if ((n2 & 0x1000) != 0) {
                    byArray[0] = KEIS_SO_CHAR[0];
                    byArray[1] = KEIS_SO_CHAR[1];
                    n3 = 2;
                    break;
                }
                if ((n2 & 0x2000) != 0) {
                    byArray[0] = 40;
                    n3 = 1;
                    break;
                }
                if ((n2 & 0x4000) != 0) {
                    byArray[0] = JIPS_SO_CHAR[0];
                    byArray[1] = JIPS_SO_CHAR[1];
                    n3 = 2;
                    break;
                }
                byArray[0] = 14;
                n3 = 1;
                break;
            }
        }
        return n3;
    }

    static int MBCS_ENTRY_SET_STATE(int n2, int n3) {
        return n2 & 0x80FFFFFF | n3 << 24;
    }

    static int MBCS_ENTRY_STATE(int n2) {
        return n2 >> 24 & 0x7F;
    }

    static int MBCS_ENTRY_TRANSITION(int n2, int n3) {
        return n2 << 24 | n3;
    }

    static int MBCS_ENTRY_FINAL(int n2, int n3, int n4) {
        return Integer.MIN_VALUE | n2 << 24 | n3 << 20 | n4;
    }

    static boolean MBCS_ENTRY_IS_TRANSITION(int n2) {
        return n2 >= 0;
    }

    static boolean MBCS_ENTRY_IS_FINAL(int n2) {
        return n2 < 0;
    }

    static int MBCS_ENTRY_TRANSITION_STATE(int n2) {
        return n2 >>> 24;
    }

    static int MBCS_ENTRY_TRANSITION_OFFSET(int n2) {
        return n2 & 0xFFFFFF;
    }

    static int MBCS_ENTRY_FINAL_STATE(int n2) {
        return n2 >>> 24 & 0x7F;
    }

    static boolean MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(int n2) {
        return n2 < -2146435072;
    }

    static int MBCS_ENTRY_FINAL_ACTION(int n2) {
        return n2 >>> 20 & 0xF;
    }

    static int MBCS_ENTRY_FINAL_VALUE(int n2) {
        return n2 & 0xFFFFF;
    }

    static char MBCS_ENTRY_FINAL_VALUE_16(int n2) {
        return (char)n2;
    }

    static boolean MBCS_IS_ASCII_ROUNDTRIP(int n2, long l2) {
        return (l2 & (long)(1 << (n2 >> 2))) != 0L;
    }

    static char MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(UConverterMBCSTable uConverterMBCSTable, int n2) {
        assert (0 <= n2 && n2 <= 255);
        return CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(uConverterMBCSTable.stateTable[0][n2]);
    }

    static char MBCS_SINGLE_RESULT_FROM_U(char[] cArray, char[] cArray2, int n2) {
        int n3 = cArray[n2 >>> 10] + (n2 >>> 4 & 0x3F);
        int n4 = cArray[n3] + (n2 & 0xF);
        return cArray2[n4];
    }

    static void MBCS_SINGLE_RESULT_FROM_U_SET(char[] cArray, char[] cArray2, int n2, int n3) {
        int n4 = cArray[n2 >>> 10] + (n2 >>> 4 & 0x3F);
        int n5 = cArray[n4] + (n2 & 0xF);
        cArray2[n5] = (char)n3;
    }

    static int MBCS_STAGE_2_FROM_U(char[] cArray, int[] nArray, int n2) {
        int n3 = cArray[n2 >>> 10] + (n2 >>> 4 & 0x3F);
        return nArray[n3];
    }

    private static boolean MBCS_FROM_U_IS_ROUNDTRIP(int n2, int n3) {
        return (n2 & 1 << 16 + (n3 & 0xF)) != 0;
    }

    static char MBCS_VALUE_2_FROM_STAGE_2(char[] cArray, int n2, int n3) {
        int n4 = 16 * (n2 & 0xFFFF) + (n3 & 0xF);
        return cArray[n4];
    }

    static void MBCS_VALUE_2_FROM_STAGE_2_SET(char[] cArray, int n2, int n3, int n4) {
        int n5 = 16 * (n2 & 0xFFFF) + (n3 & 0xF);
        cArray[n5] = (char)n4;
    }

    private static int MBCS_VALUE_4_FROM_STAGE_2(int[] nArray, int n2, int n3) {
        int n4 = 16 * (n2 & 0xFFFF) + (n3 & 0xF);
        return nArray[n4];
    }

    static int MBCS_POINTER_3_FROM_STAGE_2(byte[] byArray, int n2, int n3) {
        return (16 * (n2 & 0xFFFF) + (n3 & 0xF)) * 3;
    }

    static int TO_U_GET_BYTE(int n2) {
        return n2 >>> 24;
    }

    static int TO_U_GET_VALUE(int n2) {
        return n2 & 0xFFFFFF;
    }

    static boolean TO_U_IS_ROUNDTRIP(int n2) {
        return (n2 & 0x800000) != 0;
    }

    static boolean TO_U_IS_PARTIAL(int n2) {
        return 0 <= n2 && n2 < 0x1F0000;
    }

    static int TO_U_GET_PARTIAL_INDEX(int n2) {
        return n2;
    }

    static int TO_U_MASK_ROUNDTRIP(int n2) {
        return n2 & 0xFF7FFFFF;
    }

    private static int TO_U_MAKE_WORD(byte by2, int n2) {
        return by2 << 24 | n2;
    }

    static boolean TO_U_IS_CODE_POINT(int n2) {
        assert (n2 >= 0);
        return n2 <= 0x2FFFFF;
    }

    static int TO_U_GET_CODE_POINT(int n2) {
        assert (n2 >= 0);
        return n2 - 0x1F0000;
    }

    private static int TO_U_GET_INDEX(int n2) {
        return n2 & 0x3FFFF;
    }

    private static int TO_U_GET_LENGTH(int n2) {
        return (n2 >>> 18) - 12;
    }

    static int FROM_U(CharBuffer charBuffer, CharBuffer charBuffer2, int n2, int n3) {
        return charBuffer2.get((charBuffer.get(charBuffer.get(n2) + (n3 >>> 4 & 0x3F)) << 2) + (n3 & 0xF));
    }

    static boolean FROM_U_IS_PARTIAL(int n2) {
        return n2 >>> 24 == 0;
    }

    static int FROM_U_GET_PARTIAL_INDEX(int n2) {
        return n2;
    }

    static boolean FROM_U_IS_ROUNDTRIP(int n2) {
        return (n2 & Integer.MIN_VALUE) != 0;
    }

    private static int FROM_U_MASK_ROUNDTRIP(int n2) {
        return n2 & Integer.MAX_VALUE;
    }

    static int FROM_U_GET_LENGTH(int n2) {
        return n2 >>> 24 & 0x1F;
    }

    static int FROM_U_GET_DATA(int n2) {
        return n2 & 0xFFFFFF;
    }

    static Buffer ARRAY(ByteBuffer byteBuffer, int n2, Class<?> clazz) {
        int n3 = byteBuffer.position();
        byteBuffer.position(byteBuffer.getInt(n2 << 2));
        Buffer buffer = clazz == Integer.TYPE ? byteBuffer.asIntBuffer() : (clazz == Character.TYPE ? byteBuffer.asCharBuffer() : (clazz == Short.TYPE ? byteBuffer.asShortBuffer() : byteBuffer.slice()));
        byteBuffer.position(n3);
        return buffer;
    }

    private static int GET_MAX_BYTES_PER_UCHAR(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        return byteBuffer.getInt(17) & 0xFF;
    }

    static int findFromU(CharBuffer charBuffer, int n2, char c2) {
        int n3;
        int n4 = 0;
        int n5 = n2;
        while ((n3 = n5 - n4) > 1) {
            if (n3 <= 4) {
                if (c2 <= charBuffer.get(charBuffer.position() + n4) || ++n4 < n5 && c2 <= charBuffer.get(charBuffer.position() + n4) || ++n4 < n5 && c2 <= charBuffer.get(charBuffer.position() + n4)) break;
                ++n4;
                break;
            }
            n3 = (n4 + n5) / 2;
            if (c2 < charBuffer.get(charBuffer.position() + n3)) {
                n5 = n3;
                continue;
            }
            n4 = n3;
        }
        if (n4 < n5 && c2 == charBuffer.get(charBuffer.position() + n4)) {
            return n4;
        }
        return -1;
    }

    static int findToU(IntBuffer intBuffer, int n2, short s2) {
        int n3;
        int n4 = CharsetMBCS.TO_U_GET_BYTE(intBuffer.get(intBuffer.position()));
        int n5 = CharsetMBCS.TO_U_GET_BYTE(intBuffer.get(intBuffer.position() + n2 - 1));
        if (s2 < n4 || n5 < s2) {
            return 0;
        }
        if (n2 == n5 - n4 + 1) {
            return CharsetMBCS.TO_U_GET_VALUE(intBuffer.get(intBuffer.position() + s2 - n4));
        }
        long l2 = (long)CharsetMBCS.TO_U_MAKE_WORD((byte)s2, 0) & 0xFFFFFFFFL;
        long l3 = l2 | 0xFFFFFFL;
        n4 = 0;
        n5 = n2;
        while ((n3 = n5 - n4) > 1) {
            if (n3 <= 4) {
                if (l2 <= ((long)intBuffer.get(intBuffer.position() + n4) & 0xFFFFFFFFL) || ++n4 < n5 && l2 <= ((long)intBuffer.get(intBuffer.position() + n4) & 0xFFFFFFFFL) || ++n4 < n5 && l2 <= ((long)intBuffer.get(intBuffer.position() + n4) & 0xFFFFFFFFL)) break;
                ++n4;
                break;
            }
            n3 = (n4 + n5) / 2;
            if (l3 < ((long)intBuffer.get(intBuffer.position() + n3) & 0xFFFFFFFFL)) {
                n5 = n3;
                continue;
            }
            n4 = n3;
        }
        if (n4 < n5 && s2 == CharsetMBCS.TO_U_GET_BYTE((int)(l3 = (long)intBuffer.get(intBuffer.position() + n4) & 0xFFFFFFFFL))) {
            return CharsetMBCS.TO_U_GET_VALUE((int)l3);
        }
        return 0;
    }

    static boolean TO_U_VERIFY_SISO_MATCH(byte by2, int n2) {
        return by2 < 0 || by2 == 0 == (n2 == 1);
    }

    private static int SISO_STATE(UConverterSharedData uConverterSharedData, int n2) {
        return uConverterSharedData.mbcs.outputType == 12 ? (byte)n2 : (uConverterSharedData.mbcs.outputType == 219 ? (byte)1 : (byte)-1);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderMBCS(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderMBCS(this);
    }

    void MBCSGetFilteredUnicodeSetForUnicode(UConverterSharedData uConverterSharedData, UnicodeSet unicodeSet, int n2, int n3) {
        UConverterMBCSTable uConverterMBCSTable = uConverterSharedData.mbcs;
        char[] cArray = uConverterMBCSTable.fromUnicodeTable;
        char c2 = uConverterMBCSTable.hasSupplementary() ? (char)'\u0440' : '@';
        int n4 = 0;
        if (uConverterMBCSTable.outputType == 0) {
            char[] cArray2 = uConverterMBCSTable.fromUnicodeChars;
            char c3 = n2 == 0 ? (char)'\u0f00' : '\u0800';
            for (char c4 = '\u0000'; c4 < c2; c4 = (char)(c4 + '\u0001')) {
                char c5 = cArray[c4];
                if (c5 > c2) {
                    char c6 = c5;
                    for (c5 = '\u0000'; c5 < '@'; c5 = (char)(c5 + '\u0001')) {
                        char c7 = cArray[c6 + c5];
                        if (c7 != '\u0000') {
                            char c8 = c7;
                            do {
                                char c9 = c8;
                                c8 = (char)(c8 + '\u0001');
                                if (cArray2[c9] < c3) continue;
                                unicodeSet.add(n4);
                            } while ((++n4 & 0xF) != 0);
                            continue;
                        }
                        n4 += 16;
                    }
                    continue;
                }
                n4 += 1024;
            }
        } else {
            int n5;
            int[] nArray = uConverterMBCSTable.fromUnicodeTableInts;
            byte[] byArray = uConverterMBCSTable.fromUnicodeBytes;
            char[] cArray3 = uConverterMBCSTable.fromUnicodeChars;
            int[] nArray2 = uConverterMBCSTable.fromUnicodeInts;
            boolean bl2 = n2 == 1;
            switch (uConverterMBCSTable.outputType) {
                case 2: 
                case 9: {
                    n5 = 3;
                    break;
                }
                case 3: {
                    n5 = 4;
                    break;
                }
                default: {
                    n5 = 2;
                }
            }
            for (char c10 = '\u0000'; c10 < c2; c10 = (char)(c10 + '\u0001')) {
                char c11 = cArray[c10];
                if (c11 > c2 >> 1) {
                    char c12 = c11;
                    block21: for (c11 = '\u0000'; c11 < '@'; c11 = (char)(c11 + '\u0001')) {
                        int n6 = nArray[c12 + c11];
                        if (n6 != 0) {
                            int n7 = n5 * 16 * (n6 & 0xFFFF);
                            n6 >>>= 16;
                            switch (n3) {
                                case 1: {
                                    do {
                                        if ((n6 & 1) != 0) {
                                            unicodeSet.add(n4);
                                        } else if (bl2) {
                                            int n8 = 0;
                                            switch (n5) {
                                                case 4: {
                                                    n8 = nArray2[n7 / 4];
                                                    break;
                                                }
                                                case 3: {
                                                    n8 |= byArray[n7] | byArray[n7 + 1] | byArray[n7 + 2];
                                                    break;
                                                }
                                                case 2: {
                                                    n8 = cArray3[n7 / 2];
                                                    break;
                                                }
                                            }
                                            n7 += n5;
                                            if (n8 != 0) {
                                                unicodeSet.add(n4);
                                            }
                                        }
                                        n6 >>= 1;
                                    } while ((++n4 & 0xF) != 0);
                                    continue block21;
                                }
                                case 2: {
                                    do {
                                        if (((n6 & 1) != 0 || bl2) && cArray3[n7 / 2] >= '\u0100') {
                                            unicodeSet.add(n4);
                                        }
                                        n6 >>= 1;
                                        n7 += 2;
                                    } while ((++n4 & 0xF) != 0);
                                    continue block21;
                                }
                                case 3: {
                                    int n9;
                                    do {
                                        if (!((n6 & 1) == 0 && !bl2 || (n9 = 0xFF & byArray[n7]) != 129 && n9 != 130)) {
                                            unicodeSet.add(n4);
                                        }
                                        n6 >>= 1;
                                        n7 += 3;
                                    } while ((++n4 & 0xF) != 0);
                                    continue block21;
                                }
                                case 4: {
                                    int n9;
                                    do {
                                        if (((n6 & 1) != 0 || bl2) && (n9 = cArray3[n7 / 2]) >= 33088 && n9 <= 61436) {
                                            unicodeSet.add(n4);
                                        }
                                        n6 >>= 1;
                                        n7 += 2;
                                    } while ((++n4 & 0xF) != 0);
                                    continue block21;
                                }
                                case 5: {
                                    int n9;
                                    do {
                                        if (((n6 & 1) != 0 || bl2) && (0xFFFF & (n9 = cArray3[n7 / 2]) - 41377) <= 23901 && (0xFF & n9 - 161) <= 93) {
                                            unicodeSet.add(n4);
                                        }
                                        n6 >>= 1;
                                        n7 += 2;
                                    } while ((++n4 & 0xF) != 0);
                                    continue block21;
                                }
                                case 6: {
                                    int n9;
                                    do {
                                        if (((n6 & 1) != 0 || bl2) && (0xFFFF & (n9 = cArray3[n7 / 2]) - 41377) <= 23645 && (0xFF & n9 - 161) <= 93) {
                                            unicodeSet.add(n4);
                                        }
                                        n6 >>= 1;
                                        n7 += 2;
                                    } while ((++n4 & 0xF) != 0);
                                    continue block21;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        n4 += 16;
                    }
                    continue;
                }
                n4 += 1024;
            }
        }
        CharsetMBCS.extGetUnicodeSet(unicodeSet, n2, n3, uConverterSharedData);
    }

    static void extGetUnicodeSetString(ByteBuffer byteBuffer, UnicodeSet unicodeSet, boolean bl2, int n2, int n3, char[] cArray, int n4, int n5) {
        StringBuilder stringBuilder;
        int n6;
        CharBuffer charBuffer = (CharBuffer)CharsetMBCS.ARRAY(byteBuffer, 5, Character.TYPE);
        IntBuffer intBuffer = (IntBuffer)CharsetMBCS.ARRAY(byteBuffer, 6, Integer.TYPE);
        int n7 = charBuffer.position() + n5;
        int n8 = intBuffer.position() + n5;
        int n9 = charBuffer.get(n7++);
        if ((n6 = intBuffer.get(n8++)) != 0 && (CharsetMBCS.FROM_U_IS_ROUNDTRIP(n6) || bl2) && CharsetMBCS.FROM_U_GET_LENGTH(n6) >= n2) {
            if (n3 >= 0) {
                unicodeSet.add(n3);
            } else {
                stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < n4; ++i2) {
                    stringBuilder.append(cArray[i2]);
                }
                String string = stringBuilder.toString();
                for (int i3 = 0; i3 < n4; ++i3) {
                    unicodeSet.add(string);
                }
            }
        }
        for (int i4 = 0; i4 < n9; ++i4) {
            cArray[n4] = charBuffer.get(n7 + i4);
            n6 = intBuffer.get(n8 + i4);
            if (n6 == 0) continue;
            if (CharsetMBCS.FROM_U_IS_PARTIAL(n6)) {
                CharsetMBCS.extGetUnicodeSetString(byteBuffer, unicodeSet, bl2, n2, -1, cArray, n4 + 1, CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(n6));
                continue;
            }
            if (!(bl2 ? (n6 & 0x60000000) == 0 : (n6 & 0xE0000000) == Integer.MIN_VALUE) || CharsetMBCS.FROM_U_GET_LENGTH(n6) < n2) continue;
            stringBuilder = new StringBuilder();
            for (int i5 = 0; i5 < n4 + 1; ++i5) {
                stringBuilder.append(cArray[i5]);
            }
            unicodeSet.add(stringBuilder.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    static void extGetUnicodeSet(UnicodeSet var0, int var1_1, int var2_2, UConverterSharedData var3_3) {
        var17_4 = new char[19];
        var19_5 = var3_3.mbcs.extIndexes;
        if (var19_5 == null) {
            return;
        }
        var11_6 = (CharBuffer)CharsetMBCS.ARRAY(var19_5, 10, Character.TYPE);
        var12_7 = (CharBuffer)CharsetMBCS.ARRAY(var19_5, 13, Character.TYPE);
        var15_8 = (IntBuffer)CharsetMBCS.ARRAY(var19_5, 15, Integer.TYPE);
        var5_9 = var19_5.asIntBuffer().get(11);
        var16_10 = var1_1 == 1;
        var18_11 = 0;
        var8_12 = var2_2 == 3 ? 3 : (var3_3.mbcs.outputType == 219 || var2_2 != 1 ? 2 : 1);
        for (var4_13 = 0; var4_13 < var5_9; ++var4_13) {
            block14: {
                var6_14 = var11_6.get(var4_13);
                if (var6_14 <= var5_9) break block14;
                var9_16 = var6_14;
                for (var6_14 = 0; var6_14 < 64; ++var6_14) {
                    block15: {
                        var7_15 = var11_6.get(var9_16 + var6_14) << 2;
                        if (var7_15 == 0) break block15;
                        var10_17 = var7_15;
                        block8: do {
                            if ((var13_18 = var15_8.get(var12_7.get(var10_17++))) == 0) continue;
                            if (CharsetMBCS.FROM_U_IS_PARTIAL(var13_18)) {
                                var14_19 = 0;
                                var14_19 = UTF16.append(var17_4, var14_19, var18_11);
                                CharsetMBCS.extGetUnicodeSetString(var19_5, var0, var16_10, var8_12, var18_11, var17_4, var14_19, CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(var13_18));
                                continue;
                            }
                            if (!(var16_10 != false ? (var13_18 & 0x60000000) == 0 : (var13_18 & -536870912) == -2147483648) || CharsetMBCS.FROM_U_GET_LENGTH(var13_18) < var8_12) continue;
                            switch (var2_2) {
                                case 3: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(var13_18) != 3 || CharsetMBCS.FROM_U_GET_DATA(var13_18) > 0x82FFFF) {
                                        break;
                                    }
                                    ** GOTO lbl43
                                }
                                case 4: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(var13_18) != 2 || (var13_18 = CharsetMBCS.FROM_U_GET_DATA(var13_18)) < 33088 || var13_18 > 61436) {
                                        break;
                                    }
                                    ** GOTO lbl43
                                }
                                case 5: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(var13_18) != 2 || (var13_18 = CharsetMBCS.FROM_U_GET_DATA(var13_18)) - 41377 > 23901 || (255 & var13_18 - 161) > 93) {
                                        break;
                                    }
                                    ** GOTO lbl43
                                }
                                case 6: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(var13_18) != 2 || (var13_18 = CharsetMBCS.FROM_U_GET_DATA(var13_18)) - 41377 > 23645 || (255 & var13_18 - 161) > 93) continue block8;
                                }
lbl43:
                                // 5 sources

                                default: {
                                    var0.add(var18_11);
                                }
                            }
                        } while ((++var18_11 & 15) != 0);
                        continue;
                    }
                    var18_11 += 16;
                }
                continue;
            }
            var18_11 += 1024;
        }
    }

    void MBCSGetUnicodeSetForUnicode(UConverterSharedData uConverterSharedData, UnicodeSet unicodeSet, int n2) {
        this.MBCSGetFilteredUnicodeSetForUnicode(uConverterSharedData, unicodeSet, n2, this.sharedData.mbcs.outputType == 219 ? 2 : 1);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        if ((this.options & 0x8000) != 0) {
            unicodeSet.add(0, 55295);
            unicodeSet.add(57344, 0x10FFFF);
        } else {
            this.MBCSGetUnicodeSetForUnicode(this.sharedData, unicodeSet, n2);
        }
    }

    class CharsetEncoderMBCS
    extends CharsetEncoderICU {
        private boolean allowReplacementChanges;

        CharsetEncoderMBCS(CharsetICU charsetICU) {
            super(charsetICU, CharsetMBCS.this.fromUSubstitution);
            this.allowReplacementChanges = false;
            this.allowReplacementChanges = true;
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.preFromUFirstCP = -1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[2];
            int n5 = 0;
            int n6 = 0;
            boolean bl3 = false;
            try {
                SideEffects sideEffects;
                int n7;
                if (!bl2 && this.preFromUFirstCP >= 0) {
                    coderResultArray[0] = this.continueMatchFromU(charBuffer, byteBuffer, intBuffer, bl2, -1);
                    if (coderResultArray[0].isError()) return coderResultArray[0];
                    if (this.preFromULength < 0) {
                        return coderResultArray[0];
                    }
                }
                short s2 = CharsetMBCS.this.sharedData.mbcs.outputType;
                short s3 = CharsetMBCS.this.sharedData.mbcs.unicodeMask;
                if (s2 == 0 && (s3 & 2) == 0) {
                    if ((s3 & 1) == 0) {
                        coderResultArray[0] = this.cnvMBCSSingleFromBMPWithOffsets(charBuffer, byteBuffer, intBuffer, bl2);
                        return coderResultArray[0];
                    }
                    coderResultArray[0] = this.cnvMBCSSingleFromUnicodeWithOffsets(charBuffer, byteBuffer, intBuffer, bl2);
                    return coderResultArray[0];
                }
                if (s2 == 1) {
                    coderResultArray[0] = this.cnvMBCSDoubleFromUnicodeWithOffsets(charBuffer, byteBuffer, intBuffer, bl2);
                    return coderResultArray[0];
                }
                char[] cArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
                int[] nArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTableInts;
                int n8 = charBuffer.position();
                byte[] byArray3 = CharsetMBCS.this.sharedData.mbcs.fromUnicodeBytes;
                int[] nArray2 = CharsetMBCS.this.sharedData.mbcs.fromUnicodeInts;
                char[] cArray2 = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
                int n9 = this.fromUChar32;
                if (s2 == 12) {
                    n7 = this.fromUnicodeStatus;
                    if (n7 == 0) {
                        n7 = 1;
                    }
                } else {
                    n7 = 0;
                }
                int n10 = -1;
                int n11 = n9 == 0 ? 0 : -1;
                int n12 = 0;
                n5 = CharsetMBCS.getSISOBytes(SISO_Option.SI, CharsetMBCS.this.options, byArray);
                n6 = CharsetMBCS.getSISOBytes(SISO_Option.SO, CharsetMBCS.this.options, byArray2);
                boolean bl4 = true;
                boolean bl5 = true;
                if (n9 != 0 && byteBuffer.hasRemaining()) {
                    if (UTF16.isLeadSurrogate(n9) && (s3 & 2) == 0) {
                        sideEffects = new SideEffects(n9, n8, n11, n12, n10, n7);
                        bl4 = this.getTrail(charBuffer, byteBuffer, s3, sideEffects, bl2, coderResultArray);
                        bl5 = sideEffects.doread;
                        n9 = sideEffects.c;
                        n8 = sideEffects.sourceArrayIndex;
                        n11 = sideEffects.sourceIndex;
                        n12 = sideEffects.nextSourceIndex;
                        n10 = sideEffects.prevSourceIndex;
                        n7 = sideEffects.prevLength;
                    } else {
                        bl5 = false;
                    }
                }
                if (bl4) {
                    while (!bl5 || n8 < charBuffer.limit()) {
                        if (byteBuffer.hasRemaining()) {
                            if (bl5) {
                                n9 = charBuffer.get(n8++);
                                ++n12;
                                if (UTF16.isSurrogate(n9) && (s3 & 2) == 0) {
                                    if (UTF16.isLeadSurrogate(n9)) {
                                        sideEffects = new SideEffects(n9, n8, n11, n12, n10, n7);
                                        bl4 = this.getTrail(charBuffer, byteBuffer, s3, sideEffects, bl2, coderResultArray);
                                        n9 = sideEffects.c;
                                        n8 = sideEffects.sourceArrayIndex;
                                        n11 = sideEffects.sourceIndex;
                                        n12 = sideEffects.nextSourceIndex;
                                        n10 = sideEffects.prevSourceIndex;
                                        if (sideEffects.doread) {
                                            if (!bl4) break;
                                            continue;
                                        }
                                    } else {
                                        coderResultArray[0] = CoderResult.malformedForLength(1);
                                        break;
                                    }
                                }
                            } else {
                                bl5 = true;
                            }
                            n2 = CharsetMBCS.MBCS_STAGE_2_FROM_U(cArray, nArray, n9);
                            switch (s2) {
                                case 12: {
                                    this.fromUnicodeStatus = n7;
                                    n3 = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(cArray2, n2, n9);
                                    if (n3 <= 255) {
                                        if (n3 == 0 && !CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(n2, n9)) {
                                            n4 = 0;
                                            break;
                                        }
                                        if (n7 <= 1) {
                                            n4 = 1;
                                            break;
                                        }
                                        if (n5 == 1) {
                                            n3 |= byArray[0] << 8;
                                            n4 = 2;
                                        } else if (n5 == 2) {
                                            n3 |= byArray[1] << 8;
                                            n3 |= byArray[0] << 16;
                                            n4 = 3;
                                        }
                                        n7 = 1;
                                        break;
                                    }
                                    if (n7 == 2) {
                                        n4 = 2;
                                        break;
                                    }
                                    if (n6 == 1) {
                                        n3 |= byArray2[0] << 16;
                                        n4 = 3;
                                    } else if (n6 == 2) {
                                        n3 |= byArray2[1] << 16;
                                        n3 |= byArray2[0] << 24;
                                        n4 = 4;
                                    }
                                    n7 = 2;
                                    break;
                                }
                                case 219: {
                                    n3 = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(cArray2, n2, n9);
                                    if (n3 <= 255) {
                                        n2 = 0;
                                        n3 = 0;
                                        n4 = 0;
                                        break;
                                    }
                                    n4 = 2;
                                    break;
                                }
                                case 2: {
                                    byte[] byArray4 = byArray3;
                                    int n13 = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(byArray3, n2, n9);
                                    n3 = (byArray4[n13] & 0xFF) << 16 | (byArray4[n13 + 1] & 0xFF) << 8 | byArray4[n13 + 2] & 0xFF;
                                    if (n3 <= 255) {
                                        n4 = 1;
                                        break;
                                    }
                                    if (n3 <= 65535) {
                                        n4 = 2;
                                        break;
                                    }
                                    n4 = 3;
                                    break;
                                }
                                case 3: {
                                    n3 = CharsetMBCS.MBCS_VALUE_4_FROM_STAGE_2(nArray2, n2, n9);
                                    if (n3 < 0) {
                                        n4 = 4;
                                        break;
                                    }
                                    if (n3 <= 255) {
                                        n4 = 1;
                                        break;
                                    }
                                    if (n3 <= 65535) {
                                        n4 = 2;
                                        break;
                                    }
                                    if (n3 <= 0xFFFFFF) {
                                        n4 = 3;
                                        break;
                                    }
                                    n4 = 4;
                                    break;
                                }
                                case 8: {
                                    n3 = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(cArray2, n2, n9);
                                    if (n3 <= 255) {
                                        n4 = 1;
                                        break;
                                    }
                                    if ((n3 & 0x8000) == 0) {
                                        n3 |= 0x8E8000;
                                        n4 = 3;
                                        break;
                                    }
                                    if ((n3 & 0x80) == 0) {
                                        n3 |= 0x8F0080;
                                        n4 = 3;
                                        break;
                                    }
                                    n4 = 2;
                                    break;
                                }
                                case 9: {
                                    byte[] byArray4 = byArray3;
                                    int n13 = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(byArray3, n2, n9);
                                    n3 = (byArray4[n13] & 0xFF) << 16 | (byArray4[n13 + 1] & 0xFF) << 8 | byArray4[n13 + 2] & 0xFF;
                                    if (n3 <= 255) {
                                        n4 = 1;
                                        break;
                                    }
                                    if (n3 <= 65535) {
                                        n4 = 2;
                                        break;
                                    }
                                    if ((n3 & 0x800000) == 0) {
                                        n3 |= 0x8E800000;
                                        n4 = 4;
                                        break;
                                    }
                                    if ((n3 & 0x8000) == 0) {
                                        n3 |= 0x8F008000;
                                        n4 = 4;
                                        break;
                                    }
                                    n4 = 3;
                                    break;
                                }
                                default: {
                                    n2 = 0;
                                    n3 = 0;
                                    n4 = 0;
                                }
                            }
                            if (bl3 || !CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(n2, n9) && (!this.isFromUUseFallback(n9) || n3 == 0)) {
                                bl3 = false;
                                sideEffects = new SideEffects(n9, n8, n11, n12, n10, n7);
                                bl4 = this.unassigned(charBuffer, byteBuffer, intBuffer, sideEffects, bl2, coderResultArray);
                                n9 = sideEffects.c;
                                n8 = sideEffects.sourceArrayIndex;
                                n11 = sideEffects.sourceIndex;
                                n12 = sideEffects.nextSourceIndex;
                                n10 = sideEffects.prevSourceIndex;
                                n7 = sideEffects.prevLength;
                                if (!bl4) break;
                                continue;
                            }
                            if (n4 <= byteBuffer.remaining()) {
                                switch (n4) {
                                    case 4: {
                                        byteBuffer.put((byte)(n3 >>> 24));
                                        if (intBuffer != null) {
                                            intBuffer.put(n11);
                                        }
                                    }
                                    case 3: {
                                        byteBuffer.put((byte)(n3 >>> 16));
                                        if (intBuffer != null) {
                                            intBuffer.put(n11);
                                        }
                                    }
                                    case 2: {
                                        byteBuffer.put((byte)(n3 >>> 8));
                                        if (intBuffer != null) {
                                            intBuffer.put(n11);
                                        }
                                    }
                                    case 1: {
                                        byteBuffer.put((byte)n3);
                                        if (intBuffer == null) break;
                                        intBuffer.put(n11);
                                        break;
                                    }
                                }
                                n9 = 0;
                                if (intBuffer == null) continue;
                            } else {
                                int n14 = 0;
                                switch (n4 -= byteBuffer.remaining()) {
                                    case 3: {
                                        this.errorBuffer[n14++] = (byte)(n3 >>> 16);
                                    }
                                    case 2: {
                                        this.errorBuffer[n14++] = (byte)(n3 >>> 8);
                                    }
                                    case 1: {
                                        this.errorBuffer[n14] = (byte)n3;
                                        break;
                                    }
                                }
                                this.errorBufferLength = (byte)n4;
                                n3 >>>= 8 * n4;
                                switch (byteBuffer.remaining()) {
                                    case 3: {
                                        byteBuffer.put((byte)(n3 >>> 16));
                                        if (intBuffer != null) {
                                            intBuffer.put(n11);
                                        }
                                    }
                                    case 2: {
                                        byteBuffer.put((byte)(n3 >>> 8));
                                        if (intBuffer != null) {
                                            intBuffer.put(n11);
                                        }
                                    }
                                    case 1: {
                                        byteBuffer.put((byte)n3);
                                        if (intBuffer == null) break;
                                        intBuffer.put(n11);
                                        break;
                                    }
                                }
                                coderResultArray[0] = CoderResult.OVERFLOW;
                                n9 = 0;
                                break;
                            }
                            n10 = n11;
                            n11 = n12;
                            continue;
                        }
                        coderResultArray[0] = CoderResult.OVERFLOW;
                        break;
                    }
                }
                if (s2 == 12 && n7 == 2 && bl2 && n8 >= charBuffer.limit() && n9 == 0) {
                    if (byteBuffer.hasRemaining()) {
                        byteBuffer.put(byArray[0]);
                        if (n5 == 2) {
                            if (byteBuffer.remaining() > 0) {
                                byteBuffer.put(byArray[1]);
                            } else {
                                this.errorBuffer[0] = byArray[1];
                                this.errorBufferLength = 1;
                                coderResultArray[0] = CoderResult.OVERFLOW;
                            }
                        }
                        if (intBuffer != null) {
                            intBuffer.put(n10);
                        }
                    } else {
                        this.errorBuffer[0] = byArray[0];
                        if (n5 == 2) {
                            this.errorBuffer[1] = byArray[1];
                        }
                        this.errorBufferLength = n5;
                        coderResultArray[0] = CoderResult.OVERFLOW;
                    }
                    n7 = 1;
                }
                this.fromUChar32 = n9;
                this.fromUnicodeStatus = n7;
                charBuffer.position(n8);
                return coderResultArray[0];
            }
            catch (BufferOverflowException bufferOverflowException) {
                coderResultArray[0] = CoderResult.OVERFLOW;
            }
            return coderResultArray[0];
        }

        int fromUChar32(int n2, int[] nArray, boolean bl2) {
            int n3;
            if (n2 <= 65535 || CharsetMBCS.this.sharedData.mbcs.hasSupplementary()) {
                char[] cArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
                if (CharsetMBCS.this.sharedData.mbcs.outputType == 0) {
                    char c2 = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(cArray, CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars, n2);
                    if (bl2 ? c2 >= '\u0800' : c2 >= '\u0c00') {
                        nArray[0] = c2 & 0xFF;
                        return 1;
                    }
                } else {
                    int n4;
                    int[] nArray2 = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTableInts;
                    int n5 = CharsetMBCS.MBCS_STAGE_2_FROM_U(cArray, nArray2, n2);
                    switch (CharsetMBCS.this.sharedData.mbcs.outputType) {
                        case 1: {
                            n4 = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars, n5, n2);
                            if (n4 <= 255) {
                                n3 = 1;
                                break;
                            }
                            n3 = 2;
                            break;
                        }
                        case 2: {
                            byte[] byArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeBytes;
                            int n6 = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(byArray, n5, n2);
                            n4 = (byArray[n6] & 0xFF) << 16 | (byArray[n6 + 1] & 0xFF) << 8 | byArray[n6 + 2] & 0xFF;
                            if (n4 <= 255) {
                                n3 = 1;
                                break;
                            }
                            if (n4 <= 65535) {
                                n3 = 2;
                                break;
                            }
                            n3 = 3;
                            break;
                        }
                        default: {
                            return -1;
                        }
                    }
                    if (CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(n5, n2) || CharsetEncoderICU.isFromUUseFallback(bl2, n2) && n4 != 0) {
                        nArray[0] = n4;
                        return n3;
                    }
                }
            }
            if (CharsetMBCS.this.sharedData.mbcs.extIndexes != null) {
                n3 = this.simpleMatchFromU(n2, nArray, bl2);
                return n3 >= 0 ? n3 : -n3;
            }
            return 0;
        }

        private CoderResult continueMatchFromU(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2, int n2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            int[] nArray = new int[1];
            int n3 = this.matchFromU(this.preFromUFirstCP, this.preFromUArray, this.preFromUBegin, this.preFromULength, charBuffer, nArray, this.useFallback, bl2);
            if (n3 >= 2) {
                if ((n3 -= 2) >= this.preFromULength) {
                    charBuffer.position(charBuffer.position() + n3 - this.preFromULength);
                    this.preFromULength = 0;
                } else {
                    int n4 = this.preFromULength - n3;
                    System.arraycopy(this.preFromUArray, this.preFromUBegin + n3, this.preFromUArray, this.preFromUBegin, n4);
                    this.preFromULength = (byte)(-n4);
                }
                this.preFromUFirstCP = -1;
                this.writeFromU(nArray[0], byteBuffer, intBuffer, n2);
            } else if (n3 < 0) {
                int n5 = charBuffer.position();
                n3 = -n3 - 2;
                for (int i2 = this.preFromULength; i2 < n3; ++i2) {
                    this.preFromUArray[i2] = charBuffer.get(n5++);
                }
                charBuffer.position(n5);
                this.preFromULength = (byte)n3;
            } else {
                if (n3 == 1) {
                    this.useSubChar1 = true;
                }
                this.fromUChar32 = this.preFromUFirstCP;
                this.preFromUFirstCP = -1;
                this.preFromULength = (byte)(-this.preFromULength);
                coderResult = CoderResult.unmappableForLength(1);
            }
            return coderResult;
        }

        private int matchFromU(int n2, char[] cArray, int n3, int n4, CharBuffer charBuffer, int[] nArray, boolean bl2, boolean bl3) {
            int n5;
            int n6;
            ByteBuffer byteBuffer = CharsetMBCS.this.sharedData.mbcs.extIndexes;
            if (byteBuffer == null) {
                return 0;
            }
            int n7 = n2 >>> 10;
            if (n7 >= byteBuffer.asIntBuffer().get(11)) {
                return 0;
            }
            CharBuffer charBuffer2 = (CharBuffer)CharsetMBCS.ARRAY(byteBuffer, 10, Character.TYPE);
            CharBuffer charBuffer3 = (CharBuffer)CharsetMBCS.ARRAY(byteBuffer, 13, Character.TYPE);
            n7 = CharsetMBCS.FROM_U(charBuffer2, charBuffer3, n7, n2);
            IntBuffer intBuffer = (IntBuffer)CharsetMBCS.ARRAY(byteBuffer, 15, Integer.TYPE);
            int n8 = intBuffer.get(intBuffer.position() + n7);
            if (n8 == 0) {
                return 0;
            }
            if (CharsetMBCS.TO_U_IS_PARTIAL(n8)) {
                block17: {
                    n7 = CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(n8);
                    CharBuffer charBuffer4 = (CharBuffer)CharsetMBCS.ARRAY(byteBuffer, 5, Character.TYPE);
                    IntBuffer intBuffer2 = (IntBuffer)CharsetMBCS.ARRAY(byteBuffer, 6, Integer.TYPE);
                    n6 = 0;
                    n5 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    while (true) {
                        char c2;
                        int n11 = charBuffer4.position();
                        CharBuffer charBuffer5 = ((CharBuffer)charBuffer4.position(n7)).slice();
                        charBuffer4.position(n11);
                        n11 = intBuffer2.position();
                        IntBuffer intBuffer3 = ((IntBuffer)intBuffer2.position(n7)).slice();
                        intBuffer2.position(n11);
                        int n12 = charBuffer5.get();
                        n8 = intBuffer3.get();
                        if (n8 != 0 && (CharsetMBCS.FROM_U_IS_ROUNDTRIP(n8) || CharsetEncoderMBCS.isFromUUseFallback(bl2, n2))) {
                            n6 = n8;
                            n5 = 2 + n10 + n9;
                        }
                        if (n10 < n4) {
                            c2 = cArray[n3 + n10++];
                        } else {
                            if (charBuffer == null || n9 >= charBuffer.remaining()) {
                                if (!bl3 && (n12 = n10 + n9) <= 19) {
                                    return -(2 + n12);
                                }
                                break block17;
                            }
                            c2 = charBuffer.get(charBuffer.position() + n9++);
                        }
                        n7 = CharsetMBCS.findFromU(charBuffer5, n12, c2);
                        if (n7 < 0) break block17;
                        n8 = intBuffer3.get(intBuffer3.position() + n7);
                        if (!CharsetMBCS.FROM_U_IS_PARTIAL(n8)) break;
                        n7 = CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(n8);
                    }
                    if (CharsetMBCS.FROM_U_IS_ROUNDTRIP(n8) || CharsetEncoderMBCS.isFromUUseFallback(bl2, n2)) {
                        n6 = n8;
                        n5 = 2 + n10 + n9;
                    }
                }
                if (n5 == 0) {
                    return 0;
                }
            } else if (CharsetMBCS.FROM_U_IS_ROUNDTRIP(n8) || CharsetEncoderMBCS.isFromUUseFallback(bl2, n2)) {
                n6 = n8;
                n5 = 2;
            } else {
                return 0;
            }
            if ((n6 & 0x60000000) != 0) {
                return 0;
            }
            if (n6 == -2147483647) {
                return 1;
            }
            nArray[0] = CharsetMBCS.FROM_U_MASK_ROUNDTRIP(n6);
            return n5;
        }

        private int simpleMatchFromU(int n2, int[] nArray, boolean bl2) {
            int[] nArray2 = new int[1];
            int n3 = this.matchFromU(n2, null, 0, 0, null, nArray2, bl2, true);
            if (n3 >= 2) {
                boolean bl3 = CharsetMBCS.FROM_U_IS_ROUNDTRIP(nArray2[0]);
                int n4 = CharsetMBCS.FROM_U_GET_LENGTH(nArray2[0]);
                nArray2[0] = CharsetMBCS.FROM_U_GET_DATA(nArray2[0]);
                if (n4 <= 3) {
                    nArray[0] = nArray2[0];
                    return bl3 ? n4 : -n4;
                }
            }
            return 0;
        }

        private CoderResult writeFromU(int n2, ByteBuffer byteBuffer, IntBuffer intBuffer, int n3) {
            int n4;
            byte[] byArray;
            ByteBuffer byteBuffer2 = CharsetMBCS.this.sharedData.mbcs.extIndexes;
            byte[] byArray2 = new byte[32];
            int n5 = 0;
            int n6 = CharsetMBCS.FROM_U_GET_LENGTH(n2);
            n2 = CharsetMBCS.FROM_U_GET_DATA(n2);
            if (n6 <= 3) {
                int n7 = n5 + 1;
                switch (n6) {
                    case 3: {
                        byArray2[n7++] = (byte)(n2 >>> 16);
                    }
                    case 2: {
                        byArray2[n7++] = (byte)(n2 >>> 8);
                    }
                    case 1: {
                        byArray2[n7++] = (byte)n2;
                    }
                }
                byArray = byArray2;
                n4 = n5 + 1;
            } else {
                byte[] byArray3 = new byte[n6];
                ByteBuffer byteBuffer3 = (ByteBuffer)CharsetMBCS.ARRAY(byteBuffer2, 8, Byte.TYPE);
                byteBuffer3.position(n2);
                byteBuffer3.get(byArray3, 0, byArray3.length);
                byArray = byArray3;
                n4 = 0;
            }
            int n8 = this.fromUnicodeStatus;
            if (n8 != 0) {
                int n9;
                if (n8 > 1 && n6 == 1) {
                    n9 = 15;
                    this.fromUnicodeStatus = 1;
                } else if (n8 == 1 && n6 > 1) {
                    n9 = 14;
                    this.fromUnicodeStatus = 2;
                } else {
                    n9 = 0;
                }
                if (n9 != 0) {
                    byArray2[0] = n9;
                    if (byArray != byArray2 || n4 != n5 + 1) {
                        System.arraycopy(byArray, n4, byArray2, n5 + 1, n6);
                    }
                    byArray = byArray2;
                    n4 = n5;
                    ++n6;
                }
            }
            return CharsetEncoderMBCS.fromUWriteBytes(this, byArray, n4, n6, byteBuffer, intBuffer, n3);
        }

        private int fromU(int n2, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, int n3, int n4, boolean bl2, CoderResult[] coderResultArray) {
            this.useSubChar1 = false;
            if (CharsetMBCS.this.sharedData.mbcs.extIndexes != null && this.initialMatchFromU(n2, charBuffer, byteBuffer, intBuffer, n3, bl2, coderResultArray)) {
                return 0;
            }
            if ((CharsetMBCS.this.options & 0x8000) != 0) {
                for (int i2 = 0; i2 < gb18030Ranges.length; ++i2) {
                    int[] nArray = gb18030Ranges[i2];
                    if (nArray[0] > n2 || n2 > nArray[1]) continue;
                    byte[] byArray = new byte[4];
                    int n5 = nArray[2] - LINEAR_18030_BASE;
                    byArray[3] = (byte)(48 + (n5 += n2 - nArray[0]) % 10);
                    byArray[2] = (byte)(129 + (n5 /= 10) % 126);
                    byArray[1] = (byte)(48 + (n5 /= 126) % 10);
                    byArray[0] = (byte)(129 + (n5 /= 10));
                    coderResultArray[0] = CharsetEncoderMBCS.fromUWriteBytes(this, byArray, 0, 4, byteBuffer, intBuffer, n3);
                    return 0;
                }
            }
            coderResultArray[0] = CoderResult.unmappableForLength(n4);
            return n2;
        }

        private boolean initialMatchFromU(int n2, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, int n3, boolean bl2, CoderResult[] coderResultArray) {
            int[] nArray = new int[1];
            int n4 = this.matchFromU(n2, null, 0, 0, charBuffer, nArray, this.useFallback, bl2);
            if (n4 >= 2 && (CharsetMBCS.FROM_U_GET_LENGTH(nArray[0]) != 1 || CharsetMBCS.this.sharedData.mbcs.outputType != 219)) {
                charBuffer.position(charBuffer.position() + n4 - 2);
                coderResultArray[0] = this.writeFromU(nArray[0], byteBuffer, intBuffer, n3);
                return true;
            }
            if (n4 < 0) {
                this.preFromUFirstCP = n2;
                int n5 = charBuffer.position();
                n4 = -n4 - 2;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.preFromUArray[i2] = charBuffer.get(n5++);
                }
                charBuffer.position(n5);
                this.preFromULength = (byte)n4;
                return true;
            }
            if (n4 == 1) {
                this.useSubChar1 = true;
                return false;
            }
            return false;
        }

        CoderResult cnvMBCSFromUnicodeWithOffsets(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            return this.encodeLoop(charBuffer, byteBuffer, intBuffer, bl2);
        }

        private CoderResult cnvMBCSSingleFromBMPWithOffsets(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            SideEffectsSingleBMP sideEffectsSingleBMP;
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            int n2 = charBuffer.position();
            int n3 = byteBuffer.remaining();
            char[] cArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
            char[] cArray2 = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
            char c2 = this.useFallback ? (char)'\u0800' : '\u0c00';
            int n4 = this.fromUChar32;
            int n5 = n4 == 0 ? 0 : -1;
            int n6 = n2;
            int n7 = charBuffer.limit() - n2;
            if (n7 < n3) {
                n3 = n7;
            }
            boolean bl3 = true;
            if (n4 != 0 && n3 > 0) {
                sideEffectsSingleBMP = new SideEffectsSingleBMP(n4, n2);
                bl3 = this.getTrailSingleBMP(charBuffer, sideEffectsSingleBMP, coderResultArray);
                n4 = sideEffectsSingleBMP.c;
                n2 = sideEffectsSingleBMP.sourceArrayIndex;
            }
            if (bl3) {
                while (n3 > 0) {
                    char c3;
                    if ((c3 = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(cArray, cArray2, n4 = (int)charBuffer.get(n2++))) >= c2) {
                        byteBuffer.put((byte)c3);
                        --n3;
                        n4 = 0;
                        continue;
                    }
                    if (UTF16.isSurrogate(n4)) {
                        if (UTF16.isLeadSurrogate(n4)) {
                            sideEffectsSingleBMP = new SideEffectsSingleBMP(n4, n2);
                            bl3 = this.getTrailSingleBMP(charBuffer, sideEffectsSingleBMP, coderResultArray);
                            n4 = sideEffectsSingleBMP.c;
                            n2 = sideEffectsSingleBMP.sourceArrayIndex;
                            if (!bl3) {
                                break;
                            }
                        } else {
                            coderResultArray[0] = CoderResult.malformedForLength(1);
                            break;
                        }
                    }
                    n7 = UTF16.getCharCount(n4);
                    if (intBuffer != null) {
                        int n8 = n2 - n6;
                        n8 -= n7;
                        while (n8 > 0) {
                            intBuffer.put(n5++);
                            --n8;
                        }
                    }
                    n6 = n2;
                    charBuffer.position(n2);
                    n4 = this.fromU(n4, charBuffer, byteBuffer, intBuffer, n5, n7, bl2, coderResultArray);
                    n2 = charBuffer.position();
                    n5 += n7 + (n2 - n6);
                    n6 = n2;
                    if (coderResultArray[0].isError()) break;
                    n3 = byteBuffer.remaining();
                    n7 = charBuffer.limit() - n2;
                    if (n7 >= n3) continue;
                    n3 = n7;
                }
            }
            if (n2 < charBuffer.limit() && !byteBuffer.hasRemaining()) {
                coderResultArray[0] = CoderResult.OVERFLOW;
            }
            if (intBuffer != null) {
                for (int i2 = n2 - n6; i2 > 0; --i2) {
                    intBuffer.put(n5++);
                }
            }
            this.fromUChar32 = n4;
            charBuffer.position(n2);
            return coderResultArray[0];
        }

        /*
         * Enabled aggressive block sorting
         */
        private CoderResult cnvMBCSSingleFromUnicodeWithOffsets(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            SideEffectsDouble sideEffectsDouble;
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            int n2 = charBuffer.position();
            char[] cArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
            char[] cArray2 = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
            char c2 = this.useFallback ? (char)'\u0800' : '\u0c00';
            short s2 = CharsetMBCS.this.sharedData.mbcs.unicodeMask;
            int n3 = this.fromUChar32;
            int n4 = n3 == 0 ? 0 : -1;
            int n5 = 0;
            boolean bl3 = true;
            boolean bl4 = true;
            if (n3 != 0 && byteBuffer.hasRemaining()) {
                if (UTF16.isLeadSurrogate(n3)) {
                    sideEffectsDouble = new SideEffectsDouble(n3, n2, n4, n5);
                    bl3 = this.getTrailDouble(charBuffer, byteBuffer, s2, sideEffectsDouble, bl2, coderResultArray);
                    bl4 = sideEffectsDouble.doread;
                    n3 = sideEffectsDouble.c;
                    n2 = sideEffectsDouble.sourceArrayIndex;
                    n4 = sideEffectsDouble.sourceIndex;
                    n5 = sideEffectsDouble.nextSourceIndex;
                } else {
                    bl4 = false;
                }
            }
            if (bl3) {
                while (!bl4 || n2 < charBuffer.limit()) {
                    if (byteBuffer.hasRemaining()) {
                        char c3;
                        if (bl4) {
                            n3 = charBuffer.get(n2++);
                            ++n5;
                            if (UTF16.isSurrogate(n3)) {
                                if (UTF16.isLeadSurrogate(n3)) {
                                    sideEffectsDouble = new SideEffectsDouble(n3, n2, n4, n5);
                                    bl3 = this.getTrailDouble(charBuffer, byteBuffer, s2, sideEffectsDouble, bl2, coderResultArray);
                                    n3 = sideEffectsDouble.c;
                                    n2 = sideEffectsDouble.sourceArrayIndex;
                                    n4 = sideEffectsDouble.sourceIndex;
                                    n5 = sideEffectsDouble.nextSourceIndex;
                                    if (sideEffectsDouble.doread) {
                                        if (!bl3) break;
                                        continue;
                                    }
                                } else {
                                    coderResultArray[0] = CoderResult.malformedForLength(1);
                                    break;
                                }
                            }
                        } else {
                            bl4 = true;
                        }
                        if ((c3 = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(cArray, cArray2, n3)) >= c2) {
                            byteBuffer.put((byte)c3);
                            if (intBuffer != null) {
                                intBuffer.put(n4);
                            }
                            n3 = 0;
                            n4 = n5;
                            continue;
                        }
                        sideEffectsDouble = new SideEffectsDouble(n3, n2, n4, n5);
                        bl3 = this.unassignedDouble(charBuffer, byteBuffer, sideEffectsDouble, bl2, coderResultArray);
                        n3 = sideEffectsDouble.c;
                        n2 = sideEffectsDouble.sourceArrayIndex;
                        n4 = sideEffectsDouble.sourceIndex;
                        n5 = sideEffectsDouble.nextSourceIndex;
                        if (bl3) continue;
                        break;
                    }
                    coderResultArray[0] = CoderResult.OVERFLOW;
                    break;
                }
            }
            this.fromUChar32 = n3;
            charBuffer.position(n2);
            return coderResultArray[0];
        }

        /*
         * Enabled aggressive block sorting
         */
        private CoderResult cnvMBCSDoubleFromUnicodeWithOffsets(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            SideEffectsDouble sideEffectsDouble;
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            short s2 = CharsetMBCS.this.sharedData.mbcs.unicodeMask;
            int n2 = charBuffer.position();
            char[] cArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
            int[] nArray = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTableInts;
            char[] cArray2 = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
            int n3 = this.fromUChar32;
            int n4 = n3 == 0 ? 0 : -1;
            int n5 = 0;
            boolean bl3 = true;
            boolean bl4 = true;
            if (n3 != 0 && byteBuffer.hasRemaining()) {
                if (UTF16.isLeadSurrogate(n3)) {
                    sideEffectsDouble = new SideEffectsDouble(n3, n2, n4, n5);
                    bl3 = this.getTrailDouble(charBuffer, byteBuffer, s2, sideEffectsDouble, bl2, coderResultArray);
                    bl4 = sideEffectsDouble.doread;
                    n3 = sideEffectsDouble.c;
                    n2 = sideEffectsDouble.sourceArrayIndex;
                    n4 = sideEffectsDouble.sourceIndex;
                    n5 = sideEffectsDouble.nextSourceIndex;
                } else {
                    bl4 = false;
                }
            }
            if (bl3) {
                while (!bl4 || n2 < charBuffer.limit()) {
                    if (byteBuffer.hasRemaining()) {
                        int n6;
                        char c2;
                        if (bl4) {
                            n3 = charBuffer.get(n2++);
                            ++n5;
                            if (UTF16.isSurrogate(n3) && (s2 & 2) == 0) {
                                if (UTF16.isLeadSurrogate(n3)) {
                                    sideEffectsDouble = new SideEffectsDouble(n3, n2, n4, n5);
                                    bl3 = this.getTrailDouble(charBuffer, byteBuffer, s2, sideEffectsDouble, bl2, coderResultArray);
                                    n3 = sideEffectsDouble.c;
                                    n2 = sideEffectsDouble.sourceArrayIndex;
                                    n4 = sideEffectsDouble.sourceIndex;
                                    n5 = sideEffectsDouble.nextSourceIndex;
                                    if (sideEffectsDouble.doread) {
                                        if (!bl3) break;
                                        continue;
                                    }
                                } else {
                                    coderResultArray[0] = CoderResult.malformedForLength(1);
                                    break;
                                }
                            }
                        } else {
                            bl4 = true;
                        }
                        int n7 = (c2 = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(cArray2, n6 = CharsetMBCS.MBCS_STAGE_2_FROM_U(cArray, nArray, n3), n3)) <= '\u00ff' ? 1 : 2;
                        if (!(CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(n6, n3) || this.isFromUUseFallback(n3) && c2 != '\u0000')) {
                            sideEffectsDouble = new SideEffectsDouble(n3, n2, n4, n5);
                            bl3 = this.unassignedDouble(charBuffer, byteBuffer, sideEffectsDouble, bl2, coderResultArray);
                            n3 = sideEffectsDouble.c;
                            n2 = sideEffectsDouble.sourceArrayIndex;
                            n4 = sideEffectsDouble.sourceIndex;
                            n5 = sideEffectsDouble.nextSourceIndex;
                            if (!bl3) break;
                            continue;
                        }
                        if (n7 == 1) {
                            byteBuffer.put((byte)c2);
                            if (intBuffer != null) {
                                intBuffer.put(n4);
                            }
                        } else {
                            byteBuffer.put((byte)(c2 >>> 8));
                            if (2 <= byteBuffer.remaining()) {
                                byteBuffer.put((byte)c2);
                                if (intBuffer != null) {
                                    intBuffer.put(n4);
                                    intBuffer.put(n4);
                                }
                            } else {
                                if (intBuffer != null) {
                                    intBuffer.put(n4);
                                }
                                this.errorBuffer[0] = (byte)c2;
                                this.errorBufferLength = 1;
                                coderResultArray[0] = CoderResult.OVERFLOW;
                                n3 = 0;
                                break;
                            }
                        }
                        n3 = 0;
                        n4 = n5;
                        continue;
                    }
                    coderResultArray[0] = CoderResult.OVERFLOW;
                    break;
                }
            }
            this.fromUChar32 = n3;
            charBuffer.position(n2);
            return coderResultArray[0];
        }

        private final boolean getTrailSingleBMP(CharBuffer charBuffer, SideEffectsSingleBMP sideEffectsSingleBMP, CoderResult[] coderResultArray) {
            if (sideEffectsSingleBMP.sourceArrayIndex < charBuffer.limit()) {
                char c2 = charBuffer.get(sideEffectsSingleBMP.sourceArrayIndex);
                if (UTF16.isTrailSurrogate(c2)) {
                    ++sideEffectsSingleBMP.sourceArrayIndex;
                    sideEffectsSingleBMP.c = UCharacter.getCodePoint(sideEffectsSingleBMP.c, c2);
                    coderResultArray[0] = CoderResult.unmappableForLength(2);
                    return false;
                }
                coderResultArray[0] = CoderResult.malformedForLength(1);
                return false;
            }
            return false;
        }

        private final boolean getTrail(CharBuffer charBuffer, ByteBuffer byteBuffer, int n2, SideEffects sideEffects, boolean bl2, CoderResult[] coderResultArray) {
            if (sideEffects.sourceArrayIndex < charBuffer.limit()) {
                char c2 = charBuffer.get(sideEffects.sourceArrayIndex);
                if (UTF16.isTrailSurrogate(c2)) {
                    ++sideEffects.sourceArrayIndex;
                    ++sideEffects.nextSourceIndex;
                    sideEffects.c = UCharacter.getCodePoint(sideEffects.c, c2);
                    if ((n2 & 1) == 0) {
                        this.fromUnicodeStatus = sideEffects.prevLength;
                        sideEffects.doread = true;
                        return this.unassigned(charBuffer, byteBuffer, null, sideEffects, bl2, coderResultArray);
                    }
                    sideEffects.doread = false;
                    return true;
                }
                coderResultArray[0] = CoderResult.malformedForLength(1);
                return false;
            }
            return false;
        }

        private final boolean unassigned(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, SideEffects sideEffects, boolean bl2, CoderResult[] coderResultArray) {
            int n2 = sideEffects.sourceArrayIndex;
            charBuffer.position(sideEffects.sourceArrayIndex);
            sideEffects.c = this.fromU(sideEffects.c, charBuffer, byteBuffer, null, sideEffects.sourceIndex, sideEffects.nextSourceIndex, bl2, coderResultArray);
            sideEffects.sourceArrayIndex = charBuffer.position();
            sideEffects.nextSourceIndex += sideEffects.sourceArrayIndex - n2;
            sideEffects.prevLength = this.fromUnicodeStatus;
            if (coderResultArray[0].isError()) {
                return false;
            }
            if (intBuffer != null) {
                sideEffects.prevSourceIndex = sideEffects.sourceIndex;
                sideEffects.sourceIndex = sideEffects.nextSourceIndex;
            }
            return true;
        }

        private final boolean getTrailDouble(CharBuffer charBuffer, ByteBuffer byteBuffer, int n2, SideEffectsDouble sideEffectsDouble, boolean bl2, CoderResult[] coderResultArray) {
            if (sideEffectsDouble.sourceArrayIndex < charBuffer.limit()) {
                char c2 = charBuffer.get(sideEffectsDouble.sourceArrayIndex);
                if (UTF16.isTrailSurrogate(c2)) {
                    ++sideEffectsDouble.sourceArrayIndex;
                    ++sideEffectsDouble.nextSourceIndex;
                    sideEffectsDouble.c = UCharacter.getCodePoint(sideEffectsDouble.c, c2);
                    if ((n2 & 1) == 0) {
                        sideEffectsDouble.doread = true;
                        return this.unassignedDouble(charBuffer, byteBuffer, sideEffectsDouble, bl2, coderResultArray);
                    }
                    sideEffectsDouble.doread = false;
                    return true;
                }
                coderResultArray[0] = CoderResult.malformedForLength(1);
                return false;
            }
            return false;
        }

        private final boolean unassignedDouble(CharBuffer charBuffer, ByteBuffer byteBuffer, SideEffectsDouble sideEffectsDouble, boolean bl2, CoderResult[] coderResultArray) {
            int n2 = sideEffectsDouble.sourceArrayIndex;
            charBuffer.position(sideEffectsDouble.sourceArrayIndex);
            sideEffectsDouble.c = this.fromU(sideEffectsDouble.c, charBuffer, byteBuffer, null, sideEffectsDouble.sourceIndex, sideEffectsDouble.nextSourceIndex, bl2, coderResultArray);
            sideEffectsDouble.sourceArrayIndex = charBuffer.position();
            sideEffectsDouble.nextSourceIndex += sideEffectsDouble.sourceArrayIndex - n2;
            if (coderResultArray[0].isError()) {
                return false;
            }
            sideEffectsDouble.sourceIndex = sideEffectsDouble.nextSourceIndex;
            return true;
        }

        @Override
        protected CoderResult cbFromUWriteSub(CharsetEncoderICU charsetEncoderICU, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
            int n2;
            byte[] byArray;
            CharsetMBCS charsetMBCS = (CharsetMBCS)charsetEncoderICU.charset();
            if (charsetMBCS.subChar1 != 0 && (charsetMBCS.sharedData.mbcs.extIndexes != null ? charsetEncoderICU.useSubChar1 : charsetEncoderICU.invalidUCharBuffer[0] <= '\u00ff')) {
                byArray = new byte[]{charsetMBCS.subChar1};
                n2 = 1;
            } else {
                byArray = charsetMBCS.subChar;
                n2 = charsetMBCS.subCharLen;
            }
            charsetEncoderICU.useSubChar1 = false;
            if (charsetMBCS.sharedData.mbcs.outputType == 12) {
                byte[] byArray2 = new byte[4];
                int n3 = 0;
                switch (n2) {
                    case 1: {
                        if (charsetEncoderICU.fromUnicodeStatus == 2) {
                            charsetEncoderICU.fromUnicodeStatus = 1;
                            byArray2[n3++] = 15;
                        }
                        byArray2[n3++] = byArray[0];
                        break;
                    }
                    case 2: {
                        if (charsetEncoderICU.fromUnicodeStatus <= 1) {
                            charsetEncoderICU.fromUnicodeStatus = 2;
                            byArray2[n3++] = 14;
                        }
                        byArray2[n3++] = byArray[0];
                        byArray2[n3++] = byArray[1];
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                byArray = byArray2;
                n2 = n3;
            }
            return CharsetEncoderICU.fromUWriteBytes(charsetEncoderICU, byArray, 0, n2, byteBuffer, intBuffer, charBuffer.position());
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            if (this.allowReplacementChanges) {
                CharsetMBCS charsetMBCS = (CharsetMBCS)this.charset();
                System.arraycopy(byArray, 0, charsetMBCS.subChar, 0, byArray.length);
                charsetMBCS.subCharLen = (byte)byArray.length;
                charsetMBCS.subChar1 = 0;
            }
        }

        private final class SideEffectsDouble {
            int c;
            int sourceArrayIndex;
            int sourceIndex;
            int nextSourceIndex;
            boolean doread = true;

            SideEffectsDouble(int n2, int n3, int n4, int n5) {
                this.c = n2;
                this.sourceArrayIndex = n3;
                this.sourceIndex = n4;
                this.nextSourceIndex = n5;
            }
        }

        private final class SideEffects {
            int c;
            int sourceArrayIndex;
            int sourceIndex;
            int nextSourceIndex;
            int prevSourceIndex;
            int prevLength;
            boolean doread = true;

            SideEffects(int n2, int n3, int n4, int n5, int n6, int n7) {
                this.c = n2;
                this.sourceArrayIndex = n3;
                this.sourceIndex = n4;
                this.nextSourceIndex = n5;
                this.prevSourceIndex = n6;
                this.prevLength = n7;
            }
        }

        private final class SideEffectsSingleBMP {
            int c;
            int sourceArrayIndex;

            SideEffectsSingleBMP(int n2, int n3) {
                this.c = n2;
                this.sourceArrayIndex = n3;
            }
        }
    }

    class CharsetDecoderMBCS
    extends CharsetDecoderICU {
        CharsetDecoderMBCS(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            return this.cnvMBCSToUnicodeWithOffsets(byteBuffer, charBuffer, intBuffer, bl2);
        }

        private CoderResult continueMatchToU(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, int n2, boolean bl2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            int[] nArray = new int[1];
            int n3 = this.matchToU((byte)CharsetMBCS.SISO_STATE(CharsetMBCS.this.sharedData, this.mode), this.preToUArray, this.preToUBegin, this.preToULength, byteBuffer, nArray, CharsetDecoderMBCS.isToUUseFallback(), bl2);
            if (n3 > 0) {
                if (n3 >= this.preToULength) {
                    byteBuffer.position(byteBuffer.position() + n3 - this.preToULength);
                    this.preToULength = 0;
                } else {
                    int n4 = this.preToULength - n3;
                    System.arraycopy(this.preToUArray, this.preToUBegin + n3, this.preToUArray, this.preToUBegin, n4);
                    this.preToULength = (byte)(-n4);
                }
                coderResult = this.writeToU(nArray[0], charBuffer, intBuffer, n2);
            } else if (n3 < 0) {
                int n5 = byteBuffer.position();
                n3 = -n3;
                for (int i2 = this.preToULength; i2 < n3; ++i2) {
                    this.preToUArray[i2] = byteBuffer.get(n5++);
                }
                byteBuffer.position(n5);
                this.preToULength = (byte)n3;
            } else {
                System.arraycopy(this.preToUArray, this.preToUBegin, this.toUBytesArray, this.toUBytesBegin, this.preToUFirstLength);
                this.toULength = this.preToUFirstLength;
                int n6 = this.preToULength - this.preToUFirstLength;
                if (n6 > 0) {
                    System.arraycopy(this.preToUArray, this.preToUBegin + this.preToUFirstLength, this.preToUArray, this.preToUBegin, n6);
                }
                this.preToULength = (byte)(-n6);
                coderResult = CoderResult.unmappableForLength(this.preToUFirstLength);
            }
            return coderResult;
        }

        private int matchToU(byte by2, byte[] byArray, int n2, int n3, ByteBuffer byteBuffer, int[] nArray, boolean bl2, boolean bl3) {
            int n4;
            int n5;
            block15: {
                int n6;
                ByteBuffer byteBuffer2 = CharsetMBCS.this.sharedData.mbcs.extIndexes;
                int n7 = 0;
                if (byteBuffer2 == null || byteBuffer2.asIntBuffer().get(2) <= 0) {
                    return 0;
                }
                IntBuffer intBuffer = (IntBuffer)CharsetMBCS.ARRAY(byteBuffer2, 1, Integer.TYPE);
                int n8 = 0;
                n5 = 0;
                n4 = 0;
                int n9 = 0;
                int n10 = 0;
                if (byteBuffer != null) {
                    n7 = byteBuffer.remaining();
                }
                if (by2 == 0) {
                    if (n3 > 1) {
                        return 0;
                    }
                    if (n3 == 1) {
                        n7 = 0;
                    } else if (n7 > 1) {
                        n7 = 1;
                    }
                    bl3 = true;
                }
                while (true) {
                    short s2;
                    int n11 = intBuffer.position();
                    IntBuffer intBuffer2 = ((IntBuffer)intBuffer.position(n8)).slice();
                    intBuffer.position(n11);
                    n6 = intBuffer2.get();
                    int n12 = CharsetMBCS.TO_U_GET_BYTE(n6);
                    n6 = CharsetMBCS.TO_U_GET_VALUE(n6);
                    if (n6 != 0 && (CharsetMBCS.TO_U_IS_ROUNDTRIP(n6) || CharsetDecoderMBCS.isToUUseFallback(bl2)) && CharsetMBCS.TO_U_VERIFY_SISO_MATCH(by2, n10 + n9)) {
                        n5 = n6;
                        n4 = n10 + n9;
                    }
                    if (n10 < n3) {
                        s2 = (short)(byArray[n2 + n10++] & 0xFF);
                    } else {
                        if (n9 >= n7) {
                            if (!bl3 && (n12 = n10 + n9) <= 31) {
                                return -n12;
                            }
                            break block15;
                        }
                        s2 = (short)(byteBuffer.get(byteBuffer.position() + n9++) & 0xFF);
                    }
                    n6 = CharsetMBCS.findToU(intBuffer2, n12, s2);
                    if (n6 == 0) break block15;
                    if (!CharsetMBCS.TO_U_IS_PARTIAL(n6)) break;
                    n8 = CharsetMBCS.TO_U_GET_PARTIAL_INDEX(n6);
                }
                if ((CharsetMBCS.TO_U_IS_ROUNDTRIP(n6) || CharsetDecoderMBCS.isToUUseFallback(bl2)) && CharsetMBCS.TO_U_VERIFY_SISO_MATCH(by2, n10 + n9)) {
                    n5 = n6;
                    n4 = n10 + n9;
                }
            }
            if (n4 == 0) {
                return 0;
            }
            nArray[0] = CharsetMBCS.TO_U_MASK_ROUNDTRIP(n5);
            return n4;
        }

        private CoderResult writeToU(int n2, CharBuffer charBuffer, IntBuffer intBuffer, int n3) {
            ByteBuffer byteBuffer = CharsetMBCS.this.sharedData.mbcs.extIndexes;
            if (CharsetMBCS.TO_U_IS_CODE_POINT(n2)) {
                return this.toUWriteCodePoint(CharsetMBCS.TO_U_GET_CODE_POINT(n2), charBuffer, intBuffer, n3);
            }
            char[] cArray = new char[CharsetMBCS.TO_U_GET_LENGTH(n2)];
            CharBuffer charBuffer2 = (CharBuffer)CharsetMBCS.ARRAY(byteBuffer, 3, Character.TYPE);
            charBuffer2.position(CharsetMBCS.TO_U_GET_INDEX(n2));
            charBuffer2.get(cArray, 0, cArray.length);
            return CharsetDecoderMBCS.toUWriteUChars(this, cArray, 0, cArray.length, charBuffer, intBuffer, n3);
        }

        private CoderResult toUWriteCodePoint(int n2, CharBuffer charBuffer, IntBuffer intBuffer, int n3) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            int n4 = charBuffer.position();
            if (charBuffer.hasRemaining()) {
                if (n2 <= 65535) {
                    charBuffer.put((char)n2);
                    n2 = -1;
                } else {
                    charBuffer.put(UTF16.getLeadSurrogate(n2));
                    n2 = UTF16.getTrailSurrogate(n2);
                    if (charBuffer.hasRemaining()) {
                        charBuffer.put((char)n2);
                        n2 = -1;
                    }
                }
                if (intBuffer != null) {
                    intBuffer.put(n3);
                    if (n4 + 1 < charBuffer.position()) {
                        intBuffer.put(n3);
                    }
                }
            }
            if (n2 >= 0) {
                this.charErrorBufferLength = UTF16.append(this.charErrorBufferArray, 0, n2);
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }

        private int toU(int n2, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, int n3, boolean bl2, CoderResult[] coderResultArray) {
            if (CharsetMBCS.this.sharedData.mbcs.extIndexes != null && this.initialMatchToU(n2, byteBuffer, charBuffer, intBuffer, n3, bl2, coderResultArray)) {
                return 0;
            }
            if (n2 == 4 && (CharsetMBCS.this.options & 0x8000) != 0) {
                int n4 = CharsetMBCS.LINEAR_18030(this.toUBytesArray[0], this.toUBytesArray[1], this.toUBytesArray[2], this.toUBytesArray[3]);
                for (int i2 = 0; i2 < gb18030Ranges.length; ++i2) {
                    int[] nArray = gb18030Ranges[i2];
                    if (nArray[2] > n4 || n4 > nArray[3]) continue;
                    coderResultArray[0] = CoderResult.UNDERFLOW;
                    n4 = nArray[0] + (n4 - nArray[2]);
                    coderResultArray[0] = this.toUWriteCodePoint(n4, charBuffer, intBuffer, n3);
                    return 0;
                }
            }
            coderResultArray[0] = CoderResult.unmappableForLength(n2);
            return n2;
        }

        private boolean initialMatchToU(int n2, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, int n3, boolean bl2, CoderResult[] coderResultArray) {
            int[] nArray = new int[1];
            int n4 = 0;
            n4 = this.matchToU((byte)CharsetMBCS.SISO_STATE(CharsetMBCS.this.sharedData, this.mode), this.toUBytesArray, this.toUBytesBegin, n2, byteBuffer, nArray, CharsetDecoderMBCS.isToUUseFallback(), bl2);
            if (n4 > 0) {
                byteBuffer.position(byteBuffer.position() + n4 - n2);
                coderResultArray[0] = this.writeToU(nArray[0], charBuffer, intBuffer, n3);
                return true;
            }
            if (n4 < 0) {
                int n5;
                byte[] byArray = this.toUBytesArray;
                int n6 = this.toUBytesBegin;
                this.preToUFirstLength = (byte)n2;
                for (n5 = 0; n5 < n2; ++n5) {
                    this.preToUArray[n5] = byArray[n6++];
                }
                n6 = byteBuffer.position();
                n4 = -n4;
                while (n5 < n4) {
                    this.preToUArray[n5] = byteBuffer.get(n6++);
                    ++n5;
                }
                byteBuffer.position(n6);
                this.preToULength = (byte)n4;
                return true;
            }
            return false;
        }

        private int simpleMatchToU(ByteBuffer byteBuffer, boolean bl2) {
            int n2;
            byte[] byArray;
            int n3;
            int[] nArray = new int[1];
            if (byteBuffer.remaining() <= 0) {
                return 65535;
            }
            if (byteBuffer.isReadOnly()) {
                n3 = byteBuffer.position();
                byArray = new byte[Math.min(byteBuffer.remaining(), 31)];
                byteBuffer.get(byArray).position(n3);
                n3 = 0;
                n2 = byArray.length;
            } else {
                byArray = byteBuffer.array();
                n3 = byteBuffer.position();
                n2 = byteBuffer.limit();
            }
            int n4 = this.matchToU((byte)-1, byArray, n3, n2, null, nArray, bl2, true);
            if (n4 == byteBuffer.remaining() && CharsetMBCS.TO_U_IS_CODE_POINT(nArray[0])) {
                return CharsetMBCS.TO_U_GET_CODE_POINT(nArray[0]);
            }
            return 65534;
        }

        /*
         * Enabled aggressive block sorting
         */
        CoderResult cnvMBCSToUnicodeWithOffsets(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            int n3 = 0;
            if (this.preToULength > 0) {
                coderResultArray[0] = this.continueMatchToU(byteBuffer, charBuffer, intBuffer, -1, bl2);
                if (coderResultArray[0].isError()) return coderResultArray[0];
                if (this.preToULength < 0) {
                    return coderResultArray[0];
                }
            }
            if (CharsetMBCS.this.sharedData.mbcs.countStates == 1) {
                if (!CharsetMBCS.this.sharedData.mbcs.hasSupplementary()) {
                    coderResultArray[0] = this.cnvMBCSSingleToBMPWithOffsets(byteBuffer, charBuffer, intBuffer, bl2);
                    return coderResultArray[0];
                }
                coderResultArray[0] = this.cnvMBCSSingleToUnicodeWithOffsets(byteBuffer, charBuffer, intBuffer, bl2);
                return coderResultArray[0];
            }
            int n4 = n2 = byteBuffer.position();
            int[][] nArray = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLStateTable : CharsetMBCS.this.sharedData.mbcs.stateTable;
            char[] cArray = CharsetMBCS.this.sharedData.mbcs.unicodeCodeUnits;
            int n5 = this.toUnicodeStatus;
            int n6 = this.toULength;
            byte[] byArray = this.toUBytesArray;
            byte by2 = (byte)this.mode;
            if (by2 == 0) {
                by2 = CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState;
            }
            int n7 = n6 == 0 ? 0 : -1;
            int n8 = 0;
            while (n4 < byteBuffer.limit()) {
                int n9;
                block51: {
                    byte by3;
                    block58: {
                        char c2;
                        block55: {
                            block57: {
                                block56: {
                                    block54: {
                                        block52: {
                                            block53: {
                                                if (!charBuffer.hasRemaining()) {
                                                    coderResultArray[0] = CoderResult.OVERFLOW;
                                                    break;
                                                }
                                                if (n6 != 0) {
                                                    ++n8;
                                                    int n10 = n6++;
                                                    byte by4 = byteBuffer.get(n4++);
                                                    byArray[n10] = by4;
                                                    n3 = nArray[by2][by4 & 0xFF];
                                                } else {
                                                    do {
                                                        if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n3 = nArray[by2][byteBuffer.get(n4) & 0xFF])) {
                                                            by2 = (byte)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(n3);
                                                            n5 = CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(n3);
                                                            if (++n4 < byteBuffer.limit() && CharsetMBCS.MBCS_ENTRY_IS_FINAL(n3 = nArray[by2][byteBuffer.get(n4) & 0xFF]) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n3) == 4 && (c2 = cArray[n5 + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3)]) < '\ufffe') {
                                                                ++n4;
                                                                charBuffer.put(c2);
                                                                if (intBuffer != null) {
                                                                    intBuffer.put(n7);
                                                                    n7 = n8 += 2;
                                                                }
                                                                by2 = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(n3);
                                                                n5 = 0;
                                                                continue;
                                                            }
                                                            ++n8;
                                                            byArray[0] = byteBuffer.get(n4 - 1);
                                                            n6 = 1;
                                                            break;
                                                        }
                                                        if (!CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(n3)) break;
                                                        ++n4;
                                                        charBuffer.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3));
                                                        if (intBuffer != null) {
                                                            intBuffer.put(n7);
                                                            n7 = ++n8;
                                                        }
                                                        by2 = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(n3);
                                                    } while (n4 < byteBuffer.limit() && charBuffer.hasRemaining());
                                                    if (n4 >= byteBuffer.limit()) break;
                                                    if (!charBuffer.hasRemaining()) {
                                                        coderResultArray[0] = CoderResult.OVERFLOW;
                                                        break;
                                                    }
                                                    ++n8;
                                                    byArray[n6++] = byteBuffer.get(n4++);
                                                }
                                                if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n3)) {
                                                    by2 = (byte)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(n3);
                                                    n5 += CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(n3);
                                                    continue;
                                                }
                                                this.mode = by2;
                                                by2 = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(n3);
                                                by3 = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n3);
                                                if (by3 != 4) break block52;
                                                c2 = cArray[n5 += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3)];
                                                if (c2 >= '\ufffe') break block53;
                                                charBuffer.put(c2);
                                                if (intBuffer != null) {
                                                    intBuffer.put(n7);
                                                }
                                                n6 = 0;
                                                break block51;
                                            }
                                            if (c2 == '\ufffe') {
                                                if (this.isFallbackUsed() && (n3 = this.getFallback(CharsetMBCS.this.sharedData.mbcs, n5)) != 65534) {
                                                    charBuffer.put((char)n3);
                                                    if (intBuffer != null) {
                                                        intBuffer.put(n7);
                                                    }
                                                    n6 = 0;
                                                }
                                                break block51;
                                            } else {
                                                coderResultArray[0] = CoderResult.malformedForLength(n6);
                                            }
                                            break block51;
                                        }
                                        if (by3 != 0) break block54;
                                        charBuffer.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3));
                                        if (intBuffer != null) {
                                            intBuffer.put(n7);
                                        }
                                        n6 = 0;
                                        break block51;
                                    }
                                    if (by3 != 5) break block55;
                                    n5 += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3);
                                    if ((c2 = cArray[n5++]) >= '\ud800') break block56;
                                    charBuffer.put(c2);
                                    if (intBuffer != null) {
                                        intBuffer.put(n7);
                                    }
                                    n6 = 0;
                                    break block51;
                                }
                                if (!(this.isFallbackUsed() ? c2 <= '\udfff' : c2 <= '\udbff')) break block57;
                                charBuffer.put((char)(c2 & 0xDBFF));
                                if (intBuffer != null) {
                                    intBuffer.put(n7);
                                }
                                n6 = 0;
                                if (charBuffer.hasRemaining()) {
                                    charBuffer.put(cArray[n5]);
                                    if (intBuffer != null) {
                                        intBuffer.put(n7);
                                    }
                                    break block51;
                                } else {
                                    this.charErrorBufferArray[0] = cArray[n5];
                                    this.charErrorBufferLength = 1;
                                    coderResultArray[0] = CoderResult.OVERFLOW;
                                    n5 = 0;
                                    break;
                                }
                            }
                            if (this.isFallbackUsed() ? (c2 & 0xFFFE) == 57344 : c2 == '\ue000') {
                                charBuffer.put(cArray[n5]);
                                if (intBuffer != null) {
                                    intBuffer.put(n7);
                                }
                                n6 = 0;
                                break block51;
                            } else if (c2 == '\uffff') {
                                coderResultArray[0] = CoderResult.malformedForLength(n6);
                            }
                            break block51;
                        }
                        if (by3 != 1 && (by3 != 3 || !this.isFallbackUsed())) break block58;
                        n3 = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(n3);
                        charBuffer.put((char)(0xD800 | (char)(n3 >> 10)));
                        if (intBuffer != null) {
                            intBuffer.put(n7);
                        }
                        n6 = 0;
                        c2 = (char)(0xDC00 | (char)(n3 & 0x3FF));
                        if (charBuffer.hasRemaining()) {
                            charBuffer.put(c2);
                            if (intBuffer != null) {
                                intBuffer.put(n7);
                            }
                            break block51;
                        } else {
                            this.charErrorBufferArray[0] = c2;
                            this.charErrorBufferLength = 1;
                            coderResultArray[0] = CoderResult.OVERFLOW;
                            n5 = 0;
                            break;
                        }
                    }
                    if (by3 == 8) {
                        if (CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState == 0) {
                            n6 = 0;
                        } else {
                            by2 = (byte)this.mode;
                            coderResultArray[0] = CoderResult.malformedForLength(n6);
                        }
                    } else if (by3 == 2) {
                        if (this.isFallbackUsed()) {
                            charBuffer.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3));
                            if (intBuffer != null) {
                                intBuffer.put(n7);
                            }
                            n6 = 0;
                        }
                    } else if (by3 != 6) {
                        if (by3 == 7) {
                            coderResultArray[0] = CoderResult.malformedForLength(n6);
                        } else {
                            n6 = 0;
                        }
                    }
                }
                n5 = 0;
                if (n6 == 0) {
                    n7 = n8;
                    continue;
                }
                if (coderResultArray[0].isError()) {
                    int n11;
                    if (n6 <= 1) break;
                    n9 = CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState != 0 ? 1 : 0;
                    for (n11 = 1; n11 < n6 && !this.isSingleOrLead(nArray, by2, n9 != 0, (short)(byArray[n11] & 0xFF)); n11 = (int)((byte)(n11 + 1))) {
                    }
                    if (n11 >= n6) break;
                    byte by5 = (byte)(n6 - n11);
                    int n12 = n4 - n2;
                    n6 = n11;
                    if (by5 <= n12) {
                        n4 -= by5;
                        break;
                    }
                    this.preToULength = (byte)(n12 - by5);
                    for (int i2 = 0; i2 < -this.preToULength; ++i2) {
                        this.preToUArray[i2] = byArray[n11 + i2];
                    }
                    n4 = n2;
                    break;
                }
                n9 = n4;
                byteBuffer.position(n4);
                n6 = this.toU(n6, byteBuffer, charBuffer, intBuffer, n7, bl2, coderResultArray);
                n4 = byteBuffer.position();
                n7 = n8 += n4 - n9;
                if (!coderResultArray[0].isError() && !coderResultArray[0].isOverflow()) continue;
            }
            this.toUnicodeStatus = n5;
            this.mode = by2;
            this.toULength = n6;
            byteBuffer.position(n4);
            return coderResultArray[0];
        }

        private CoderResult cnvMBCSSingleToBMPWithOffsets(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            int n3 = byteBuffer.position();
            int n4 = charBuffer.remaining();
            int[][] nArray = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLStateTable : CharsetMBCS.this.sharedData.mbcs.stateTable;
            int n5 = 0;
            int n6 = n3;
            int n7 = byteBuffer.remaining();
            if (n7 < n4) {
                n4 = n7;
            }
            while (n4 > 0 && n3 < byteBuffer.limit()) {
                int n8;
                if (CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(n8 = nArray[0][byteBuffer.get(n3++) & 0xFF])) {
                    charBuffer.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n8));
                    --n4;
                    continue;
                }
                byte by2 = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n8);
                if (by2 == 2) {
                    if (this.isFallbackUsed()) {
                        charBuffer.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n8));
                        --n4;
                        continue;
                    }
                } else if (by2 != 6) {
                    if (by2 != 7) continue;
                    coderResultArray[0] = CoderResult.malformedForLength(n3 - n6);
                }
                if (intBuffer != null) {
                    n2 = n3 - n6;
                    while (--n2 > 0) {
                        intBuffer.put(n5++);
                    }
                }
                if (coderResultArray[0].isError()) break;
                n6 = n3;
                this.toUBytesArray[0] = byteBuffer.get(n3 - 1);
                byteBuffer.position(n3);
                this.toULength = this.toU(1, byteBuffer, charBuffer, intBuffer, n5, bl2, coderResultArray);
                n3 = byteBuffer.position();
                n5 += 1 + (n3 - n6);
                if (coderResultArray[0].isError()) break;
                n4 = charBuffer.remaining();
                n7 = byteBuffer.remaining();
                if (n7 >= n4) continue;
                n4 = n7;
            }
            if (!coderResultArray[0].isError() && n3 < byteBuffer.limit() && !charBuffer.hasRemaining()) {
                coderResultArray[0] = CoderResult.OVERFLOW;
            }
            if (intBuffer != null) {
                for (n2 = n3 - n6; n2 > 0; --n2) {
                    intBuffer.put(n5++);
                }
            }
            byteBuffer.position(n3);
            return coderResultArray[0];
        }

        private CoderResult cnvMBCSSingleToUnicodeWithOffsets(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult[] coderResultArray = new CoderResult[]{CoderResult.UNDERFLOW};
            int n2 = byteBuffer.position();
            int[][] nArray = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLStateTable : CharsetMBCS.this.sharedData.mbcs.stateTable;
            int n3 = 0;
            while (n2 < byteBuffer.limit()) {
                int n4;
                if (!charBuffer.hasRemaining()) {
                    coderResultArray[0] = CoderResult.OVERFLOW;
                    break;
                }
                if (CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(n4 = nArray[0][byteBuffer.get(n2++) & 0xFF])) {
                    charBuffer.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n4));
                    if (intBuffer != null) {
                        intBuffer.put(n3);
                    }
                    ++n3;
                    continue;
                }
                byte by2 = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n4);
                if (by2 == 1 || by2 == 3 && this.isFallbackUsed()) {
                    n4 = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(n4);
                    charBuffer.put((char)(0xD800 | (char)(n4 >>> 10)));
                    if (intBuffer != null) {
                        intBuffer.put(n3);
                    }
                    char c2 = (char)(0xDC00 | (char)(n4 & 0x3FF));
                    if (charBuffer.hasRemaining()) {
                        charBuffer.put(c2);
                        if (intBuffer != null) {
                            intBuffer.put(n3);
                        }
                    } else {
                        this.charErrorBufferArray[0] = c2;
                        this.charErrorBufferLength = 1;
                        coderResultArray[0] = CoderResult.OVERFLOW;
                        break;
                    }
                    ++n3;
                    continue;
                }
                if (by2 == 2) {
                    if (this.isFallbackUsed()) {
                        charBuffer.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n4));
                        if (intBuffer != null) {
                            intBuffer.put(n3);
                        }
                        ++n3;
                        continue;
                    }
                } else if (by2 != 6) {
                    if (by2 == 7) {
                        coderResultArray[0] = CoderResult.malformedForLength(1);
                    } else {
                        ++n3;
                        continue;
                    }
                }
                if (coderResultArray[0].isError()) break;
                int n5 = n2;
                this.toUBytesArray[0] = byteBuffer.get(n2 - 1);
                byteBuffer.position(n2);
                this.toULength = this.toU(1, byteBuffer, charBuffer, intBuffer, n3, bl2, coderResultArray);
                n2 = byteBuffer.position();
                n3 += 1 + (n2 - n5);
                if (!coderResultArray[0].isError()) continue;
                break;
            }
            byteBuffer.position(n2);
            return coderResultArray[0];
        }

        private int getFallback(UConverterMBCSTable uConverterMBCSTable, int n2) {
            int n3 = uConverterMBCSTable.countToUFallbacks;
            if (n3 > 0) {
                MBCSToUFallback[] mBCSToUFallbackArray = uConverterMBCSTable.toUFallbacks;
                int n4 = 0;
                while (n4 < n3 - 1) {
                    int n5 = n4 + n3 >>> 1;
                    if (n2 < mBCSToUFallbackArray[n5].offset) {
                        n3 = n5;
                        continue;
                    }
                    n4 = n5;
                }
                if (n2 == mBCSToUFallbackArray[n4].offset) {
                    return mBCSToUFallbackArray[n4].codePoint;
                }
            }
            return 65534;
        }

        int simpleGetNextUChar(ByteBuffer byteBuffer, boolean bl2) {
            int n2;
            int n3;
            int[][] nArray = CharsetMBCS.this.sharedData.mbcs.stateTable;
            char[] cArray = CharsetMBCS.this.sharedData.mbcs.unicodeCodeUnits;
            int n4 = 0;
            int n5 = CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState;
            int n6 = byteBuffer.position();
            int n7 = byteBuffer.limit() - n6;
            while (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n3 = nArray[n5][byteBuffer.get(n6++) & 0xFF])) {
                n5 = CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(n3);
                n4 += CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(n3);
                if (n6 != byteBuffer.limit()) continue;
                return 65535;
            }
            int n8 = CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n3);
            if (n8 == 4) {
                n2 = cArray[n4 += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3)];
                if (n2 == 65534 && CharsetDecoderMBCS.isToUUseFallback()) {
                    n2 = this.getFallback(CharsetMBCS.this.sharedData.mbcs, n4);
                }
            } else if (n8 == 0) {
                n2 = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3);
            } else if (n8 == 5) {
                n4 += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3);
                if ((n2 = cArray[n4++]) >= 55296) {
                    if (CharsetDecoderMBCS.isToUUseFallback() ? n2 <= 57343 : n2 <= 56319) {
                        n2 = ((n2 & 0x3FF) << 10) + cArray[n4] + 9216;
                    } else if (CharsetDecoderMBCS.isToUUseFallback() ? (n2 & 0xFFFE) == 57344 : n2 == 57344) {
                        n2 = cArray[n4];
                    } else {
                        if (n2 == 65535) {
                            return 65535;
                        }
                        n2 = 65534;
                    }
                }
            } else if (n8 == 1) {
                n2 = 65536 + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(n3);
            } else if (n8 == 2) {
                n2 = !CharsetDecoderMBCS.isToUUseFallback(bl2) ? 65534 : (int)CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(n3);
            } else if (n8 == 3) {
                n2 = !CharsetDecoderMBCS.isToUUseFallback(bl2) ? 65534 : 65536 + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(n3);
            } else if (n8 == 6) {
                n2 = 65534;
            } else {
                return 65535;
            }
            if (n6 != byteBuffer.limit()) {
                return 65535;
            }
            if (n2 == 65534 && CharsetMBCS.this.sharedData.mbcs.extIndexes != null) {
                if (byteBuffer.limit() > n6 + n7) {
                    byteBuffer.limit(n6 + n7);
                }
                return this.simpleMatchToU(byteBuffer, bl2);
            }
            return n2;
        }

        private boolean hasValidTrailBytes(int[][] nArray, short s2) {
            int n2;
            int[] nArray2 = nArray[s2];
            int n3 = nArray2[161];
            if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n3) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n3) != 7) {
                return true;
            }
            n3 = nArray2[65];
            if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n3) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n3) != 7) {
                return true;
            }
            for (n2 = 0; n2 <= 255; ++n2) {
                n3 = nArray2[n2];
                if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n3) || CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n3) == 7) continue;
                return true;
            }
            for (n2 = 0; n2 <= 255; ++n2) {
                n3 = nArray2[n2];
                if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n3) || !this.hasValidTrailBytes(nArray, (short)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(n3))) continue;
                return true;
            }
            return false;
        }

        private boolean isSingleOrLead(int[][] nArray, int n2, boolean bl2, int n3) {
            int[] nArray2 = nArray[n2];
            int n4 = nArray2[n3];
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(n4)) {
                return this.hasValidTrailBytes(nArray, (short)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(n4));
            }
            int n5 = CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(n4);
            if (n5 == 8 && bl2) {
                return false;
            }
            return n5 != 7;
        }
    }

    private static enum SISO_Option {
        SI,
        SO;

    }

    static final class MBCSHeader {
        byte[] version = new byte[4];
        int countStates;
        int countToUFallbacks;
        int offsetToUCodeUnits;
        int offsetFromUTable;
        int offsetFromUBytes;
        int flags;
        int fromUBytesLength;
        int options;
        int fullStage2Length;

        MBCSHeader() {
        }
    }

    static final class UConverterMBCSTable {
        short countStates;
        byte dbcsOnlyState;
        boolean stateTableOwned;
        int countToUFallbacks;
        int[][] stateTable;
        int[][] swapLFNLStateTable;
        char[] unicodeCodeUnits;
        MBCSToUFallback[] toUFallbacks;
        char[] fromUnicodeTable;
        int[] fromUnicodeTableInts;
        byte[] fromUnicodeBytes;
        char[] fromUnicodeChars;
        int[] fromUnicodeInts;
        char[] swapLFNLFromUnicodeChars;
        int fromUBytesLength;
        short outputType;
        short unicodeMask;
        String swapLFNLName;
        UConverterSharedData baseSharedData;
        ByteBuffer extIndexes;
        CharBuffer mbcsIndex = null;
        boolean utf8Friendly = false;
        char maxFastUChar;
        int asciiRoundtrips;

        UConverterMBCSTable() {
        }

        boolean hasSupplementary() {
            return (this.unicodeMask & 1) != 0;
        }
    }

    static final class MBCSToUFallback {
        int offset;
        int codePoint;

        MBCSToUFallback(int n2, int n3) {
            this.offset = n2;
            this.codePoint = n3;
        }
    }
}

