/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetASCII;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetProviderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public abstract class CharsetICU
extends Charset {
    String icuCanonicalName;
    int options;
    float maxCharsPerByte;
    String name;
    int codepage;
    byte platform;
    byte conversionType;
    int minBytesPerChar;
    int maxBytesPerChar;
    byte[] subChar;
    byte subCharLen;
    byte hasToUnicodeFallback;
    byte hasFromUnicodeFallback;
    short unicodeMask;
    byte subChar1;
    public static final int ROUNDTRIP_SET = 0;
    @Deprecated
    public static final int ROUNDTRIP_AND_FALLBACK_SET = 1;
    private static final HashMap<String, String> algorithmicCharsets = new HashMap();

    protected CharsetICU(String string, String string2, String[] stringArray) {
        super(string2, stringArray);
        if (string2.length() == 0) {
            throw new IllegalCharsetNameException(string2);
        }
        this.icuCanonicalName = string;
    }

    @Override
    public boolean contains(Charset charset) {
        if (null == charset) {
            return false;
        }
        return this.equals(charset);
    }

    static final Charset getCharset(String string, String string2, String[] stringArray) {
        String string3 = algorithmicCharsets.get(string);
        if (string3 == null) {
            string3 = "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS";
        }
        try {
            CharsetICU charsetICU = null;
            Class<CharsetICU> clazz = Class.forName(string3).asSubclass(CharsetICU.class);
            Class[] classArray = new Class[]{String.class, String.class, String[].class};
            Constructor<CharsetICU> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string, string2, stringArray};
            try {
                charsetICU = constructor.newInstance(objectArray);
                if (charsetICU != null) {
                    return charsetICU;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                UnsupportedCharsetException unsupportedCharsetException = new UnsupportedCharsetException(string + ": Could not load " + string3 + ". Exception: " + throwable);
                unsupportedCharsetException.initCause(throwable);
                throw unsupportedCharsetException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new UnsupportedCharsetException(string + ": Could not load " + string3);
    }

    static final boolean isSurrogate(int n2) {
        return (n2 & 0xFFFFF800) == 55296;
    }

    public static Charset forNameICU(String string) throws IllegalCharsetNameException, UnsupportedCharsetException {
        CharsetProviderICU charsetProviderICU = new CharsetProviderICU();
        CharsetICU charsetICU = (CharsetICU)charsetProviderICU.charsetForName(string);
        if (charsetICU != null) {
            return charsetICU;
        }
        return Charset.forName(string);
    }

    abstract void getUnicodeSetImpl(UnicodeSet var1, int var2);

    public void getUnicodeSet(UnicodeSet unicodeSet, int n2) {
        if (unicodeSet == null || n2 != 0) {
            throw new IllegalArgumentException();
        }
        unicodeSet.clear();
        this.getUnicodeSetImpl(unicodeSet, n2);
    }

    public boolean isFixedWidth() {
        if (this instanceof CharsetASCII || this instanceof CharsetUTF32) {
            return true;
        }
        return this instanceof CharsetMBCS && ((CharsetMBCS)this).sharedData.staticData.maxBytesPerChar == ((CharsetMBCS)this).sharedData.staticData.minBytesPerChar;
    }

    static void getNonSurrogateUnicodeSet(UnicodeSet unicodeSet) {
        unicodeSet.add(0, 55295);
        unicodeSet.add(57344, 0x10FFFF);
    }

    static void getCompleteUnicodeSet(UnicodeSet unicodeSet) {
        unicodeSet.add(0, 0x10FFFF);
    }

    static {
        algorithmicCharsets.put("LMBCS-1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-2", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-3", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-4", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-5", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-6", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-8", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-11", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-16", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-17", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-18", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-19", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("BOCU-1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetBOCU1");
        algorithmicCharsets.put("SCSU", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetSCSU");
        algorithmicCharsets.put("US-ASCII", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetASCII");
        algorithmicCharsets.put("ISO-8859-1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.Charset88591");
        algorithmicCharsets.put("UTF-16", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-16BE", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16BE");
        algorithmicCharsets.put("UTF-16BE,version=1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16BE");
        algorithmicCharsets.put("UTF-16LE", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF-16LE,version=1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_OppositeEndian", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_PlatformEndian", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-32", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-32BE", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32BE");
        algorithmicCharsets.put("UTF-32LE", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_OppositeEndian", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_PlatformEndian", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-8", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF8");
        algorithmicCharsets.put("CESU-8", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetCESU8");
        algorithmicCharsets.put("UTF-7", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF7");
        algorithmicCharsets.put("ISCII,version=0", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=2", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=3", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=4", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=5", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=6", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=7", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=8", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("IMAP-mailbox-name", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF7");
        algorithmicCharsets.put("HZ", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetHZ");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=0", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=2", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=3", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=4", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=0", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=2", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ko,version=0", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ko,version=1", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("x11-compound-text", "macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetCompoundText");
    }
}

