/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationListener;
import java.util.ArrayList;

public abstract class RtfDestination {
    protected RtfParser rtfParser = null;
    protected boolean modified = false;
    protected RtfCtrlWordData lastCtrlWord = null;
    private static ArrayList listeners = new ArrayList();

    public RtfDestination() {
        this.rtfParser = null;
    }

    public RtfDestination(RtfParser rtfParser) {
        this.rtfParser = rtfParser;
    }

    public void setParser(RtfParser rtfParser) {
        if (this.rtfParser != null && this.rtfParser.equals(rtfParser)) {
            return;
        }
        this.rtfParser = rtfParser;
    }

    public abstract boolean closeDestination();

    public abstract boolean handleOpeningSubGroup();

    public abstract boolean handleCloseGroup();

    public abstract boolean handleOpenGroup();

    public abstract boolean handleCharacter(int var1);

    public abstract boolean handleControlWord(RtfCtrlWordData var1);

    public abstract void setToDefaults();

    public boolean isModified() {
        return this.modified;
    }

    public boolean addListener(RtfDestinationListener rtfDestinationListener) {
        return listeners.add(rtfDestinationListener);
    }

    public boolean removeListener(RtfDestinationListener rtfDestinationListener) {
        return listeners.remove(rtfDestinationListener);
    }

    protected RtfCtrlWordData beforeCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.beforeCtrlWord(rtfCtrlWordData);
        }
        return null;
    }

    protected RtfCtrlWordData onCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.onCtrlWord(rtfCtrlWordData);
        }
        return null;
    }

    protected RtfCtrlWordData afterCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.afterCtrlWord(rtfCtrlWordData);
        }
        return null;
    }

    protected int beforeCharacter(int n) {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.beforeCharacter(n);
        }
        return 0;
    }

    protected int onCharacter(int n) {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.onCharacter(n);
        }
        return 0;
    }

    protected int afterCharacter(int n) {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.afterCharacter(n);
        }
        return 0;
    }

    protected boolean onOpenGroup() {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.onOpenGroup();
        }
        return true;
    }

    protected boolean onCloseGroup() {
        for (RtfDestinationListener rtfDestinationListener : listeners) {
            rtfDestinationListener.onCloseGroup();
        }
        return true;
    }

    public int getNewTokeniserState() {
        return 5;
    }
}

