/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRShortIncrementerFactory;

class JRShortCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRShortCountIncrementer mainInstance = new JRShortCountIncrementer();

    private JRShortCountIncrementer() {
    }

    public static JRShortCountIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRShortIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRShortIncrementerFactory.ZERO;
        }
        return new Short((short)(value.shortValue() + 1));
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null) {
            value = calculable.getValue() == null ? (Number)JRShortIncrementerFactory.ZERO : (Number)((Number)calculable.getValue());
        }
        if (combineValue == null) {
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            value = JRShortIncrementerFactory.ZERO;
        }
        return new Short((short)(value.shortValue() + combineValue.shortValue()));
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRShortIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

