/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JRSourceCompileTask {
    private JasperDesign jasperDesign;
    private String unitName;
    private JRExpressionCollector expressionCollector;
    private Map parametersMap;
    private Map fieldsMap;
    private Map variablesMap;
    private JRVariable[] variables;
    private List expressions;
    private boolean onlyDefaultEvaluation;

    protected JRSourceCompileTask(JasperDesign jasperDesign, String unitName, JRExpressionCollector expressionCollector, Map parametersMap, Map fieldsMap, Map variablesMap, JRVariable[] variables, List expressions, boolean onlyDefaultEvaluation) {
        this.jasperDesign = jasperDesign;
        this.unitName = unitName;
        this.expressionCollector = expressionCollector;
        this.parametersMap = parametersMap;
        this.fieldsMap = fieldsMap;
        this.variablesMap = variablesMap;
        this.variables = variables;
        this.expressions = expressions;
        this.onlyDefaultEvaluation = onlyDefaultEvaluation;
    }

    public JRSourceCompileTask(JasperDesign jasperDesign, JRDesignDataset dataset, JRExpressionCollector expressionCollector, String unitName) {
        this(jasperDesign, unitName, expressionCollector, dataset.getParametersMap(), dataset.getFieldsMap(), dataset.getVariablesMap(), dataset.getVariables(), expressionCollector.getExpressions(dataset), false);
    }

    public JRSourceCompileTask(JasperDesign jasperDesign, JRDesignCrosstab crosstab, JRExpressionCollector expressionCollector, String unitName) {
        this(jasperDesign, unitName, expressionCollector, crosstab.getParametersMap(), null, crosstab.getVariablesMap(), crosstab.getVariables(), expressionCollector.getExpressions(crosstab), true);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public Map getFieldsMap() {
        return this.fieldsMap;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public String[] getImports() {
        return this.jasperDesign.getImports();
    }

    public boolean isOnlyDefaultEvaluation() {
        return this.onlyDefaultEvaluation;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public Map getVariablesMap() {
        return this.variablesMap;
    }

    public Integer getExpressionId(JRExpression expression) {
        return this.expressionCollector.getExpressionId(expression);
    }
}

