/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class JRMapArrayDataSource
implements JRRewindableDataSource {
    private Object[] records = null;
    private int index = -1;

    public JRMapArrayDataSource(Object[] array) {
        this.records = array;
    }

    @Override
    public boolean next() {
        ++this.index;
        if (this.records != null) {
            return this.index < this.records.length;
        }
        return false;
    }

    @Override
    public Object getFieldValue(JRField field) {
        Object value = null;
        Map currentRecord = (Map)this.records[this.index];
        if (currentRecord != null) {
            value = currentRecord.get(field.getName());
        }
        return value;
    }

    @Override
    public void moveFirst() {
        this.index = -1;
    }
}

