/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseElement
implements JRElement,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String key = null;
    protected byte positionType;
    protected byte stretchType;
    protected boolean isPrintRepeatedValues = true;
    protected Byte mode;
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected boolean isRemoveLineWhenBlank = false;
    protected boolean isPrintInFirstWholeBand = false;
    protected boolean isPrintWhenDetailOverflows = false;
    protected Color forecolor = null;
    protected Color backcolor = null;
    protected JRExpression printWhenExpression = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRElementGroup elementGroup = null;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;

    protected JRBaseElement(JRDefaultStyleProvider defaultStyleProvider) {
        this.defaultStyleProvider = defaultStyleProvider;
    }

    protected JRBaseElement(JRElement element, JRBaseObjectFactory factory) {
        factory.put(element, this);
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        this.parentStyle = factory.getStyle(element.getStyle());
        this.key = element.getKey();
        this.positionType = element.getPositionType();
        this.stretchType = element.getStretchType();
        this.isPrintRepeatedValues = element.isPrintRepeatedValues();
        this.mode = element.getOwnMode();
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.isRemoveLineWhenBlank = element.isRemoveLineWhenBlank();
        this.isPrintInFirstWholeBand = element.isPrintInFirstWholeBand();
        this.isPrintWhenDetailOverflows = element.isPrintWhenDetailOverflows();
        this.forecolor = element.getOwnForecolor();
        this.backcolor = element.getOwnBackcolor();
        this.printWhenExpression = factory.getExpression(element.getPrintWhenExpression());
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = factory.getElementGroup(element.getElementGroup());
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public byte getPositionType() {
        return this.positionType;
    }

    @Override
    public void setPositionType(byte positionType) {
        this.positionType = positionType;
    }

    @Override
    public byte getStretchType() {
        return this.stretchType;
    }

    @Override
    public void setStretchType(byte stretchType) {
        this.stretchType = stretchType;
    }

    @Override
    public boolean isPrintRepeatedValues() {
        return this.isPrintRepeatedValues;
    }

    @Override
    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
        this.isPrintRepeatedValues = isPrintRepeatedValues;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    @Override
    public Byte getOwnMode() {
        return this.mode;
    }

    @Override
    public void setMode(byte mode) {
        this.mode = new Byte(mode);
    }

    @Override
    public void setMode(Byte mode) {
        this.mode = mode;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isRemoveLineWhenBlank() {
        return this.isRemoveLineWhenBlank;
    }

    @Override
    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
        this.isRemoveLineWhenBlank = isRemoveLine;
    }

    @Override
    public boolean isPrintInFirstWholeBand() {
        return this.isPrintInFirstWholeBand;
    }

    @Override
    public void setPrintInFirstWholeBand(boolean isPrint) {
        this.isPrintInFirstWholeBand = isPrint;
    }

    @Override
    public boolean isPrintWhenDetailOverflows() {
        return this.isPrintWhenDetailOverflows;
    }

    @Override
    public void setPrintWhenDetailOverflows(boolean isPrint) {
        this.isPrintWhenDetailOverflows = isPrint;
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public void setForecolor(Color forecolor) {
        this.forecolor = forecolor;
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    @Override
    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }
}

