/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseDataset
implements JRDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected final boolean isMain;
    protected String name = null;
    protected String scriptletClass = null;
    protected JRParameter[] parameters = null;
    protected JRQuery query = null;
    protected JRField[] fields = null;
    protected JRVariable[] variables = null;
    protected JRGroup[] groups = null;
    protected String resourceBundle = null;
    protected byte whenResourceMissingType = 1;
    protected JRPropertiesMap propertiesMap;
    protected JRExpression filterExpression;

    protected JRBaseDataset(boolean isMain) {
        this.isMain = isMain;
        this.propertiesMap = new JRPropertiesMap();
    }

    protected JRBaseDataset(JRDataset dataset, JRBaseObjectFactory factory) {
        JRGroup[] jrGroups;
        JRVariable[] jrVariables;
        JRField[] jrFields;
        factory.put(dataset, this);
        this.name = dataset.getName();
        this.scriptletClass = dataset.getScriptletClass();
        this.resourceBundle = dataset.getResourceBundle();
        this.whenResourceMissingType = dataset.getWhenResourceMissingType();
        this.propertiesMap = new JRPropertiesMap(dataset.getPropertiesMap());
        this.query = factory.getQuery(dataset.getQuery());
        this.isMain = dataset.isMainDataset();
        JRParameter[] jrParameters = dataset.getParameters();
        if (jrParameters != null && jrParameters.length > 0) {
            this.parameters = new JRParameter[jrParameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getParameter(jrParameters[i]);
            }
        }
        if ((jrFields = dataset.getFields()) != null && jrFields.length > 0) {
            this.fields = new JRField[jrFields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = factory.getField(jrFields[i]);
            }
        }
        if ((jrVariables = dataset.getVariables()) != null && jrVariables.length > 0) {
            this.variables = new JRVariable[jrVariables.length];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = factory.getVariable(jrVariables[i]);
            }
        }
        if ((jrGroups = dataset.getGroups()) != null && jrGroups.length > 0) {
            this.groups = new JRGroup[jrGroups.length];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = factory.getGroup(jrGroups[i]);
            }
        }
        this.filterExpression = factory.getExpression(dataset.getFilterExpression());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScriptletClass() {
        return this.scriptletClass;
    }

    @Override
    public JRQuery getQuery() {
        return this.query;
    }

    @Override
    public JRParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRField[] getFields() {
        return this.fields;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }

    @Override
    public JRGroup[] getGroups() {
        return this.groups;
    }

    @Override
    public boolean isMainDataset() {
        return this.isMain;
    }

    @Override
    public String getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public byte getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    @Override
    public void setWhenResourceMissingType(byte whenResourceMissingType) {
        this.whenResourceMissingType = whenResourceMissingType;
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.propertiesMap;
    }

    @Override
    public JRExpression getFilterExpression() {
        return this.filterExpression;
    }
}

