/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.report;

import coldfusion.document.DocumentInvalidWaterMarkFileException;
import coldfusion.server.LicenseService;
import coldfusion.server.ServiceFactory;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.JRPdfExporter;

public class CFPdfExporter
extends JRPdfExporter {
    private PdfWriter pdfWriter = null;
    private static int DefaultByteArraySize = 204800;

    public void CFPdfExporterInit(Document document, PdfWriter pdfwriter) {
        this.document = document;
        this.pdfWriter = pdfwriter;
    }

    public byte[] exportToByteArray() throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(DefaultByteArraySize);
        this.exportReportToStream(baos);
        return baos.toByteArray();
    }

    @Override
    protected void exportReportToStream(OutputStream os) throws JRException {
        this.document = new Document(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
        if (this.pdfWriter == null) {
            try {
                this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            }
            catch (DocumentException e) {
                throw new JRException("PDF Document error : " + this.jasperPrint.getName(), e);
            }
        }
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        try {
            this.pdfWriter.setCloseStream(false);
            if (this.isEncrypted) {
                this.pdfWriter.setEncryption(this.is128BitKey, this.userPassword, this.ownerPassword, this.permissions);
            }
            this.document.open();
            this.pdfContentByte = this.pdfWriter.getDirectContent();
            PdfOutline root = this.pdfContentByte.getRootOutline();
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance((Document)this.imageTesterDocument, (OutputStream)new ByteArrayOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.loadedImagesMap = new HashMap();
                this.document.setPageSize(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
                List pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (this.isModeBatch) {
                        this.document.newPage();
                        PdfDestination newReport = new PdfDestination(0, 0.0f, (float)this.jasperPrint.getPageHeight(), 0.0f);
                        new PdfOutline(root, newReport, this.jasperPrint.getName(), false);
                        this.startPageIndex = 0;
                        this.endPageIndex = pages.size() - 1;
                    }
                    Chunk chunk = null;
                    ColumnText colText = null;
                    JRPrintPage page = null;
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        page = (JRPrintPage)pages.get(pageIndex);
                        this.document.newPage();
                        this.pdfContentByte = this.pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        chunk = new Chunk(" ");
                        chunk.setLocalDestination("JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (pageIndex + 1));
                        colText = new ColumnText(this.pdfContentByte);
                        colText.setSimpleColumn(new Phrase(chunk), 0.0f, (float)this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
                        colText.go();
                        this.exportPage(page);
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = this.pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
        }
        catch (DocumentException e) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), e);
        }
        catch (IOException e) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), e);
        }
        finally {
            this.document.close();
            this.imageTesterDocument.close();
        }
    }

    @Override
    protected Chunk getChunk(Map attributes, String text, float leadingOffset) throws JRException, DocumentException, IOException {
        Object script;
        Font font;
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        Color backcolor = (Color)attributes.get(TextAttribute.BACKGROUND);
        boolean isEmbedded = jrFont.isPdfEmbedded();
        String pdfEncoding = jrFont.getPdfEncoding();
        try {
            String pdfFontName = jrFont.getPdfFontName();
            String archive_property = System.getProperty("ARCHIVE_ENCODING");
            if (archive_property != null && !archive_property.isEmpty()) {
                pdfEncoding = archive_property;
            }
            if ((font = FontFactory.getFont((String)pdfFontName, (String)pdfEncoding, (boolean)isEmbedded, (float)jrFont.getSize(), (int)((jrFont.isBold() ? 1 : 0) + (jrFont.isItalic() ? 2 : 0) + (jrFont.isUnderline() ? 4 : 0) + (jrFont.isStrikeThrough() ? 8 : 0)), (Color)forecolor)).getBaseFont() == null) {
                FontFactory.registerDirectories();
                font = FontFactory.getFont((String)pdfFontName, (String)pdfEncoding, (boolean)isEmbedded, (float)jrFont.getSize(), (int)((jrFont.isBold() ? 1 : 0) + (jrFont.isItalic() ? 2 : 0) + (jrFont.isUnderline() ? 4 : 0) + (jrFont.isStrikeThrough() ? 8 : 0)), (Color)forecolor);
            }
            if (!isEmbedded) {
                font.getBaseFont().setSubset(false);
            }
        }
        catch (RuntimeException e) {
            try {
                font = FontFactory.getFont((String)jrFont.getPdfFontName(), (String)"Cp1252", (boolean)jrFont.isPdfEmbedded(), (float)jrFont.getSize(), (int)((jrFont.isBold() ? 1 : 0) + (jrFont.isItalic() ? 2 : 0) + (jrFont.isUnderline() ? 4 : 0) + (jrFont.isStrikeThrough() ? 8 : 0)), (Color)forecolor);
            }
            catch (Exception e1) {
                throw new JRException("Could not load the following font : \npdfFontName   : " + jrFont.getPdfFontName() + "\npdfEncoding   : " + jrFont.getPdfEncoding() + "\nisPdfEmbedded : " + jrFont.isPdfEmbedded(), e);
            }
        }
        Chunk chunk = new Chunk(text, font);
        if (backcolor != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setTextRise(font.getCalculatedLeading(1.0f) / 2.0f);
            } else if (script != null && TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setTextRise(-font.getCalculatedLeading(1.0f) / 2.0f);
            }
        }
        return chunk;
    }

    @Override
    protected void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        super.exportPage(page);
        LicenseService ls = ServiceFactory.getLicenseService();
        if (ls.isDeveloper()) {
            Image image = null;
            image = System.getSecurityManager() == null ? ServiceFactory.getDocumentService().getWmimage() : (Image)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ServiceFactory.getDocumentService().getWmimage();
                }
            });
            if (image != null) {
                Image scaledimage = image.getScaledInstance(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), 1);
                com.lowagie.text.Image wmimage = com.lowagie.text.Image.getInstance((Image)scaledimage, null);
                wmimage.setAbsolutePosition(0.0f, 0.0f);
                this.pdfContentByte.addImage(wmimage);
            } else {
                throw new DocumentInvalidWaterMarkFileException();
            }
        }
    }
}

