/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.webkit.core.DocumentSettingsWebkit;
import coldfusion.document.webkit.core.HtmlToPdfMargin;
import coldfusion.document.webkit.core.HtmlToPdfPageLayout;
import coldfusion.runtime.RequestMonitor;
import coldfusion.vfs.VFSFileFactory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.lang3.StringEscapeUtils;

public final class PDFgServiceRequestCreator {
    private static final String VALUE = "' value='";
    private static final String SETTING_NAME = "<Setting name='";
    private static final String AUTHPASSWORD = "<Setting name='AuthPassword' value='";
    private static final String AUTHUSER = "<Setting name='AuthUser' value='";
    private static final String DEVWATERMARK = "<Setting name='AddDeveloperWatermark' value='";
    private static final String BOOKMARKS = "<Setting name='Bookmarks' value='";
    private static final String FONTEMBED = "<Setting name='FontEmbed' value='";
    private static final String SCALE = "<Setting name='Scale' value='";
    private static final String ORIENTATION = "<Setting name='Orientation' value='";
    private static final String PAGEHEIGHT = "<Setting name='PageHeight' value='";
    private static final String PAGEWIDTH = "<Setting name='PageWidth' value='";
    private static final String CONVERSION_TIMEOUT = "<Setting name='ConversionTimeout' value='";
    private static final String MIMETYPE = "<Setting name='MimeType' value='";
    private static final String OVERWRITE = "<Setting name='Overwrite' value='";
    private static final String DESTFILE = "<Setting name='DestFile' value='";
    private static final String BASEURL = "<Setting name='BaseURL' value='";
    private static final String SOURCEURL = "<Setting name='SourceURL' value='";
    private static final String HEADERFOOTER = "<Setting name='HeaderFooter' value='";
    private static final String MARGINBOTTOM = "<Setting name='MarginBottom' value='";
    private static final String MARGINTOP = "<Setting name='MarginTop' value='";
    private static final String MARGINRIGHT = "<Setting name='MarginRight' value='";
    private static final String MARGINLEFT = "<Setting name='MarginLeft' value='";
    private static final String LANGUAGE = "<Setting name='Language' value='";
    private static final String PAGETYPE = "<Setting name='PageType' value='";
    private static final String UNIT = "<Setting name='unit' value='";
    private static final String CONFORMANCE = "<Setting name='Conformance' value='";
    private static final String CFLICENSE = "<Setting name='CfLicense' value='";
    private static final String HEADER = "<Setting name='Header' value='";
    private static final String HEADER_ALIGN = "<Setting name='Header_Align' value='";
    private static final String HEADER_LEFTMARGIN = "<Setting name='Header_LeftMargin' value='";
    private static final String HEADER_RIGHTMARGIN = "<Setting name='Header_RightMargin' value='";
    private static final String HEADER_TOPMARGIN = "<Setting name='Header_TopMargin' value='";
    private static final String HEADER_NUMBERFORMAT = "<Setting name='Header_NumberFormat' value='";
    private static final String HEADER_OPACITY = "<Setting name='Header_Opacity' value='";
    private static final String HEADER_CONTENT = "<Setting name='Header_Content' value='";
    private static final String FOOTER = "<Setting name='Footer' value='";
    private static final String FOOTER_ALIGN = "<Setting name='Footer_Align' value='";
    private static final String FOOTER_LEFTMARGIN = "<Setting name='Footer_LeftMargin' value='";
    private static final String FOOTER_RIGHTMARGIN = "<Setting name='Footer_RightMargin' value='";
    private static final String FOOTER_BOTTOMMARGIN = "<Setting name='Footer_BottomMargin' value='";
    private static final String FOOTER_NUMBERFORMAT = "<Setting name='Footer_NumberFormat' value='";
    private static final String FOOTER_OPACITY = "<Setting name='Footer_Opacity' value='";
    private static final String FOOTER_CONTENT = "<Setting name='Footer_Content' value='";
    private static final String CONVERT_PDF = "<PDFConversion><PDFOperation name='ConvertPDF'>";
    public static final String END_OPERATION = "</PDFOperation></PDFConversion>";
    private static final String TASK_START_ELEMENT = "<PDFTask>";
    private static final String TASK_END_ELEMENT = "</PDFTask>";
    private static final String END_ELEMENT = "'/>";

    public static String buildSectionConvertPDFRequestTask(DocumentSettingsWebkit sectionSettings) {
        StringBuffer initData = new StringBuffer();
        initData.append(TASK_START_ELEMENT);
        PDFgServiceRequestCreator.addSectionConvertData(sectionSettings, initData);
        initData.append(TASK_END_ELEMENT);
        return initData.toString();
    }

    public static String buildConvertPDFRequestForSection(DocumentSettingsWebkit pdfSettings) {
        StringBuffer initData = new StringBuffer();
        initData.append(CONVERT_PDF);
        PDFgServiceRequestCreator.addCommonConversionData(pdfSettings, initData);
        return initData.toString();
    }

    public static String buildConvertPDFRequest(DocumentSettingsWebkit pdfSettings, HashMap<String, String> otherPdfSettings, String engine) {
        StringBuffer initData = new StringBuffer();
        initData.append(CONVERT_PDF);
        PDFgServiceRequestCreator.addEntry(initData, SOURCEURL, StringEscapeUtils.escapeXml((String)StringEscapeUtils.unescapeXml((String)pdfSettings.getPageURL())));
        PDFgServiceRequestCreator.addEntry(initData, BASEURL, pdfSettings.getBaseURL());
        PDFgServiceRequestCreator.addCommonConversionData(pdfSettings, initData);
        if (engine.equalsIgnoreCase("pdfReactor")) {
            PDFgServiceRequestCreator.addSettingsForPdfReactor(pdfSettings, otherPdfSettings, initData);
            PDFgServiceRequestCreator.addHeaderFooterSettingsForPdfReactor(pdfSettings, otherPdfSettings, initData);
        } else if (engine.equalsIgnoreCase("webkit")) {
            PDFgServiceRequestCreator.addMarginsForWebKit(pdfSettings, initData);
            PDFgServiceRequestCreator.addPageDimensionsForWebKit(pdfSettings, initData);
        }
        initData.append(END_OPERATION);
        return initData.toString();
    }

    private static void addCommonConversionData(DocumentSettingsWebkit pdfSettings, StringBuffer initData) {
        String outputFile = pdfSettings.getOutputFile();
        if (outputFile != null && !VFSFileFactory.checkIfVFile((String)outputFile)) {
            PDFgServiceRequestCreator.addEntry(initData, DESTFILE, outputFile);
        }
        PDFgServiceRequestCreator.addEntry(initData, OVERWRITE, pdfSettings.isOverwrite());
        PDFgServiceRequestCreator.addEntry(initData, MIMETYPE, pdfSettings.getMimeType());
        PDFgServiceRequestCreator.addEntry(initData, ORIENTATION, pdfSettings.getPageLayout().getOrientation());
        PDFgServiceRequestCreator.addEntry(initData, SCALE, pdfSettings.getScale());
        PDFgServiceRequestCreator.addEntry(initData, FONTEMBED, pdfSettings.isFontEmbed());
        PDFgServiceRequestCreator.addEntry(initData, BOOKMARKS, pdfSettings.isBookmark() ? "TRUE" : "FALSE");
        PDFgServiceRequestCreator.addEntry(initData, DEVWATERMARK, pdfSettings.isAddDevWatermark());
        PDFgServiceRequestCreator.addEntry(initData, HEADERFOOTER, pdfSettings.isShowHeader());
        PDFgServiceRequestCreator.addEntry(initData, AUTHUSER, pdfSettings.getAuthUser());
        PDFgServiceRequestCreator.addEntry(initData, AUTHPASSWORD, pdfSettings.getAuthPassword());
        long requestTimeout = RequestMonitor.getRequestTimeout();
        PDFgServiceRequestCreator.addEntry(initData, CONVERSION_TIMEOUT, requestTimeout);
    }

    private static void addSectionConvertData(DocumentSettingsWebkit sectionSettings, StringBuffer initData) {
        PDFgServiceRequestCreator.addEntry(initData, SOURCEURL, sectionSettings.getPageURL());
        PDFgServiceRequestCreator.addEntry(initData, BASEURL, sectionSettings.getBaseURL());
        PDFgServiceRequestCreator.addEntry(initData, MIMETYPE, sectionSettings.getMimeType());
        PDFgServiceRequestCreator.addEntry(initData, AUTHUSER, sectionSettings.getAuthUser());
        PDFgServiceRequestCreator.addEntry(initData, AUTHPASSWORD, sectionSettings.getAuthPassword());
        PDFgServiceRequestCreator.addMarginsForWebKit(sectionSettings, initData);
    }

    private static void addEntry(StringBuffer initData, String key, String value) {
        if (value != null) {
            initData.append(key);
            initData.append(value);
            initData.append(END_ELEMENT);
        }
    }

    private static void addEntry(StringBuffer initData, String key, boolean value) {
        initData.append(key);
        initData.append(value);
        initData.append(END_ELEMENT);
    }

    private static void addEntry(StringBuffer initData, String key, long value) {
        if (value >= 0L) {
            initData.append(key);
            initData.append(value);
            initData.append(END_ELEMENT);
        }
    }

    private static void addEntry(StringBuffer initData, String key, double value) {
        if (value >= 0.0) {
            initData.append(key);
            initData.append(value);
            initData.append(END_ELEMENT);
        }
    }

    private static void addSettingsForPdfReactor(DocumentSettingsWebkit pdfSettings, HashMap<String, String> otherPdfSettings, StringBuffer initData) {
        HtmlToPdfPageLayout pageLayout = pdfSettings.getPageLayout();
        if (pageLayout != null) {
            HtmlToPdfMargin margin = pageLayout.getMargin();
            if (margin.getLeft() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINLEFT, String.valueOf(margin.getLeft()));
            }
            if (margin.getRight() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINRIGHT, String.valueOf(margin.getRight()));
            }
            if (margin.getTop() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINTOP, String.valueOf(margin.getTop()));
            }
            if (margin.getBottom() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINBOTTOM, String.valueOf(margin.getBottom()));
            }
            PDFgServiceRequestCreator.addEntry(initData, PAGEWIDTH, pageLayout.getPagewidth());
            PDFgServiceRequestCreator.addEntry(initData, PAGEHEIGHT, pageLayout.getPageheight());
        }
        if (otherPdfSettings != null) {
            if (otherPdfSettings.get("Language") != null) {
                PDFgServiceRequestCreator.addEntry(initData, LANGUAGE, otherPdfSettings.get("Language"));
            }
            if (otherPdfSettings.get("PageType") != null) {
                PDFgServiceRequestCreator.addEntry(initData, PAGETYPE, otherPdfSettings.get("PageType"));
            }
            if (otherPdfSettings.get("unit") != null) {
                PDFgServiceRequestCreator.addEntry(initData, UNIT, otherPdfSettings.get("unit"));
            }
            if (otherPdfSettings.get("Conformance") != null) {
                PDFgServiceRequestCreator.addEntry(initData, CONFORMANCE, otherPdfSettings.get("Conformance"));
            }
            if (otherPdfSettings.get("CfLicense") != null) {
                PDFgServiceRequestCreator.addEntry(initData, CFLICENSE, otherPdfSettings.get("CfLicense"));
            }
        }
    }

    private static void addHeaderFooterSettingsForPdfReactor(DocumentSettingsWebkit pdfSettings, HashMap<String, String> otherPdfSettings, StringBuffer initData) {
        PDFgServiceRequestCreator.addEntry(initData, HEADER, otherPdfSettings.get("Header"));
        if (pdfSettings.getHeader() != null) {
            PDFgServiceRequestCreator.addEntry(initData, HEADER_ALIGN, otherPdfSettings.get("Header_Align"));
            PDFgServiceRequestCreator.addEntry(initData, HEADER_LEFTMARGIN, otherPdfSettings.get("Header_LeftMargin"));
            PDFgServiceRequestCreator.addEntry(initData, HEADER_RIGHTMARGIN, otherPdfSettings.get("Header_RightMargin"));
            PDFgServiceRequestCreator.addEntry(initData, HEADER_TOPMARGIN, otherPdfSettings.get("Header_TopMargin"));
            PDFgServiceRequestCreator.addEntry(initData, HEADER_NUMBERFORMAT, otherPdfSettings.get("Header_NumberFormat"));
            PDFgServiceRequestCreator.addEntry(initData, HEADER_OPACITY, otherPdfSettings.get("Header_Opacity"));
            if (otherPdfSettings.get("Header_Content") != null) {
                String base64HeaderContent = Base64.getEncoder().encodeToString(otherPdfSettings.get("Header_Content").getBytes(StandardCharsets.UTF_8));
                PDFgServiceRequestCreator.addEntry(initData, HEADER_CONTENT, base64HeaderContent);
            }
        }
        PDFgServiceRequestCreator.addEntry(initData, FOOTER, otherPdfSettings.get("Footer"));
        if (pdfSettings.getFooter() != null) {
            PDFgServiceRequestCreator.addEntry(initData, FOOTER_ALIGN, otherPdfSettings.get("Footer_Align"));
            PDFgServiceRequestCreator.addEntry(initData, FOOTER_LEFTMARGIN, otherPdfSettings.get("Footer_LeftMargin"));
            PDFgServiceRequestCreator.addEntry(initData, FOOTER_RIGHTMARGIN, otherPdfSettings.get("Footer_RightMargin"));
            PDFgServiceRequestCreator.addEntry(initData, FOOTER_BOTTOMMARGIN, otherPdfSettings.get("Footer_BottomMargin"));
            PDFgServiceRequestCreator.addEntry(initData, FOOTER_NUMBERFORMAT, otherPdfSettings.get("Footer_NumberFormat"));
            PDFgServiceRequestCreator.addEntry(initData, FOOTER_OPACITY, otherPdfSettings.get("Footer_Opacity"));
            if (otherPdfSettings.get("Footer_Content") != null) {
                String base64FooterContent = Base64.getEncoder().encodeToString(otherPdfSettings.get("Footer_Content").getBytes(StandardCharsets.UTF_8));
                PDFgServiceRequestCreator.addEntry(initData, FOOTER_CONTENT, base64FooterContent);
            }
        }
    }

    private static void addMarginsForWebKit(DocumentSettingsWebkit pdfSettings, StringBuffer initData) {
        HtmlToPdfPageLayout pageLayout = pdfSettings.getPageLayout();
        if (pageLayout != null) {
            HtmlToPdfMargin margin = pageLayout.getMargin();
            if (margin.getLeft() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINLEFT, String.valueOf(margin.getLeft() * 72.0));
            }
            if (margin.getRight() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINRIGHT, String.valueOf(margin.getRight() * 72.0));
            }
            if (margin.getTop() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINTOP, String.valueOf(margin.getTop() * 72.0));
            }
            if (margin.getBottom() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINBOTTOM, String.valueOf(margin.getBottom() * 72.0));
            }
        }
    }

    private static void addPageDimensionsForWebKit(DocumentSettingsWebkit pdfSettings, StringBuffer initData) {
        PDFgServiceRequestCreator.addEntry(initData, PAGEWIDTH, pdfSettings.getPageLayout().getPagewidth() * 72.0);
        PDFgServiceRequestCreator.addEntry(initData, PAGEHEIGHT, pdfSettings.getPageLayout().getPageheight() * 72.0);
    }
}

