/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class UtilTransliteratorWithFixup
extends UtilTransliterator {
    private String encoding;
    private CharToByteConverter c2b;
    private ByteToCharConverter b2c;
    private int maxBytesPerChar;
    private int maxCharsPerByte;
    private char[][] fixupMapPut;
    private char[][] fixupMapGet;
    private static final char[][] MS932_eucJP_Map = new char[][]{{'\u2225', '\u2016'}, {'\uff5e', '\u301c'}, {'\uff0d', '\u2212'}, {'\u2015', '\u2014'}};
    private static final char[][] eucJP_MS932_Map = new char[][]{{'\u00ac', '\uffe2'}, {'\u2016', '\u2225'}, {'\u301c', '\uff5e'}, {'\u2212', '\uff0d'}, {'\u00a2', '\uffe0'}, {'\u00a3', '\uffe1'}, {'\u2014', '\u2015'}};
    private Reader _rdr;

    private void fixup(char[] cArray, int n, char[][] cArray2) {
        int n2 = cArray2.length;
        block0: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            for (int j = 0; j < n2; ++j) {
                if (c != cArray2[j][0]) continue;
                cArray[i] = cArray2[j][1];
                continue block0;
            }
        }
    }

    public UtilTransliteratorWithFixup(String string, int n, int n2) throws UtilException {
        try {
            this.encoding = string;
            this.c2b = CharToByteConverter.getConverter((String)string);
            this.b2c = ByteToCharConverter.getConverter((String)string);
            this.maxBytesPerChar = this.c2b.getMaxBytesPerChar();
            this.maxCharsPerByte = this.b2c.getMaxCharsPerByte();
            this.setDefaultCacheSize();
            block1 : switch (n2) {
                case 1: {
                    switch (n) {
                        case 2: {
                            this.fixupMapPut = eucJP_MS932_Map;
                            this.fixupMapGet = MS932_eucJP_Map;
                            break block1;
                        }
                    }
                    this.fixupMapGet = new char[0][0];
                    this.fixupMapPut = this.fixupMapGet;
                    break;
                }
                case 2: {
                    switch (n) {
                        case 1: {
                            this.fixupMapPut = MS932_eucJP_Map;
                            this.fixupMapGet = eucJP_MS932_Map;
                            break block1;
                        }
                    }
                    this.fixupMapGet = new char[0][0];
                    this.fixupMapPut = this.fixupMapGet;
                    break;
                }
                default: {
                    this.fixupMapGet = new char[0][0];
                    this.fixupMapPut = this.fixupMapGet;
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
    }

    public boolean isFixedBytesPerChar() {
        return this.c2b.getMaxBytesPerChar() == 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public int getMaxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public byte[] encode(String string) throws UtilException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        this.fixup(cArray, n, this.fixupMapPut);
        try {
            return this.c2b.convertAll(cArray);
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        int n2 = n * this.maxBytesPerChar;
        this.setCacheSize(n);
        try {
            this.c2b.reset();
            this.c2b.setSubstitutionMode(true);
            string.getChars(0, n, this.charsCache, 0);
            this.fixup(this.charsCache, n, this.fixupMapPut);
            int n3 = this.c2b.convert(this.charsCache, 0, n, this.bytesCache, 0, n2);
            nArray[0] = n3 += this.c2b.flush(this.bytesCache, this.c2b.nextByteIndex(), n2);
            return this.bytesCache;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                for (int i = 0; i < n3; ++i) {
                    this.charsCache[i] = (char)(this.bytesCache[i] & 0xFF);
                }
                this.fixup(this.charsCache, n3, this.fixupMapPut);
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                this.fixup(this.charsCache, n3, this.fixupMapPut);
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        int n3 = n2 * this.maxCharsPerByte;
        this.setCacheSize(n3);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n4 = this.b2c.convert(byArray, n, n + n2, this.charsCache, 0, n3);
            n4 += this.b2c.flush(this.charsCache, n4, n3);
            this.fixup(this.charsCache, n4, this.fixupMapGet);
            return new String(this.charsCache, 0, n4);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n3 = this.b2c.convert(byArray, n, n + n2, cArray, 0, cArray.length);
            n3 += this.b2c.flush(cArray, n3, cArray.length);
            this.fixup(this.charsCache, n3, this.fixupMapGet);
            return n3;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        int n4 = n2 * this.maxCharsPerByte;
        int n5 = Math.max(n4, n3);
        this.setCacheSize(n5);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n6 = this.b2c.convert(byArray, n, n + n2, this.charsCache, 0, n4);
            n6 += this.b2c.flush(this.charsCache, n6, n4);
            this.fixup(this.charsCache, n6, this.fixupMapGet);
            for (int i = n6; i < n3; ++i) {
                this.charsCache[i] = 32;
            }
            return new String(this.charsCache, 0, n3);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            this._rdr = new InputStreamReader(inputStream, this.encoding);
            return new Reader(){
                private Reader rdr;
                private int length;
                private char[] cache;
                {
                    this.rdr = UtilTransliteratorWithFixup.this._rdr;
                }

                public int read() throws IOException {
                    int n = this.rdr.read();
                    if (n == -1) {
                        return -1;
                    }
                    if (this.cache == null || this.cache.length < 1) {
                        this.cache = new char[1];
                    }
                    this.cache[0] = (char)n;
                    UtilTransliteratorWithFixup.this.fixup(this.cache, 1, UtilTransliteratorWithFixup.this.fixupMapGet);
                    return this.cache[0];
                }

                public int read(char[] cArray, int n, int n2) throws IOException {
                    int n3;
                    if (this.cache == null || this.cache.length < n2) {
                        this.cache = new char[n2];
                    }
                    if ((n3 = this.rdr.read(this.cache, 0, n2)) <= 0) {
                        return n3;
                    }
                    UtilTransliteratorWithFixup.this.fixup(this.cache, n3, UtilTransliteratorWithFixup.this.fixupMapGet);
                    System.arraycopy(this.cache, 0, cArray, n, n3);
                    return n3;
                }

                public void close() throws IOException {
                    this.rdr.close();
                }
            };
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }
}

