/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import macromedia.slutil.UtilByteArray;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilResource;
import macromedia.slutil.UtilResourceLocator;
import macromedia.slutil.UtilTransliterator;

public class UtilTransliteratorUsingTable
extends UtilTransliterator {
    private byte[] toServerArray;
    private char[] toClientArray;
    private byte[] unicodeBytes;
    private char[] unicodeChars;
    private int unicodeCount;
    private byte encodedUndefinedCharacter;
    private int[] rl;
    private static HashMap CachedConversionTables;
    private InputStream _in;

    public UtilTransliteratorUsingTable(String string) throws UtilException {
        ConversionTable conversionTable;
        if (CachedConversionTables == null) {
            CachedConversionTables = new HashMap();
        }
        if ((conversionTable = (ConversionTable)CachedConversionTables.get(string)) != null) {
            this.loadCachedConversionTable(conversionTable);
        } else {
            InputStream inputStream = null;
            this.toClientArray = new char[256];
            UtilResource utilResource = new UtilResource(new UtilResourceLocator().getClass(), string);
            try {
                inputStream = utilResource.getAsStream();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new UtilException(1005, string);
            }
            if (inputStream == null) {
                throw new UtilException(1005, string);
            }
            this.loadTable(inputStream, string);
            this.buildConversionTables();
            this.cacheConversionTables(string);
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setDefaultCacheSize();
        this.supportByteArrayToByteArrayDecode = true;
    }

    public UtilTransliteratorUsingTable(String string, char[] cArray, byte by) throws UtilException {
        ConversionTable conversionTable;
        if (CachedConversionTables == null) {
            CachedConversionTables = new HashMap();
        }
        if ((conversionTable = (ConversionTable)CachedConversionTables.get(string)) != null) {
            this.loadCachedConversionTable(conversionTable);
        } else {
            if (cArray.length != 256) {
                throw new UtilException(1008, "ctor 2");
            }
            this.toClientArray = cArray;
            this.encodedUndefinedCharacter = by;
            this.buildConversionTables();
            this.cacheConversionTables(string);
        }
        this.setDefaultCacheSize();
        this.supportByteArrayToByteArrayDecode = true;
    }

    public static UtilTransliteratorUsingTable GetIfLoaded(String string) throws UtilException {
        if (CachedConversionTables == null) {
            return null;
        }
        if (CachedConversionTables.get(string) == null) {
            return null;
        }
        return new UtilTransliteratorUsingTable(string);
    }

    private void loadTable(InputStream inputStream, String string) throws UtilException {
        try {
            int n;
            for (int i = 0; i < 256; ++i) {
                n = inputStream.read();
                if (n == -1) {
                    throw new IOException();
                }
                int n2 = inputStream.read();
                if (n2 == -1) {
                    throw new IOException();
                }
                this.toClientArray[i] = (char)(n * 256 + n2);
            }
            n = inputStream.read();
            if (n == -1) {
                throw new IOException();
            }
            this.encodedUndefinedCharacter = (byte)n;
            if (inputStream.read() != -1) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1008, string);
        }
    }

    private void buildConversionTables() {
        int n;
        int n2;
        int n3;
        this.unicodeCount = 0;
        this.toServerArray = new byte[256];
        for (n3 = 0; n3 < 256; ++n3) {
            this.toServerArray[n3] = this.encodedUndefinedCharacter;
            if ((this.toClientArray[n3] & 0xFF00) == 0) continue;
            ++this.unicodeCount;
        }
        this.unicodeBytes = new byte[this.unicodeCount];
        this.unicodeChars = new char[this.unicodeCount];
        this.unicodeCount = 0;
        for (n3 = 0; n3 < 256; ++n3) {
            n2 = this.toClientArray[n3];
            if ((n2 & 0xFF00) == 0) {
                this.toServerArray[n2] = (byte)n3;
                continue;
            }
            this.unicodeChars[this.unicodeCount] = n2;
            this.unicodeBytes[this.unicodeCount] = (byte)n3;
            ++this.unicodeCount;
        }
        char[] cArray = new char[this.unicodeCount];
        for (n2 = 0; n2 < this.unicodeCount; ++n2) {
            cArray[n2] = this.unicodeChars[n2];
        }
        byte[] byArray = new byte[this.unicodeCount];
        for (n = 0; n < this.unicodeCount; ++n) {
            byArray[n] = this.unicodeBytes[n];
        }
        Arrays.sort(this.unicodeChars);
        for (n = 0; n < this.unicodeCount; ++n) {
            int n4 = Arrays.binarySearch(this.unicodeChars, cArray[n]);
            this.unicodeBytes[n4] = byArray[n];
        }
    }

    private void cacheConversionTables(Object object) {
        ConversionTable conversionTable = new ConversionTable();
        conversionTable.toServerArray = this.toServerArray;
        conversionTable.toClientArray = this.toClientArray;
        conversionTable.unicodeBytes = this.unicodeBytes;
        conversionTable.unicodeChars = this.unicodeChars;
        conversionTable.unicodeCount = this.unicodeCount;
        conversionTable.encodedUndefinedCharacter = this.encodedUndefinedCharacter;
        CachedConversionTables.put(object, conversionTable);
    }

    private void loadCachedConversionTable(ConversionTable conversionTable) {
        this.toServerArray = conversionTable.toServerArray;
        this.toClientArray = conversionTable.toClientArray;
        this.unicodeBytes = conversionTable.unicodeBytes;
        this.unicodeChars = conversionTable.unicodeChars;
        this.unicodeCount = conversionTable.unicodeCount;
        this.encodedUndefinedCharacter = conversionTable.encodedUndefinedCharacter;
    }

    private byte mapUnicodeChar(char c) {
        int n = Arrays.binarySearch(this.unicodeChars, c);
        if (n >= 0) {
            return this.unicodeBytes[n];
        }
        return this.encodedUndefinedCharacter;
    }

    public boolean isFixedBytesPerChar() {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 1;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        return UtilByteArray.duplicate(this.encode(string, this.rl), string.length());
    }

    private void _encode(char[] cArray, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            byArray[i] = (c & 0xFF00) == 0 ? this.toServerArray[c] : this.mapUnicodeChar(c);
        }
    }

    private void _encode(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.toServerArray[byArray[i] & 0xFF];
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        this.setCacheSize(n);
        string.getChars(0, n, this.charsCache, 0);
        this._encode(this.charsCache, this.bytesCache, n);
        nArray[0] = n;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                this._encode(this.bytesCache, n3);
                outputStream.write(this.bytesCache, 0, n3);
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                this._encode(this.charsCache, this.bytesCache, n3);
                outputStream.write(this.bytesCache, 0, n3);
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private void _decode(byte[] byArray, char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n2; i >= 10; i -= 10) {
            cArray[n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            ++n3;
        }
        while (n3 < n2) {
            cArray[n3 + n] = this.toClientArray[byArray[n3] & 0xFF];
            ++n3;
        }
    }

    private void _decode(byte[] byArray, int n, char[] cArray, int n2) {
        int n3 = 0;
        for (int i = n2; i >= 10; i -= 10) {
            cArray[n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            ++n3;
        }
        while (n3 < n2) {
            cArray[n3] = this.toClientArray[byArray[n3 + n] & 0xFF];
            ++n3;
        }
    }

    private void _decode(byte[] byArray, char[] cArray, int n) {
        int n2 = 0;
        for (int i = n; i >= 10; i -= 10) {
            cArray[n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            cArray[++n2] = this.toClientArray[byArray[n2] & 0xFF];
            ++n2;
        }
        while (n2 < n) {
            cArray[n2] = this.toClientArray[byArray[n2] & 0xFF];
            ++n2;
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        this.setCacheSize(n2);
        if (n == 0) {
            this._decode(byArray, this.charsCache, n2);
        } else {
            this._decode(byArray, n, this.charsCache, n2);
        }
        return new String(this.charsCache, 0, n2);
    }

    public int decode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        int n4 = 32;
        for (int i = n2; i > 0; --i) {
            n4 = this.toClientArray[byArray[n++] & 0xFF];
            byArray2[n3++] = (byte)(n4 >> 8);
            byArray2[n3++] = (byte)(n4 & 0xFF);
        }
        return n2 * 2;
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        if (n == 0) {
            this._decode(byArray, cArray, n2);
        } else {
            this._decode(byArray, n, cArray, n2);
        }
        return n2;
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        int n4 = Math.max(n2, n3);
        this.setCacheSize(n4);
        if (n == 0) {
            this._decode(byArray, this.charsCache, n2);
        } else {
            this._decode(byArray, n, this.charsCache, n2);
        }
        for (int i = n2; i < n3; ++i) {
            this.charsCache[i] = 32;
        }
        return new String(this.charsCache, 0, n3);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorUsingTable.this._in;
            }

            public int read() throws IOException {
                int n = this.in.read();
                if (n == -1) {
                    return -1;
                }
                return UtilTransliteratorUsingTable.this.toClientArray[n & 0xFF];
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                if (this.cache == null || this.cache.length < n2) {
                    this.cache = new byte[n2];
                }
                if ((n3 = this.in.read(this.cache, 0, n2)) <= 0) {
                    return n3;
                }
                UtilTransliteratorUsingTable.this._decode(this.cache, cArray, n, n3);
                return n3;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }

    private class ConversionTable {
        byte[] toServerArray;
        char[] toClientArray;
        byte[] unicodeBytes;
        char[] unicodeChars;
        int unicodeCount;
        byte encodedUndefinedCharacter;

        private ConversionTable() {
        }
    }
}

