/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import macromedia.slutil.UtilByteArray;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class UtilTransliteratorForUCS2
extends UtilTransliterator {
    private boolean isBigEndian;
    private byte[] temp;
    private int[] rl;
    private InputStream _in;

    public UtilTransliteratorForUCS2() {
        this.setDefaultCacheSize();
        this.isBigEndian = true;
    }

    public boolean isFixedBytesPerChar() {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public void setToBigEndian() {
        this.isBigEndian = true;
    }

    public void setToLittleEndian() {
        this.isBigEndian = false;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        return UtilByteArray.duplicate(this.encode(string, this.rl), string.length() * 2);
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        this.setCacheSize(n);
        string.getChars(0, n, this.charsCache, 0);
        if (this.isBigEndian) {
            for (int i = 0; i < n; ++i) {
                char c = this.charsCache[i];
                this.bytesCache[i * 2] = (byte)(c >>> 8);
                this.bytesCache[i * 2 + 1] = (byte)c;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                char c = this.charsCache[i];
                this.bytesCache[i * 2] = (byte)c;
                this.bytesCache[i * 2 + 1] = (byte)(c >>> 8);
            }
        }
        nArray[0] = n * 2;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            if (this.temp == null) {
                this.temp = new byte[this.streamChunkSize];
            }
            while (n > 0) {
                int n2;
                int n3 = Math.min(n, this.streamChunkSize);
                int n4 = inputStream.read(this.temp, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                if (this.isBigEndian) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.bytesCache[n2 * 2] = 0;
                        this.bytesCache[n2 * 2 + 1] = this.temp[n2];
                    }
                } else {
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.bytesCache[n2 * 2] = this.temp[n2];
                        this.bytesCache[n2 * 2 + 1] = 0;
                    }
                }
                outputStream.write(this.bytesCache, 0, n4 * 2);
                n -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n > 0) {
                char c;
                int n2;
                int n3 = Math.min(n, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                if (this.isBigEndian) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        c = this.charsCache[n2];
                        this.bytesCache[n2 * 2] = (byte)(c >>> 8);
                        this.bytesCache[n2 * 2 + 1] = (byte)c;
                    }
                } else {
                    for (n2 = 0; n2 < n4; ++n2) {
                        c = this.charsCache[n2];
                        this.bytesCache[n2 * 2] = (byte)c;
                        this.bytesCache[n2 * 2 + 1] = (byte)(c >>> 8);
                    }
                }
                outputStream.write(this.bytesCache, 0, n4 * 2);
                n -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private void _decode(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        if (this.isBigEndian) {
            for (n4 = 0; n4 < n3; ++n4) {
                cArray[n4 + n2] = (char)((byArray[n5 + n] & 0xFF) << 8 | byArray[n5 + 1 + n] & 0xFF);
                n5 += 2;
            }
        } else {
            while (n4 < n3) {
                cArray[n4 + n2] = (char)((byArray[n5 + 1 + n] & 0xFF) << 8 | byArray[n5 + n] & 0xFF);
                n5 += 2;
                ++n4;
            }
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        int n3 = n2 / 2;
        this.setCacheSize(n3);
        this._decode(byArray, n, this.charsCache, 0, n3);
        return new String(this.charsCache, 0, n3);
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 / 2;
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        this._decode(byArray, n, cArray, 0, n3);
        return n3;
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        int n4 = n2 / 2;
        int n5 = Math.max(n4, n3);
        this.setCacheSize(n5);
        this._decode(byArray, n, this.charsCache, 0, n4);
        for (int i = n4; i < n3; ++i) {
            this.charsCache[i] = 32;
        }
        return new String(this.charsCache, 0, n3);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorForUCS2.this._in;
            }

            public int read() throws IOException {
                int n = this.in.read();
                int n2 = this.in.read();
                if (n == -1 || n2 == -1) {
                    return -1;
                }
                if (UtilTransliteratorForUCS2.this.isBigEndian) {
                    return (char)((n & 0xFF) << 8 | n2 & 0xFF);
                }
                return (char)((n2 & 0xFF) << 8 | n & 0xFF);
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                int n4 = n2 * 2;
                if (this.cache == null || this.cache.length < n4) {
                    this.cache = new byte[n4];
                }
                if ((n3 = this.in.read(this.cache, 0, n4)) <= 0) {
                    return n3;
                }
                int n5 = n3 / 2;
                UtilTransliteratorForUCS2.this._decode(this.cache, 0, cArray, n, n5);
                return n5;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }
}

