/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import macromedia.sequelink.util.UnSyncVectorEnumerator;

public class UnSyncVector
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public UnSyncVector(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public UnSyncVector(int n) {
        this(n, 0);
    }

    public UnSyncVector() {
        this(10);
    }

    public final void copyInto(Object[] objectArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            objectArray[n] = this.elementData[n];
        }
    }

    public final void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int n) {
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        Object[] objectArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new Object[n2];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public final void setSize(int n) {
        if (n > this.elementCount && n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final Enumeration elements() {
        return new UnSyncVectorEnumerator(this);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public final int lastIndexOf(Object object, int n) {
        for (int i = n; i >= 0; --i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public final void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void insertElementAt(Object object, int n) {
        int n2 = this.elementCount + 1;
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public final void addElement(Object object) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
        this.elementData[this.elementCount++] = object;
    }

    public final boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        try {
            UnSyncVector unSyncVector = (UnSyncVector)super.clone();
            unSyncVector.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, unSyncVector.elementData, 0, this.elementCount);
            return unSyncVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

