/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Random;
import macromedia.sequelink.net.NetOutputStream;
import macromedia.sequelink.ssp.SlXid;
import macromedia.sequelink.ssp.SspOutputStream;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class SspOutputStreamOnDataOutputStream
extends SspOutputStream {
    private DataOutputStream dos;
    private NetOutputStream nos;
    private byte[] byteBuf = new byte[80];
    private UtilTransliterator transliterator;
    private int[] returnedLength = new int[1];
    private int index;
    private boolean newNibble;
    private static byte[] sl = new byte[]{83, 101, 113, 117, 101, 76, 105, 110, 107};
    private static byte[][] s1 = new byte[][]{{45, 57, -81, 70, 51, -68, -99, 29}, {-18, -93, 111, -61, 33, 12, 69, -77}, {90, -25, -27, -61, -34, 117, -114, -3}, {84, -125, 125, 61, 52, 98, 60, -113}, {-19, -83, -83, 69, -39, -70, -38, -37}, {-31, -36, 122, -116, -16, 95, 66, -80}, {25, 65, -14, -36, -121, -80, 26, -72}, {40, 72, -80, -98, 24, 9, 83, -8}, {-49, 26, 93, 86, 11, 63, -85, 82}, {124, 27, 44, 36, 49, 39, 42, 4}, {-59, 110, 91, 67, 72, 14, -89, 39}, {-17, 111, -73, -117, 124, 64, 66, 51}, {107, 54, 22, -16, -30, -124, -24, 121}, {86, 24, -35, 3, -3, -100, -44, -91}, {-9, 39, 122, 111, 59, -57, 11, 68}, {66, -80, -24, 123, 118, 64, -34, 57}, {89, -70, 48, -116, 117, -65, 106, 72}, {8, -117, -27, -94, 107, -11, 25, -114}, {70, 37, -91, -40, 117, 18, 32, 4}, {-71, -61, -99, -25, 31, 65, 0, 2}, {48, 94, 4, -95, -34, 41, 7, -72}, {41, 44, -100, 120, -108, 108, -49, -76}, {75, 30, 54, -9, 17, 41, -68, 97}, {-21, 96, 45, 70, -114, 123, -127, -124}, {-119, -38, -24, -88, 51, -6, -103, -64}, {82, -77, 91, -2, -112, 55, -48, 17}, {-98, -53, -124, 67, 37, 66, -71, 83}, {113, 62, -16, 16, -36, 38, 55, -70}, {-4, -26, 54, 24, -116, 106, -9, 88}, {27, -40, 121, -85, 119, -112, -13, -99}, {-41, -28, -24, 53, -54, -105, -17, -48}, {-29, 23, 63, -66, 33, 122, -4, -103}};

    public void setOutputStream(NetOutputStream netOutputStream) {
        this.nos = netOutputStream;
        this.dos = new DataOutputStream(netOutputStream);
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public int getPosition() throws IOException {
        return this.nos.getPosition();
    }

    public void setPosition(int n) throws IOException {
        this.nos.setPosition(n);
    }

    public void writeSSPInt8(int n) throws IOException {
        this.dos.write((byte)n);
    }

    public void writeSSPInt16(int n) throws IOException {
        this.dos.writeShort((short)n);
    }

    public void writeSSPFullInt32(int n) throws IOException {
        this.dos.writeInt(n);
    }

    public void writeSSPFullInt32(int n, int n2) throws IOException {
        int n3 = this.nos.getPosition();
        this.nos.setPosition(n);
        this.dos.writeInt(n2);
        this.nos.setPosition(n3);
    }

    public void writeSSPUInt32(int n) throws IOException {
        if (n >= 0 && n <= 254) {
            this.dos.write(n);
            return;
        }
        this.dos.write(255);
        this.dos.writeInt(n);
    }

    public void writeSSPInt32(int n) throws IOException {
        if (n >= -127 && n < 127) {
            this.dos.write(n);
            return;
        }
        this.dos.write(128);
        this.dos.writeInt(n);
    }

    public void writeSSPIndicator(int n) throws IOException {
        this.writeSSPInt32(n);
    }

    public void writeSSPEnum(int n) throws IOException {
        this.writeSSPInt32(n);
    }

    public void writeSSPErr(int n) throws IOException {
        this.writeSSPFullInt32(n);
    }

    public void writeSSPRefNum(int n) throws IOException {
        this.writeSSPUInt32(n);
    }

    public void writeSSPString(String string) throws IOException, UtilException {
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeSSPUInt32(n);
        this.dos.write(byArray, 0, n);
    }

    public void writeSSPCipherString(String string) throws IOException, UtilException {
        byte[] byArray = this.transliterator.encode(string);
        byArray = SspOutputStreamOnDataOutputStream.m11(byArray, Math.min(79, byArray.length), 100);
        this.writeSSPUInt32(101);
        this.dos.write(0);
        this.dos.write(byArray);
    }

    private String getValueString(int n, String string, int n2) {
        StringBuffer stringBuffer;
        int n3 = string.length() - n2;
        if (n3 == 0) {
            return (n < 0 ? "-0." : "0.") + string;
        }
        if (n3 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n3, '.');
            if (n < 0) {
                stringBuffer.insert(0, '-');
            }
        } else {
            stringBuffer = new StringBuffer(3 - n3 + string.length());
            stringBuffer.append(n < 0 ? "-0." : "0.");
            for (int i = 0; i < -n3; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void writeSSPBcdType(BigDecimal bigDecimal) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        this.newNibble = true;
        if (bigDecimal.signum() == -1) {
            n = 13;
            bigDecimal = bigDecimal.negate();
        } else {
            n = 12;
        }
        String string = this.getValueString(bigDecimal.signum(), bigDecimal.unscaledValue().abs().toString(), bigDecimal.scale());
        int n4 = string.length();
        int n5 = n4 - 1;
        char c = string.charAt(n5);
        while (n5 > 0 && (c == '0' || c == '.')) {
            if (c == '.') {
                n4 = n5;
            }
            c = string.charAt(--n5);
        }
        int n6 = 0;
        c = string.charAt(n6);
        while (n6 < n5 && (c == '0' || c == '.')) {
            if (c == '.') {
                n2 = n5 - n6;
                bl = true;
            }
            c = string.charAt(++n6);
        }
        int n7 = (n5 - n6 + 1) / 2 + 3;
        if (this.byteBuf.length < n7) {
            this.byteBuf = new byte[n7];
        }
        this.index = n7;
        this.encodeNibble((byte)n);
        for (int i = n5; i >= n6; --i) {
            c = string.charAt(i);
            if (c == '.') {
                n2 = n5 - i;
                bl = true;
                continue;
            }
            this.encodeNibble((byte)(c - 48));
            ++n3;
        }
        if (!bl) {
            n2 -= n4 - (n5 + 1);
        } else if (n5 == n6 && string.charAt(n5) == '.') {
            ++n3;
        }
        this.encodeByte((byte)n2);
        this.encodeByte((byte)n3);
        this.dos.write(this.byteBuf, this.index, n7 - this.index);
    }

    private void encodeNibble(byte by) {
        if (this.newNibble) {
            --this.index;
            this.byteBuf[this.index] = by;
        } else {
            this.byteBuf[this.index] = (byte)(this.byteBuf[this.index] | by << 4);
        }
        this.newNibble = !this.newNibble;
    }

    private void encodeByte(byte by) {
        --this.index;
        this.byteBuf[this.index] = by;
    }

    public void writeSSPBinaryType(byte[] byArray) throws IOException {
        this.dos.writeInt(byArray.length);
        this.dos.write(byArray);
    }

    public void writeSSPFloatType(double d) throws IOException {
        this.dos.writeDouble(d);
    }

    public void writeSSPRealType(float f) throws IOException {
        this.dos.writeFloat(f);
    }

    public void writeXid(SlXid slXid) throws IOException {
        this.writeSSPFullInt32(slXid.getFormatId());
        byte[] byArray = slXid.getGlobalTransactionId();
        byte[] byArray2 = slXid.getBranchQualifier();
        this.writeSSPInt32(byArray.length);
        this.writeSSPInt32(byArray2.length);
        this.dos.write(byArray);
        this.dos.write(byArray2);
    }

    public void writeSequeLink() throws IOException {
        this.dos.write(sl);
    }

    public void writeSSPASCIIString(String string) throws IOException {
        int n = string.length();
        this.writeSSPFullInt32(n);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        this.dos.write(byArray);
    }

    private static byte[] m11(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = new byte[8];
        Random random = new Random();
        int n4 = random.nextInt() & 0xFF;
        System.arraycopy(s1[n4 >>> 3], 0, byArray2, 0, 8);
        byte[] byArray3 = new byte[n2];
        byArray3[0] = (byte)n4;
        byArray3[1] = (byte)n;
        System.arraycopy(byArray, 0, byArray3, 2, n);
        for (n3 = n + 2; n3 < n2; ++n3) {
            byArray3[n3] = (byte)(random.nextInt() & 0xFF);
        }
        n3 = n4 % 8;
        for (int i = 1; i < n2; ++i) {
            byArray3[i] = (byte)(byArray3[i] ^ byArray2[n3] ^ byArray2[0] * n3);
            int n5 = n3;
            byArray2[n5] = (byte)(byArray2[n5] + (n3 < 7 ? byArray2[n3 + 1] : byArray2[0]));
            if (byArray2[n3] == 0) {
                byArray2[n3] = 1;
            }
            if (++n3 < 8) continue;
            n3 = 0;
        }
        return byArray3;
    }

    public void writeSSPLongVarBinary(byte[] byArray, int n, int n2) throws IOException {
        this.writeSSPFullInt32(n2);
        this.dos.write(byArray, n, n2);
    }

    public void writeSSPLongVarChar(byte[] byArray, int n, int n2) throws IOException {
        this.writeSSPUInt32(n2);
        this.dos.write(byArray, n, n2);
    }
}

