/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ctxt.stmt;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import macromedia.sequelink.ctxt.Context;
import macromedia.sequelink.ctxt.conn.ConnectionContext;
import macromedia.sequelink.describe.VariableDescriptor;
import macromedia.sequelink.ssp.CodecAssociate;
import macromedia.sequelink.ssp.CodecChainedPacket;
import macromedia.sequelink.ssp.CodecExec;
import macromedia.sequelink.ssp.CodecExecArray;
import macromedia.sequelink.ssp.CodecExecDirect;
import macromedia.sequelink.ssp.CodecExecRsn;
import macromedia.sequelink.ssp.CodecExtendedDefine;
import macromedia.sequelink.ssp.CodecFetch;
import macromedia.sequelink.ssp.CodecFreeVariables;
import macromedia.sequelink.ssp.CodecGetDescribe;
import macromedia.sequelink.ssp.CodecNextResult;
import macromedia.sequelink.ssp.CodecOpen;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.IntegerSetSetting;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SetSetting;
import macromedia.sequelink.util.UnSyncVector;
import macromedia.sequelink.variables.CursorVariables;
import macromedia.slutil.UtilPagedTempBuffer;
import macromedia.slutil.UtilTempBuffer;

public final class StatementContext
extends Context {
    private ConnectionContext conCtxt;
    private VariableDescriptor[][] cursorDescriptors;
    private VariableDescriptor[][] paramDescriptors;
    private boolean _supportsDescribeParam;
    private boolean _deferDescribeParam;
    private int rowCount;
    private int resultAvailable;
    private int fetchFlag;
    private CodecOpen codecOpen;
    private byte[] xferBuf;
    private UtilPagedTempBuffer tempBuffer;
    private CodecFetch _preFetch;

    public StatementContext(ConnectionContext connectionContext) {
        this.type = 3;
        this.conCtxt = connectionContext;
        this.ssp = connectionContext.getSsp();
        this.chain = this.ssp.getChain();
        this.codecOpen = this.ssp.getCodecOpen(connectionContext.getSesRef(), this);
        this.chain.add(this.codecOpen);
        this._supportsDescribeParam = connectionContext.supportsDescribeParam();
        this._deferDescribeParam = connectionContext.deferDescribeParam();
    }

    public boolean supportsDescribeParam() {
        return this._supportsDescribeParam;
    }

    public boolean deferDescribeParam() {
        return this._deferDescribeParam;
    }

    public void update() {
        if (this.codecOpen != null) {
            if (this.codecOpen.isOpenAtServer()) {
                this.isActive = true;
            }
            this.codecOpen = null;
        }
    }

    public Object getNetMutex() {
        return this.conCtxt.getNetMutex();
    }

    public void deactivate(DiagnosticList diagnosticList) throws SQLException {
        if (!this.isActive) {
            return;
        }
        CodecChainedPacket codecChainedPacket = this.ssp.getCodecClose(this);
        this.chain.removeAllCodecs();
        this.chain.add(codecChainedPacket);
        this.chain.send(diagnosticList);
        this.isActive = false;
    }

    public void associate(String string, boolean bl, DiagnosticList diagnosticList) throws SQLException {
        boolean bl2;
        this.cursorDescriptors = null;
        this.paramDescriptors = null;
        CodecAssociate codecAssociate = this.ssp.getCodecAssociate(string, this);
        this.chain.add(codecAssociate);
        CodecGetDescribe codecGetDescribe = null;
        boolean bl3 = bl2 = bl && this._supportsDescribeParam && !this._deferDescribeParam;
        if (bl2) {
            codecGetDescribe = this.ssp.getCodecGetDescribeParam(this.conCtxt.getParamDescribe(), this);
            this.chain.add(codecGetDescribe);
        }
        try {
            this.chain.send(diagnosticList);
        }
        catch (SQLException sQLException) {
            if (!codecAssociate.isSuccessfullyProcessed()) {
                throw sQLException;
            }
            bl2 = false;
        }
        if (bl2) {
            this.paramDescriptors = codecGetDescribe.getDescribe();
        }
    }

    public void execute(boolean bl, UnSyncVector unSyncVector, UnSyncVector unSyncVector2, DiagnosticList diagnosticList) throws SQLException {
        CodecExec codecExec = this.ssp.getCodecExec(this, unSyncVector, unSyncVector2);
        this.chain.add(codecExec);
        CodecGetDescribe codecGetDescribe = null;
        if (bl) {
            codecGetDescribe = this.ssp.getCodecGetDescribeCursor(this.conCtxt.getCursorDescribe(), this);
            this.chain.add(codecGetDescribe);
        }
        this.chain.send(diagnosticList);
        this.resultAvailable = codecExec.getResultAvailable();
        this.rowCount = codecExec.getRowCount();
        if (bl) {
            this.cursorDescriptors = codecGetDescribe.getDescribe();
        }
    }

    public void execDirect(String string, boolean bl, UnSyncVector unSyncVector, UnSyncVector unSyncVector2, DiagnosticList diagnosticList) throws SQLException {
        this.cursorDescriptors = null;
        CodecExecDirect codecExecDirect = this.ssp.getCodecExecDirect(string, this, unSyncVector, unSyncVector2);
        this.chain.add(codecExecDirect);
        CodecGetDescribe codecGetDescribe = null;
        if (bl) {
            codecGetDescribe = this.ssp.getCodecGetDescribeCursor(this.conCtxt.getCursorDescribe(), this);
            this.chain.add(codecGetDescribe);
        }
        this.chain.send(diagnosticList);
        this.resultAvailable = codecExecDirect.getResultAvailable();
        this.rowCount = codecExecDirect.getRowCount();
        if (bl) {
            this.cursorDescriptors = codecGetDescribe.getDescribe();
        }
    }

    public void prepareAndExecute(String string, boolean bl, boolean bl2, UnSyncVector unSyncVector, UnSyncVector unSyncVector2, DiagnosticList diagnosticList) throws SQLException {
        boolean bl3;
        this.cursorDescriptors = null;
        this.paramDescriptors = null;
        CodecAssociate codecAssociate = this.ssp.getCodecAssociate(string, this);
        this.chain.add(codecAssociate);
        CodecGetDescribe codecGetDescribe = null;
        boolean bl4 = bl3 = bl2 && this._supportsDescribeParam && !this._deferDescribeParam;
        if (bl3) {
            codecGetDescribe = this.ssp.getCodecGetDescribeParam(this.conCtxt.getParamDescribe(), this);
            this.chain.add(codecGetDescribe);
        }
        CodecExec codecExec = this.ssp.getCodecExec(this, unSyncVector, unSyncVector2);
        this.chain.add(codecExec);
        CodecGetDescribe codecGetDescribe2 = null;
        if (bl) {
            codecGetDescribe2 = this.ssp.getCodecGetDescribeCursor(this.conCtxt.getCursorDescribe(), this);
            this.chain.add(codecGetDescribe2);
        }
        try {
            this.chain.send(diagnosticList);
        }
        catch (SQLException sQLException) {
            if (!codecAssociate.isSuccessfullyProcessed()) {
                throw sQLException;
            }
            if (!codecExec.isSuccessfullyProcessed()) {
                throw sQLException;
            }
            bl3 = false;
        }
        if (bl3) {
            this.paramDescriptors = codecGetDescribe.getDescribe();
        }
        this.resultAvailable = codecExec.getResultAvailable();
        this.rowCount = codecExec.getRowCount();
        if (bl) {
            this.cursorDescriptors = codecGetDescribe2.getDescribe();
        }
    }

    public int[] executeBatch(int n, UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws BatchUpdateException {
        int[] nArray;
        Object object;
        SQLException sQLException = null;
        this.cursorDescriptors = null;
        UnSyncVector unSyncVector2 = new UnSyncVector();
        if (this.ssp.getSspVersion() >= 8) {
            object = this.ssp.getCodecExecArray(this, n, unSyncVector, unSyncVector2);
            this.chain.add((CodecChainedPacket)object);
            try {
                this.chain.send(diagnosticList);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            nArray = ((CodecExecArray)object).getUpdateCounts();
            this.rowCount = ((CodecExecArray)object).getConsolidatedUpdateCount();
        } else {
            int n2;
            object = new CodecExec[n];
            for (int i = 0; i < n; ++i) {
                object[i] = this.ssp.getCodecExec(this, unSyncVector, unSyncVector2);
                this.chain.add((CodecChainedPacket)object[i]);
            }
            try {
                this.chain.send(diagnosticList);
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
            }
            int n3 = 0;
            for (n2 = 0; n2 < n && ((CodecExec)object[n2]).isSuccessfullyProcessed(); ++n2) {
                ++n3;
            }
            this.rowCount = 0;
            n2 = 0;
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                int n4;
                nArray[i] = n4 = ((CodecExec)object[i]).getRowCount();
                this.rowCount += n4;
                if (((CodecExec)object[i]).getResultAvailable() != 1) continue;
                n2 = 1;
            }
            if (n2 != 0) {
                sQLException = Message.Gen.getSqlException(7425);
            }
        }
        if (sQLException != null) {
            object = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
            ((SQLException)object).setNextException(sQLException.getNextException());
            throw object;
        }
        return nArray;
    }

    public VariableDescriptor[][] getDescribeCursor(DiagnosticList diagnosticList) throws SQLException {
        if (this.cursorDescriptors == null) {
            CodecGetDescribe codecGetDescribe = this.ssp.getCodecGetDescribeCursor(this.conCtxt.getCursorDescribe(), this);
            this.chain.add(codecGetDescribe);
            this.chain.send(diagnosticList);
            this.cursorDescriptors = codecGetDescribe.getDescribe();
        }
        return this.cursorDescriptors;
    }

    public boolean hasDescribeCursor() throws SQLException {
        return this.cursorDescriptors != null;
    }

    public boolean hasDescribeParam() throws SQLException {
        return this.paramDescriptors != null;
    }

    public VariableDescriptor[][] getDescribeParam(DiagnosticList diagnosticList) throws SQLException {
        if (this.paramDescriptors == null) {
            if (!this._supportsDescribeParam) {
                throw Message.Gen.getSqlException(7391, "getParameterMetaData()");
            }
            CodecGetDescribe codecGetDescribe = this.ssp.getCodecGetDescribeParam(this.conCtxt.getParamDescribe(), this);
            this.chain.add(codecGetDescribe);
            this.chain.send(diagnosticList);
            this.paramDescriptors = codecGetDescribe.getDescribe();
        }
        return this.paramDescriptors;
    }

    public void extendedDefine(UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws SQLException {
        CodecExtendedDefine codecExtendedDefine = this.ssp.getCodecExtendedDefine(unSyncVector, this);
        this.chain.add(codecExtendedDefine);
    }

    public void fetch(int n, CursorVariables cursorVariables, UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws SQLException {
        CodecFetch codecFetch = this.ssp.getCodecFetch(n, cursorVariables, unSyncVector, this);
        this.chain.add(codecFetch);
        this.chain.send(diagnosticList);
        this.rowCount = codecFetch.getRowCount();
        this.fetchFlag = codecFetch.getFetchFlag();
    }

    public void preFetch(int n, CursorVariables cursorVariables, UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws SQLException {
        this._preFetch = this.ssp.getCodecFetch(n, cursorVariables, unSyncVector, this);
        this.chain.add(this._preFetch);
        this.chain.encodeAndSend(diagnosticList);
    }

    public void postFetch(DiagnosticList diagnosticList) throws SQLException {
        this.chain.receiveAndDecode(diagnosticList);
        this.rowCount = this._preFetch.getRowCount();
        this.fetchFlag = this._preFetch.getFetchFlag();
        this._preFetch = null;
    }

    public void discardFetch(DiagnosticList diagnosticList) throws SQLException {
        this.chain.discardPending();
        this._preFetch = null;
    }

    public void execRsn(int n, UnSyncVector unSyncVector, UnSyncVector unSyncVector2, DiagnosticList diagnosticList) throws SQLException {
        if (n != 999) {
            CodecExecRsn codecExecRsn = this.ssp.getCodecExecRsn(this, n, unSyncVector, unSyncVector2);
            this.chain.add(codecExecRsn);
            this.chain.send(diagnosticList);
        }
        this.resultAvailable = 1;
        this.rowCount = -1;
    }

    public void freeVariables(int n, DiagnosticList diagnosticList) throws SQLException {
        CodecFreeVariables codecFreeVariables = this.ssp.getCodecFreeVariables(n, this);
        this.chain.add(codecFreeVariables);
    }

    public void nextResult(UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws SQLException {
        this.cursorDescriptors = null;
        CodecNextResult codecNextResult = this.ssp.getCodecNextResult(this, unSyncVector);
        this.chain.add(codecNextResult);
        CodecGetDescribe codecGetDescribe = this.ssp.getCodecGetDescribeCursor(this.conCtxt.getCursorDescribe(), this);
        this.chain.add(codecGetDescribe);
        this.chain.send(diagnosticList);
        this.resultAvailable = codecNextResult.getResultAvailable();
        this.rowCount = codecNextResult.getRowCount();
        this.cursorDescriptors = codecGetDescribe.getDescribe();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getResultType() {
        return this.resultAvailable;
    }

    public int getFetchFlag() {
        return this.fetchFlag;
    }

    public void setRowCount(int n) {
        this.rowCount = n;
    }

    public void setResultType(int n) {
        this.resultAvailable = n;
    }

    public void cancel() throws SQLException {
        this.ssp.cancel();
    }

    public void setQueryTimeout(int n, DiagnosticList diagnosticList) throws SQLException {
        IntegerSetSetting integerSetSetting = new IntegerSetSetting(10001, n);
        SetSetting[] setSettingArray = new SetSetting[]{integerSetSetting};
        CodecChainedPacket codecChainedPacket = this.getSsp().getCodecSetSettings(setSettingArray, this);
        this.add(codecChainedPacket);
        this.send(diagnosticList);
    }

    void preCancel() throws SQLException {
    }

    void postCancel() throws SQLException {
    }

    void add(CodecChainedPacket codecChainedPacket) {
        this.chain.add(codecChainedPacket);
    }

    void send(DiagnosticList diagnosticList) throws SQLException {
        this.chain.send(diagnosticList);
    }

    public byte[] getXferBuffer() {
        if (this.xferBuf == null) {
            this.xferBuf = new byte[512];
        }
        return this.xferBuf;
    }

    public UtilTempBuffer getTempBuffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new UtilPagedTempBuffer();
        }
        return this.tempBuffer;
    }

    public int getLobLocatorSize() throws SQLException {
        return this.conCtxt.getPidList().getPidInt(11406, DiagnosticList.GetADummyList());
    }
}

