/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.auth;

import macromedia.sequelink.auth.EmptyCredential;
import macromedia.sequelink.auth.KerberosContext;
import macromedia.sequelink.auth.MGSSContext;
import macromedia.sequelink.auth.MGSSCredential;
import macromedia.sequelink.auth.MGSSException;
import macromedia.sequelink.auth.MGSSProvider;
import macromedia.slutil.UtilException;

public class KerberosProvider
implements MGSSProvider {
    private String principalName;
    private static final String KERBEROS = "Kerberos";

    public MGSSCredential acquireCredential(StringBuffer stringBuffer, String string, int n) throws MGSSException {
        return new EmptyCredential();
    }

    public MGSSContext getSecContext(String string, int n) throws MGSSException {
        if (!KERBEROS.equalsIgnoreCase(string)) {
            throw new MGSSException(1);
        }
        try {
            return new KerberosContext(this.principalName);
        }
        catch (UtilException utilException) {
            throw new MGSSException(13);
        }
    }

    public String[] getMechs() throws MGSSException {
        return new String[]{KERBEROS};
    }

    public boolean isMechSupported(String string) throws MGSSException {
        return KERBEROS.equalsIgnoreCase(string);
    }

    public boolean isMechSupported(String[] stringArray) throws MGSSException {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!KERBEROS.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

