/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.util.HashMap;
import macromedia.jdbc.slbase.BaseColumn;
import macromedia.jdbc.slbase.BaseData;

public class BaseColumns {
    static final int INITIAL_SIZE = 16;
    private BaseColumn[] columns = new BaseColumn[16];
    private int nextEmptyPosition = 0;
    public static final int COUNT_ALL = 0;
    public static final int COUNT_EXPOSED = 1;
    public static final int COUNT_HIDDEN = 2;
    public static final int COUNT_KEY = 3;
    public static final int COUNT_AUTOINCREMENT = 4;
    private boolean countsValid = false;
    private int hiddenCount;
    private int exposedCount;
    private int allCount;
    private int keyCount;
    private int autoincrementCount;
    private HashMap columnLabelMap;
    private HashMap columnNameMap;

    public void add(BaseColumn baseColumn) {
        if (this.nextEmptyPosition == this.columns.length - 1) {
            BaseColumn[] baseColumnArray = this.columns;
            this.columns = new BaseColumn[this.columns.length * 2];
            System.arraycopy(baseColumnArray, 0, this.columns, 0, baseColumnArray.length);
        }
        this.columns[this.nextEmptyPosition++] = baseColumn;
        this.countsValid = false;
    }

    public int count(int n) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        switch (n) {
            case 0: {
                return this.allCount;
            }
            case 1: {
                return this.exposedCount;
            }
            case 2: {
                return this.hiddenCount;
            }
            case 3: {
                return this.keyCount;
            }
            case 4: {
                return this.autoincrementCount;
            }
        }
        return 0;
    }

    private void calculateCounts() {
        this.allCount = this.nextEmptyPosition;
        this.hiddenCount = 0;
        this.exposedCount = 0;
        this.keyCount = 0;
        this.autoincrementCount = 0;
        for (int i = 0; i < this.allCount; ++i) {
            BaseColumn baseColumn = this.columns[i];
            if (baseColumn.isHidden) {
                ++this.hiddenCount;
            } else {
                ++this.exposedCount;
            }
            if (baseColumn.isKey) {
                ++this.keyCount;
            }
            if (!baseColumn.isAutoIncrement || baseColumn.isHidden) continue;
            ++this.autoincrementCount;
        }
        this.countsValid = true;
    }

    public BaseColumn get(int n) {
        BaseColumn baseColumn = this.columns[n - 1];
        return baseColumn;
    }

    public boolean isValidColumnOrdinal(int n) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        return n > 0 && n <= this.exposedCount;
    }

    public int getOrdinal(String string) {
        int n = this.nextEmptyPosition;
        if (this.columnLabelMap == null) {
            this.columnLabelMap = new HashMap(n);
        } else {
            Object v = this.columnLabelMap.get(string);
            if (v != null) {
                return (Integer)v;
            }
        }
        for (int i = 0; i < n; ++i) {
            if (!this.columns[i].label.equalsIgnoreCase(string)) continue;
            this.columnLabelMap.put(string, new Integer(i + 1));
            return i + 1;
        }
        if (this.columnNameMap == null) {
            this.columnNameMap = new HashMap(n);
        } else {
            Object v = this.columnNameMap.get(string);
            if (v != null) {
                return (Integer)v;
            }
        }
        for (int i = 0; i < n; ++i) {
            if (!this.columns[i].name.equalsIgnoreCase(string)) continue;
            this.columnNameMap.put(string, new Integer(i + 1));
            return i + 1;
        }
        return 0;
    }

    public void reset() {
        if (this.columns != null) {
            this.nextEmptyPosition = 0;
        }
        this.countsValid = false;
    }

    public void resetCount() {
        this.countsValid = false;
    }

    public void markColumnsAsKeyStartingAt(int n, boolean bl) {
        this.allCount = this.nextEmptyPosition;
        for (int i = n - 1; i < this.allCount; ++i) {
            BaseColumn baseColumn = this.columns[i];
            if (!(baseColumn.isSearchable != 4 && baseColumn.isSearchable != 3 || baseColumn.isHidden || BaseData.isStreamed(baseColumn.baseDataType))) {
                baseColumn.isKey = true;
            }
            if (!bl) continue;
            baseColumn.isHidden = true;
        }
        this.countsValid = false;
    }
}

