/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.parameters;

import macromedia.jdbc.sequelink.parameters.SequeLinkParameter;
import macromedia.sequelink.util.UnSyncVector;

public class SequeLinkParameters {
    private boolean containsLongParameters;
    private boolean containsNormalParameters;
    private UnSyncVector parameters = new UnSyncVector();
    private UnSyncVector inputParams;
    private UnSyncVector longInputParams;
    private UnSyncVector normalInputParams;
    private UnSyncVector normalOutputParams;
    private UnSyncVector normalParams;
    private UnSyncVector outputParams;

    public void add(SequeLinkParameter sequeLinkParameter) {
        if (sequeLinkParameter.isLong()) {
            this.containsLongParameters = true;
        } else {
            this.containsNormalParameters = true;
        }
        this.parameters.addElement(sequeLinkParameter);
    }

    public boolean containsLongParameters() {
        return this.containsLongParameters;
    }

    public boolean containsNormalParameters() {
        return this.containsNormalParameters;
    }

    public UnSyncVector getNormalParams() {
        if (this.normalParams != null) {
            return this.normalParams;
        }
        int n = this.parameters.size();
        this.normalParams = new UnSyncVector();
        for (int i = 0; i < n; ++i) {
            SequeLinkParameter sequeLinkParameter = (SequeLinkParameter)this.parameters.elementAt(i);
            if (sequeLinkParameter.isLong()) continue;
            this.normalParams.addElement(sequeLinkParameter);
        }
        return this.normalParams;
    }

    public UnSyncVector getNormalInputParams() {
        if (this.normalInputParams != null) {
            return this.normalInputParams;
        }
        int n = this.parameters.size();
        this.normalInputParams = new UnSyncVector();
        for (int i = 0; i < n; ++i) {
            SequeLinkParameter sequeLinkParameter = (SequeLinkParameter)this.parameters.elementAt(i);
            if (sequeLinkParameter.isLong() || !sequeLinkParameter.isInput()) continue;
            this.normalInputParams.addElement(sequeLinkParameter);
        }
        return this.normalInputParams;
    }

    public UnSyncVector getNormalOutputParams() {
        if (this.normalOutputParams != null) {
            return this.normalOutputParams;
        }
        int n = this.parameters.size();
        this.normalOutputParams = new UnSyncVector();
        for (int i = 0; i < n; ++i) {
            SequeLinkParameter sequeLinkParameter = (SequeLinkParameter)this.parameters.elementAt(i);
            if (sequeLinkParameter.isLong() || !sequeLinkParameter.isOutput()) continue;
            this.normalOutputParams.addElement(sequeLinkParameter);
        }
        return this.normalOutputParams;
    }

    public UnSyncVector getInputParams() {
        if (this.inputParams != null) {
            return this.inputParams;
        }
        int n = this.parameters.size();
        this.inputParams = new UnSyncVector();
        for (int i = 0; i < n; ++i) {
            SequeLinkParameter sequeLinkParameter = (SequeLinkParameter)this.parameters.elementAt(i);
            if (!sequeLinkParameter.isInput()) continue;
            this.inputParams.addElement(sequeLinkParameter);
        }
        return this.inputParams;
    }

    public UnSyncVector getOutputParams() {
        if (this.outputParams != null) {
            return this.outputParams;
        }
        int n = this.parameters.size();
        this.outputParams = new UnSyncVector();
        for (int i = 0; i < n; ++i) {
            SequeLinkParameter sequeLinkParameter = (SequeLinkParameter)this.parameters.elementAt(i);
            if (!sequeLinkParameter.isOutput()) continue;
            this.outputParams.addElement(sequeLinkParameter);
        }
        return this.outputParams;
    }

    public UnSyncVector getLongInputParams() {
        if (this.longInputParams != null) {
            return this.longInputParams;
        }
        int n = this.parameters.size();
        this.longInputParams = new UnSyncVector();
        for (int i = 0; i < n; ++i) {
            SequeLinkParameter sequeLinkParameter = (SequeLinkParameter)this.parameters.elementAt(i);
            if (!sequeLinkParameter.isLong() || !sequeLinkParameter.isInput()) continue;
            this.longInputParams.addElement(sequeLinkParameter);
        }
        return this.longInputParams;
    }

    public SequeLinkParameter atPosition(int n) {
        return (SequeLinkParameter)this.parameters.elementAt(n - 1);
    }
}

