/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.parameters.SequeLinkStreamParameter;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BaseParameter;
import macromedia.sequelink.ctxt.stmt.SequeLinkOutputStream;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SspOutputStream;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTempBuffer;

public class SequeLinkLongvarcharParameter
extends SequeLinkStreamParameter {
    public SequeLinkLongvarcharParameter(StatementContext statementContext, int n, int n2, BaseExceptions baseExceptions) throws SQLException {
        super(statementContext, n, -1, 0, n2, baseExceptions);
    }

    protected void setBindInfo() {
        this.sqlnkType = 4;
        this.sqlnkSize = 0;
    }

    public void writeLongData(SspOutputStream sspOutputStream, byte[] byArray, int n, int n2) throws IOException {
        sspOutputStream.writeSSPLongVarChar(byArray, n, n2);
    }

    public void setDataIn(BaseParameter baseParameter) throws SQLException {
        this.bdIn = baseParameter;
        this.bdOut = null;
        if (this.bdIn.getType() == 15) {
            BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)this.bdIn.getASCIIStreamNoConvert();
            this.totalLength = baseInputStreamWrapper != null ? (int)baseInputStreamWrapper.determineLength() : 0;
        } else {
            BaseCharacterStreamWrapper baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)this.bdIn.getCharacterStreamReader(-1, null, this.exceptions);
            this.totalLength = baseCharacterStreamWrapper != null ? (int)baseCharacterStreamWrapper.determineLength() : 0;
            this.bdIn.setCharacterStreamReader(baseCharacterStreamWrapper);
        }
    }

    public void xfer(DiagnosticList diagnosticList) throws SQLException {
        try {
            if (this.bdIn.isNull()) {
                this.writeAsciiStream(null, diagnosticList);
                return;
            }
            switch (this.bdIn.getType()) {
                case 15: {
                    this.writeAsciiStream(this.bdIn.getASCIIStreamNoConvert(), diagnosticList);
                    break;
                }
                case 18: {
                    this.writeCharacterStream(this.bdIn.getCharacterStreamReaderNoConvert(), diagnosticList);
                    break;
                }
                default: {
                    throw new InternalError(this.getClass().getName() + " xfer 2 " + this.bdIn.getType());
                }
            }
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
    }

    private void writeAsciiStream(InputStream inputStream, DiagnosticList diagnosticList) throws SQLException, UtilException {
        try {
            if (!this.ut.isFixedBytesPerChar()) {
                SequeLinkOutputStream sequeLinkOutputStream = new SequeLinkOutputStream(this, diagnosticList);
                if (this.isNull() || this.totalLength == 0) {
                    return;
                }
                UtilTempBuffer utilTempBuffer = this.stmtCtxt.getTempBuffer();
                this.ut.encode(inputStream, this.totalLength, utilTempBuffer.getOutputStream());
                this.writeStream(utilTempBuffer.getInputStream(), sequeLinkOutputStream, (int)utilTempBuffer.getSize());
                utilTempBuffer.truncate();
                return;
            }
            int n = this.totalLength;
            this.totalLength = n * this.ut.getMaxBytesPerChar();
            SequeLinkOutputStream sequeLinkOutputStream = new SequeLinkOutputStream(this, diagnosticList);
            if (this.isNull() || this.totalLength == 0) {
                return;
            }
            this.ut.encode(inputStream, n, (OutputStream)sequeLinkOutputStream);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString(), "HY000");
        }
    }

    private void writeCharacterStream(Reader reader, DiagnosticList diagnosticList) throws SQLException, UtilException {
        try {
            if (this.isNull() || this.totalLength == 0) {
                SequeLinkOutputStream sequeLinkOutputStream = new SequeLinkOutputStream(this, diagnosticList);
                return;
            }
            if (!this.ut.isFixedBytesPerChar()) {
                UtilTempBuffer utilTempBuffer = this.stmtCtxt.getTempBuffer();
                this.ut.encode(reader, this.totalLength, utilTempBuffer.getOutputStream());
                this.totalLength = (int)utilTempBuffer.getSize();
                SequeLinkOutputStream sequeLinkOutputStream = new SequeLinkOutputStream(this, diagnosticList);
                this.writeStream(utilTempBuffer.getInputStream(), sequeLinkOutputStream, this.totalLength);
                utilTempBuffer.truncate();
                return;
            }
            int n = this.totalLength;
            this.totalLength = n * this.ut.getMaxBytesPerChar();
            SequeLinkOutputStream sequeLinkOutputStream = new SequeLinkOutputStream(this, diagnosticList);
            this.ut.encode(reader, n, (OutputStream)sequeLinkOutputStream);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString(), "HY000");
        }
    }
}

