/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.parameters.SequeLinkStreamParameter;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BaseParameter;
import macromedia.sequelink.ctxt.stmt.SequeLinkOutputStream;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspOutputStream;

public class SequeLinkLongvarbinaryParameter
extends SequeLinkStreamParameter {
    public SequeLinkLongvarbinaryParameter(StatementContext statementContext, int n, int n2, BaseExceptions baseExceptions) throws SQLException {
        super(statementContext, n, -4, 0, n2, baseExceptions);
    }

    protected void setBindInfo() {
        this.sqlnkType = 5;
        this.sqlnkSize = 0;
    }

    public void writeLongData(SspOutputStream sspOutputStream, byte[] byArray, int n, int n2) throws IOException {
        sspOutputStream.writeSSPLongVarBinary(byArray, n, n2);
    }

    public void setDataIn(BaseParameter baseParameter) throws SQLException {
        this.bdIn = baseParameter;
        this.bdOut = null;
        BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)this.bdIn.getBinaryStream(-1, null, this.exceptions);
        this.bdIn.setBinaryStream(baseInputStreamWrapper);
        this.totalLength = baseInputStreamWrapper != null ? (int)baseInputStreamWrapper.determineLength() : 0;
    }

    public void xfer(DiagnosticList diagnosticList) throws SQLException {
        this.writeBinaryStream(this.bdIn.getBinaryStreamNoConvert(), diagnosticList);
    }

    private void writeBinaryStream(InputStream inputStream, DiagnosticList diagnosticList) throws SQLException {
        try {
            SequeLinkOutputStream sequeLinkOutputStream = new SequeLinkOutputStream(this, diagnosticList);
            if (this.isNull() || this.totalLength == 0) {
                return;
            }
            this.writeStream(inputStream, sequeLinkOutputStream, this.totalLength);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString(), "HY000");
        }
    }
}

