/*
 * Decompiled with CFR 0.152.
 */
package ice.net.proxy;

import ice.debug.Debug;
import ice.net.ConnectionRoute;
import ice.net.proxy.Proxy;
import ice.net.proxy.ProxyResolver;
import ice.util.Defs;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProxyManager
implements ProxyResolver {
    private static final String HTTP_PROXY_HOST_KEY = "http.proxyHost";
    private static final String HTTP_PROXY_PORT_KEY = "http.proxyPort";
    private static final int HTTP_PROXY_PORT_DEFAULT = 80;
    private static final String HTTPS_PROXY_HOST_KEY = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT_KEY = "https.proxyPort";
    private static final int HTTPS_PROXY_PORT_DEFAULT = 80;
    private static final String HTTP_NON_PROXY_HOSTS_KEY = "http.nonProxyHosts";
    private static final String HTTP_NON_PROXY_PORTS_KEY = "http.nonProxyPorts";
    private static final String DELIMITER = "|";
    private Vector nonProxyDomainList = new Vector();
    private Vector nonProxyHostList = new Vector();
    private Vector nonProxyPortList = new Vector();
    private boolean useProxies;
    private Hashtable globalProxies = new Hashtable();
    private Hashtable proxyDomains = new Hashtable();

    public ProxyManager() {
        this.readProperties();
    }

    public synchronized void addNonProxyDomainOrHost(String domainOrHost) {
        if (domainOrHost != null) {
            if (domainOrHost.indexOf("*") != -1) {
                this.addNonProxyDomain(domainOrHost);
            } else {
                this.addNonProxyHost(domainOrHost);
            }
        }
    }

    public synchronized void addNonProxyDomain(String nonProxyDomain) {
        String _nonProxyDomain;
        if (nonProxyDomain != null && !this.nonProxyDomainList.contains(_nonProxyDomain = nonProxyDomain.substring(2).toLowerCase())) {
            this.nonProxyDomainList.addElement(_nonProxyDomain);
        }
    }

    public synchronized void addNonProxyHost(String nonProxyHost) {
        String _nonProxyHost;
        if (nonProxyHost != null && !this.nonProxyHostList.contains(_nonProxyHost = nonProxyHost.toLowerCase())) {
            this.nonProxyHostList.addElement(_nonProxyHost);
        }
    }

    public synchronized void addNonProxyPort(int nonProxyPort) {
        Integer _nonProxyPort;
        if (nonProxyPort >= 0 && nonProxyPort <= 65536 && !this.nonProxyPortList.contains(_nonProxyPort = new Integer(nonProxyPort))) {
            this.nonProxyPortList.addElement(_nonProxyPort);
        }
    }

    public synchronized void clearNonProxyDomains() {
        this.nonProxyDomainList.clear();
    }

    public synchronized void clearNonProxyHosts() {
        this.nonProxyHostList.clear();
    }

    public synchronized void clearNonProxyPorts() {
        this.nonProxyPortList.clear();
    }

    public ConnectionRoute findProxyForUrl(URL url) {
        if (url == null) {
            return null;
        }
        return this.getProxy(url.getHost(), url.getPort(), url.getProtocol());
    }

    public String[] getNonProxyDomains() {
        Object[] _nonProxyDomains = new String[this.nonProxyDomainList.size()];
        this.nonProxyDomainList.copyInto(_nonProxyDomains);
        return _nonProxyDomains;
    }

    public String[] getNonProxyHosts() {
        Object[] _nonProxyHosts = new String[this.nonProxyHostList.size()];
        this.nonProxyHostList.copyInto(_nonProxyHosts);
        return _nonProxyHosts;
    }

    public int[] getNonProxyPorts() {
        int[] _nonProxyPorts = new int[this.nonProxyPortList.size()];
        for (int i = 0; i < _nonProxyPorts.length; ++i) {
            _nonProxyPorts[i] = (Integer)this.nonProxyPortList.elementAt(i);
        }
        return _nonProxyPorts;
    }

    public Proxy getProxy(String host, int port) {
        return this.getProxy(host, port, "http");
    }

    public Proxy getProxy(String host, int port, String protocol) {
        int _port = port >= 0 && port <= 65536 ? port : (protocol != null && protocol.equalsIgnoreCase("http") ? 80 : (protocol != null && protocol.equalsIgnoreCase("https") ? 443 : 80));
        if (!this.getProxyUse() || this.isNonProxyHost(host) || this.isNonProxyPort(_port)) {
            return null;
        }
        Proxy _proxy = this.getProxyForDomain(host, protocol);
        if (_proxy == null) {
            _proxy = (Proxy)this.globalProxies.get(protocol);
        }
        return _proxy;
    }

    public boolean isNonProxyHost(String host) {
        if (this.nonProxyHostList.contains(host) || this.nonProxyDomainList.contains(host)) {
            return true;
        }
        StringTokenizer _tokens = new StringTokenizer(host, ".");
        int _tokenCount = _tokens.countTokens();
        Vector<String> _tokenList = new Vector<String>();
        for (int i = 0; i < _tokenCount; ++i) {
            _tokenList.addElement(_tokens.nextToken());
        }
        while (_tokenCount != 0) {
            StringBuffer _stringBuffer = new StringBuffer();
            for (int i = 0; i < _tokenCount; ++i) {
                if (i != 0) {
                    _stringBuffer.append(".");
                }
                _stringBuffer.append((String)_tokenList.elementAt(i));
            }
            if (this.nonProxyDomainList.contains(_stringBuffer.toString())) {
                _tokenList.removeAllElements();
                return true;
            }
            _tokenList.removeElementAt(0);
            --_tokenCount;
        }
        return false;
    }

    public boolean isNonProxyPort(int port) {
        Integer _port = new Integer(port);
        return this.nonProxyPortList.contains(_port);
    }

    public synchronized void readProxies(ObjectInput objectInput) {
        if (objectInput != null) {
            try {
                this.proxyDomains = (Hashtable)objectInput.readObject();
                this.nonProxyHostList = (Vector)objectInput.readObject();
                this.nonProxyDomainList = (Vector)objectInput.readObject();
                this.nonProxyPortList = (Vector)objectInput.readObject();
                this.globalProxies = (Hashtable)objectInput.readObject();
            }
            catch (ClassNotFoundException exception) {
            }
            catch (IOException exception) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public synchronized void removeNonProxyDomain(String nonProxyDomain) {
        if (this.nonProxyDomainList.contains(nonProxyDomain)) {
            this.nonProxyDomainList.removeElement(nonProxyDomain);
        }
    }

    public synchronized void removeNonProxyHost(String nonProxyHost) {
        if (this.nonProxyHostList.contains(nonProxyHost)) {
            this.nonProxyHostList.removeElement(nonProxyHost);
        }
    }

    public synchronized void removeNonProxyPort(int nonProxyPort) {
        Integer _nonProxyPort = new Integer(nonProxyPort);
        if (this.nonProxyPortList.contains(_nonProxyPort)) {
            this.nonProxyDomainList.removeElement(_nonProxyPort);
        }
    }

    public synchronized void setNonProxyDomains(String[] nonProxyDomains) {
        this.clearNonProxyDomains();
        for (int i = 0; i < nonProxyDomains.length; ++i) {
            this.addNonProxyDomain(nonProxyDomains[i]);
        }
    }

    public synchronized void setNonProxyHosts(String nonProxyHosts) {
        this.clearNonProxyHosts();
        if (nonProxyHosts != null && nonProxyHosts.trim().length() != 0) {
            StringTokenizer _httpNonProxyHosts = new StringTokenizer(nonProxyHosts, DELIMITER);
            int _tokenCount = _httpNonProxyHosts.countTokens();
            for (int i = 0; i < _tokenCount; ++i) {
                String _httpNonProxyHost = _httpNonProxyHosts.nextToken();
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.proxy", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                    Debug.trace((String)("HTTP non proxy host: " + _httpNonProxyHost));
                }
                this.addNonProxyDomainOrHost(_httpNonProxyHost);
            }
        }
    }

    public synchronized void setNonProxyHosts(String[] nonProxyHosts) {
        this.clearNonProxyHosts();
        for (int i = 0; i < nonProxyHosts.length; ++i) {
            this.addNonProxyHost(nonProxyHosts[i]);
        }
    }

    public synchronized void setNonProxyPorts(String nonProxyPorts) {
        this.clearNonProxyPorts();
        if (nonProxyPorts != null && nonProxyPorts.trim().length() != 0) {
            StringTokenizer _httpNonProxyPorts = new StringTokenizer(nonProxyPorts, DELIMITER);
            int _tokenCount = _httpNonProxyPorts.countTokens();
            for (int i = 0; i < _tokenCount; ++i) {
                try {
                    int _httpNonProxyPort = Integer.parseInt(_httpNonProxyPorts.nextToken());
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.proxy", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                        Debug.trace((String)("HTTP non proxy port: " + _httpNonProxyPort));
                    }
                    this.addNonProxyPort(_httpNonProxyPort);
                    continue;
                }
                catch (NumberFormatException exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void setNonProxyPorts(int[] nonProxyPorts) {
        this.clearNonProxyPorts();
        for (int i = 0; i < nonProxyPorts.length; ++i) {
            this.addNonProxyPort(nonProxyPorts[i]);
        }
    }

    public synchronized void writeProxies(ObjectOutput objectOutput) {
        if (objectOutput != null) {
            try {
                objectOutput.writeObject(this.proxyDomains);
                objectOutput.writeObject(this.nonProxyHostList);
                objectOutput.writeObject(this.nonProxyDomainList);
                objectOutput.writeObject(this.nonProxyPortList);
                objectOutput.writeObject(this.globalProxies);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Proxy[] findProxy(String url) {
        try {
            URL _url = new URL(url);
            Proxy _proxy = this.getProxy(_url.getHost(), _url.getPort(), _url.getProtocol());
            if (_proxy == null) {
                return null;
            }
            return new Proxy[]{_proxy};
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String[] getNoProxy() {
        String[] _nonProxyDomains = this.getNonProxyDomains();
        String[] _nonProxyHosts = this.getNonProxyHosts();
        String[] _nonProxyDomainsAndHosts = new String[_nonProxyDomains.length + _nonProxyHosts.length];
        System.arraycopy(_nonProxyDomains, 0, _nonProxyDomainsAndHosts, 0, _nonProxyDomains.length);
        System.arraycopy(_nonProxyHosts, 0, _nonProxyDomainsAndHosts, _nonProxyDomains.length, _nonProxyHosts.length);
        return _nonProxyDomainsAndHosts;
    }

    public boolean isNoProxy(String host) {
        return this.isNonProxyHost(host);
    }

    public void setNoProxy(String domainOrHost) {
        this.addNonProxyDomainOrHost(domainOrHost);
    }

    public synchronized void setNoProxy(String[] domains) {
        this.setNonProxyHosts(domains);
    }

    public Proxy whatProxy(String host) {
        return this.getProxy(host, 80, "http");
    }

    public Proxy whatProxy(String host, String protocol) {
        if ("https".equals(protocol)) {
            return this.getProxy(host, 443, protocol);
        }
        return this.getProxy(host, 80, protocol);
    }

    private void readProperties() {
        String proxyDomainString;
        String _httpNonProxyPortsValue;
        String _httpProxyHostValue = Defs.sysProperty((String)HTTP_PROXY_HOST_KEY);
        if (_httpProxyHostValue != null && _httpProxyHostValue.equals("")) {
            _httpProxyHostValue = null;
        } else if (_httpProxyHostValue != null) {
            int _httpProxyPortValue = Defs.sysPropertyInt((String)HTTP_PROXY_PORT_KEY, (int)80);
            this.setGlobalProxy(new Proxy("http", _httpProxyHostValue, _httpProxyPortValue));
            this.setProxyUse(true);
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.proxy", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                Debug.trace((String)("http.proxyHost is " + _httpProxyHostValue + " " + HTTP_PROXY_PORT_KEY + " is " + _httpProxyPortValue));
            }
        }
        String _httpsProxyHostValue = Defs.sysProperty((String)HTTPS_PROXY_HOST_KEY);
        if (_httpsProxyHostValue != null && _httpsProxyHostValue.equals("")) {
            _httpsProxyHostValue = null;
        } else if (_httpsProxyHostValue != null) {
            int _httpsProxyPortValue = Defs.sysPropertyInt((String)HTTPS_PROXY_PORT_KEY, (int)80);
            this.setGlobalProxy(new Proxy("https", _httpsProxyHostValue, _httpsProxyPortValue, true));
            this.setProxyUse(true);
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.proxy", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                Debug.trace((String)("https.proxyHost is " + _httpsProxyHostValue + " " + HTTPS_PROXY_PORT_KEY + " is " + _httpsProxyPortValue));
            }
        }
        String _httpNonProxyHostsValue = Defs.sysProperty((String)HTTP_NON_PROXY_HOSTS_KEY);
        if (_httpNonProxyHostsValue != null) {
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.proxy", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                Debug.trace((String)("http.nonProxyHosts is " + _httpNonProxyHostsValue));
            }
            this.setNonProxyHosts(_httpNonProxyHostsValue);
        }
        if ((_httpNonProxyPortsValue = Defs.sysProperty((String)HTTP_NON_PROXY_PORTS_KEY)) != null) {
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.proxy", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                Debug.trace((String)("http.nonProxyPorts is " + _httpNonProxyPortsValue));
            }
            this.setNonProxyPorts(_httpNonProxyPortsValue);
        }
        if ((proxyDomainString = Defs.sysProperty((String)"ice.net.proxydomains")) != null) {
            this.setProxyUse(true);
            StringTokenizer st = new StringTokenizer(proxyDomainString, ":;");
            try {
                while (st.hasMoreTokens()) {
                    String protocol = st.nextToken();
                    String domain = st.nextToken();
                    String pHost = st.nextToken();
                    int port = Integer.parseInt(st.nextToken());
                    this.proxyDomains.put(protocol + domain, new Proxy(protocol, pHost, port));
                }
            }
            catch (NoSuchElementException nse) {
                // empty catch block
            }
        }
    }

    public void rereadProperties() {
        this.readProperties();
    }

    public boolean getProxyUse() {
        return this.useProxies;
    }

    public void setProxyUse(boolean useproxies) {
        this.useProxies = useproxies;
    }

    public void removeAllProxies() {
        this.proxyDomains.clear();
        this.globalProxies.clear();
    }

    public void setGlobalProxy(Proxy proxy) {
        if (proxy != null) {
            this.globalProxies.put(proxy.getProtocol(), proxy);
        }
    }

    public Proxy getGlobalProxy() {
        return this.getGlobalProxy("http");
    }

    public Proxy getGlobalProxy(String protocol) {
        return (Proxy)this.globalProxies.get(protocol);
    }

    public Proxy[] getAllGlobalProxies() {
        Proxy[] p = new Proxy[this.globalProxies.size()];
        Enumeration e = this.globalProxies.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            p[i] = (Proxy)e.nextElement();
            ++i;
        }
        return p;
    }

    public void setProxyDomain(String domain, Proxy proxy) {
        this.proxyDomains.put(proxy.getProtocol().toLowerCase() + domain.toLowerCase(), proxy);
    }

    public void removeProxy(String domain) {
        this.removeProxy(domain, "http");
    }

    public void removeProxy(String domain, String protocol) {
        this.proxyDomains.remove(protocol + domain.toLowerCase());
    }

    public void removeGlobalProxy(Proxy proxyRef) {
        Enumeration e = this.globalProxies.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if ((Proxy)this.globalProxies.get(s) != proxyRef) continue;
            this.globalProxies.remove(s);
        }
    }

    public Proxy getProxy(String domain) {
        return this.getProxyForDomain(domain);
    }

    public String[] getDomainsForProxy(Proxy p) {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.proxyDomains.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (this.proxyDomains.get(s) != p) continue;
            v.addElement(s);
        }
        if (v.size() == 0) {
            return null;
        }
        String[] domains = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            String t;
            String s = (String)v.elementAt(i);
            domains[i] = s.startsWith("https") ? (t = s.substring(5)) : (t = s.substring(4));
        }
        return domains;
    }

    public Proxy getProxyForDomain(String domain, String protocol) {
        Proxy result = (Proxy)this.proxyDomains.get(protocol + domain);
        if (result != null) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(domain, ".");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        while (v.size() > 0) {
            StringBuffer b = new StringBuffer(protocol);
            for (int i = 0; i < v.size(); ++i) {
                b.append((String)v.elementAt(i));
                if (i + 1 >= v.size()) continue;
                b.append(".");
            }
            result = (Proxy)this.proxyDomains.get(b.toString());
            if (result != null) {
                v.removeAllElements();
                return result;
            }
            v.removeElementAt(0);
        }
        return null;
    }

    public Proxy getProxyForDomain(String domain) {
        return this.getProxyForDomain(domain, "http");
    }

    public void setProxyForDomain(String domain, Proxy proxy) {
        this.proxyDomains.put(proxy.getProtocol() + domain, proxy);
    }

    public Proxy[] getAllProxies() {
        int size = this.proxyDomains.size();
        if (size == 0) {
            return null;
        }
        Proxy[] tmp = new Proxy[size];
        Enumeration enumeration = this.proxyDomains.keys();
        for (int i = 0; i < size; ++i) {
            tmp[i] = (Proxy)this.proxyDomains.get(enumeration.nextElement());
        }
        return tmp;
    }

    public String[] getAllProxyDomainsByProtocol(String protocol) {
        int size = this.proxyDomains.size();
        if (size == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        Enumeration enumeration = this.proxyDomains.keys();
        for (int i = 0; i < size; ++i) {
            String t = (String)enumeration.nextElement();
            if (!t.endsWith(protocol)) continue;
            String s = t.substring(0, t.length() - protocol.length());
            v.addElement(s);
        }
        Object[] tmp = new String[v.size()];
        v.copyInto(tmp);
        return tmp;
    }

    public Enumeration elements() {
        if (this.proxyDomains != null) {
            return this.proxyDomains.keys();
        }
        return null;
    }
}

